<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@page import="com.maplesoft.mapleta.gbk.Constants"%>
<%@page import="com.maplesoft.mapleta.session.Role"%>

<jsp:directive.page import="com.maplesoft.mapleta.session.Context"/>

<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html" %>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic" %>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<tiles:useAttribute name="gradesList"/>
<tiles:useAttribute name="currentUser"/>

<c:set var="module"><%= request.getContextPath() %></c:set>
<c:set var="NUMERIC" value="<%= new Integer(Constants.NUMERIC_CODE) %>" scope="page"/>
<c:set var="LETTER" value="<%= new Integer(Constants.LETTER_CODE) %>" scope="page"/>
<c:set var="PERCENTAGE" value="<%= new Integer(Constants.PERCENTAGE_CODE) %>" scope="page"/>
<c:set var="IN_PROGRESS" value="<%= Constants.ACTIVE_ASGN_CODE %>" scope="page"/>

<c:set var="AVG"><%= Constants.AVG_CODE %></c:set>

<c:set var="SORT_SN"><%= Constants.SORT_SN %></c:set>
<c:set var="SORT_GIVENNAME"><%= Constants.SORT_GIVENNAME %></c:set>
<c:set var="SORT_MI"><%= Constants.SORT_MI %></c:set>
<c:set var="SORT_LOGIN"><%= Constants.SORT_LOGIN %></c:set>
<c:set var="SORT_EMAIL"><%= Constants.SORT_EMAIL %></c:set>
<c:set var="SORT_STUDENTID"><%= Constants.SORT_STUDENTID %></c:set>
<c:set var="SORT_TOTAL"><%= Constants.SORT_TOTAL %></c:set>
<c:set var="SORT_NAME"><%= Constants.SORT_NAME %></c:set>
<c:set var="SORT_NAME_DESC"><%= Constants.SORT_NAME_DESC %></c:set>
<c:set var="SORT_ASGN_NAME"><%= Constants.SORT_ASGN_NAME %></c:set>
<c:set var="SORT_ASGN_NAME_DESC"><%= Constants.SORT_ASGN_NAME_DESC %></c:set>
<c:set var="SORT_SCORE"><%= Constants.SORT_SCORE %></c:set>
<c:set var="SORT_SCORE_DESC"><%= Constants.SORT_SCORE_DESC %></c:set>
<c:set var="SORT_START"><%= Constants.SORT_START %></c:set>
<c:set var="SORT_START_DESC"><%= Constants.SORT_START_DESC %></c:set>
<c:set var="SORT_END"><%= Constants.SORT_END %></c:set>
<c:set var="SORT_END_DESC"><%= Constants.SORT_END_DESC %></c:set>
<c:set var="SORT_DURATION"><%= Constants.SORT_DURATION %></c:set>
<c:set var="SORT_DURATION_DESC"><%= Constants.SORT_DURATION_DESC %></c:set>

<c:set var="ADMINISTRATOR"><%= Role.ADMINISTRATOR %></c:set>
<c:set var="INSTRUCTOR"><%= Role.INSTRUCTOR %></c:set>
<c:set var="PROCTOR"><%= Role.PROCTOR %></c:set>

<c:set var="role"><%= Context.getContext(request.getSession()).getRole() %></c:set>
<c:set var="hasPrivilege"><%= Context.getContext(request.getSession()).getRole().atLeast(Role.PROCTOR) %></c:set>

<logic:messagesPresent>
<html:messages id="msg" message="false">
	<span class="errorStyle1"><c:out value='${msg}' escapeXml="false"/></span>
	<br>
</html:messages>
</logic:messagesPresent>

<c:choose>
	<c:when test="${role == ADMINISTRATOR ||  role == INSTRUCTOR || role == PROCTOR}">
		<input type="hidden" id="refreshView" value="refresh.user"/>
	</c:when>
	<c:otherwise>
		<input type="hidden" id="refreshView" value="refresh.student"/>
	</c:otherwise>
</c:choose>
<br/>
<html:hidden property="userId"/>

<em class="divider"><fmt:message key="label.grades.student"/>: ${selectedUser.uid}</em>
<br/>

<tiles:useAttribute name="error" ignore="true"/>
<logic:notEmpty name="error">${error}</logic:notEmpty>

<c:choose>
	<c:when test="${ empty viewSearchForm.userId }">
		<div>
			<em class="title"><fmt:message key="ViewSearchForm.nouser.msg"/></em>
		</div>
	</c:when>
	<c:when test="${ (fn:length(viewSearchForm.assignmentSelection) <= 0 && fn:length(viewSearchForm.externalSelection) <= 0) }">
		<div>
			<em class="title"><fmt:message key="ViewSearchForm.noassigments.msg"/></em>
		</div>
	</c:when>
	<c:when test="${ fn:length(viewSearchForm.classSelection) <= 0 }">
		<div>
			<em class="title"><fmt:message key="ViewSearchForm.noclasses.msg"/></em>
		</div>
	</c:when>
	<c:otherwise>

<tiles:insert definition=".gbk.info.userinfo">
	<tiles:put name="selectedUser" beanName="selectedUser" />
</tiles:insert>
<%--
<tiles:insert definition=".gradebook.assignmentStatsInfo"></tiles:insert>
--%>

<!-- ** put the Labels onto the screen ** -->
<tiles:insert definition=".gbk.page.labels">
	<tiles:put name="gradesList" beanName="gradesList"/>
</tiles:insert>

<!-- ** Start the grade table ** -->
<br/>
<table class="gradesTable studentGradesList" cellpadding="0" cellspacing="0">
	<thead>
		<tr class="header">
<c:if test="${viewSearchForm.showClassName}">
			<c:choose>
				<c:when test="${viewSearchForm.sort eq SORT_NAME}">
					<td class="total totalHeader sorted"><a class="sort sorted" href="javascript:sort('<%= Constants.SORT_NAME_DESC %>')"><fmt:message key="label.class"/></a></td>
				</c:when>
				<c:when test="${viewSearchForm.sort eq SORT_NAME_DESC}">
					<td class="total totalHeader sorted"><a class="sort sorted" href="javascript:sort('<%= Constants.SORT_NAME %>')"><fmt:message key="label.class"/></a></td>
				</c:when>
				<c:otherwise>
					<td class="total totalHeader"><a class="sort" href="javascript:sort('<%= Constants.SORT_NAME %>')"><fmt:message key="label.class"/></a></td>
				</c:otherwise>
			</c:choose>
</c:if>
			<c:choose>
				<c:when test="${viewSearchForm.sort eq SORT_ASGN_NAME}">
					<td class="total totalHeader sorted"><a class="sort sorted" href="javascript:sort('<%= Constants.SORT_ASGN_NAME_DESC %>')"><fmt:message key="label.assignmentName"/></a></td>
				</c:when>
				<c:when test="${viewSearchForm.sort eq SORT_ASGN_NAME_DESC}">
					<td class="total totalHeader sorted"><a class="sort sorted" href="javascript:sort('<%= Constants.SORT_ASGN_NAME %>')"><fmt:message key="label.assignmentName"/></a></td>
				</c:when>
				<c:otherwise>
					<td class="total totalHeader"><a class="sort" href="javascript:sort('<%= Constants.SORT_ASGN_NAME %>')"><fmt:message key="label.assignmentName"/></a></td>
				</c:otherwise>
			</c:choose>
			<td></td>
			<td><fmt:message key="label.details"/></td>
			<c:choose>
				<c:when test="${viewSearchForm.sort eq SORT_SCORE}">
					<td class="total totalHeader sorted"><a class="sort sorted" href="javascript:sort('<%= Constants.SORT_SCORE_DESC %>')"><fmt:message key="label.score"/></a></td>
				</c:when>
				<c:when test="${viewSearchForm.sort eq SORT_SCORE_DESC}">
					<td class="total totalHeader sorted"><a class="sort sorted" href="javascript:sort('<%= Constants.SORT_SCORE %>')"><fmt:message key="label.score"/></a></td>
				</c:when>
				<c:otherwise>
					<td class="total totalHeader"><a class="sort" href="javascript:sort('<%= Constants.SORT_SCORE %>')"><fmt:message key="label.score"/></a></td>
				</c:otherwise>
			</c:choose>
			<c:choose>
				<c:when test="${viewSearchForm.sort eq SORT_TOTAL}">
					<td class="total totalHeader sorted"><a class="sort sorted" href="javascript:sort('<%= Constants.SORT_TOTAL_DESC %>')"><fmt:message key="label.total"/></a></td>
				</c:when>
				<c:when test="${viewSearchForm.sort eq SORT_TOTAL_DESC}">
					<td class="total totalHeader sorted"><a class="sort sorted" href="javascript:sort('<%= Constants.SORT_TOTAL %>')"><fmt:message key="label.total"/></a></td>
				</c:when>
				<c:otherwise>
					<td class="total totalHeader"><a class="sort" href="javascript:sort('<%= Constants.SORT_TOTAL %>')"><fmt:message key="label.total"/></a></td>
				</c:otherwise>
			</c:choose>
			<c:choose>
				<c:when test="${viewSearchForm.sort eq SORT_START}">
					<td class="total totalHeader sorted"><a class="sort sorted" href="javascript:sort('<%= Constants.SORT_START_DESC %>')"><fmt:message key="label.start"/></a></td>
				</c:when>
				<c:when test="${viewSearchForm.sort eq SORT_START_DESC}">
					<td class="total totalHeader sorted"><a class="sort sorted" href="javascript:sort('<%= Constants.SORT_START %>')"><fmt:message key="label.start"/></a></td>
				</c:when>
				<c:otherwise>
					<td class="total totalHeader"><a class="sort" href="javascript:sort('<%= Constants.SORT_START %>')"><fmt:message key="label.start"/></a></td>
				</c:otherwise>
			</c:choose>
			<c:choose>
				<c:when test="${viewSearchForm.sort eq SORT_END}">
					<td class="total totalHeader sorted"><a class="sort sorted" href="javascript:sort('<%= Constants.SORT_END_DESC %>')"><fmt:message key="label.end"/></a></td>
				</c:when>
				<c:when test="${viewSearchForm.sort eq SORT_END_DESC}">
					<td class="total totalHeader sorted"><a class="sort sorted" href="javascript:sort('<%= Constants.SORT_END %>')"><fmt:message key="label.end"/></a></td>
				</c:when>
				<c:otherwise>
					<td class="total totalHeader"><a class="sort" href="javascript:sort('<%= Constants.SORT_END %>')"><fmt:message key="label.end"/></a></td>
				</c:otherwise>
			</c:choose>
			<c:choose>
				<c:when test="${viewSearchForm.sort eq SORT_DURATION}">
					<td class="total totalHeader sorted"><a class="sort sorted" href="javascript:sort('<%= Constants.SORT_DURATION_DESC %>')"><fmt:message key="label.duration"/></a></td>
				</c:when>
				<c:when test="${viewSearchForm.sort eq SORT_DURATION_DESC}">
					<td class="total totalHeader sorted"><a class="sort sorted" href="javascript:sort('<%= Constants.SORT_DURATION %>')"><fmt:message key="label.duration"/></a></td>
				</c:when>
				<c:otherwise>
					<td class="total totalHeader"><a class="sort" href="javascript:sort('<%= Constants.SORT_DURATION %>')"><fmt:message key="label.duration"/></a></td>
				</c:otherwise>
			</c:choose>
		</tr>
	</thead>
<c:forEach var="gradeLine" items="${gradesList.gradeLines}" varStatus="line">

	<c:forEach var="gradeWrapper" items="${gradeLine.grades}" varStatus="wrapper">
		<c:forEach var="grade" items="${gradeWrapper.grades}" varStatus="c">
			<c:set var="styleClass"><c:if test="${c.count > 1}">extraAttempt</c:if></c:set>
			
			<c:if test="${not grade.emptyGrade}">
	<c:set var="rowClass">
		<c:choose>
			<c:when test="${line.count mod 2 == 0}">even</c:when>
			<c:otherwise>odd</c:otherwise>
		</c:choose>
	</c:set>
<tr class="${rowClass}">
	<c:if test="${viewSearchForm.showClassName}">
		<td class="top className">${gradeLine.className}</td>
	</c:if>

	<c:if test="${c.count == 1}">
		<td class="top" rowspan="${gradeLine.maxAttempts}">
			${gradeLine.assignmentName}
		</td>
		
		<td>
		<c:if test="${hasPrivilege && not grade.fullyGraded && grade.id > 0}">
			<img src="modules/gbk/images/needsGrade.gif"/>
		</c:if>
		</td>		
		
	</c:if>
	<td class="${styleClass}">
		<c:choose>
			<c:when test="${hasPrivilege && grade.id < 0}">
				<a href="javascript:action('External','asgnId=${-grade.id}')"><fmt:message key="label.details"/></a>
			</c:when>
			<c:when test="${(hasPrivilege || ((not grade.delayFeedback) && (not grade.active))) && viewSearchForm.resultType != AVG && grade.id >= 0}">
				<a href="javascript:action('Details','userId=${selectedUser.uid}&trId=${grade.id}')"><fmt:message key="label.details"/></a>
			</c:when>
			<c:when test="${(not hasPrivilege) && (grade.delayFeedback || grade.active) && viewSearchForm.resultType != AVG && grade.id >= 0}">
				<img src="modules/gbk/images/padlock.gif" title='<fmt:message key="label.assignmentStats.unavailable"/>'/>
			</c:when>
		</c:choose>
	</td>
	<td class="${styleClass}">
		<c:choose>
			<c:when test="${not hasPrivilege && (not grade.showGrade || grade.active)}">
				<img src="modules/gbk/images/padlock.gif" title='<fmt:message key="label.assignmentStats.unavailable"/>'/>
			</c:when>
			<c:when test="${not hasPrivilege && grade.delayFeedback}">
				<img src="modules/gbk/images/padlock.gif" title='<fmt:message key="label.assignmentStats.unavailable.until"><fmt:param value="${grade.delayFeedbackDate}"></fmt:param></fmt:message>'/>
			</c:when>
			<c:otherwise>
				<c:choose>
					<c:when test="${grade.emptyGrade}">
						<fmt:message key="label.decorator.number.empty"/>
					</c:when>
					<c:when test="${viewSearchForm.gradingStyle == PERCENTAGE}">
						${grade.percent}
						<c:if test="${viewSearchForm.active == IN_PROGRESS && not grade.emptyGrade}"><fmt:message key="label.decorator.number.inProgress"/></c:if>
					</c:when>
					<c:when test="${viewSearchForm.gradingStyle == LETTER}">
						${grade.letter}
						<c:if test="${viewSearchForm.active == IN_PROGRESS && not grade.emptyGrade}"><fmt:message key="label.decorator.number.inProgress"/></c:if>
					</c:when>
					<c:otherwise>
						${grade}
						<c:if test="${viewSearchForm.active == IN_PROGRESS && not grade.emptyGrade}"><fmt:message key="label.decorator.number.inProgress"/></c:if>
					</c:otherwise>
				</c:choose>			
			</c:otherwise>
		</c:choose>
	</td>
	<td class="${styleClass}">${grade.total}</td>
	<td class="${styleClass}">
		<c:choose>
			<c:when test="${empty grade.start}">
				<fmt:message key="label.decorator.number.empty"/>
			</c:when>
			<c:otherwise>
				<fmt:formatDate value="${grade.start}" dateStyle="short" type="date" timeZone="${grade.timeZone}"/> <fmt:formatDate value="${grade.start}" timeStyle="medium" type="time" timeZone="${grade.timeZone}"/>
			</c:otherwise>
		</c:choose>
	</td>
	<td class="${styleClass}">
		<c:choose>
			<c:when test="${empty grade.end}">
				<fmt:message key="label.decorator.number.empty"/>
			</c:when>
			<c:otherwise>
				<fmt:formatDate value="${grade.end}" dateStyle="short" type="date" timeZone="${grade.timeZone}"/> <fmt:formatDate value="${grade.end}" timeStyle="medium" type="time" timeZone="${grade.timeZone}"/>
			</c:otherwise>
		</c:choose>
	</td>
	<td class="${styleClass}">
		<c:choose>
			<c:when test="${empty grade.duration}">
				<fmt:message key="label.decorator.number.empty"/>
			</c:when>
			<c:otherwise>
				${grade.duration}
			</c:otherwise>
		</c:choose>
	</td>
</tr>	
			</c:if>
		
		</c:forEach>
	</c:forEach>
</c:forEach>	
</table>

	</c:otherwise>
</c:choose>
