<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@ taglib uri="http://jakarta.apache.org/struts/tags-html" prefix="html"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://displaytag.sf.net" prefix="display" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>

<tiles:useAttribute name="cancelAction"/>

<script>

	function doCancel() {
		var action = '<%=request.getContextPath()%>'+'${cancelAction}'<c:if test="${not empty param.classid}">+'?classid=${param.classid}'</c:if>;	
		document.location.href=action;
	}

</script>

<fmt:bundle basename="com.maplesoft.mapleta.application.ApplicationResources">
	<html:form action="/DeleteAndRestoreClass" method="post">
		<html:hidden property="mode"/>
		<table border=0 width="80%">
			<tr>
				<td>
					<em class="divider">
						<fmt:message key="SearchForm.confirm.title.label">
							<fmt:param value="${SearchForm.mode}"/>
						</fmt:message>
					</em>
					<br />
				</td>
			</tr>
		</table>
		<br />
		<fmt:message key="SearchForm.confirm1.msg">
			<fmt:param value="${SearchForm.mode}"/>
		</fmt:message>
		<p>
			<ul>
				<c:choose>
				<c:when test="${not empty classList}">
				<c:forEach var="theClass" items="${classList}">
					<html:multibox property="selectedItems" value="${theClass.cid}"/><em class="title">${theClass.name}</em><br>
				</c:forEach>
				</c:when>
				<c:otherwise>
					<fmt:message key="SearchForm.nothing_found.msg">
						<fmt:param value="${SearchForm.mode}"/>
					</fmt:message>
				</c:otherwise>
				</c:choose>
			</ul>
		</p>
		<br />
		<c:if test="${ not empty noDelete }">
			<fmt:message key="SearchForm.no_delete.msg"/>
			<p>
				<ul>
					<c:forEach var="theClass" items="${noDelete}">
						<li><em class="title">${theClass.name}</em></li>
					</c:forEach>
				</ul>
			</p>
		</c:if>
		<c:if test="${ not empty noRestore }">
			<fmt:message key="SearchForm.no_restore.msg"/>
			<p>
				<ul>
					<c:forEach var="theClass" items="${noRestore}">
						<li><em class="title">${theClass.name}</em></li>
					</c:forEach>
				</ul>
			</p>
		</c:if>
		
		<input type="button" class="button" value="<fmt:message key='SearchForm.cancel.label'/>" onclick="doCancel();" />
		<a>&nbsp;</a>
		<c:if test="${not empty classList}">
			<html:submit styleClass="button">
				<fmt:message key="SearchForm.confirm.label"/>
			</html:submit>
		</c:if>
	</html:form>
</fmt:bundle>
