<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@ page import="com.maplesoft.mapleta.gateway.GatewayService"%>

<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html" %>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic" %>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<link rel="stylesheet" type="text/css" href="<%=GatewayService.getServerURL()%>modules/skin/css/gbk.css">

<style>

td.yellow {
	border: 1px solid yellow;
}
td.red {
	border: 1px solid red;
}

</style>

Student Report

<c:forEach var="report" items="${reports}">

<table style="border-collapse: collapse;">
	<tr>
		<th>Topic</th>
		<th>Subtopic</th>
		<th>Grade</th>
		<th>Your Answer</th>
		<th>Correct Answer</th>
	</tr>

	<c:choose>
		<c:when test="${line.versionedResponse.grade eq 0.0}">
			<c:set var="styleClass" value="red"/>
		</c:when>
		<c:when test="${line.versionedResponse.grade > 0.0 && line.versionedResponse.grade < 1.0}">
			<c:set var="styleClass" value="yellow"/>
		</c:when>
		<c:otherwise>
			<c:set var="styleClass" value="green"/>
		</c:otherwise>
	</c:choose>

	
	<c:forEach var="line" items="${report.lines}">
		<tr>
			<td class="${styleClass}">${line.topic}</td>
			<td class="${styleClass}">${line.subTopic}</td>
			<td class="${styleClass}">${line.versionedResponse.grade}</td>
			<td class="${styleClass}"><c:out value="${line.versionedResponse.responseForDisplay}" escapeXml="false"/></td>
			<td class="${styleClass}"><c:out value="${line.versionedResponse.answerForDisplay}" escapeXml="false"/></td>
		</tr>
	</c:forEach>
</table>

<tiles:insert definition=".gbk.report.summary">
	<tiles:put name="summary" beanName="report" beanProperty="assessmentSummary" />
</tiles:insert>

</c:forEach>
