<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@page import="com.maplesoft.mapleta.gbk.Constants"%>
<%@ page import="com.maplesoft.mapleta.session.Role" %>
<%@ page import="com.maplesoft.mapleta.session.Context" %>

<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html" %>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic" %>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<tiles:useAttribute name="gradesTable" ignore="true"/>

<c:set var="module"><%= request.getContextPath() %></c:set>
<c:set var="NUMERIC" value="<%= new Integer(Constants.NUMERIC_CODE) %>" scope="page"/>
<c:set var="LETTER" value="<%= new Integer(Constants.LETTER_CODE) %>" scope="page"/>
<c:set var="PERCENTAGE" value="<%= new Integer(Constants.PERCENTAGE_CODE) %>" scope="page"/>
<c:set var="IN_PROGRESS" value="<%= Constants.ACTIVE_ASGN_CODE %>" scope="page"/>

<c:set var="SORT_GRADE"><%= Constants.SORT_GRADE %></c:set>
<c:set var="SORT_GRADE_DESC"><%= Constants.SORT_GRADE_DESC %></c:set>
<c:set var="SORT_TOTAL"><%= Constants.SORT_TOTAL %></c:set>
<c:set var="SORT_TOTAL_DESC"><%= Constants.SORT_TOTAL_DESC %></c:set>

<c:set var="ADMINISTRATOR"><%= Role.ADMINISTRATOR %></c:set>
<c:set var="INSTRUCTOR"><%= Role.INSTRUCTOR %></c:set>
<c:set var="PROCTOR"><%= Role.PROCTOR %></c:set>

<c:set var="role"><%= Context.getContext(request.getSession()).getRole() %></c:set>

<input type="hidden" id="refreshView" value="refresh.class"/>
<script>
function refresh(_export) {
	var form = document.forms['viewSearchForm'];
	if( _export ) {
		document.getElementById('export').value=_export;
	}
	form.submit();
}
function showDetails(_id) {
	var details = document.getElementById(_id);
	if( details ) { 
		details.className='showDetails';
	}
}
function hideDetails(_id) {
	var details = document.getElementById(_id);
	if( details ) { 
		details.className='hidden';
	}
}
function sortGrade(_sort, _id) {
	var form = document.forms['viewSearchForm'];
	var sortAction = '<%= request.getContextPath() %>/gradebook/ReportSort.do'
	
	form.action= sortAction + '?sort=' + _sort + '&sortId=' + _id;
	form.submit();
} 

</script>
<html:form action="/RefreshReport.do" styleId="viewSearchForm">
	<html:hidden styleId="viewSearchFormAction" property="actionID"/>
	<html:hidden styleId="viewSearchFormAssignmentId" property="assignmentId"/>
	<html:hidden styleId="viewSearchFormQuGroup" property="quGroup"/>
	<html:hidden styleId="viewSearchFormQuRef" property="quRef"/>
	<html:hidden styleId="viewSearchFormTrId" property="trId"/>
	<input type="hidden" name="export" id="export" value=""/>
<div style="border: 1px solid #ccc;">
	<tiles:insert definition=".gbk.panel.snapshot.view"/>
</div>
</html:form>

<logic:notEmpty name="csvFile" scope="request">
<div>
<fmt:message key="RosterAdmin.csv.begin.msg"/>
<a href="<%=request.getContextPath()%>${csvFile}">
	<fmt:message key="RosterAdmin.csv.download.label"/>
</a>
</div>
</logic:notEmpty>

<em class="divider"><fmt:message key="gbk.gradebooks.label"/>: ${gradesTable.snapshot.name}
</em>
<c:set var="total" value="0"/>
<c:set var="total">${total + 1}</c:set>
<br/>
<c:choose>
<c:when test="${snapshotForm.id <= 0}">
	<div>
		<em class="title"><fmt:message key="gbk.gradebooks.none_selected.msg"/></em>
	</div>
</c:when>
<c:when test="${ fn:length(snapshotForm.classSelection) <= 0 }">
	<div>
		<em class="title"><fmt:message key="ViewSearchForm.noclasses.msg"/></em>
	</div>
</c:when>
<c:otherwise>

<div class="gbkInfo">
	<a href="#" onClick="toggleItem('reportInfo'); this.blur(); return false;">
		<span>
			<img src="modules/configureClasses/images/closeDirIcon.gif" border="0" id="reportInfoTwisty">
			${gradesTable.snapshot.name}
		</span>
	</a>
	<div id="reportInfoTable">
	<tiles:insert definition=".gbk.snapshot.groups.list">
		<tiles:put name="displayOnly" value="true"/>
	</tiles:insert>
	</div>
</div>

<!-- ** put the Labels onto the screen ** -->
<tiles:insert definition=".gbk.page.labels">
	<tiles:put name="gradesTable" beanName="gradesTable"/>
</tiles:insert>



<!-- ** Start the grade table ** -->

<table class="gradesTable" cellpadding="0" cellspacing="0">
	<thead>
	
	<!-- ** Show the assignment headers ** -->
	
		<tr class="asgnHeader">
			<c:if test="${viewSearchForm.showExtraData || viewSearchForm.showClassName}"><td class="invisible">&nbsp;</td></c:if>
			<c:if test="${viewSearchForm.showLastName}"><td class="invisible"></td></c:if>
			<c:if test="${viewSearchForm.showGivenName}"><td class="invisible"></td></c:if>
			<c:if test="${viewSearchForm.showMi}"><td class="invisible"></td></c:if>
			<c:if test="${viewSearchForm.showUid}"><td class="invisible"></td></c:if>
			<c:if test="${viewSearchForm.showEmail}"><td class="invisible"></td></c:if>
			<c:if test="${viewSearchForm.showStudentId}"><td class="invisible"></td></c:if>
<c:forEach var="header1" items="${gradesTable.headers}">
		<c:set var="colspan">1</c:set>

<%--		
		<c:if test="${ (viewSearchForm.showStartTime || viewSearchForm.showStartDate) || 
						(viewSearchForm.showEndTime || viewSearchForm.showEndDate)  ||
						(viewSearchForm.showNumAttempts) || (viewSearchForm.showDuration) }">
			<c:set var="colspan">${colspan+1}</c:set>		
		</c:if>
--%>

<%--
			<td class="gradeColumn" colspan="${colspan}"><a class="header gradeColumn" href="${module}/gradebook/Assignment.do?assignmentSelection=${header1.id}" title="${header1.name}">${header1.name}</a></td>
--%>
<c:if test="${header1.bonus}">
	<c:set var="bonus" value="bonus"/>
</c:if>
			<td class="gradeColumn yellow" colspan="${colspan}" style="white-space: nowrap;">
				<c:choose>
					<c:when test="${role == ADMINISTRATOR || role==INSTRUCTOR || role == PROCTOR}">
						<a class="header gradeColumn ${bonus}" href="javascript:action('EditReportGroup','id=${header1.snapshotId}&order=${header1.id}&edit=true')" title="${header1.name}">
							${header1.longName}
						<c:if test="${header1.bonus}">
							<img style="border: none;" src="<%=request.getContextPath()%>/modules/gbk/images/bonus.gif" title="<fmt:message key='gbk.bonus.label'/>" alt="<fmt:message key='gbk.bonus.label'/>"/>
						</c:if>
						</a>
					</c:when>
					<c:otherwise>
						<span class="gradeColumn header ${bonus}">
							${header1.longName}
						<c:if test="${header1.bonus}">
							<img src="<%=request.getContextPath()%>/modules/gbk/images/bonus.gif" title="<fmt:message key='gbk.gradebooks.bonus.label'/>" alt="<fmt:message key='gbk.gradebooks.bonus.label'/>"/>
						</c:if>
						</span>
					</c:otherwise>
				</c:choose>
			</td>
</c:forEach>
			<td></td>			
		</tr>

	<!-- ** Show the user and grade headers ** -->
	
		<tr class="header">
		<c:if test="${viewSearchForm.showExtraData && not viewSearchForm.showClassName}">
			<td>&nbsp;</td>
		</c:if>
				
			<!-- ** user data headers ** -->
<tiles:insert definition=".gbk.common.userheaders"/>

		<!-- ** grade headers ** -->
	<c:forEach var="header1" items="${gradesTable.headers}" varStatus="c">

	
			<c:set var="id">${header1.id}</c:set>
			<c:choose>
				<c:when test="${viewSearchForm.sort eq SORT_GRADE && viewSearchForm.sortId == id}">
					<td class="grade gradeDataTitle sorted"><a class="sort sorted" href="javascript:sortGrade('${SORT_GRADE_DESC}','${header1.id}')"><fmt:message key="label.grade"/></a></td>				
				</c:when>
				<c:when test="${viewSearchForm.sort eq SORT_GRADE_DESC && viewSearchForm.sortId == id}">
					<td class="grade gradeDataTitle sorted"><a class="sort sorted" href="javascript:sortGrade('${SORT_GRADE}','${header1.id}')"><fmt:message key="label.grade"/></a></td>				
				</c:when>
				<c:otherwise>
					<td class="grade gradeDataTitle"><a class="sort" href="javascript:sortGrade('${SORT_GRADE}','${header1.id}')"><fmt:message key="label.grade"/></a></td>				
				</c:otherwise>

			</c:choose>
	</c:forEach>
	
			<!-- ** total header ** -->
			<c:choose>
				<c:when test="${viewSearchForm.sort eq SORT_TOTAL}">
					<td class="borderLeft total totalHeader sorted"><a class="sort sorted" href="javascript:sort('<%= Constants.SORT_TOTAL_DESC %>')"><fmt:message key="label.total"/></a></td>
				</c:when>
				<c:when test="${viewSearchForm.sort eq SORT_TOTAL_DESC}">
					<td class="total totalHeader sorted"><a class="sort sorted" href="javascript:sort('<%= Constants.SORT_TOTAL %>')"><fmt:message key="label.total"/></a></td>
				</c:when>
				<c:otherwise>
					<td class="total totalHeader"><a class="sort" href="javascript:sort('<%= Constants.SORT_TOTAL %>')"><fmt:message key="label.total"/></a></td>
				</c:otherwise>
			</c:choose>			
		</tr>		
	</thead>
	<tbody>

	<!-- ** Extra data headers ** -->

<c:if test="${viewSearchForm.showExtraData}">
	<tiles:insert definition=".gbk.common.extraData">
		<tiles:put name="gradesTable" beanName="gradesTable"/>
		<tiles:put name="alwaysShowTotals" value="true"/>
	</tiles:insert>
</c:if>

<c:forEach var="gradeLine" items="${gradesTable.gradeLines}" varStatus="c">
	<c:set var="maxAttempts">${gradeLine.maxAttempts}</c:set>
	<c:set var="rowClass">
		<c:choose>
			<c:when test="${c.count mod 2 == 0}">even</c:when>
			<c:otherwise>odd</c:otherwise>
		</c:choose>
	</c:set>
		<tr class="${rowClass}">
	<c:choose>
		<c:when test="${viewSearchForm.showClassName}"><td class="top className"><span class="className">${gradeLine.className}</span></td></c:when>	
		<c:when test="${viewSearchForm.showExtraData}"><td></td></c:when>
	</c:choose>

	<c:choose>
	<c:when test="${lastId != gradeLine.user.id}">
		<c:if test="${viewSearchForm.showUid}"><td class="top userInfo"><span class="userLink"></span>${gradeLine.user.uid}</span></td></c:if>
		<c:if test="${viewSearchForm.showLastName}"><td class="top userInfo"><span class="userLink">${gradeLine.user.sn}</span></td></c:if>
		<c:if test="${viewSearchForm.showMi}"><td class="top userInfo"><span class="userLink">${gradeLine.user.mi}</span></td></c:if>
		<c:if test="${viewSearchForm.showGivenName}"><td class="top userInfo"><span class="userLink">${gradeLine.user.givenName}</span></td></c:if>
		<c:if test="${viewSearchForm.showEmail}"><td class="top userInfo"><span class="userLink">${gradeLine.user.email}</span></td></c:if>
		<c:if test="${viewSearchForm.showStudentId}"><td class="top userInfo"><span class="userLink">${gradeLine.user.studentID}</span></td></c:if>		
	</c:when>
	<c:otherwise>
		<c:if test="${viewSearchForm.showUid}"><td class="top userInfo"></td></c:if>
		<c:if test="${viewSearchForm.showLastName}"><td class="top userInfo"></td></c:if>
		<c:if test="${viewSearchForm.showMi}"><td class="top userInfo"></td></c:if>
		<c:if test="${viewSearchForm.showGivenName}"><td class="top userInfo"></td></c:if>
		<c:if test="${viewSearchForm.showEmail}"><td class="top userInfo"></td></c:if>
		<c:if test="${viewSearchForm.showStudentId}"><td class="top userInfo"></td></c:if>		
	</c:otherwise>
	</c:choose>

		<c:forEach var="gradeWrapper" items="${gradeLine.grades}">
			<c:set var="attempts">${fn:length(gradeWrapper.grades)}</c:set>
			<c:set var="attempt">0</c:set>

			<td class="borderLeft">
			
			<c:forEach var="grade" items="${gradeWrapper.grades}">
			
		
				<c:set var="styleClass"><c:if test="${attempt > 0}">extraAttempt</c:if></c:set>
			<span class="grade block ${styleClass}" id="grade${grade.id}" title="${grade.grade}/${grade.total}">

				<c:choose>
					<c:when test="${grade.emptyGrade}">
						<fmt:message key="label.decorator.number.empty"/>
					</c:when>
					<c:when test="${viewSearchForm.gradingStyle == PERCENTAGE}">
						${grade.percent}
					</c:when>
					<c:when test="${viewSearchForm.gradingStyle == LETTER}">
						${grade.letter}
					</c:when>
					<c:otherwise>
						${grade}
					</c:otherwise>
				</c:choose>
				<c:if test="${viewSearchForm.active == IN_PROGRESS}"><fmt:message key="label.decorator.number.inProgress"/></c:if>
			</span>	
	
				<c:set var="attempt">${attempt+1}</c:set>
			</c:forEach>

			<c:set var="diff">${maxAttempts-attempts}</c:set>

			<c:if test="${diff >= 0}">		
				<c:forEach begin="1" end="${diff}">
					<c:set var="styleClass"><c:if test="${attempt > 0}">extraAttempt</c:if></c:set>
					<span class="block ${styleClass}"><fmt:message key="label.decorator.number.empty"/></span>
					<c:set var="attempt">${attempt+1}</c:set>
				</c:forEach>
			</c:if>
			</td>			
		</c:forEach>
			<td class="top total">
				<c:choose>
					<c:when test="${gradeLine.total.emptyGrade}">
						<fmt:message key="label.decorator.number.empty"/>
					</c:when>
					<c:when test="${viewSearchForm.gradingStyle == PERCENTAGE}">
						${gradeLine.total.percent}
					</c:when>
					<c:when test="${viewSearchForm.gradingStyle == LETTER}">
						${gradeLine.total.letter}
					</c:when>
					<c:otherwise>
						${gradeLine.total}
					</c:otherwise>
				</c:choose>
			</td>				
		</tr>
</c:forEach>
	</tbody>

</table>

<!-- ** put the Labels onto the screen ** -->
<tiles:insert definition=".gbk.page.labels">
	<tiles:put name="gradesTable" beanName="gradesTable"/>
</tiles:insert>

</c:otherwise>
</c:choose>

