/*
 * Decompiled with CFR 0.152.
 */
package applets.labelImage;

import applets.MessageUtilities;
import applets.util.URLEncoder;
import applets.util.WarningDialog;
import java.applet.Applet;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;

public class LabelImage
extends Applet {
    private static final String LEFT_STR = "left";
    private static final String CENTER_STR = "center";
    private static final String RIGHT_STR = "right";
    private static final int LEFT = 0;
    private static final int CENTER = 1;
    private static final int RIGHT = 2;
    private Image img;
    private String[] labels;
    private Point[] positions;
    private int[] align;
    private Frame holderFrame;
    Locale mtaLocale = new Locale("en", "US");

    public void init() {
        String[] locale;
        try {
            locale = this.getParameter("mtalocale").split("_");
        }
        catch (Exception e) {
            locale = "en_US".split("_");
        }
        if (locale.length == 1) {
            this.mtaLocale = new Locale(locale[0]);
        } else if (locale.length == 2) {
            this.mtaLocale = new Locale(locale[0], locale[1]);
        } else if (locale.length == 3) {
            this.mtaLocale = new Locale(locale[0], locale[1], locale[2]);
        }
        this.holderFrame = new Frame();
        try {
            this.img = this.getImage(this.completeURL(this.getParameter("image")));
        }
        catch (Exception e) {
            this.dialog(this.getParameter("image"));
            e.printStackTrace();
        }
        int k = Integer.parseInt(this.getParameter("size"));
        this.positions = new Point[k];
        this.labels = new String[k];
        this.align = new int[k];
        int i = 0;
        while (i < k) {
            String name = "label." + (i + 1);
            int x = Integer.parseInt(this.getParameter(String.valueOf(name) + ".x"));
            int y = Integer.parseInt(this.getParameter(String.valueOf(name) + ".y"));
            this.positions[i] = new Point(x, y);
            this.labels[i] = this.parseEntities(this.getParameter(String.valueOf(name) + ".text"));
            String s = this.getParameter(String.valueOf(name) + ".align");
            this.align[i] = s == null || s.equals(LEFT_STR) ? 0 : (s.equals(CENTER_STR) ? 1 : (s.equals(RIGHT_STR) ? 2 : 0));
            ++i;
        }
    }

    private URL completeURL(String tail) throws MalformedURLException {
        try {
            return new URL(URLEncoder.encode(tail));
        }
        catch (Exception e) {
            URL rep = new URL(URLEncoder.encode(this.getDocumentBase().toString().replaceAll("/([^/])+$", "")));
            URL db = new URL(rep, URLEncoder.encode(tail));
            return db;
        }
    }

    public void dialog(String img) {
        this.showStatus("Error loading image..." + img);
        new WarningDialog(this.holderFrame, String.valueOf(MessageUtilities.getMessage(this.mtaLocale, "LabelImage.LoadingImage.Error")) + "\n \n" + "   " + img, this.mtaLocale).show();
    }

    public void paint(Graphics g) {
        Font theFont = new Font("TimesRoman", 0, 14);
        FontMetrics fm = g.getFontMetrics(theFont);
        g.drawImage(this.img, 0, 0, this);
        g.setFont(theFont);
        int i = 0;
        while (i < this.labels.length) {
            int x;
            String label = this.labels[i];
            switch (this.align[i]) {
                case 1: {
                    x = this.positions[i].x;
                    break;
                }
                case 2: {
                    x = this.positions[i].x - fm.stringWidth(label);
                    break;
                }
                default: {
                    x = this.positions[i].x - fm.stringWidth(label) / 2;
                }
            }
            int y = this.positions[i].y;
            g.drawString(label, x, y);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private String parseEntities(String s) {
        out = new StringBuffer();
        i = 0;
        while (i < s.length()) {
            block3: {
                block4: {
                    block2: {
                        c = s.charAt(i);
                        if (c == '&') break block2;
                        out.append(c);
                        break block3;
                    }
                    numStr = new StringBuffer();
                    if ((c = s.charAt(++i)) == '#') break block4;
                    out.append(c);
                    break block3;
                }
                if ((c = s.charAt(++i)) == 'x' || c == 'X') ** GOTO lbl22
                out.append(c);
                break block3;
lbl-1000:
                // 1 sources

                {
                    numStr.append(c);
lbl22:
                    // 2 sources

                    ** while ((c = s.charAt((int)(++i))) != ';' && c > ' ')
                }
lbl23:
                // 1 sources

                out.append((char)Integer.parseInt(numStr.toString(), 16));
            }
            ++i;
        }
        return out.toString();
    }
}

