/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mapleta.hotfix.installer;

import com.maplesoft.mapleta.hotfix.installer.BackupException;
import com.maplesoft.mapleta.hotfix.installer.CommandLineInfo;
import com.maplesoft.mapleta.hotfix.installer.HotfixDef;
import com.maplesoft.mapleta.hotfix.installer.InstallException;
import com.maplesoft.mapleta.hotfix.installer.InstallableFileOperationSpec;
import com.maplesoft.mapleta.hotfix.installer.MapleTAInstallationManager;
import com.maplesoft.mapleta.hotfix.installer.RevertException;
import com.maplesoft.mapleta.hotfix.installer.TomcatInstallationManager;
import com.maplesoft.mapleta.hotfix.installer.UpdateLogger;
import com.maplesoft.mapleta.hotfix.installer.ValidationException;
import java.io.File;
import java.io.IOException;

public class Installer {
    private static CommandLineInfo commandLineInfo;
    private static HotfixDef hotfixDef;
    private TomcatInstallationManager tomcatInstallationManager;
    private static MapleTAInstallationManager mapleTAInstallationManager;

    public static CommandLineInfo getCommandLineInfo() {
        return commandLineInfo;
    }

    public static HotfixDef getHotfixDef() {
        return hotfixDef;
    }

    public String getHotfixId() {
        return hotfixDef.getHotfixId();
    }

    public boolean isRevert() {
        return commandLineInfo.isRevert();
    }

    public boolean isForce() {
        return commandLineInfo.isForce();
    }

    public Installer(String[] args) throws Exception {
        try {
            commandLineInfo = new CommandLineInfo(args);
        }
        catch (IllegalArgumentException ex) {
            throw new Exception("Hotfix Installer: error while processing command-line arguments.", ex);
        }
        this.InitializeOutputFolders();
        UpdateLogger.getLogger().Log("Maple T.A. hotfix processing starting.");
        try {
            hotfixDef = new HotfixDef();
        }
        catch (IOException ex) {
            throw new Exception("Hotfix Installer: error while processing hotfix definition file.", ex);
        }
    }

    public void Run() throws Exception {
        this.InitializeTomcatInstallationManager();
        this.ValidateTAVersion();
        this.InitializeMapleTAInstallationManager();
        mapleTAInstallationManager.InitializeHotfixLog();
        this.ValidateNotAlreadyInstalled();
        this.ValidateSourcesAndTargets();
        if (!commandLineInfo.isRevert() && !commandLineInfo.isForce()) {
            this.BackupTargets();
        }
        if (commandLineInfo.isRevert()) {
            this.RevertTargets();
        } else {
            this.InstallTargets();
        }
    }

    private void InitializeOutputFolders() throws Exception {
        String[] stringArray = new String[]{"log", "backup"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String folder = stringArray[n2];
            File file = new File(folder);
            if (!file.isDirectory() && !file.mkdir()) {
                throw new Exception(String.format("Unable to create output folder '%s'.", file.getAbsolutePath()));
            }
            ++n2;
        }
    }

    private void InitializeTomcatInstallationManager() throws Exception {
        String userSpecifiedTomcatFolder = hotfixDef.getTomcatFolder();
        this.tomcatInstallationManager = new TomcatInstallationManager(userSpecifiedTomcatFolder);
    }

    private void InitializeMapleTAInstallationManager() throws Exception {
        mapleTAInstallationManager = new MapleTAInstallationManager(this.tomcatInstallationManager);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void ValidateNotAlreadyInstalled() throws Exception {
        String msg;
        boolean isPartlyInstalled = false;
        boolean isFullyInstalled = true;
        for (InstallableFileOperationSpec installable : hotfixDef.getInstallableFileOperationSpecs(this.tomcatInstallationManager.getMapletaDeploymentFolder())) {
            if (installable.isInstalled()) {
                isPartlyInstalled = true;
                continue;
            }
            isFullyInstalled = false;
        }
        if (isPartlyInstalled && commandLineInfo.isInstall()) {
            if (commandLineInfo.isForce()) {
                UpdateLogger.getLogger().Log(String.format("Warning, it appears that this hotfix is already %s installed, but you have specified '%s' so install will continue.", isFullyInstalled ? "fully" : "partly", commandLineInfo.getSpecifiedForceParameterName()));
                return;
            }
            msg = String.format("It appears that this hotfix is already %s installed. Installation will abort. If you wish to install in spite of this situation, rerun with the %s parameter.", isFullyInstalled ? "fully" : "partly", commandLineInfo.getSpecifiedForceParameterName());
            throw new Exception(msg);
        }
        if (isPartlyInstalled) return;
        if (!commandLineInfo.isRevert()) return;
        if (commandLineInfo.isForce()) {
            UpdateLogger.getLogger().Log(String.format("Warning, it appears that this hotfix is not installed, but you have specified '%s' so revert will continue.", isPartlyInstalled ? "only partly" : "not", commandLineInfo.getSpecifiedForceParameterName()));
            return;
        }
        msg = String.format("It appears that this hotfix is not installed. Revert will abort. If you wish to revert in spite of this situation, rerun with the %s parameter.", isPartlyInstalled ? "only partly" : "not", commandLineInfo.getSpecifiedForceParameterName());
        throw new Exception(msg);
    }

    private void ValidateTAVersion() throws Exception {
        String majorTAVersion = this.tomcatInstallationManager.getMajorTAVersion();
        String minorTAVersion = this.tomcatInstallationManager.getMinorTAVersion();
        String flatTAVersion = String.valueOf(majorTAVersion) + minorTAVersion;
        if (!hotfixDef.getHotfixFlatVersionNumber().equals(flatTAVersion)) {
            throw new Exception(String.format("The deployed Maple T.A. version is %s. This hotfix can only be applied to %s.", flatTAVersion, hotfixDef.getHotfixFlatVersionNumber()));
        }
        UpdateLogger.getLogger().Log(String.format("The deployed Maple T.A. is version %s.%s.", majorTAVersion, minorTAVersion));
    }

    private void ValidateSourcesAndTargets() throws ValidationException {
        for (InstallableFileOperationSpec installable : hotfixDef.getInstallableFileOperationSpecs(this.tomcatInstallationManager.getMapletaDeploymentFolder())) {
            if (commandLineInfo.isRevert()) {
                installable.ValidateRevert();
                continue;
            }
            installable.ValidateInstall(commandLineInfo.isForce());
        }
    }

    private void BackupTargets() throws BackupException {
        UpdateLogger.getLogger().Log("Backing up.");
        for (InstallableFileOperationSpec installable : hotfixDef.getInstallableFileOperationSpecs(this.tomcatInstallationManager.getMapletaDeploymentFolder())) {
            installable.Backup();
        }
    }

    private void InstallTargets() throws InstallException {
        UpdateLogger.getLogger().Log(String.format("Installing hotfix %s to '%s'.", hotfixDef.getHotfixId(), this.tomcatInstallationManager.getMapletaDeploymentFolder()));
        for (InstallableFileOperationSpec installable : hotfixDef.getInstallableFileOperationSpecs(this.tomcatInstallationManager.getMapletaDeploymentFolder())) {
            installable.Install();
        }
    }

    private void RevertTargets() throws RevertException {
        UpdateLogger.getLogger().Log(String.format("Reverting hotfix %s from '%s'.", hotfixDef.getHotfixId(), this.tomcatInstallationManager.getMapletaDeploymentFolder()));
        for (InstallableFileOperationSpec installable : hotfixDef.getInstallableFileOperationSpecs(this.tomcatInstallationManager.getMapletaDeploymentFolder())) {
            installable.Revert();
        }
    }
}

