<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@ page import="com.maplesoft.mapleta.session.SessionManager" %>

<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html" %>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic" %>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<tiles:useAttribute name="isStudent" ignore="true"/>

<c:if test="${isStudent == 'true'}">
	<html:hidden property="userFilter"/>
	<html:hidden property="userList"/>
	<html:hidden property="showStudents"/>
	<html:hidden property="showInstructors"/>
	<html:hidden property="showProctors"/>
</c:if>

<div>
<a href="#" onClick="toggleItem('gbkAdvanced'); this.blur(); return false;">
	<span class="toggle"> <img
			src="modules/configureClasses/images/closeDirIcon.gif" border="0"
			id="gbkAdvancedTwisty"> <fmt:message key="label.search.advanced.panel" />
	</span>
</a>
<table id="gbkAdvancedTable" class="panel" cellpadding="2" cellspacing="2">
<tr>
	<td rowspan="4"><tiles:insert attribute="classChooser"/></td>

<c:if test="${empty isStudent}">
	<td><strong><fmt:message key="label.search.header.userfilter"/>:</strong></td>
	<td>
		<tiles:insert attribute="userFilter" />
	</td>
</c:if>
	<td><strong><fmt:message key="label.search.header.resultType"/>:</strong></td>
	<td>
		<tiles:insert attribute="resultType" />
	</td>	
</tr>
<tr>
<c:if test="${empty isStudent}">
	<td><strong><fmt:message key="label.view.header.userList"/>:</strong></td>
	<td>
		<tiles:insert attribute="userList" />
	</td>
</c:if>
	<td><strong><fmt:message key="label.search.header.active"/>:</strong></td>
	<td>
		<tiles:insert attribute="active" />
	</td>
</tr>
<tr>
<c:if test="${empty isStudent}">
	<td rowspan="2" valign="top"><strong><fmt:message key="label.view.header.userResults"/>:</strong></td>
	<td rowspan="2">
		<tiles:insert attribute="userResults"/>
	</td>
</c:if>
	<td><strong><fmt:message key="label.dateRangeStart"/></strong></td>
	<td>
		<html:hidden property="dateRangeStart" styleId="dateRangeStart_if" />
		<input type="text" readonly="true" id="dateRangeStart_da" size="15">
		<img src="jscalendar-1.0/img.gif" id="dateRangeStart_trigger">
		&nbsp;
		<a href="#" onclick="clearDate('dateRangeStart_if','dateRangeStart_da');return false;"><fmt:message key="label.clear"/></a>
	</td>
</tr>
<tr>
	<td><strong><fmt:message key="label.dateRangeEnd"/></strong></td>
	<td>
		<html:hidden property="dateRangeEnd" styleId="dateRangeEnd_if" />
		<input type="text" readonly="true" id="dateRangeEnd_da" size="15">
		<img src="jscalendar-1.0/img.gif" id="dateRangeEnd_trigger">
		&nbsp;
		<a href="#" onclick="clearDate('dateRangeEnd_if','dateRangeEnd_da');return false;"><fmt:message key="label.clear"/></a>
	</td>
</tr>	
</table>
</div>

<script>
	<c:choose>
		<c:when test="${locale == java.util.Locale.US}">
			var daFmt = "%m/%d/%Y";
		</c:when>
		<c:otherwise>
			var daFmt = "%d/%m/%Y";
		</c:otherwise>
	</c:choose>	

	<%-- Simple i18n of date format --%>
		
	// Create a Calenar object 
	// create this onload so that it works in IE, there is a known race condition
	// with timeouts in IE that throws exception if this is not created on page load
	window.onload=function() {
		window.calendar = new Calendar();
		window.calendar.create();
	}
	
	// When the page is loaded, use the epoch timestamp that was
	// provided by the form bean, if any, to initialize the display. 
	function calInit(ifStr, daStr) {
		var displayArea = document.getElementById(daStr);
		var inputField = document.getElementById(ifStr);
		
		if (inputField.value) {
			var i = parseInt(inputField.value);
			if (i > 0) {
				var d = new Date(parseInt(inputField.value));
				displayArea.value = d.print(daFmt);
			}
		}
	}
	calInit("dateRangeStart_if", "dateRangeStart_da");
	calInit("dateRangeEnd_if", "dateRangeEnd_da");
	
	// Event handler for when the popup button is clicked
	function calOnClick(clicker, ifStr, daStr) {
		var cal = window.calendar;
		var inputField = document.getElementById(ifStr);
		var displayArea = document.getElementById(daStr);
		
		// Event handler to perform when a date is selected.
		// Note that the action performed will target the 
		// inputField and displayArea of the selector that was
		// last clicked.
		cal.onSelected = function (cal, date) {
		
			inputField.value = cal.date.print("%s") + "000"; // Use milliseconds since Epoch
			displayArea.value = cal.date.print(daFmt);
		
			cal.hide(); // one-click behavior
		};
		
		// Event handler for when the calendar is closed. Since a shared
		// calendar is cached, merely hide it.
		cal.onClose = function (cal) {
			cal.hide();
		};
		
		// Set the calendar to the date carried by the form bean, if any
		if (inputField.value) {
			var i = parseInt(inputField.value);
			if (i > 0) {
				cal.setDate(new Date(i));
			} else {
				cal.setDate(new Date());
			}
		}
		cal.showAtElement(clicker);
	}
	
	function clearDate(ifStr, daStr) {
		var inputField = document.getElementById(ifStr);
		var displayArea = document.getElementById(daStr);
		inputField.value="";
		displayArea.value="";	
	}
	
	document.getElementById("dateRangeStart_trigger").onclick = function () {
		calOnClick(this, "dateRangeStart_if", "dateRangeStart_da");
	};
	
	document.getElementById("dateRangeEnd_trigger").onclick = function () {
		calOnClick(this, "dateRangeEnd_if", "dateRangeEnd_da");
	};
</script>
