<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@ page import="com.maplesoft.mapleta.gateway.GatewayService"%>

<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html" %>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic" %>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>


<%@page import="com.maplesoft.mapleta.session.Context"%>
<%@page import="com.maplesoft.mapleta.session.Role"%><tiles:useAttribute name="snapshots"/>
<c:set var="allowed"><%= Context.getContext(request.getSession()).getRole().atLeast(Role.PROCTOR)%></c:set>

<script>
function submitForm(action) {
	
	document.getElementById('actionMethod').value=action;

	var form = document.getElementById('selectSnapshotForm');
	var actionPage = "gradebook/" + action + "Report.do";
	

		form.action = actionPage;
	
		
	if( verifyForm() ) {
		form.submit();
	}
}

function verifyForm() {

<c:if test="${sessionScope.snapshot_edit}">
	if( !confirm("<fmt:message key='gbk.gradebooks.editing.msg'/>") ) {
		return false;
	}	
</c:if>

	var action = document.getElementById('actionMethod').value;
	if( action == 'Edit' ) {
		var report = document.getElementById('reportIds');
		if( !report.value ) {
			alert("<fmt:message key='gbk.gradebooks.none_selected.msg'/>");
			return false;
		}	
	} 	
	else if( action == 'Load' ) {
		var report = document.getElementById('reportIds');
		if( !report.value ) {
			alert("<fmt:message key='gbk.gradebooks.none_selected.msg'/>");
			return false;
		}	
	} 	
	else if( action == 'Delete' ) {
		var report = document.getElementById('reportIds');
		if( !report.value ) {
			alert("<fmt:message key='gbk.gradebooks.none_selected.msg'/>");
			return false;
		}	

		if( !confirm("<fmt:message key='gbk.gradebooks.confirmDelete.msg'/>") ) {
			return false;
		}	
	} 
	return true;
}

</script>

<html:form action="/LoadReport.do" styleId="selectSnapshotForm" onsubmit="return verifyForm();">
<input type="hidden" id="actionMethod" value="Load"/>
<table>
	<tr>
		<td>
			<strong><fmt:message key="gbk.gradebooks.label"/>:</strong><br/>
			<html:select styleId="reportIds" property="id" size="4" style="width:300px;">
				<c:choose>
					<c:when test="${fn:length(snapshots) > 0}">
				<c:forEach var="snapshot" items="${snapshots}">
					<c:if test="${snapshot.visible || allowed}">
						<html:option value="${snapshot.id}">${snapshot.name}</html:option>
					</c:if>
				</c:forEach>
					</c:when>
					<c:otherwise>
						<option disabled="disabled"><fmt:message key="gbk.gradebooks.none_found.label"/></option>
					</c:otherwise>
				</c:choose>
			</html:select>


		</td>
<c:choose>
<c:when test="${allowed}">
		<td rowspan="2">
			<tiles:insert definition=".gbk.panel.search.classChooser" />
<%--
	<input type="hidden" name="classSelection" value="${snapshotForm.singleClassSelection}"/>
--%>

		</td>
		<td></td>

		<td rowspan="2">
			<table cellspacing="0" cellpadding="0">
				<tr>
					<td><strong><fmt:message key="label.search.header.userfilter"/>:</strong></td>
					<td><tiles:insert definition=".gbk.panel.search.userFilter" /></td>		
				</tr>
				<tr>
					<td><strong><fmt:message key="label.view.header.userList"/>:</strong></td>
					<td><tiles:insert definition=".gbk.panel.search.userList" /></td>		
				</tr>
				<tr>
					<td><strong><fmt:message key="label.view.header.userResults"/>:</strong></td>
					<td><tiles:insert definition=".gbk.panel.search.userResults" /></td>
				</tr>
			</table>			
		</td>
</c:when>
<c:otherwise>
	<input type="hidden" name="classSelection" value="${snapshotForm.singleClassSelection}"/>
	<html:hidden property="showStudents"/>
	<html:hidden property="userList"/>
</c:otherwise>
</c:choose>
	</tr>
	<tr>
		<td>
<c:choose>
	<c:when test="${allowed}">
			<input type="button" class="button" onclick="submitForm('New');" value='<fmt:message key="gbk.gradebooks.new.label"/>'/>
		<c:if test="${fn:length(snapshots) > 0}">
			<input type="button" class="button" onclick="submitForm('Edit');" value='<fmt:message key="gbk.gradebooks.edit.label"/>'/>
			<input type="button" class="button" onclick="submitForm('Load');" value='<fmt:message key="gbk.gradebooks.load.label"/>'/>
			<input type="button" class="button" onclick="submitForm('Delete');" value='<fmt:message key="AddExternalForm.delete.label"/>'/>
		</c:if>
	</c:when>
	<c:otherwise><input type="button" class="button" onclick="submitForm('Load');" value='<fmt:message key="gbk.gradebooks.load.label"/>'/></c:otherwise>
</c:choose>
		</td>
	</tr>

	
	
</table>



</html:form>

