<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://www.rabago.net/tags-valid2" prefix="html2"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>

<tiles:useAttribute name="isLDAPEnabled" ignore="true"/>
<tiles:useAttribute name="allowSelfRegistration" ignore="true"/>

<tiles:useAttribute name="startError" ignore="true"/>

<style>
	table.login {
		border: solid #777777 10px;
		margin: 1em;
		padding: 10px;
		background-color: #cccccc;
		font-family: sans-serif;
	}
	table.errors {
		border: solid white 10 px;
		margin: 1em;
		font-family: sans-serif;
	}
	td.login td.errors{
		padding: 10px;
		
	}
</style>

<fmt:bundle	basename="com.maplesoft.mapleta.application.ApplicationResources">

<c:choose>
	<c:when test="${startError}">
		<span class="errorStyle1"><fmt:message key="ServerStart.error.msg"/></span>
	</c:when>
	<c:otherwise>

	<html2:form action="/login" method="post" focus="login" validatorForm="LoginActionForm">
		<html:hidden property="terminateOldSession"/>
	
		<logic:messagesPresent message="false">
			<p>
				<html:messages id="msg" message="false" property="userCreated">
					<span class="errorStyle1"><c:out value='${msg}' /></span><br/>
				</html:messages>
			</p>
		</logic:messagesPresent>
	
		<table style="{padding:20px;}">
		
			<tr>
				<td valign="top">
					<table class="login">
						<html2:field property="login">
						<tr height="25">
								<td style="text-align: right;padding:5px 5px 0px 5px; font-weight: bold; color:#444444;">
									<html2:label  />
								</td>
								<td style="padding:5px 5px 0px 0px;">
									<html2:text style="width:100%;"/>
								</td>
						</tr>
						</html2:field>
						<html2:field property="password">
						<tr height="25">
								<td style="text-align: right;padding:0px 5px 0px 5px; font-weight: bold; color:#444444;">
									<html2:label  />
								</td>
								<td style="padding:0px 5px 0px 0px;">
									<html2:password style="width:100%;"/>
								</td>
						</tr>
						</html2:field>
						<tr height="25">
							<td style="text-align: right;padding:0px 5px 0px 5px; font-weight: bold; color:#444444;">&nbsp;</td>			
							<td style="padding:10px 5px 0px 0px; text-align: center;">
								<html2:submit styleClass="button"><fmt:message key='LoginActionForm.button.submit.label' /></html2:submit>
					<c:if test="${ not isLDAPEnabled }">
							</td>
						</tr>
						<tr height="25">
							<td style="text-align: right;padding:0px 5px 0px 5px; font-weight: bold; color:#444444;">&nbsp;</td>			
							<td style="padding:0px 5px 0px 0px; text-align: center;">
									<a href="passwordreset/PasswordReset.do">	      			
										<fmt:message key="LoginActionForm.passwordForgot.msg" />
									</a>
						<c:if test="${ allowSelfRegistration }">
									<br/>
									<fmt:message key="LoginActionForm.notregistered.msg"/>
										<a href="login/Register.do">	      			
											<fmt:message key="LoginActionForm.register.label" />
										</a>
						</c:if>
					</c:if>					
							</td>
						</tr>
					</table>
				</td>
				<td valign="top">
					<table class="errors">
						<html2:field property="login">
						<tr height="25">
								<td valign="top">
									<html2:error styleClass="errorStyle1" />
								</td>
						</tr>
						</html2:field>
						<html2:field property="password">
						<tr height="25">
								<td valign="top">
									<html2:error styleClass="errorStyle1" />
								</td>
						</tr>
						</html2:field>
						<tr height="25"><td>&nbsp;</td></tr>
					</table>
				</td>
			</tr>
			<tr>
				<td colspan="2">
					<a>&nbsp;&nbsp;&nbsp;</a>
					<a href="" onclick="javascript:window.open(getBaseURL()+'modules/supported.jsp','SupportedBrowsers','width=650,height=450,scrollbars,resizable').focus(); return false;">	      			
	      				<fmt:message key='LoginActionForm.supportedBrowsers.msg' />
					</a>
				</td>
			</tr>
		</table>
	</html2:form>
	 <logic:messagesPresent>
		<table border=0>
			<tr>
				<td>
					<span class="errorStyle1">
						<html:messages id="msg" property="badLogin">
							<bean:write name="msg" />
						</html:messages>
					</span>
				</td>
			</tr>
		</table>		
	</logic:messagesPresent>
	<html2:html2Javascript labelErrorStyleClass="errorStyle1" xmlHttpRequest="false" />
	
	<script type="text/javascript">
		var msg = "<fmt:message key='LoginActionForm.sessionExists.error'/>";
	</script>
	<c:if test="${LoginActionForm.showConfirmation}">
		<script type="text/javascript">
			if (confirm(msg)) {
				LoginActionForm.terminateOldSession.value=true;
				LoginActionForm.submit();
			}
		</script>
	</c:if>

</c:otherwise>
</c:choose>


</fmt:bundle>


