/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mapleta.hotfix.installer;

import com.maplesoft.mapleta.hotfix.installer.UpdateLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTools {
    public static void copy(File source, File dest) throws IOException {
        UpdateLogger.getLogger().Log(String.format("Copying '%s' to '%s'.", source.getAbsolutePath(), dest.getAbsolutePath()));
        FileInputStream in = new FileInputStream(source);
        FileOutputStream out = new FileOutputStream(dest);
        byte[] buf = new byte[(int)source.length()];
        ((InputStream)in).read(buf);
        ((OutputStream)out).write(buf, 0, buf.length);
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static boolean areIdentical(File filea, File fileb) throws Exception {
        if (filea.length() != fileb.length()) {
            return false;
        }
        if (filea.length() == 0L) {
            return true;
        }
        byte[] bufa = FileTools.LoadBinaryFileContents(filea);
        byte[] bufb = FileTools.LoadBinaryFileContents(fileb);
        int i = 0;
        while (i < bufa.length) {
            if (bufa[i] != bufb[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static byte[] LoadBinaryFileContents(File file) throws Exception {
        FileInputStream stream = new FileInputStream(file);
        byte[] buf = new byte[(int)file.length()];
        ((InputStream)stream).read(buf);
        ((InputStream)stream).close();
        return buf;
    }

    public static List<String> LoadTextFileLines(File file) throws FileNotFoundException, IOException {
        String line;
        ArrayList<String> fileLines = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            fileLines.add(line);
        }
        reader.close();
        return fileLines;
    }
}

