/*
 * Decompiled with CFR 0.152.
 */
package applets.util;

import java.io.UnsupportedEncodingException;

public class URLEncoder {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String encode(String input) {
        if (input == null || "".equals(input)) {
            return new String(input);
        }
        StringBuffer output = new StringBuffer();
        int index = 0;
        while (index < input.length()) {
            output.append(URLEncoder.escape(input.charAt(index)));
            ++index;
        }
        return output.toString();
    }

    private static String escape(char input) {
        StringBuffer output = new StringBuffer();
        if (input <= '\u007f') {
            return output.append(input).toString();
        }
        try {
            byte[] bytes = String.valueOf(input).getBytes("UTF-8");
            int i = 0;
            while (i < bytes.length) {
                output.append('%').append(DIGITS[(0xF0 & bytes[i]) >> 4]).append(DIGITS[0xF & bytes[i]]);
                ++i;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            output = new StringBuffer();
            return output.append(input).toString();
        }
        return output.toString().toUpperCase();
    }
}

