/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util.encoder;

import com.maplesoft.util.encoder.DefaultEncoder;
import com.maplesoft.util.encoder.codepage.AbstractCodePage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;

public abstract class AbstractStringEncoder {
    public static final String OCTAL_REGEX = "(?s:.*\\\\[0-7]{3}.*)";
    public static final int SINGLE_BYTE = 0;
    public static final int DOUBLE_BYTE = 1;
    private static HashMap nameMap = new HashMap();
    private Mapping mapping;
    private String name;

    protected AbstractStringEncoder(String string) {
        this.name = string;
        this.initialize();
    }

    protected void initialize() {
        if (this.name != null) {
            Object v = nameMap.get(this.name);
            if (v == null) {
                AbstractCodePage[] abstractCodePageArray = this.getCodePages();
                if (abstractCodePageArray != null) {
                    this.mapping = new Mapping();
                    if (abstractCodePageArray != null) {
                        for (int i = 0; i < abstractCodePageArray.length; ++i) {
                            abstractCodePageArray[i].encode(this.mapping);
                        }
                    }
                    nameMap.put(this.name, this.mapping);
                }
            } else {
                this.mapping = (Mapping)v;
            }
        }
    }

    public int[] toUnicode(int[] nArray) {
        return this.mapping.toUnicode(nArray);
    }

    public int[] fromUnicode(int[] nArray) {
        return this.mapping.fromUnicode(nArray);
    }

    public int canEncodeUpTo(String string) {
        int[] nArray = new int[string.length()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = string.charAt(i);
        }
        return this.mapping.canEncodeUpTo(nArray);
    }

    public boolean canEncodeCharacter(char c) {
        return this.mapping.canEncodeUpTo(new int[]{c}) == -1;
    }

    private AbstractCodePage[] getCodePages() {
        AbstractCodePage[] abstractCodePageArray = null;
        String[] stringArray = this.getPageRefs();
        if (stringArray != null) {
            abstractCodePageArray = new AbstractCodePage[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                abstractCodePageArray[i] = this.instantiatePage(stringArray[i]);
            }
        }
        return abstractCodePageArray;
    }

    private AbstractCodePage instantiatePage(String string) {
        AbstractCodePage abstractCodePage = null;
        String string2 = "com.maplesoft.util.encoder.codepage." + this.name + "Page" + string;
        try {
            Class<?> clazz = Class.forName(string2);
            abstractCodePage = (AbstractCodePage)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            abstractCodePage = null;
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
            abstractCodePage = null;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            abstractCodePage = null;
        }
        return abstractCodePage;
    }

    public String getName() {
        return this.name;
    }

    public abstract String toUnicode(String var1);

    public abstract String fromUnicode(String var1);

    public abstract int getType();

    protected abstract String[] getPageRefs();

    public static String xmlEncode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > '\u007f' && c <= '\u00ff' || c == '\\') {
                stringBuffer.append('\\');
                stringBuffer.append(Integer.toOctalString(c));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String xmlDecode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (n2 + 3 < n && c == '\\' && Character.isDigit(string.charAt(n2 + 1)) && Character.isDigit(string.charAt(n2 + 2)) && Character.isDigit(string.charAt(n2 + 3))) {
                int n3 = (string.charAt(n2 + 1) - 48) * 64;
                n3 += (string.charAt(n2 + 2) - 48) * 8;
                stringBuffer.append((char)(n3 += string.charAt(n2 + 3) - 48));
                n2 += 4;
                continue;
            }
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String xmlEncodeMWS(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > '\u007f' && c <= '\u00ff') {
                stringBuffer.append('\\');
                stringBuffer.append(Integer.toOctalString(c));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String rtfEncode(String string) {
        return AbstractStringEncoder.rtfEncode(string, string, false);
    }

    public static String rtfEncode(String string, String string2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        boolean bl2 = false;
        for (n2 = 0; n2 < n; ++n2) {
            if (string.charAt(n2) <= '\u00ff') continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            DefaultEncoder defaultEncoder = new DefaultEncoder();
            string = defaultEncoder.fromUnicode(string);
        }
        if (bl) {
            boolean bl3 = true;
            int n3 = 0;
            for (n2 = 0; n2 < n; ++n2) {
                char c = string.charAt(n2);
                if (c > '\u007f' || !bl3) {
                    boolean bl4;
                    char c2 = string2.charAt(n3);
                    boolean bl5 = bl4 = '\uff66' <= c2 && c2 <= '\uff9f';
                    if (bl3) {
                        if (!bl4) {
                            stringBuffer.append("\\uc2\\u");
                        } else {
                            stringBuffer.append("\\uc1\\u");
                            ++n3;
                        }
                        stringBuffer.append((int)c2);
                    } else {
                        ++n3;
                    }
                    stringBuffer.append("\\'");
                    stringBuffer.append(Integer.toHexString(c));
                    if (bl4) continue;
                    bl3 = !bl3;
                    continue;
                }
                stringBuffer.append(c);
                ++n3;
            }
        } else {
            stringBuffer.append("\\uc1");
            for (n2 = 0; n2 < n; ++n2) {
                char c = string.charAt(n2);
                if (c > '\u007f') {
                    stringBuffer.append("\\u");
                    stringBuffer.append((int)c);
                }
                stringBuffer.append(c);
            }
        }
        return stringBuffer.toString();
    }

    private static class ArrayKey {
        private int[] theArray = null;

        public ArrayKey(int[] nArray) {
            this.theArray = nArray;
        }

        public ArrayKey(int n) {
            int[] nArray = new int[]{n};
            this.theArray = nArray;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (!(!(object instanceof ArrayKey) || object == null && this.theArray != null || object != null && this.theArray == null)) {
                if (object == null && this.theArray == null) {
                    bl = true;
                } else {
                    int[] nArray = ((ArrayKey)object).getArray();
                    if (nArray.length == this.theArray.length) {
                        bl = true;
                        for (int i = 0; i < this.theArray.length; ++i) {
                            if (nArray[i] == this.theArray[i]) continue;
                            bl = false;
                            break;
                        }
                    }
                }
            }
            return bl;
        }

        public int hashCode() {
            int n = 0;
            for (int i = 0; i < this.theArray.length; ++i) {
                n ^= this.theArray[i] * i;
            }
            return n;
        }

        public String toString() {
            if (this.theArray != null) {
                StringBuffer stringBuffer = new StringBuffer(this.theArray.length * 2);
                for (int i = 0; i < this.theArray.length; ++i) {
                    stringBuffer.append(Integer.toHexString(this.theArray[i]));
                    stringBuffer.append(' ');
                }
                return stringBuffer.toString();
            }
            return null;
        }

        public int[] getArray() {
            return this.theArray;
        }
    }

    public static class Mapping {
        private int UNKNOWN_CHAR = 63;
        private int[][] toUnicodeMap = new int[256][];
        private int[][] fromUnicodeMap = new int[256][];
        private HashMap toUnicodeMultiMap = null;
        private HashMap fromUnicodeMultiMap = null;
        private int maxSequenceLength = 1;

        public void addMapping(int n, int n2) {
            int n3 = n & 0xFF;
            int n4 = n >> 8;
            int n5 = n2 & 0xFF;
            int n6 = n2 >> 8;
            if (this.toUnicodeMap[n4] == null) {
                this.toUnicodeMap[n4] = new int[256];
                Arrays.fill(this.toUnicodeMap[n4], -1);
            }
            if (this.fromUnicodeMap[n6] == null) {
                this.fromUnicodeMap[n6] = new int[256];
                Arrays.fill(this.fromUnicodeMap[n6], -1);
            }
            this.toUnicodeMap[n4][n3] = n2;
            this.fromUnicodeMap[n6][n5] = n;
        }

        public void addMapping(int[] nArray, int[] nArray2) {
            int[] nArray3;
            int[] nArray4;
            if (this.toUnicodeMultiMap == null) {
                this.toUnicodeMultiMap = new HashMap();
                this.fromUnicodeMultiMap = new HashMap();
            }
            int n = nArray[0] >> 8;
            int n2 = nArray2[0] >> 8;
            if (this.toUnicodeMap[n] == null) {
                this.toUnicodeMap[n] = new int[256];
                Arrays.fill(this.toUnicodeMap[n], -1);
            }
            if (this.fromUnicodeMap[n2] == null) {
                this.fromUnicodeMap[n2] = new int[256];
                Arrays.fill(this.fromUnicodeMap[n2], -1);
            }
            if ((nArray4 = this.toUnicodeMap[n]) != null && (nArray3 = new int[]{nArray4[nArray[0] & 0xFF]})[0] != -1) {
                this.toUnicodeMap[n][nArray[0] & 0xFF] = -1;
                this.toUnicodeMultiMap.put(new ArrayKey(nArray[0]), nArray3);
            }
            if ((nArray4 = this.fromUnicodeMap[n2]) != null && (nArray3 = new int[]{nArray4[nArray2[0] & 0xFF]})[0] != -1) {
                this.fromUnicodeMap[n2][nArray2[0] & 0xFF] = -1;
                this.fromUnicodeMultiMap.put(new ArrayKey(nArray2[0]), nArray3);
            }
            this.toUnicodeMultiMap.put(new ArrayKey(nArray), nArray2);
            this.fromUnicodeMultiMap.put(new ArrayKey(nArray2), nArray);
            if (nArray2.length > this.maxSequenceLength) {
                this.maxSequenceLength = nArray2.length;
            }
            if (nArray.length > this.maxSequenceLength) {
                this.maxSequenceLength = nArray.length;
            }
        }

        public int[] toUnicode(int[] nArray) {
            return this.lookup(nArray, this.toUnicodeMap, this.toUnicodeMultiMap, true);
        }

        public int[] fromUnicode(int[] nArray) {
            return this.lookup(nArray, this.fromUnicodeMap, this.fromUnicodeMultiMap, true);
        }

        public int canEncodeUpTo(int[] nArray) {
            int[] nArray2 = this.lookup(nArray, this.fromUnicodeMap, this.fromUnicodeMultiMap, false);
            return nArray2[0];
        }

        private int[] lookup(int[] nArray, int[][] nArray2, HashMap hashMap, boolean bl) {
            int[] nArray3 = null;
            if (hashMap == null) {
                nArray3 = bl ? new int[nArray.length] : new int[]{-1};
                for (int i = 0; i < nArray.length; ++i) {
                    int n;
                    if (bl) {
                        nArray3[i] = nArray[i];
                    }
                    int n2 = nArray[i] >> 8;
                    int[] nArray4 = nArray2[n2];
                    boolean bl2 = false;
                    if (nArray4 != null && (n = nArray4[nArray[i] & 0xFF]) != -1) {
                        if (bl) {
                            nArray3[i] = n;
                        }
                        bl2 = true;
                    }
                    if (bl || bl2) continue;
                    nArray3[0] = i;
                    break;
                }
            } else {
                int n;
                Vector<Integer> vector = bl ? new Vector<Integer>(nArray.length) : null;
                for (n = 0; n < nArray.length; ++n) {
                    int[] nArray5 = nArray2[nArray[n] >> 8];
                    Integer n3 = null;
                    if (nArray5 != null) {
                        int n4 = nArray5[nArray[n] & 0xFF];
                        if (n4 == -1 && this.maxSequenceLength > 1) {
                            for (int i = this.maxSequenceLength; i > 0; --i) {
                                if (n + i - 1 < nArray.length) {
                                    int[] nArray6 = new int[i];
                                    for (int j = 0; j < i; ++j) {
                                        nArray6[j] = nArray[n + j];
                                    }
                                    int[] nArray7 = (int[])hashMap.get(new ArrayKey(nArray6));
                                    if (nArray7 != null) {
                                        for (int j = 0; j < nArray7.length; ++j) {
                                            vector.add(new Integer(nArray7[j]));
                                        }
                                        n += nArray6.length - 1;
                                        break;
                                    }
                                }
                                if (i != 1) continue;
                                n3 = new Integer(nArray[n] > 127 ? this.UNKNOWN_CHAR : nArray[n]);
                            }
                        } else {
                            n3 = n4 != -1 ? new Integer(n4) : new Integer(this.UNKNOWN_CHAR);
                        }
                    } else {
                        n3 = new Integer(nArray[n] > 127 ? this.UNKNOWN_CHAR : nArray[n]);
                    }
                    if (n3 == null) continue;
                    if (n3 != this.UNKNOWN_CHAR && bl) {
                        vector.add(n3);
                        continue;
                    }
                    if (bl) {
                        vector.add(new Integer(this.UNKNOWN_CHAR));
                        continue;
                    }
                    nArray3 = new int[]{n};
                    break;
                }
                if (nArray3 == null) {
                    if (bl) {
                        nArray3 = new int[vector.size()];
                        for (n = 0; n < vector.size(); ++n) {
                            nArray3[n] = (Integer)vector.get(n);
                        }
                    } else {
                        nArray3 = new int[]{-1};
                    }
                }
            }
            return nArray3;
        }
    }
}

