/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util.commandlineoptions.tests;

import com.maplesoft.util.commandlineoptions.AbstractOptionHandler;
import com.maplesoft.util.commandlineoptions.CommandOptionException;
import com.maplesoft.util.commandlineoptions.CommandOptionParser;
import com.maplesoft.util.commandlineoptions.GeometryOptionHandler;
import java.util.LinkedList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class CommandOptionParserTest
extends TestSuite {
    static final String[][] TEST_OPTIONS = new String[][]{new String[0], {""}, {"-"}, {"- "}, {"-b"}, {"-b option"}, {"b"}, {"-b option", "b option"}, {"-b", "option", "-b", "option"}};
    static final String[][] VALID_OPTIONS = new String[][]{{"b"}, {"b"}, {"b"}, {"b"}, {"b"}, {"b"}, {"b"}, {"b"}, {"b"}};
    static final int[] TARGET_OPTIONS = new int[]{0, 0, 0, 0, 1, 0, 0, 0, 2};
    static final boolean[] EXCEPTION_EXPECTED = new boolean[]{false, false, true, true, false, true, false, true, false};
    static final String[][] ARGUMENT_TEST_OPTIONS = new String[][]{new String[0], {"-b"}, {"-b"}, {"-b", "one"}, {"-b", "one"}, {"-b", "one", "two"}, {"-b", "one", "two"}, {"-b", "one", "two"}};
    static final int[] NUM_EXPECTED = new int[]{0, 0, 1, 1, 0, 1, 2, 3};
    static final boolean[] ARG_SHOULD_FAIL = new boolean[]{false, false, true, false, false, false, false, true};
    static final String[][] OPTION_SOURCES = new String[][]{new String[0], {""}, {"-"}, {"- "}, {"-p"}, {"-p202"}, {"-p", "202"}, {"-p", "203"}};
    static final boolean[] OPTION_SHOULD_FAIL = new boolean[]{true, true, true, true, true, false, false, true};

    public CommandOptionParserTest() {
        this("CommandOptionParser Test");
    }

    public CommandOptionParserTest(String string) {
        super(string);
    }

    public static Test suite() {
        CommandOptionParserTest commandOptionParserTest = new CommandOptionParserTest();
        commandOptionParserTest.configureTests();
        return commandOptionParserTest;
    }

    private void configureTests() {
        int n;
        this.addTest((Test)new ConfirmOptionCorrectTestImpl("Basic Functionality Test"));
        this.addTest((Test)new SequenceTestImpl("Confirm Options Handled in Correct Order/Parsed Correctly"));
        this.addTest((Test)new GeometryTestImpl("GeometryTest 1 - No Concatenation", new String[]{"-geometry", "100x100+0+0"}, new int[]{100, 100, 0, 0}, false));
        this.addTest((Test)new GeometryTestImpl("GeometryTest 2 - Concatenation", new String[]{"-geometry100x100+0+0"}, new int[]{100, 100, 0, 0}, false));
        this.addTest((Test)new GeometryTestImpl("GeometryTest 3 - Malformed", new String[]{"-geometry100100p0x0"}, new int[0], true));
        this.addTest((Test)new GeometryTestImpl("GeometryTest 4 - Verify Test Function", new String[]{"-geometry100x100+0+0"}, new int[]{200, 100, 0, 0}, true));
        for (n = 0; n < TEST_OPTIONS.length; ++n) {
            this.addTest((Test)new CommandOptionParserTestImpl("test-" + n, TEST_OPTIONS[n], VALID_OPTIONS[n], TARGET_OPTIONS[n]));
        }
        for (n = 0; n < TEST_OPTIONS.length; ++n) {
            this.addTest((Test)new StrictParserTestImpl("strict-test-" + n, TEST_OPTIONS[n], VALID_OPTIONS[n], EXCEPTION_EXPECTED[n]));
        }
        for (n = 0; n < ARGUMENT_TEST_OPTIONS.length; ++n) {
            this.addTest((Test)new ArgumentTestImpl("arg-test-" + n, ARGUMENT_TEST_OPTIONS[n], VALID_OPTIONS[n], NUM_EXPECTED[n], ARG_SHOULD_FAIL[n]));
        }
        for (n = 0; n < OPTION_SOURCES.length; ++n) {
            this.addTest((Test)new ConCatTestImpl("ConCat-Test-" + n, OPTION_SOURCES[n], new String[]{"p"}, "202", OPTION_SHOULD_FAIL[n]));
        }
    }

    public class ConfirmOptionTestHandler
    extends AbstractOptionHandler {
        public void handle(CommandOptionParser commandOptionParser, String[] stringArray) throws CommandOptionException {
            String[] stringArray2 = this.getOptionNames();
            boolean bl = false;
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!stringArray2[i].equals(stringArray[0])) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new CommandOptionException("Name Received (" + stringArray[0] + ")" + " did not match any of the specified names for this option.");
            }
        }
    }

    public class SequenceTestHandler
    extends ArgumentTestHandler {
        LinkedList received;

        public SequenceTestHandler(String string, int n) {
            super(n);
            this.received = new LinkedList();
            this.addOptionNames(new String[]{string});
        }

        public void handle(CommandOptionParser commandOptionParser, String[] stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.received.add(stringArray[i]);
            }
        }

        public LinkedList getReceivedOptions() {
            return this.received;
        }
    }

    public class SequenceTestImpl
    extends TestCase {
        public String[] OPTIONS;
        public String[] EXPECTED;

        public SequenceTestImpl(String string) {
            super(string);
            this.OPTIONS = new String[]{"-g100", "-b", "2", "-q", "-r", "-geometry", "100x100-0+0"};
            this.EXPECTED = new String[]{"g", "100", "b", "2", "q", "r", "geometry", "100x100-0+0"};
        }

        public void runTest() {
            CommandOptionParser commandOptionParser = new CommandOptionParser();
            try {
                commandOptionParser.setStrict(true);
                SequenceTestHandler sequenceTestHandler = new SequenceTestHandler("g", 1);
                SequenceTestHandler sequenceTestHandler2 = new SequenceTestHandler("b", 1);
                SequenceTestHandler sequenceTestHandler3 = new SequenceTestHandler("q", 0);
                SequenceTestHandler sequenceTestHandler4 = new SequenceTestHandler("r", 0);
                SequenceTestHandler sequenceTestHandler5 = new SequenceTestHandler("geometry", 1);
                commandOptionParser.addHandler(sequenceTestHandler);
                commandOptionParser.addHandler(sequenceTestHandler2);
                commandOptionParser.addHandler(sequenceTestHandler3);
                commandOptionParser.addHandler(sequenceTestHandler4);
                commandOptionParser.addHandler(sequenceTestHandler5);
                commandOptionParser.process(this.OPTIONS);
                LinkedList linkedList = new LinkedList();
                linkedList.addAll(sequenceTestHandler.getReceivedOptions());
                linkedList.addAll(sequenceTestHandler2.getReceivedOptions());
                linkedList.addAll(sequenceTestHandler3.getReceivedOptions());
                linkedList.addAll(sequenceTestHandler4.getReceivedOptions());
                linkedList.addAll(sequenceTestHandler5.getReceivedOptions());
                String[] stringArray = linkedList.toArray(new String[0]);
                if (stringArray.length != this.EXPECTED.length) {
                    SequenceTestImpl.fail((String)"Options Received Did not Match Options Expected");
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals(this.EXPECTED[i])) continue;
                    SequenceTestImpl.fail((String)("Option " + i + " was mismatched. Expected: " + this.EXPECTED[i] + " Received: " + stringArray[i]));
                }
            }
            catch (CommandOptionException commandOptionException) {
                SequenceTestImpl.fail((String)("An Exception occured: " + commandOptionException.getMessage()));
            }
        }
    }

    public class ConfirmOptionCorrectTestImpl
    extends TestCase {
        public ConfirmOptionCorrectTestImpl(String string) {
            super(string);
        }

        public void runTest() {
            CommandOptionParser commandOptionParser = new CommandOptionParser();
            try {
                commandOptionParser.setStrict(true);
                ConfirmOptionTestHandler confirmOptionTestHandler = new ConfirmOptionTestHandler();
                confirmOptionTestHandler.addOptionNames(new String[]{"b"});
                commandOptionParser.addHandler(confirmOptionTestHandler);
            }
            catch (Exception exception) {
                ConfirmOptionCorrectTestImpl.fail((String)("Test Failed to Build Parser Correctly " + exception.getMessage()));
            }
            try {
                commandOptionParser.process(new String[]{"-b"});
            }
            catch (Exception exception) {
                ConfirmOptionCorrectTestImpl.fail((String)"Option -b was not correctly fed to handler");
            }
            boolean bl = false;
            try {
                commandOptionParser.process(new String[]{"-c"});
            }
            catch (Exception exception) {
                bl = true;
            }
            if (!bl) {
                ConfirmOptionCorrectTestImpl.fail((String)"Parser Sent an option to a handler that shouldn't have got it.");
            }
        }
    }

    public class ConCatTestHandler
    extends AbstractOptionHandler {
        public String receivedArg = null;

        public int numArgs() {
            return 1;
        }

        public void handle(CommandOptionParser commandOptionParser, String[] stringArray) {
            this.receivedArg = stringArray[1];
        }

        public String getReceivedArg() {
            return this.receivedArg;
        }
    }

    public class ArgumentTestHandler
    extends AbstractOptionHandler {
        int numArgs = 0;
        int receivedArgs = 0;

        public ArgumentTestHandler(int n) {
            this.numArgs = n;
        }

        public int numArgs() {
            return this.numArgs;
        }

        public void handle(CommandOptionParser commandOptionParser, String[] stringArray) {
            this.receivedArgs = stringArray.length - 1;
        }

        public int getReceivedArgs() {
            return this.receivedArgs;
        }
    }

    public class BasicTestHandler
    extends AbstractOptionHandler {
        int optionCount = 0;

        public void handle(CommandOptionParser commandOptionParser, String[] stringArray) {
            ++this.optionCount;
        }

        public int getOptionCount() {
            return this.optionCount;
        }
    }

    public class GeometryTestImpl
    extends TestCase {
        String[] testOptions;
        int[] expected;
        boolean shouldFail;

        public GeometryTestImpl(String string, String[] stringArray, int[] nArray, boolean bl) {
            super(string);
            this.testOptions = null;
            this.expected = null;
            this.shouldFail = false;
            this.testOptions = stringArray;
            this.expected = nArray;
            this.shouldFail = bl;
        }

        public void runTest() {
            block4: {
                CommandOptionParser commandOptionParser = new CommandOptionParser();
                try {
                    commandOptionParser.setStrict(true);
                    GeometryOptionHandler geometryOptionHandler = new GeometryOptionHandler();
                    commandOptionParser.addHandler(geometryOptionHandler);
                    commandOptionParser.process(this.testOptions);
                    boolean bl = geometryOptionHandler.isConfigured();
                    bl = bl && this.expected[0] == geometryOptionHandler.getWidth();
                    bl = bl && this.expected[1] == geometryOptionHandler.getHeight();
                    bl = bl && this.expected[2] == geometryOptionHandler.getXPosition();
                    boolean bl2 = bl = bl && this.expected[3] == geometryOptionHandler.getYPosition();
                    if (!this.shouldFail && !bl) {
                        GeometryTestImpl.fail((String)"Failed to Correctly Parse Geometry Options");
                    }
                    if (bl && this.shouldFail) {
                        GeometryTestImpl.fail((String)"This Test Should have had an exception, but didn't");
                    }
                }
                catch (CommandOptionException commandOptionException) {
                    if (this.shouldFail) break block4;
                    GeometryTestImpl.fail((String)("An Exception occured: " + commandOptionException.getMessage()));
                }
            }
        }
    }

    public class ConCatTestImpl
    extends TestCase {
        String[] testOptions;
        String[] validNames;
        boolean shouldFail;
        String expectedArg;

        public ConCatTestImpl(String string, String[] stringArray, String[] stringArray2, String string2, boolean bl) {
            super(string);
            this.testOptions = null;
            this.validNames = null;
            this.shouldFail = false;
            this.expectedArg = null;
            this.testOptions = stringArray;
            this.validNames = stringArray2;
            this.expectedArg = string2;
            this.shouldFail = bl;
        }

        public void runTest() {
            block4: {
                CommandOptionParser commandOptionParser = new CommandOptionParser();
                try {
                    boolean bl;
                    commandOptionParser.setStrict(true);
                    ConCatTestHandler conCatTestHandler = new ConCatTestHandler();
                    conCatTestHandler.addOptionNames(this.validNames);
                    commandOptionParser.addHandler(conCatTestHandler);
                    commandOptionParser.process(this.testOptions);
                    String string = conCatTestHandler.getReceivedArg();
                    boolean bl2 = bl = string != null && string.equals(this.expectedArg);
                    if (!this.shouldFail && !bl) {
                        ConCatTestImpl.fail((String)("Expected Argument: " + this.expectedArg + " but received: " + string));
                    }
                    if (bl && this.shouldFail) {
                        ConCatTestImpl.fail((String)"This Test Should have had an exception, but didn't");
                    }
                }
                catch (CommandOptionException commandOptionException) {
                    if (this.shouldFail) break block4;
                    ConCatTestImpl.fail((String)("An Exception occured: " + commandOptionException.getMessage()));
                }
            }
        }
    }

    public class ArgumentTestImpl
    extends TestCase {
        String[] testOptions;
        String[] validNames;
        int numArgs;
        boolean shouldFail;

        public ArgumentTestImpl(String string, String[] stringArray, String[] stringArray2, int n, boolean bl) {
            super(string);
            this.testOptions = null;
            this.validNames = null;
            this.numArgs = 0;
            this.shouldFail = false;
            this.testOptions = stringArray;
            this.validNames = stringArray2;
            this.numArgs = n;
            this.shouldFail = bl;
        }

        public void runTest() {
            block4: {
                CommandOptionParser commandOptionParser = new CommandOptionParser();
                try {
                    ArgumentTestHandler argumentTestHandler = new ArgumentTestHandler(this.numArgs);
                    argumentTestHandler.addOptionNames(this.validNames);
                    commandOptionParser.addHandler(argumentTestHandler);
                    commandOptionParser.process(this.testOptions);
                    if (argumentTestHandler.getReceivedArgs() != this.numArgs) {
                        ArgumentTestImpl.fail((String)("Did not receive correct number of arguments. Received: " + argumentTestHandler.getReceivedArgs() + " Expected: " + this.numArgs));
                    }
                    if (this.shouldFail) {
                        ArgumentTestImpl.fail((String)"This Test Should have had an exception, but didn't");
                    }
                }
                catch (CommandOptionException commandOptionException) {
                    if (this.shouldFail) break block4;
                    ArgumentTestImpl.fail((String)("An Exception occured: " + commandOptionException.getMessage()));
                }
            }
        }
    }

    public class StrictParserTestImpl
    extends TestCase {
        String[] testOptions;
        String[] validNames;
        boolean exceptionExpected;

        public StrictParserTestImpl(String string, String[] stringArray, String[] stringArray2, boolean bl) {
            super(string);
            this.testOptions = null;
            this.validNames = null;
            this.exceptionExpected = false;
            this.testOptions = stringArray;
            this.validNames = stringArray2;
            this.exceptionExpected = bl;
        }

        public void runTest() {
            block2: {
                CommandOptionParser commandOptionParser = new CommandOptionParser();
                try {
                    commandOptionParser.setStrict(true);
                    BasicTestHandler basicTestHandler = new BasicTestHandler();
                    basicTestHandler.addOptionNames(this.validNames);
                    commandOptionParser.addHandler(basicTestHandler);
                    commandOptionParser.process(this.testOptions);
                }
                catch (CommandOptionException commandOptionException) {
                    if (this.exceptionExpected) break block2;
                    StrictParserTestImpl.fail((String)("An Exception " + commandOptionException + " occured in a strict test while" + " no exception was expected"));
                }
            }
        }
    }

    public class CommandOptionParserTestImpl
    extends TestCase {
        String[] testOptions;
        String[] validNames;
        int shouldSee;

        public CommandOptionParserTestImpl(String string, String[] stringArray, String[] stringArray2, int n) {
            super(string);
            this.testOptions = null;
            this.validNames = null;
            this.shouldSee = 0;
            this.testOptions = stringArray;
            this.validNames = stringArray2;
            this.shouldSee = n;
        }

        public void runTest() {
            CommandOptionParser commandOptionParser = new CommandOptionParser();
            try {
                BasicTestHandler basicTestHandler = new BasicTestHandler();
                basicTestHandler.addOptionNames(this.validNames);
                commandOptionParser.addHandler(basicTestHandler);
                commandOptionParser.process(this.testOptions);
                if (basicTestHandler.getOptionCount() != this.shouldSee) {
                    CommandOptionParserTestImpl.fail((String)("Did not process correct number of options. was " + basicTestHandler.getOptionCount() + " should be " + this.shouldSee + "."));
                }
            }
            catch (CommandOptionException commandOptionException) {
                CommandOptionParserTestImpl.fail((String)("An Exception occured: " + commandOptionException.getMessage()));
            }
        }
    }
}

