/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util.commandlineoptions;

import com.maplesoft.util.commandlineoptions.CommandOptionException;
import com.maplesoft.util.commandlineoptions.CommandOptionSetupException;
import com.maplesoft.util.commandlineoptions.FileRecognizer;
import com.maplesoft.util.commandlineoptions.OptionHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class CommandOptionParser {
    private HashMap optionIDToHandler = new HashMap();
    private List handlers = new ArrayList();
    private char[] optionIdCharacters = new char[]{'-'};
    private boolean strict = false;
    private List filesFound = new ArrayList();
    private FileRecognizer fileFinder;
    private HashSet concatenators = new HashSet();
    private static final String OPTION_PARSE_ERROR_START = "The option '";
    private static final String OPTION_PARSE_ERROR_NOT_SUPPORTED = "' is not supported.";
    private static final String OPTION_PARSE_ERROR_ONEARG = " argument.";
    private static final String OPTION_PARSE_ERROR_MULTIARG = " arguments.";
    private static final String OPTION_PARSE_ERROR_EXPECT = "' expects ";

    public void addHandler(OptionHandler optionHandler) throws CommandOptionSetupException {
        int n;
        if (optionHandler == null) {
            throw new CommandOptionSetupException("Handler may not be null");
        }
        if (this.handlers.indexOf(optionHandler) > -1) {
            throw new CommandOptionSetupException("Duplicate Handlers not allowed");
        }
        String[] stringArray = optionHandler.getOptionNames();
        if (stringArray == null || stringArray != null && stringArray.length == 0) {
            throw new CommandOptionSetupException("OptionHandler " + optionHandler + " does not return a valid list of option names");
        }
        for (n = 0; n < stringArray.length; ++n) {
            for (int i = 0; i < this.handlers.size(); ++i) {
                String[] stringArray2 = ((OptionHandler)this.handlers.get(i)).getOptionNames();
                for (int j = 0; j < stringArray2.length; ++j) {
                    if (!stringArray2[j].equals(stringArray[n])) continue;
                    throw new CommandOptionSetupException("Duplicate option names are not allowed.");
                }
            }
        }
        this.handlers.add(optionHandler);
        if (optionHandler.isConcatenationAllowed()) {
            this.concatenators.add(optionHandler);
        }
        for (n = 0; n < stringArray.length; ++n) {
            this.optionIDToHandler.put(stringArray[n], optionHandler);
        }
    }

    public void process(String[] stringArray) throws CommandOptionException {
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (this.isOption(stringArray[i])) {
                Object object;
                string = this.stripLeadCharacters(stringArray[i]);
                boolean bl = false;
                String string2 = null;
                Object object2 = (OptionHandler)this.optionIDToHandler.get(string);
                if (object2 == null && this.isConcatenationPossible() && string.length() > 1) {
                    Iterator iterator = this.concatenators.iterator();
                    int n = 0;
                    object = null;
                    while (iterator.hasNext()) {
                        OptionHandler optionHandler = (OptionHandler)iterator.next();
                        String[] stringArray2 = optionHandler.getOptionNames();
                        for (int j = 0; j < stringArray2.length; ++j) {
                            String string3;
                            if (string.length() <= stringArray2[j].length() || !(string3 = string.substring(0, stringArray2[j].length())).equals(stringArray2[j]) || string3.length() <= n) continue;
                            object = optionHandler;
                            n = string3.length();
                            string2 = string3;
                        }
                    }
                    object2 = object;
                    boolean bl2 = bl = object2 != null;
                    if (object2 == null) {
                        string2 = null;
                    }
                }
                if (this.strict && object2 == null) {
                    throw new CommandOptionException(OPTION_PARSE_ERROR_START + stringArray[i] + OPTION_PARSE_ERROR_NOT_SUPPORTED);
                }
                if (object2 == null) continue;
                int n = object2.numArgs();
                String[] stringArray3 = new String[1 + n];
                if (bl) {
                    object = string.substring(1);
                    stringArray3[1] = object;
                } else {
                    string2 = string;
                    if (n >= stringArray.length - i) {
                        throw new CommandOptionException(OPTION_PARSE_ERROR_START + string + OPTION_PARSE_ERROR_EXPECT + n + (n != 1 ? OPTION_PARSE_ERROR_MULTIARG : OPTION_PARSE_ERROR_ONEARG));
                    }
                    for (int j = 1; j <= n; ++j) {
                        stringArray3[j] = stringArray[i + j];
                    }
                    i += n;
                }
                stringArray3[0] = string2;
                object2.handle(this, stringArray3);
                continue;
            }
            if (this.fileFinder == null) continue;
            string = stringArray[i];
            if (string.startsWith("\"")) {
                string = string.substring(1, string.length() - 1);
            }
            if (!this.fileFinder.isValidFile(string)) continue;
            this.filesFound.add(string);
        }
    }

    public boolean isConcatenationPossible() {
        return this.concatenators.size() > 0;
    }

    public void setFileFinder(FileRecognizer fileRecognizer) {
        this.fileFinder = fileRecognizer;
    }

    public List getFilesFound() {
        return this.filesFound;
    }

    public boolean isOption(String string) {
        boolean bl = false;
        if (string.length() > 0) {
            char c = string.charAt(0);
            for (int i = 0; i < this.optionIdCharacters.length; ++i) {
                if (c != this.optionIdCharacters[i]) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public String getOptionHelp() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.handlers.iterator();
        while (iterator.hasNext()) {
            OptionHandler optionHandler = (OptionHandler)iterator.next();
            String[] stringArray = optionHandler.getOptionNames();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(this.optionIdCharacters[0]);
                stringBuffer.append(stringArray[i]);
                if (i >= stringArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("   -   ");
            stringBuffer.append(optionHandler.getHelpText());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public void setOptionLeadCharacters(char[] cArray) {
        this.optionIdCharacters = cArray;
    }

    public char[] getOptionLeadCharacters() {
        return this.optionIdCharacters;
    }

    public void setStrict(boolean bl) {
        this.strict = bl;
    }

    public boolean isStrict() {
        return this.strict;
    }

    private String stripLeadCharacters(String string) {
        for (int i = 0; i < this.optionIdCharacters.length; ++i) {
            while (string.length() > 0 && string.charAt(0) == this.optionIdCharacters[i]) {
                string = string.substring(1);
            }
        }
        return string;
    }
}

