/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import com.maplesoft.util.RuntimePlatform;
import com.maplesoft.util.StringTools;
import com.maplesoft.util.encoder.AbstractStringEncoder;
import com.maplesoft.util.encoder.ShiftJISEncoder;

public class StringToolsJapanese {
    public static final int LOW_JAPANESE_UNICODE = 12288;
    public static final int HIGH_JAPANESE_UNICODE = 40879;
    public static final int LOW_JAPANESE_UNICODE_HW = 65280;
    public static final int HIGH_JAPANESE_UNICODE_HW = 65519;
    public static final int NUM_JAPANESE_FONTS = 4;
    public static final String[] JAPANESE_FONT_NAMES = new String[4];
    public static final String[] JAPANESE_FONT_ALTERNATE_NAMES = new String[4];
    public static final String MINCHO_FONT_NAME;
    public static final String MINCHO_ALTERNATE_NAME;
    public static final String PMINCHO_FONT_NAME;
    public static final String PMINCHO_ALTERNATE_NAME;
    public static final String GOTHIC_FONT_NAME;
    public static final String GOTHIC_ALTERNATE_NAME;
    public static final String PGOTHIC_FONT_NAME;
    public static final String PGOTHIC_ALTERNATE_NAME;

    public static boolean isJapaneseText(String string) {
        boolean bl = false;
        if (string != null) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                boolean bl2;
                char c = string.charAt(i);
                boolean bl3 = bl2 = c >= '\u3000' && c <= '\u9faf' || c >= '\uff00' && c <= '\uffef';
                if (!bl2 || c == '\u300a' || c == '\u300b') continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static boolean isShiftJISJapaneseText(String string) {
        return StringToolsJapanese.isJapaneseText(StringToolsJapanese.shiftJISDecode(string));
    }

    public static String shiftJISEncode(String string, boolean bl) {
        ShiftJISEncoder shiftJISEncoder = new ShiftJISEncoder();
        String string2 = shiftJISEncoder.fromUnicode(string);
        if (bl) {
            string2 = AbstractStringEncoder.xmlEncode(string2);
        }
        return string2;
    }

    public static String shiftJISDecode(String string, boolean bl) {
        return StringToolsJapanese.shiftJISDecode(string);
    }

    public static String shiftJISDecode(String string) {
        ShiftJISEncoder shiftJISEncoder = new ShiftJISEncoder();
        String string2 = string;
        if (!StringToolsJapanese.isJapaneseText(string)) {
            string2 = shiftJISEncoder.toUnicode(AbstractStringEncoder.xmlDecode(string));
        }
        return string2;
    }

    public static boolean isJapaneseFont(String string) {
        return StringToolsJapanese.isJapaneseFont(string, true);
    }

    public static boolean isJapaneseFont(String string, boolean bl) {
        String string2;
        boolean bl2 = false;
        String string3 = string2 = bl ? StringToolsJapanese.shiftJISDecode(string) : string;
        if (!bl2) {
            bl2 = StringToolsJapanese.isJapaneseText(string2);
        }
        return bl2;
    }

    public static boolean isUTF8JapaneseFont(String string) {
        String string2 = StringTools.UTF8Decode(string);
        return StringToolsJapanese.isJapaneseText(string2);
    }

    public static boolean isEnglishNameJapaneseFont(String string) {
        boolean bl = false;
        for (int i = 0; i < 4; ++i) {
            if (!string.equals(JAPANESE_FONT_NAMES[i])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static String toJapaneseFontName(String string) {
        String string2 = string;
        for (int i = 0; i < 4; ++i) {
            if (!string.equals(JAPANESE_FONT_NAMES[i])) continue;
            string2 = JAPANESE_FONT_ALTERNATE_NAMES[i];
            break;
        }
        return string2;
    }

    static {
        StringToolsJapanese.JAPANESE_FONT_NAMES[0] = "MS Mincho";
        MINCHO_FONT_NAME = "MS Mincho";
        StringToolsJapanese.JAPANESE_FONT_ALTERNATE_NAMES[0] = RuntimePlatform.isMac() ? "Hiragino Mincho Pro" : "\uff2d\uff33 \u660e\u671d";
        MINCHO_ALTERNATE_NAME = StringToolsJapanese.JAPANESE_FONT_ALTERNATE_NAMES[0];
        StringToolsJapanese.JAPANESE_FONT_NAMES[1] = "MS PMincho";
        PMINCHO_FONT_NAME = "MS PMincho";
        StringToolsJapanese.JAPANESE_FONT_ALTERNATE_NAMES[1] = RuntimePlatform.isMac() ? "Hiragino Mincho Pro" : "\uff2d\uff33 \uff30\u660e\u671d";
        PMINCHO_ALTERNATE_NAME = StringToolsJapanese.JAPANESE_FONT_ALTERNATE_NAMES[1];
        StringToolsJapanese.JAPANESE_FONT_NAMES[2] = "MS Gothic";
        GOTHIC_FONT_NAME = "MS Gothic";
        StringToolsJapanese.JAPANESE_FONT_ALTERNATE_NAMES[2] = RuntimePlatform.isMac() ? "Hiragino Kaku Gothic Pro" : "\uff2d\uff33 \u30b4\u30b7\u30c3\u30af";
        GOTHIC_ALTERNATE_NAME = StringToolsJapanese.JAPANESE_FONT_ALTERNATE_NAMES[2];
        StringToolsJapanese.JAPANESE_FONT_NAMES[3] = "MS PGothic";
        PGOTHIC_FONT_NAME = "MS PGothic";
        StringToolsJapanese.JAPANESE_FONT_ALTERNATE_NAMES[3] = RuntimePlatform.isMac() ? "Hiragino Kaku Gothic Pro" : "\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af";
        PGOTHIC_ALTERNATE_NAME = StringToolsJapanese.JAPANESE_FONT_ALTERNATE_NAMES[3];
    }
}

