/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import com.maplesoft.util.WmiSearchException;
import com.maplesoft.util.WmiSearchVisitor;

public class SearchAlgorithms {
    public static final int FORWARDS = 1;
    public static final int BACKWARDS = -1;

    private SearchAlgorithms() {
    }

    public static Object depthFirstSearch(Object object, ChildOperation childOperation, MatchCondition matchCondition, int n) throws WmiSearchException {
        if (object != null && matchCondition.matchesCondition(object)) {
            return object;
        }
        if (!childOperation.hasChildren(object)) {
            return null;
        }
        if (n != 1 && n != -1) {
            throw new IllegalArgumentException("invalid direction");
        }
        int n2 = childOperation.getChildCount(object);
        for (int i = 0; i < n2; ++i) {
            int n3 = n == 1 ? i : n2 - i - 1;
            Object object2 = childOperation.getChild(object, n3);
            Object object3 = SearchAlgorithms.depthFirstSearch(object2, childOperation, matchCondition, n);
            if (object3 == null) continue;
            return object3;
        }
        return null;
    }

    public static boolean depthFirstVisit(Object object, ChildOperation childOperation, MatchCondition matchCondition, MatchCondition matchCondition2, int n, WmiSearchVisitor wmiSearchVisitor) throws WmiSearchException {
        boolean bl = true;
        if (wmiSearchVisitor == null) {
            throw new IllegalArgumentException("Visitor not defined.");
        }
        if (n != 1 && n != -1) {
            throw new IllegalArgumentException("invalid direction");
        }
        int n2 = 0;
        if (object != null && (matchCondition == null || matchCondition.matchesCondition(object)) && (n2 = wmiSearchVisitor.visitMatch(object)) == 2) {
            return false;
        }
        if (object != null && matchCondition2 != null && matchCondition2.matchesCondition(object)) {
            return true;
        }
        if (childOperation.hasChildren(object) && n2 == 0) {
            int n3 = childOperation.getChildCount(object);
            int n4 = n == 1 ? 0 : n3 - 1;
            int n5 = n == 1 ? n3 - 1 : 0;
            for (int i = n4; bl && i <= n5; i += n) {
                Object object2 = childOperation.getChild(object, i);
                bl = SearchAlgorithms.depthFirstVisit(object2, childOperation, matchCondition, matchCondition2, n, wmiSearchVisitor);
                n3 = childOperation.getChildCount(object);
                n5 = n == 1 ? n3 - 1 : 0;
            }
        }
        return bl;
    }

    public static Object parentSearch(Object object, ParentOperation parentOperation, MatchCondition matchCondition) throws WmiSearchException {
        Object object2 = object;
        while (object2 != null && !matchCondition.matchesCondition(object2)) {
            object2 = parentOperation.getParent(object2);
        }
        return object2;
    }

    public static interface MatchCondition {
        public boolean matchesCondition(Object var1);
    }

    public static interface ParentOperation {
        public Object getParent(Object var1) throws WmiSearchException;
    }

    public static interface ChildOperation {
        public boolean hasChildren(Object var1);

        public Object getChild(Object var1, int var2) throws WmiSearchException;

        public int getChildCount(Object var1) throws WmiSearchException;
    }
}

