/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import com.maplesoft.util.RuntimePlatform;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ResourceLoader {
    private static final String ALTERNATE_WINDOWS_TEMP_DIR = "C:\\WINDOWS\\TEMP";

    public static InputStream getResourceAsStream(String string) {
        return ResourceLoader.class.getResourceAsStream(ResourceLoader.slashifyName(string));
    }

    public static Image getResourceAsImage(String string) {
        URL uRL = ResourceLoader.class.getResource(ResourceLoader.slashifyName(string));
        return uRL != null ? Toolkit.getDefaultToolkit().createImage(uRL) : null;
    }

    public static URL getResourceAsURL(String string) {
        return ResourceLoader.class.getResource(ResourceLoader.slashifyName(string));
    }

    public static StreamSource getResourceAsStreamSource(String string) {
        InputStream inputStream = ResourceLoader.class.getResourceAsStream(ResourceLoader.slashifyName(string));
        return inputStream != null ? new StreamSource(inputStream) : null;
    }

    public static Document getResourceAsDOMValidated(String string) throws Exception {
        Document document = null;
        InputStream inputStream = ResourceLoader.getResourceAsStream(ResourceLoader.slashifyName(string));
        if (inputStream == null) {
            throw new FileNotFoundException("Could not open " + string);
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        InputSource inputSource = new InputSource(inputStream);
        documentBuilderFactory.setIgnoringComments(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        document = documentBuilder.parse(inputSource);
        return document;
    }

    public static Document getResourceAsDOM(String string) {
        Document document = null;
        try {
            document = ResourceLoader.getResourceAsDOMValidated(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Font getResourceAsFont(String string) throws IOException, FontFormatException, IllegalArgumentException {
        File file;
        Object object;
        InputStream inputStream = ResourceLoader.getResourceAsStream(string);
        Object object2 = null;
        if (RuntimePlatform.isWindows() && ResourceLoader.couldContainCJKText((String)(object = System.getProperty("java.io.tmpdir"))) && (file = new File(ALTERNATE_WINDOWS_TEMP_DIR)).canWrite()) {
            object2 = object;
            System.setProperty("java.io.tmpdir", ALTERNATE_WINDOWS_TEMP_DIR);
        }
        object = null;
        try {
            object = Font.createFont(0, inputStream);
            inputStream.close();
        }
        finally {
            if (object2 != null) {
                System.setProperty("java.io.tmpdir", object2);
            }
        }
        return object;
    }

    private static boolean couldContainCJKText(String string) {
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) <= '\u00ff') continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static Font getResourceAsFont(String string, float f) throws IOException, FontFormatException, IllegalArgumentException {
        Font font = ResourceLoader.getResourceAsFont(string);
        font = font.deriveFont(f);
        return font;
    }

    public static Font getResourceAsFont(String string, int n, float f) throws IOException, FontFormatException, IllegalArgumentException {
        Font font = ResourceLoader.getResourceAsFont(string);
        font = font.deriveFont(n, f);
        return font;
    }

    public static Class[] getClasses(String string) {
        Class[] classArray = null;
        LinkedList<Serializable> linkedList = new LinkedList<Serializable>();
        if (string != null && Package.getPackage(string) != null) {
            String string2 = System.getProperty("java.class.path");
            StringTokenizer stringTokenizer = new StringTokenizer(string2, System.getProperty("path.separator"));
            String string3 = string.replace('.', '/');
            while (stringTokenizer.hasMoreTokens()) {
                Serializable serializable;
                Object object;
                Object object2;
                Object object3;
                String string4 = stringTokenizer.nextToken();
                if (string4.endsWith(".jar")) {
                    try {
                        object3 = new JarFile(new File(string4));
                        object2 = ((JarFile)object3).entries();
                        while (object2.hasMoreElements()) {
                            object = (JarEntry)object2.nextElement();
                            if (!((ZipEntry)object).getName().startsWith(string3) || !((ZipEntry)object).getName().endsWith(".class")) continue;
                            try {
                                serializable = Class.forName(((ZipEntry)object).getName().replace('/', '.').substring(0, ((ZipEntry)object).getName().length() - 6));
                                linkedList.add(serializable);
                            }
                            catch (Throwable throwable) {}
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                try {
                    object3 = System.getProperty("file.separator");
                    object2 = string.replace('.', ((String)object3).charAt(0));
                    object = string4 + (String)object3 + (String)object2;
                    serializable = new File((String)object);
                    if (!serializable.exists() || !serializable.isDirectory()) continue;
                    File[] fileArray = serializable.listFiles();
                    for (int i = 0; i < fileArray.length; ++i) {
                        File file = fileArray[i];
                        String string5 = file.getName();
                        int n = string5.indexOf(".class");
                        if (n <= 0) continue;
                        String string6 = string + "." + string5.substring(0, n);
                        try {
                            Class<?> clazz = Class.forName(string6);
                            linkedList.add(clazz);
                            continue;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                catch (Exception exception) {
                }
            }
            if (linkedList.size() > 0) {
                classArray = new Class[linkedList.size()];
                for (int i = 0; i < linkedList.size(); ++i) {
                    classArray[i] = (Class)linkedList.get(i);
                }
            }
        }
        return classArray;
    }

    public static Class[] getClasses(String string, Class clazz) {
        Class[] classArray = null;
        Class[] classArray2 = ResourceLoader.getClasses(string);
        if (classArray2 != null && classArray2.length > 0 && clazz != null) {
            int n;
            LinkedList<Class> linkedList = new LinkedList<Class>();
            block2: for (n = 0; n < classArray2.length; ++n) {
                try {
                    if (classArray2[n].getSuperclass() != null && classArray2[n].getSuperclass().equals(clazz)) {
                        linkedList.add(classArray2[n]);
                        continue;
                    }
                    Class<?>[] classArray3 = classArray2[n].getInterfaces();
                    if (classArray3 == null) continue;
                    for (int i = 0; i < classArray3.length; ++i) {
                        if (!classArray3[i].equals(clazz)) continue;
                        linkedList.add(classArray2[n]);
                        continue block2;
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            classArray = new Class[linkedList.size()];
            for (n = 0; n < linkedList.size(); ++n) {
                classArray[n] = (Class)linkedList.get(n);
            }
        } else if (classArray2 != null && classArray2.length == 0) {
            classArray = new Class[]{};
        }
        return classArray;
    }

    private static String slashifyName(String string) {
        return string.startsWith("/") ? string : "/" + string;
    }
}

