/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math.renderers;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.renderers.WmiBaselineProvider;
import com.maplesoft.mathdoc.view.math.renderers.WmiGlyphRenderer;
import com.maplesoft.mathdoc.view.math.renderers.WmiOperatorRenderer;
import java.awt.Font;
import java.awt.geom.Rectangle2D;

public class WmiIntegralRenderer
extends WmiGlyphRenderer {
    private static final WmiBaselineProvider INTEGRAL_BASELINE_SOURCE = new WmiIntegralBaselineProvider();
    private static final int MIN_SCALE = 2;
    private static final int MAX_SCALE = 8;
    private static final float[][] OUTLINE = new float[][]{{0.4742268f, 0.065979354f}, {0.4742268f, 0.080412365f, 0.46030927f, 0.09381444f}, {0.44639176f, 0.10721651f, 0.43195876f, 0.10721651f}, {0.41340205f, 0.10721651f, 0.39175257f, 0.07680413f}, {0.37010312f, 0.04639175f, 0.3515464f, 0.04639175f}, {0.32577318f, 0.04639175f, 0.30721653f, 0.09587631f}, {0.2958763f, 0.12886599f, 0.29175258f, 0.16804123f}, {0.2886598f, 0.19381444f, 0.28556702f, 0.3072165f}, {0.28247425f, 0.35876286f, 0.27835053f, 0.4628866f}, {0.27113402f, 0.68762887f, 0.26082474f, 0.74948454f}, {0.23195878f, 0.9402062f, 0.14123712f, 0.98556703f}, {0.11340207f, 1.0f, 0.067010306f, 1.0f}, {0.04226804f, 1.0f, 0.02113402f, 0.98298967f}, {0.0f, 0.96597934f, 0.0f, 0.9412371f}, {0.0f, 0.92371136f, 0.013917526f, 0.90979385f}, {0.027835052f, 0.8958763f, 0.045360826f, 0.8958763f}, {0.065979384f, 0.8958763f, 0.08505155f, 0.9298969f}, {0.10412372f, 0.96391755f, 0.12474228f, 0.96391755f}, {0.14742269f, 0.96391755f, 0.16494846f, 0.9185567f}, {0.17628866f, 0.88659793f, 0.1814433f, 0.8525773f}, {0.18762888f, 0.8072165f, 0.18969072f, 0.72783506f}, {0.19793814f, 0.4216495f, 0.22371136f, 0.23608245f}, {0.25567013f, 0.0f, 0.39896908f, 0.0f}, {0.4742268f, 0.0f, 0.4742268f, 0.065979354f}};
    private static final int[] MORPH_RULES = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1};

    protected float[][] getGlyphOutline() {
        return OUTLINE;
    }

    protected int[] getStretchRules() {
        return MORPH_RULES;
    }

    protected void morphGlyph(float[][] fArray, Font font, int n) {
        float f = font.getSize2D();
        this.stretchScale(fArray, f, n, this.getStretchRules());
    }

    public boolean forcePreKernAdjustment(WmiMathOperatorView wmiMathOperatorView) {
        return true;
    }

    public int glyphCopies() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutView(WmiMathOperatorView wmiMathOperatorView, int n) throws WmiNoReadAccessException {
        boolean bl = n == 0;
        int n2 = -1;
        Font font = wmiMathOperatorView.getFont();
        if (font != null && (n2 = this.computeIntegralHeight(font, wmiMathOperatorView)) != wmiMathOperatorView.getHeight()) {
            bl = true;
        }
        if (bl) {
            Font font2 = this.getFont(wmiMathOperatorView);
            if (!WmiMathOperatorModel.disableStretchyOps) {
                wmiMathOperatorView.setHeight(n2);
            } else {
                wmiMathOperatorView.setHeight(Math.round(font.getSize2D() * 2.0f));
            }
            WmiGlyphRenderer.GlyphCache glyphCache = this.cache;
            synchronized (glyphCache) {
                WmiGlyphRenderer.RenderedGlyph renderedGlyph = this.cache.getGlyph(font2, n2);
                if (renderedGlyph == null) {
                    renderedGlyph = this.createGlyph(font2, n2);
                    this.cache.setGlyph(font2, n2, renderedGlyph);
                }
                if (renderedGlyph != null) {
                    Rectangle2D.Float float_ = renderedGlyph.getBounds();
                    wmiMathOperatorView.setWidth((int)Math.round(float_.getWidth()));
                }
            }
            wmiMathOperatorView.setBaselineProvider(INTEGRAL_BASELINE_SOURCE);
        }
    }

    public WmiGlyphRenderer.RenderedGlyph createGlyph(Font font, int n) {
        float[][] fArray = this.getGlyphOutline();
        float[][] fArrayArray = new float[fArray.length][];
        for (int i = 0; i < fArray.length; ++i) {
            float[] fArray2 = fArray[i];
            fArrayArray[i] = new float[fArray2.length];
            System.arraycopy(fArray2, 0, fArrayArray[i], 0, fArray2.length);
        }
        this.morphGlyph(fArrayArray, font, n);
        WmiGlyphRenderer.RenderedGlyph renderedGlyph = new WmiGlyphRenderer.RenderedGlyph(fArrayArray);
        int n2 = this.glyphCopies();
        if (n2 != 1) {
            Rectangle2D.Float float_ = renderedGlyph.getBounds();
            float f = (float)float_.getWidth();
            float[][] fArrayArray2 = new float[n2 * fArrayArray.length][];
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                int n4 = 0;
                while (n4 < fArray.length) {
                    float[] fArray3 = fArrayArray[n4];
                    fArrayArray2[n3] = new float[fArray3.length];
                    System.arraycopy(fArray3, 0, fArrayArray2[n3], 0, fArray3.length);
                    for (int j = 0; j < fArray3.length; j += 2) {
                        int n5 = j;
                        fArray3[n5] = fArray3[n5] + f;
                    }
                    ++n4;
                    ++n3;
                }
            }
            renderedGlyph = new WmiGlyphRenderer.RenderedGlyph(fArrayArray2);
        }
        return renderedGlyph;
    }

    private int computeIntegralHeight(Font font, WmiMathOperatorView wmiMathOperatorView) throws WmiNoReadAccessException {
        int n = 0;
        WmiModel wmiModel = wmiMathOperatorView.getModel();
        WmiView wmiView = wmiMathOperatorView;
        while (wmiModel != null && wmiModel.getTag() != WmiModelTag.MATH_ROW) {
            wmiModel = (wmiView = wmiView.getParentView()) != null ? wmiView.getModel() : null;
        }
        if (wmiModel != null) {
            n = this.computeViewHeight(wmiView, wmiMathOperatorView);
        }
        int n2 = Math.round(font.getSize2D());
        int n3 = 2 * n2;
        int n4 = 8 * n2;
        if (n < n3) {
            n = n3;
        } else if (n > n4) {
            n = n4;
        }
        return n;
    }

    private int computeViewHeight(WmiView wmiView, WmiMathOperatorView wmiMathOperatorView) throws WmiNoReadAccessException {
        int n = 0;
        if (wmiView instanceof WmiInlineView) {
            n = this.computeRowHeight((WmiInlineView)wmiView, wmiMathOperatorView);
        } else if (!this.containsTargetIntegral(wmiView, wmiMathOperatorView)) {
            n = ((WmiPositionedView)wmiView).getHeight();
        }
        return n;
    }

    private int computeRowHeight(WmiInlineView wmiInlineView, WmiMathOperatorView wmiMathOperatorView) throws WmiNoReadAccessException {
        int n = 0;
        if (wmiInlineView instanceof WmiCompositeView) {
            WmiInlineView wmiInlineView2 = wmiInlineView;
            int n2 = wmiInlineView2.getChildCount();
            for (int i = 0; i < n2; ++i) {
                int n3;
                WmiView wmiView = wmiInlineView2.getChild(i);
                if (this.containsIntegral(wmiView) || (n3 = this.computeViewHeight(wmiView, wmiMathOperatorView)) <= n) continue;
                n = n3;
            }
        }
        return n;
    }

    private boolean containsIntegral(WmiView wmiView) throws WmiNoReadAccessException {
        WmiOperatorRenderer wmiOperatorRenderer;
        Object object;
        boolean bl = false;
        while (wmiView instanceof WmiCompositeView && (object = (WmiCompositeView)wmiView).getChildCount() > 0) {
            wmiView = object.getChild(0);
        }
        if (wmiView instanceof WmiMathOperatorView && (wmiOperatorRenderer = WmiMathOperatorView.getRenderer((String)(object = ((WmiMathOperatorView)wmiView).getText()))) == this) {
            bl = true;
        }
        return bl;
    }

    private boolean containsTargetIntegral(WmiView wmiView, WmiMathOperatorView wmiMathOperatorView) {
        WmiCompositeView wmiCompositeView;
        boolean bl = false;
        while (wmiView instanceof WmiCompositeView && (wmiCompositeView = (WmiCompositeView)wmiView).getChildCount() > 0) {
            wmiView = wmiCompositeView.getChild(0);
        }
        if (wmiView == wmiMathOperatorView) {
            bl = true;
        }
        return bl;
    }

    public boolean applyRenderer(WmiMathOperatorView wmiMathOperatorView, int n) {
        return true;
    }

    private static class WmiIntegralBaselineProvider
    implements WmiBaselineProvider {
        private static final int STRETCH_BASELINE_DIVISOR = 2;
        private static final int ASCENT_BASELINE_ADJUST_DIVISOR = 3;

        private WmiIntegralBaselineProvider() {
        }

        public int calculateBaseline(WmiMathOperatorView wmiMathOperatorView) {
            int n = wmiMathOperatorView.getHeight() / 2;
            try {
                WmiTextModel wmiTextModel = (WmiTextModel)wmiMathOperatorView.getModel();
                WmiFontAttributeSet wmiFontAttributeSet = (WmiFontAttributeSet)wmiTextModel.getAttributesForRead();
                boolean bl = wmiMathOperatorView.getDocumentView().isPrintView();
                Font font = WmiFontResolver.getFont(wmiFontAttributeSet, wmiMathOperatorView.getZoomFactor(), bl);
                WmiFontMetrics wmiFontMetrics = WmiFontResolver.getFontMetrics(font);
                int n2 = wmiFontMetrics.getFontProperty(3, bl);
                n += n2 / 3;
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            return n;
        }
    }

    public static class WmiTripleIntegralRenderer
    extends WmiIntegralRenderer {
        public int glyphCopies() {
            return 3;
        }
    }

    public static class WmiDoubleIntegralRenderer
    extends WmiIntegralRenderer {
        public int glyphCopies() {
            return 2;
        }
    }

    public static class WmiQuaternionIntegrationRenderer
    extends WmiIntegralRenderer {
        private static final float[][] Q_OUTLINE = new float[][]{{0.47835055f, 0.73917526f}, {0.26391754f, 0.73917526f}, {0.2474227f, 0.85360825f, 0.21340209f, 0.9134021f}, {0.16391753f, 1.0f, 0.068041235f, 1.0f}, {0.04329897f, 1.0f, 0.02216495f, 0.98298967f}, {0.00103093f, 0.96597934f, 0.00103093f, 0.9412371f}, {0.00103093f, 0.92371136f, 0.014948457f, 0.90979385f}, {0.028865982f, 0.8958763f, 0.046391755f, 0.8958763f}, {0.06701031f, 0.8958763f, 0.08608249f, 0.9298969f}, {0.10515464f, 0.96391755f, 0.12577319f, 0.96391755f}, {0.18350518f, 0.96391755f, 0.19072166f, 0.73917526f}, {0.0f, 0.73917526f}, {0.0f, 0.26082474f}, {0.22164951f, 0.26082474f}, {0.2360825f, 0.14536078f, 0.26391754f, 0.08969069f}, {0.30824745f, 0.0f, 0.40000004f, 0.0f}, {0.47525775f, 0.0f, 0.47525775f, 0.065979354f}, {0.47525775f, 0.081443295f, 0.46134022f, 0.094329864f}, {0.4474227f, 0.10721651f, 0.4329897f, 0.10721651f}, {0.414433f, 0.10721651f, 0.39329898f, 0.07680413f}, {0.372165f, 0.04639175f, 0.35257733f, 0.04639175f}, {0.2917526f, 0.04639175f, 0.2876289f, 0.26082474f}, {0.47835055f, 0.26082474f}, new float[0], {0.4247423f, 0.685567f}, {0.4247423f, 0.31443298f}, {0.28659797f, 0.31443298f}, {0.28350517f, 0.36391753f, 0.27938145f, 0.4628866f}, {0.27835053f, 0.5371134f, 0.2701031f, 0.685567f}, new float[0], {0.21546394f, 0.31443298f}, {0.05360825f, 0.31443298f}, {0.05360825f, 0.685567f}, {0.1917526f, 0.685567f}, {0.19896908f, 0.46391755f, 0.21546394f, 0.31443298f}, new float[0]};
        private static final int[] Q_MORPH_RULES = new int[]{0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 7, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

        protected float[][] getGlyphOutline() {
            return Q_OUTLINE;
        }

        protected int[] getStretchRules() {
            return Q_MORPH_RULES;
        }
    }

    public static class WmiFinitePartIntegrationRenderer
    extends WmiIntegralRenderer {
        private static final float[][] FP_OUTLINE = new float[][]{{0.4742268f, 0.065979354f}, {0.4742268f, 0.081443295f, 0.46030927f, 0.094329864f}, {0.44639176f, 0.10721651f, 0.43195876f, 0.10721651f}, {0.41340205f, 0.10721651f, 0.39226806f, 0.07680413f}, {0.37113404f, 0.04639175f, 0.3515464f, 0.04639175f}, {0.30824742f, 0.04639175f, 0.29381445f, 0.1597938f}, {0.2886598f, 0.19587627f, 0.28556702f, 0.3072165f}, {0.28247425f, 0.3618557f, 0.27835053f, 0.47216496f}, {0.41134024f, 0.47216496f}, {0.41134024f, 0.5278351f}, {0.27731958f, 0.5278351f}, {0.2731959f, 0.6907217f, 0.25670102f, 0.77938145f}, {0.22474226f, 0.94329894f, 0.14123712f, 0.98556703f}, {0.11340207f, 1.0f, 0.067010306f, 1.0f}, {0.04226804f, 1.0f, 0.02113402f, 0.98298967f}, {0.0f, 0.96597934f, 0.0f, 0.9412371f}, {0.0f, 0.92371136f, 0.013917526f, 0.90979385f}, {0.027835052f, 0.8958763f, 0.045360826f, 0.8958763f}, {0.065979384f, 0.8958763f, 0.08505155f, 0.9298969f}, {0.10412372f, 0.96391755f, 0.12474228f, 0.96391755f}, {0.18247424f, 0.96391755f, 0.18969072f, 0.72783506f}, {0.1927835f, 0.60618556f, 0.19690722f, 0.5278351f}, {0.06494846f, 0.5278351f}, {0.06494846f, 0.47216496f}, {0.20103092f, 0.47216496f}, {0.20927836f, 0.34226802f, 0.22371136f, 0.23608245f}, {0.25567013f, 0.0f, 0.39896908f, 0.0f}, {0.4742268f, 0.0f, 0.4742268f, 0.065979354f}, new float[0]};
        private static final int[] FP_MORPH_RULES = new int[]{1, 1, 1, 1, 1, 1, 1, 6, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 7, 0, 0, 0, 1, 1, 1, 0};

        protected float[][] getGlyphOutline() {
            return FP_OUTLINE;
        }

        protected int[] getStretchRules() {
            return FP_MORPH_RULES;
        }
    }

    public static class WmiCWIntegrationRenderer
    extends WmiIntegralRenderer {
        private static final float[][] CW_OUTLINE = new float[][]{{0.61958766f, 0.5257732f}, {0.50206184f, 0.67010313f}, {0.47525775f, 0.67010313f}, {0.34948453f, 0.5257732f}, {0.34948453f, 0.50206184f}, {0.4628866f, 0.5701031f}, {0.45670104f, 0.50412375f, 0.41288662f, 0.4541237f}, {0.36907217f, 0.40412372f, 0.30412373f, 0.38969073f}, {0.30103093f, 0.4917526f, 0.29793814f, 0.59484535f}, {0.29175258f, 0.74123716f, 0.26701033f, 0.8298969f}, {0.23298968f, 0.9494846f, 0.16391753f, 0.98556703f}, {0.13608249f, 1.0f, 0.08969073f, 1.0f}, {0.06494846f, 1.0f, 0.043814432f, 0.98298967f}, {0.022680413f, 0.96597934f, 0.022680413f, 0.9412371f}, {0.022680413f, 0.92371136f, 0.036597937f, 0.90979385f}, {0.05051546f, 0.8958763f, 0.068041235f, 0.8958763f}, {0.08865979f, 0.8958763f, 0.1072165f, 0.9298969f}, {0.12577319f, 0.96391755f, 0.14742269f, 0.96391755f}, {0.20515464f, 0.96391755f, 0.21237116f, 0.72783506f}, {0.2185567f, 0.51649487f, 0.22989692f, 0.38659796f}, {0.15463917f, 0.3969072f, 0.10412372f, 0.45515463f}, {0.053608246f, 0.51340204f, 0.053608246f, 0.58969074f}, {0.053608246f, 0.6597938f}, {0.0010309274f, 0.6597938f}, {0.0f, 0.58969074f, 0.0f, 0.58969074f}, {0.0f, 0.4886598f, 0.067010306f, 0.41494846f}, {0.13402061f, 0.3412371f, 0.23505156f, 0.33195877f}, {0.2505155f, 0.1814433f, 0.27216494f, 0.12164944f}, {0.31649485f, 0.0f, 0.4216495f, 0.0f}, {0.49690723f, 0.0f, 0.49690723f, 0.065979354f}, {0.49690723f, 0.081443295f, 0.4835052f, 0.094329864f}, {0.4701031f, 0.10721651f, 0.45463917f, 0.10721651f}, {0.43505156f, 0.10721651f, 0.414433f, 0.07680413f}, {0.39381444f, 0.04639175f, 0.3742268f, 0.04639175f}, {0.328866f, 0.04639175f, 0.31443298f, 0.17319587f}, {0.3134021f, 0.18041237f, 0.30721653f, 0.33505154f}, {0.39278352f, 0.3515464f, 0.4515464f, 0.41701034f}, {0.5103093f, 0.4824742f, 0.51649487f, 0.5690721f}, {0.5505155f, 0.5463917f, 0.61958766f, 0.50206184f}, new float[0]};
        private static final int[] CW_MORPH_RULES = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 6, 0, 0, 0, 0};

        protected float[][] getGlyphOutline() {
            return CW_OUTLINE;
        }

        protected int[] getStretchRules() {
            return CW_MORPH_RULES;
        }
    }

    public static class WmiCirculationFunctionRenderer
    extends WmiIntegralRenderer {
        private static final float[][] CF_OUTLINE = new float[][]{{0.4742268f, 0.065979354f}, {0.4742268f, 0.081443295f, 0.46030927f, 0.094329864f}, {0.44639176f, 0.10721651f, 0.43195876f, 0.10721651f}, {0.41340205f, 0.10721651f, 0.39226806f, 0.07680413f}, {0.37113404f, 0.04639175f, 0.3515464f, 0.04639175f}, {0.29072165f, 0.04639175f, 0.28659794f, 0.2783505f}, {0.33195877f, 0.29793814f, 0.36082473f, 0.33917525f}, {0.37010312f, 0.31443298f, 0.38865983f, 0.26494843f}, {0.40721652f, 0.26494843f}, {0.41237116f, 0.47525775f}, {0.39175257f, 0.47525775f}, {0.3628866f, 0.3402062f, 0.28556702f, 0.30412373f}, {0.28247425f, 0.35670105f, 0.27835053f, 0.4628866f}, {0.27731958f, 0.5443299f, 0.26701033f, 0.70515466f}, {0.3742268f, 0.6907217f, 0.38969076f, 0.5443299f}, {0.41237116f, 0.5443299f}, {0.4082474f, 0.6185567f, 0.372165f, 0.6670103f}, {0.3329897f, 0.7195876f, 0.26391754f, 0.73195875f}, {0.24845362f, 0.8484536f, 0.214433f, 0.91030926f}, {0.16494846f, 1.0f, 0.067010306f, 1.0f}, {0.04226804f, 1.0f, 0.02113402f, 0.98298967f}, {0.0f, 0.96597934f, 0.0f, 0.9412371f}, {0.0f, 0.92371136f, 0.013917526f, 0.90979385f}, {0.027835052f, 0.8958763f, 0.045360826f, 0.8958763f}, {0.065979384f, 0.8958763f, 0.08505155f, 0.9298969f}, {0.10412372f, 0.96391755f, 0.12474228f, 0.96391755f}, {0.18247424f, 0.96391755f, 0.18969072f, 0.73195875f}, {0.11237113f, 0.71752584f, 0.062886596f, 0.6474227f}, {0.015463918f, 0.5804123f, 0.015463918f, 0.5f}, {0.015463918f, 0.41237113f, 0.07216495f, 0.3402062f}, {0.13402061f, 0.2628866f, 0.21958764f, 0.26494843f}, {0.23402062f, 0.14948452f, 0.2618557f, 0.09175257f}, {0.30618557f, 0.0f, 0.39896908f, 0.0f}, {0.4742268f, 0.0f, 0.4742268f, 0.065979354f}, new float[0], {0.21649484f, 0.29175258f}, {0.15773197f, 0.3010309f, 0.12886599f, 0.3597938f}, {0.10618556f, 0.4072165f, 0.10618556f, 0.4742268f}, {0.10618556f, 0.5350515f}, {0.10618556f, 0.5845361f, 0.12680413f, 0.6268041f}, {0.14948454f, 0.6742268f, 0.19072166f, 0.69381446f}, {0.19793814f, 0.4515464f, 0.21649484f, 0.29175258f}, new float[0]};
        private static final int[] CF_MORPH_RULES = new int[]{1, 1, 1, 1, 1, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 7, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0};

        protected float[][] getGlyphOutline() {
            return CF_OUTLINE;
        }

        protected int[] getStretchRules() {
            return CF_MORPH_RULES;
        }
    }

    public static class WmiCCWContourIntegralRenderer
    extends WmiIntegralRenderer {
        private static final float[][] CCW_CONTOUR_OUTLINE = new float[][]{{0.57113403f, 0.5804123f}, {0.52680415f, 0.55979383f, 0.47731963f, 0.5257732f}, {0.46804124f, 0.6092784f, 0.40773195f, 0.6695876f}, {0.3474227f, 0.72989696f, 0.26391754f, 0.73814434f}, {0.2474227f, 0.8525773f, 0.21340206f, 0.91237116f}, {0.16391753f, 1.0f, 0.068041235f, 1.0f}, {0.04329897f, 1.0f, 0.02216495f, 0.98298967f}, {0.0010309274f, 0.96597934f, 0.0010309274f, 0.9412371f}, {0.0010309274f, 0.92371136f, 0.014948451f, 0.90979385f}, {0.028865978f, 0.8958763f, 0.04639175f, 0.8958763f}, {0.067010306f, 0.8958763f, 0.08608247f, 0.9298969f}, {0.10515464f, 0.96391755f, 0.12577319f, 0.96391755f}, {0.18350515f, 0.96391755f, 0.19072166f, 0.7340206f}, {0.10824742f, 0.71649486f, 0.05412371f, 0.65051544f}, {0.0f, 0.5845361f, 0.0f, 0.5f}, {0.0f, 0.40618557f, 0.063917525f, 0.33762887f}, {0.12783507f, 0.26907218f, 0.22164948f, 0.26185566f}, {0.2371134f, 0.14639172f, 0.26391754f, 0.09072163f}, {0.30824742f, 0.0f, 0.40000004f, 0.0f}, {0.47525775f, 0.0f, 0.47525775f, 0.065979354f}, {0.47525775f, 0.080412365f, 0.46185568f, 0.09381444f}, {0.44845363f, 0.10721651f, 0.4329897f, 0.10721651f}, {0.414433f, 0.10721651f, 0.39329898f, 0.07680413f}, {0.372165f, 0.04639175f, 0.35257733f, 0.04639175f}, {0.29175258f, 0.04639175f, 0.2876289f, 0.26597938f}, {0.38969076f, 0.28659794f, 0.44226807f, 0.3742268f}, {0.44536084f, 0.38041237f, 0.46804124f, 0.42886597f}, {0.4948454f, 0.48659796f, 0.57113403f, 0.5505155f}, new float[0], {0.42268044f, 0.52680415f}, {0.3835052f, 0.556701f, 0.33195877f, 0.5804123f}, {0.33195877f, 0.5505155f}, {0.41340205f, 0.4824742f, 0.4195876f, 0.45463917f}, {0.40721652f, 0.40618557f, 0.37113404f, 0.36958763f}, {0.33505157f, 0.3329897f, 0.28659794f, 0.32061857f}, {0.28350517f, 0.36804125f, 0.27938145f, 0.4628866f}, {0.27835053f, 0.53608245f, 0.2701031f, 0.68247426f}, {0.328866f, 0.672165f, 0.37113404f, 0.62886596f}, {0.41340205f, 0.585567f, 0.42268044f, 0.52680415f}, new float[0], {0.214433f, 0.31649485f}, {0.14536083f, 0.32577318f, 0.09948454f, 0.37783504f}, {0.053608246f, 0.4298969f, 0.053608246f, 0.5f}, {0.053608246f, 0.5628866f, 0.09226804f, 0.6128866f}, {0.13092783f, 0.66288656f, 0.1917526f, 0.6793815f}, {0.19896908f, 0.4628866f, 0.214433f, 0.31649485f}, new float[0]};
        private static final int[] CCW_CONTOUR_MORPH_RULES = new int[]{0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 7, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

        protected float[][] getGlyphOutline() {
            return CCW_CONTOUR_OUTLINE;
        }

        protected int[] getStretchRules() {
            return CCW_CONTOUR_MORPH_RULES;
        }
    }

    public static class WmiCWContourIntegralRenderer
    extends WmiIntegralRenderer {
        private static final float[][] CW_CONTOUR_OUTLINE = new float[][]{{0.57113403f, 0.44948453f}, {0.5237114f, 0.4886598f, 0.48865983f, 0.5371134f}, {0.47731963f, 0.5525774f, 0.46391755f, 0.5814433f}, {0.44948453f, 0.61340207f, 0.44226807f, 0.6257732f}, {0.38144332f, 0.7257732f, 0.26391754f, 0.73814434f}, {0.2474227f, 0.8525773f, 0.21340206f, 0.91237116f}, {0.16391753f, 1.0f, 0.068041235f, 1.0f}, {0.04329897f, 1.0f, 0.02216495f, 0.98298967f}, {0.0010309274f, 0.96597934f, 0.0010309274f, 0.9412371f}, {0.0010309274f, 0.92371136f, 0.014948451f, 0.90979385f}, {0.028865978f, 0.8958763f, 0.04639175f, 0.8958763f}, {0.067010306f, 0.8958763f, 0.08608247f, 0.9298969f}, {0.10515464f, 0.96391755f, 0.12577319f, 0.96391755f}, {0.18350515f, 0.96391755f, 0.19072166f, 0.7340206f}, {0.10824742f, 0.71649486f, 0.05412371f, 0.65051544f}, {0.0f, 0.5845361f, 0.0f, 0.5f}, {0.0f, 0.40618557f, 0.063917525f, 0.33762887f}, {0.12783507f, 0.26907218f, 0.22164948f, 0.26185566f}, {0.2371134f, 0.14639172f, 0.26391754f, 0.09072163f}, {0.30824742f, 0.0f, 0.40000004f, 0.0f}, {0.47525775f, 0.0f, 0.47525775f, 0.065979354f}, {0.47525775f, 0.080412365f, 0.46185568f, 0.09381444f}, {0.44845363f, 0.10721651f, 0.4329897f, 0.10721651f}, {0.414433f, 0.10721651f, 0.39329898f, 0.07680413f}, {0.372165f, 0.04639175f, 0.35257733f, 0.04639175f}, {0.29175258f, 0.04639175f, 0.2876289f, 0.26597938f}, {0.36391753f, 0.2814433f, 0.41649488f, 0.33917525f}, {0.4690722f, 0.3969072f, 0.47731963f, 0.4742268f}, {0.52680415f, 0.4402062f, 0.57113403f, 0.4195876f}, new float[0], {0.42268044f, 0.47319588f}, {0.414433f, 0.4185567f, 0.3773196f, 0.3768041f}, {0.3402062f, 0.33505154f, 0.28659794f, 0.32061857f}, {0.28350517f, 0.36804125f, 0.27938145f, 0.4628866f}, {0.27835053f, 0.53608245f, 0.2701031f, 0.68247426f}, {0.32371137f, 0.6731959f, 0.36494848f, 0.635567f}, {0.4061856f, 0.5979382f, 0.4195876f, 0.5453608f}, {0.41340205f, 0.5175258f, 0.33195877f, 0.44948453f}, {0.33195877f, 0.4195876f}, {0.3835052f, 0.44329897f, 0.42268044f, 0.47319588f}, new float[0], {0.214433f, 0.31649485f}, {0.14536083f, 0.32577318f, 0.09948454f, 0.37783504f}, {0.053608246f, 0.4298969f, 0.053608246f, 0.5f}, {0.053608246f, 0.5628866f, 0.09226804f, 0.6128866f}, {0.13092783f, 0.66288656f, 0.1917526f, 0.6793815f}, {0.19896908f, 0.4628866f, 0.214433f, 0.31649485f}, new float[0]};
        private static final int[] CW_CONTOUR_MORPH_RULES = new int[]{0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 7, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

        protected float[][] getGlyphOutline() {
            return CW_CONTOUR_OUTLINE;
        }

        protected int[] getStretchRules() {
            return CW_CONTOUR_MORPH_RULES;
        }
    }

    public static class WmiTripleContourIntegralRenderer
    extends WmiIntegralRenderer {
        private static final float[][] TRIPLE_CONTOUR_OUTLINE = new float[][]{{0.9896908f, 0.5f}, {0.9896908f, 0.6608248f, 0.7783505f, 0.7134021f}, {0.76391757f, 0.8371134f, 0.7309278f, 0.9020619f}, {0.68041235f, 1.0f, 0.57938147f, 1.0f}, {0.55463916f, 1.0f, 0.5335052f, 0.98298967f}, {0.5123712f, 0.96597934f, 0.5123712f, 0.9412371f}, {0.5123712f, 0.92371136f, 0.5262887f, 0.90979385f}, {0.5402062f, 0.8958763f, 0.557732f, 0.8958763f}, {0.57835054f, 0.8958763f, 0.5974227f, 0.9298969f}, {0.6164949f, 0.96391755f, 0.6371134f, 0.96391755f}, {0.69587636f, 0.96391755f, 0.70206195f, 0.72783506f}, {0.6257732f, 0.73814434f, 0.51958764f, 0.73917526f}, {0.50309277f, 0.85360825f, 0.4690722f, 0.9134021f}, {0.4195876f, 1.0f, 0.32371137f, 1.0f}, {0.2989691f, 1.0f, 0.27783507f, 0.98298967f}, {0.25670102f, 0.96597934f, 0.25670102f, 0.9412371f}, {0.25670102f, 0.92371136f, 0.2706186f, 0.90979385f}, {0.2845361f, 0.8958763f, 0.30206186f, 0.8958763f}, {0.3226804f, 0.8958763f, 0.3417526f, 0.9298969f}, {0.36082473f, 0.96391755f, 0.38144332f, 0.96391755f}, {0.43917528f, 0.96391755f, 0.44639176f, 0.73917526f}, {0.34226808f, 0.7371134f, 0.26597938f, 0.7247423f}, {0.2505155f, 0.84432995f, 0.21649484f, 0.9072165f}, {0.16701032f, 1.0f, 0.068041235f, 1.0f}, {0.04329897f, 1.0f, 0.02216495f, 0.98298967f}, {0.0010309274f, 0.96597934f, 0.0010309274f, 0.9412371f}, {0.0010309274f, 0.92371136f, 0.014948451f, 0.90979385f}, {0.028865978f, 0.8958763f, 0.04639175f, 0.8958763f}, {0.067010306f, 0.8958763f, 0.08608247f, 0.9298969f}, {0.10515464f, 0.96391755f, 0.12577319f, 0.96391755f}, {0.18350515f, 0.96391755f, 0.1917526f, 0.70721656f}, {0.0f, 0.65257734f, 0.0f, 0.5f}, {0.0f, 0.33711338f, 0.2185567f, 0.28556702f}, {0.23298968f, 0.1587629f, 0.2587629f, 0.1010309f}, {0.30309278f, 0.0f, 0.40000004f, 0.0f}, {0.47525775f, 0.0f, 0.47525775f, 0.065979354f}, {0.47525775f, 0.081443295f, 0.46134022f, 0.094329864f}, {0.4474227f, 0.10721651f, 0.4329897f, 0.10721651f}, {0.414433f, 0.10721651f, 0.39329898f, 0.07680413f}, {0.372165f, 0.04639175f, 0.35257733f, 0.04639175f}, {0.29175258f, 0.04639175f, 0.2876289f, 0.27216494f}, {0.3659794f, 0.26185566f, 0.47731963f, 0.26082474f}, {0.4917526f, 0.14536078f, 0.51958764f, 0.08969069f}, {0.5639176f, 0.0f, 0.65567017f, 0.0f}, {0.7309278f, 0.0f, 0.7309278f, 0.065979354f}, {0.7309278f, 0.081443295f, 0.7170104f, 0.094329864f}, {0.7030928f, 0.10721651f, 0.6886599f, 0.10721651f}, {0.6701031f, 0.10721651f, 0.6489691f, 0.07680413f}, {0.6278351f, 0.04639175f, 0.60824746f, 0.04639175f}, {0.5474227f, 0.04639175f, 0.54329896f, 0.26082474f}, {0.6515464f, 0.2628866f, 0.7309278f, 0.27731958f}, {0.7453609f, 0.1546392f, 0.77216506f, 0.09690724f}, {0.8164948f, 0.0f, 0.91134024f, 0.0f}, {0.9865979f, 0.0f, 0.9865979f, 0.065979354f}, {0.9865979f, 0.081443295f, 0.9726805f, 0.094329864f}, {0.9587629f, 0.10721651f, 0.94433f, 0.10721651f}, {0.9257733f, 0.10721651f, 0.90463924f, 0.07680413f}, {0.8835052f, 0.04639175f, 0.8639175f, 0.04639175f}, {0.8030928f, 0.04639175f, 0.79793817f, 0.29175258f}, {0.9896908f, 0.34742266f, 0.9896908f, 0.5f}, new float[0], {0.9360825f, 0.5f}, {0.9360825f, 0.3824742f, 0.7969073f, 0.3402062f}, {0.7938144f, 0.4484536f, 0.78350526f, 0.66391754f}, {0.9360825f, 0.6226804f, 0.9360825f, 0.5f}, new float[0], {0.7257732f, 0.32474226f}, {0.65773195f, 0.31443298f, 0.5628866f, 0.31443298f}, {0.5422681f, 0.31443298f}, {0.5391753f, 0.36391753f, 0.5350516f, 0.4628866f}, {0.53402066f, 0.5371134f, 0.5257732f, 0.685567f}, {0.5515464f, 0.685567f}, {0.643299f, 0.685567f, 0.7030928f, 0.6783505f}, {0.71030927f, 0.46804124f, 0.7257732f, 0.32474226f}, new float[0], {0.47113407f, 0.31443298f}, {0.4371134f, 0.31443298f}, {0.34639177f, 0.31443298f, 0.28659794f, 0.3216495f}, {0.28350517f, 0.36907217f, 0.27938145f, 0.4628866f}, {0.27835053f, 0.5340206f, 0.27113402f, 0.67628866f}, {0.33711338f, 0.685567f, 0.42680413f, 0.685567f}, {0.4474227f, 0.685567f}, {0.45463917f, 0.46391755f, 0.47113407f, 0.31443298f}, new float[0], {0.21340206f, 0.33505154f}, {0.053608246f, 0.37525776f, 0.053608246f, 0.5f}, {0.053608246f, 0.61649483f, 0.1927835f, 0.6597938f}, {0.19896908f, 0.47010309f, 0.21340206f, 0.33505154f}, new float[0]};
        private static final int[] TRIPLE_CONTOUR_MORPH_RULES = new int[]{0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 7, 0, 3, 3, 3, 3, 3, 3, 3, 3, 7, 0, 3, 3, 3, 3, 3, 3, 3, 3, 7, 0, 0, 1, 1, 1, 1, 1, 1, 1, 6, 0, 1, 1, 1, 1, 1, 1, 1, 6, 0, 1, 1, 1, 1, 1, 1, 1, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

        protected float[][] getGlyphOutline() {
            return TRIPLE_CONTOUR_OUTLINE;
        }

        protected int[] getStretchRules() {
            return TRIPLE_CONTOUR_MORPH_RULES;
        }
    }

    public static class WmiDoubleContourIntegralRenderer
    extends WmiIntegralRenderer {
        private static final float[][] DOUBLE_CONTOUR_OUTLINE = new float[][]{{0.7340206f, 0.5f}, {0.7340206f, 0.66288656f, 0.5216495f, 0.7195876f}, {0.5072165f, 0.8412371f, 0.47319588f, 0.9051547f}, {0.42371136f, 1.0f, 0.32371137f, 1.0f}, {0.2989691f, 1.0f, 0.27783507f, 0.98298967f}, {0.25670105f, 0.96597934f, 0.25670105f, 0.9412371f}, {0.25670105f, 0.92371136f, 0.2706186f, 0.90979385f}, {0.2845361f, 0.8958763f, 0.30206186f, 0.8958763f}, {0.3226804f, 0.8958763f, 0.3417526f, 0.9298969f}, {0.36082476f, 0.96391755f, 0.38144332f, 0.96391755f}, {0.43917528f, 0.96391755f, 0.44639176f, 0.7340206f}, {0.4061856f, 0.73917526f, 0.36701035f, 0.73917526f}, {0.31649485f, 0.73917526f, 0.26494846f, 0.7309278f}, {0.24948455f, 0.8484536f, 0.21546394f, 0.90927833f}, {0.1659794f, 1.0f, 0.068041235f, 1.0f}, {0.04329897f, 1.0f, 0.02216495f, 0.98298967f}, {0.00103093f, 0.96597934f, 0.00103093f, 0.9412371f}, {0.00103093f, 0.92371136f, 0.014948457f, 0.90979385f}, {0.028865982f, 0.8958763f, 0.046391755f, 0.8958763f}, {0.06701031f, 0.8958763f, 0.08608249f, 0.9298969f}, {0.10515464f, 0.96391755f, 0.12577319f, 0.96391755f}, {0.18453608f, 0.96391755f, 0.19072166f, 0.7134021f}, {0.0f, 0.65360826f, 0.0f, 0.5f}, {0.0f, 0.33402064f, 0.21958764f, 0.2783505f}, {0.23402062f, 0.15567009f, 0.25979385f, 0.0979381f}, {0.30515465f, 0.0f, 0.40000004f, 0.0f}, {0.47525775f, 0.0f, 0.47525775f, 0.065979354f}, {0.47525775f, 0.081443295f, 0.46134022f, 0.094329864f}, {0.4474227f, 0.10721651f, 0.4329897f, 0.10721651f}, {0.414433f, 0.10721651f, 0.39329898f, 0.07680413f}, {0.372165f, 0.04639175f, 0.35257733f, 0.04639175f}, {0.2917526f, 0.04639175f, 0.2876289f, 0.26597938f}, {0.32783505f, 0.26082474f, 0.36701035f, 0.26082474f}, {0.4216495f, 0.26082474f, 0.47628868f, 0.2701031f}, {0.49072164f, 0.15154639f, 0.5175258f, 0.09484537f}, {0.5618557f, 0.0f, 0.65567017f, 0.0f}, {0.7309278f, 0.0f, 0.7309278f, 0.065979354f}, {0.7309278f, 0.081443295f, 0.7170103f, 0.094329864f}, {0.7030928f, 0.10721651f, 0.6886598f, 0.10721651f}, {0.6701031f, 0.10721651f, 0.6489691f, 0.07680413f}, {0.6278351f, 0.04639175f, 0.60824746f, 0.04639175f}, {0.5474227f, 0.04639175f, 0.5422681f, 0.28659794f}, {0.7340206f, 0.34639177f, 0.7340206f, 0.5f}, new float[0], {0.6804124f, 0.5f}, {0.6804124f, 0.385567f, 0.5412372f, 0.3402062f}, {0.53814435f, 0.4484536f, 0.5278351f, 0.66494846f}, {0.6804124f, 0.61958766f, 0.6804124f, 0.5f}, new float[0], {0.4701031f, 0.3226804f}, {0.41958767f, 0.31443298f, 0.36701035f, 0.31443298f}, {0.32577324f, 0.31443298f, 0.28659797f, 0.31958762f}, {0.28350517f, 0.3670103f, 0.27938145f, 0.4628866f}, {0.27835053f, 0.5350515f, 0.2701031f, 0.6783505f}, {0.3175258f, 0.685567f, 0.36701035f, 0.685567f}, {0.40824747f, 0.685567f, 0.4474227f, 0.6804124f}, {0.45463923f, 0.46701032f, 0.4701031f, 0.3226804f}, new float[0], {0.21340209f, 0.33402064f}, {0.05360825f, 0.37731957f, 0.05360825f, 0.5f}, {0.05360825f, 0.614433f, 0.19278353f, 0.6597938f}, {0.19896908f, 0.4690722f, 0.21340209f, 0.33402064f}, new float[0]};
        private static final int[] DOUBLE_CONTOUR_MORPH_RULES = new int[]{0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 7, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 7, 0, 0, 1, 1, 1, 1, 1, 1, 1, 6, 0, 0, 1, 1, 1, 1, 1, 1, 1, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

        protected float[][] getGlyphOutline() {
            return DOUBLE_CONTOUR_OUTLINE;
        }

        protected int[] getStretchRules() {
            return DOUBLE_CONTOUR_MORPH_RULES;
        }
    }

    public static class WmiContourIntegralRenderer
    extends WmiIntegralRenderer {
        private static final float[][] CONTOUR_OUTLINE = new float[][]{{0.47835055f, 0.5f}, {0.47835055f, 0.5917525f, 0.41649488f, 0.6603093f}, {0.3546392f, 0.72886604f, 0.26391754f, 0.73814434f}, {0.2474227f, 0.8525773f, 0.21340209f, 0.91237116f}, {0.16391753f, 1.0f, 0.068041235f, 1.0f}, {0.04329897f, 1.0f, 0.02216495f, 0.98298967f}, {0.00103093f, 0.96597934f, 0.00103093f, 0.9412371f}, {0.00103093f, 0.92371136f, 0.014948457f, 0.90979385f}, {0.028865982f, 0.8958763f, 0.046391755f, 0.8958763f}, {0.06701031f, 0.8958763f, 0.08608249f, 0.9298969f}, {0.10515464f, 0.96391755f, 0.12577319f, 0.96391755f}, {0.18350518f, 0.96391755f, 0.19072166f, 0.7340206f}, {0.10721649f, 0.71752584f, 0.05360825f, 0.65103096f}, {0.0f, 0.5845361f, 0.0f, 0.5f}, {0.0f, 0.40618557f, 0.06391753f, 0.33711338f}, {0.12783505f, 0.26804122f, 0.22164951f, 0.26185566f}, {0.2360825f, 0.14639172f, 0.26391754f, 0.09072163f}, {0.30824745f, 0.0f, 0.40000004f, 0.0f}, {0.47525775f, 0.0f, 0.47525775f, 0.065979354f}, {0.47525775f, 0.081443295f, 0.46134022f, 0.094329864f}, {0.4474227f, 0.10721651f, 0.4329897f, 0.10721651f}, {0.414433f, 0.10721651f, 0.39329898f, 0.07680413f}, {0.372165f, 0.04639175f, 0.35257733f, 0.04639175f}, {0.2917526f, 0.04639175f, 0.2876289f, 0.26597938f}, {0.37113404f, 0.2824742f, 0.4247423f, 0.34896907f}, {0.47835055f, 0.41546392f, 0.47835055f, 0.5f}, new float[0], {0.4247423f, 0.5f}, {0.4247423f, 0.4371134f, 0.38608247f, 0.38659796f}, {0.3474227f, 0.33608246f, 0.28659797f, 0.32061857f}, {0.28350517f, 0.36804125f, 0.27938145f, 0.4628866f}, {0.27835053f, 0.53608245f, 0.2701031f, 0.6835052f}, {0.33711344f, 0.672165f, 0.38092786f, 0.6201031f}, {0.4247423f, 0.56804127f, 0.4247423f, 0.5f}, new float[0], {0.214433f, 0.31649485f}, {0.14536084f, 0.32474226f, 0.09948454f, 0.37731957f}, {0.05360825f, 0.4298969f, 0.05360825f, 0.5f}, {0.05360825f, 0.5628866f, 0.09226806f, 0.61340207f}, {0.13092783f, 0.66391754f, 0.1917526f, 0.6793815f}, {0.19896908f, 0.4628866f, 0.214433f, 0.31649485f}, new float[0]};
        private static final int[] CONTOUR_MORPH_RULES = new int[]{0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 7, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

        protected float[][] getGlyphOutline() {
            return CONTOUR_OUTLINE;
        }

        protected int[] getStretchRules() {
            return CONTOUR_MORPH_RULES;
        }
    }
}

