/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiSuperscriptModel;
import com.maplesoft.mathdoc.view.WmiAdjustableTextBounds;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiTextAdjustmentUtils;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiMultiscriptView;
import com.maplesoft.mathdoc.view.math.WmiTraversableCompositeMathView;
import java.awt.Point;

public class WmiSuperscriptView
extends WmiTraversableCompositeMathView
implements WmiAdjustableTextBounds {
    private static final int BASE_INDEX = 0;
    private static final int EXPONENT_INDEX = 1;
    public static final double ITALICS_ADJUSTMENT_FACTOR = 0.19438030913772;
    private static final double FONT_VERTICAL_ADJUSTMENT_FACTOR = 0.55;

    public WmiSuperscriptView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        super(wmiModel, wmiMathDocumentView);
    }

    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            this.validateChildren();
            super.layoutView();
            WmiFontMetrics wmiFontMetrics = WmiViewUtil.getFontMetrics(this);
            WmiPositionedView wmiPositionedView = (WmiPositionedView)this.getChild(0);
            WmiPositionedView wmiPositionedView2 = (WmiPositionedView)this.getChild(1);
            if (wmiPositionedView != null && wmiPositionedView2 != null) {
                int n = WmiSuperscriptView.getSuperscriptHOffset(wmiPositionedView, wmiPositionedView2);
                wmiPositionedView2.setHorizontalOffset(n);
                WmiPositionedView wmiPositionedView3 = wmiPositionedView;
                if (wmiPositionedView instanceof WmiMultiscriptView) {
                    wmiPositionedView3 = (WmiPositionedView)((WmiCompositeView)((Object)wmiPositionedView3)).getChild(0);
                }
                int n2 = WmiSuperscriptView.getBaseVOffset(this, wmiPositionedView3, wmiPositionedView2, wmiFontMetrics);
                if (wmiPositionedView != wmiPositionedView3) {
                    wmiPositionedView2.setVerticalOffset(wmiPositionedView.getBaseline() - wmiPositionedView3.getBaseline());
                }
                wmiPositionedView.setVerticalOffset(n2);
                this.height = n2 + wmiPositionedView.getHeight() - wmiPositionedView2.getVerticalOffset();
                this.width = n + wmiPositionedView2.getWidth();
                this.baseline = wmiPositionedView.getBaseline() + n2;
                this.addNavigationLinks();
            }
        }
    }

    public static int getSuperscriptHOffset(WmiPositionedView wmiPositionedView, WmiPositionedView wmiPositionedView2) {
        int n = wmiPositionedView.getWidth();
        if (wmiPositionedView instanceof WmiAdjustableTextBounds) {
            n += ((WmiAdjustableTextBounds)((Object)wmiPositionedView)).computePostKernAdjustment();
        }
        if (wmiPositionedView2 instanceof WmiAdjustableTextBounds) {
            n += ((WmiAdjustableTextBounds)((Object)wmiPositionedView2)).computePreKernAdjustment();
        }
        return n;
    }

    public static int getBaseVOffset(WmiView wmiView, WmiPositionedView wmiPositionedView, WmiPositionedView wmiPositionedView2) throws WmiNoReadAccessException {
        WmiFontMetrics wmiFontMetrics = null;
        if (wmiView instanceof WmiGenericView) {
            wmiFontMetrics = WmiViewUtil.getFontMetrics((WmiGenericView)wmiView);
        }
        return WmiSuperscriptView.getBaseVOffset(wmiView, wmiPositionedView, wmiPositionedView2, wmiFontMetrics);
    }

    public static int getBaseVOffset(WmiView wmiView, WmiPositionedView wmiPositionedView, WmiPositionedView wmiPositionedView2, WmiFontMetrics wmiFontMetrics) throws WmiNoReadAccessException {
        WmiMathDocumentView wmiMathDocumentView;
        int n = wmiPositionedView2.getBaseline();
        int n2 = wmiPositionedView2.getHeight() - n;
        int n3 = 0;
        int n4 = 0;
        int n5 = wmiFontMetrics != null ? wmiFontMetrics.getFontProperty(5, wmiView.getDocumentView().isPrintView()) : 8;
        int n6 = (int)Math.round((double)n5 * 0.55);
        WmiAttributeSet wmiAttributeSet = wmiView.getModel().getAttributes();
        if (wmiAttributeSet instanceof WmiSuperscriptModel.WmiSuperscriptAttributeSet) {
            n4 = ((WmiSuperscriptModel.WmiSuperscriptAttributeSet)wmiAttributeSet).getSuperscriptShift();
        }
        if ((wmiMathDocumentView = wmiPositionedView.getDocumentView()) != null) {
            int n7 = wmiMathDocumentView.getZoomFactor();
            n4 = Math.round(n7 * n4 / 100);
        }
        n3 = n;
        n3 -= n6;
        n3 += n2;
        return n3 += n4;
    }

    public void addNavigationLinks() {
        WmiPositionedView wmiPositionedView = (WmiPositionedView)this.getChild(0);
        WmiPositionedView wmiPositionedView2 = (WmiPositionedView)this.getChild(1);
        if (wmiPositionedView != null && wmiPositionedView2 != null) {
            wmiPositionedView.setNextView(wmiPositionedView2, 3);
            wmiPositionedView2.setNextView(wmiPositionedView, 2);
            this.setNextView(null, -2);
            this.setNextView(wmiPositionedView, -1);
            this.setNextView(wmiPositionedView, -4);
            this.setNextView(wmiPositionedView2, -3);
        }
    }

    public WmiPositionedView getNextView(int n) {
        WmiPositionMarker wmiPositionMarker;
        WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
        boolean bl = false;
        if (wmiMathDocumentView != null && (wmiPositionMarker = wmiMathDocumentView.getPositionMarker()) != null) {
            bl = wmiPositionMarker.getView() == this.getChild(1);
        }
        int n2 = bl && n == 1 ? 3 : n;
        return super.getNextView(n2);
    }

    public WmiPositionedView getViewForNavigation(int n, Point point) {
        WmiPositionedView wmiPositionedView = this.getNextView(n);
        if (wmiPositionedView == null) {
            return this.getNearestChildView(point);
        }
        return wmiPositionedView;
    }

    public int computePreKernAdjustment() {
        return WmiTextAdjustmentUtils.computePreKernAdjustment(this, 0);
    }

    public int computePostKernAdjustment() {
        return WmiTextAdjustmentUtils.computePostKernAdjustment(this, 1);
    }

    public int computeSpaceAbove() {
        return WmiTextAdjustmentUtils.computeSpaceAbove(this, 1);
    }

    public int computeSpaceBelow() {
        return WmiTextAdjustmentUtils.computeSpaceBelow(this, 0);
    }

    public int getNearestSearchRule() {
        return 2;
    }

    public int doImplicitLinebreak(WmiParagraphView wmiParagraphView, int n, int n2, int n3) throws WmiNoReadAccessException {
        return WmiSuperscriptView.doImplicitScriptBreak(this, wmiParagraphView, n, n2, n3);
    }

    public static int doImplicitScriptBreak(WmiCompositeView wmiCompositeView, WmiParagraphView wmiParagraphView, int n, int n2, int n3) throws WmiNoReadAccessException {
        int n4 = 0;
        WmiInlineView wmiInlineView = null;
        WmiPositionedView wmiPositionedView = (WmiPositionedView)wmiCompositeView.getChild(0);
        if (wmiPositionedView instanceof WmiCompositeView && wmiPositionedView.hasGoodBreakpoint(n, n2, n3)) {
            wmiInlineView = WmiSuperscriptView.convertToInline(wmiCompositeView);
        } else if (n3 > 1) {
            wmiInlineView = WmiSuperscriptView.convertToInline(wmiCompositeView);
        }
        if (wmiInlineView != null) {
            WmiCompositeView wmiCompositeView2 = wmiCompositeView.getParentView();
            int n5 = wmiCompositeView2.indexOf(wmiCompositeView);
            int n6 = ((WmiPositionedView)((Object)wmiCompositeView)).getHorizontalOffset();
            if (n5 >= 0) {
                wmiCompositeView2.replaceChild(wmiInlineView, n5);
                wmiInlineView.setParentView(wmiCompositeView2);
                wmiInlineView.setHorizontalOffset(n6);
                n4 = 1;
            }
        }
        return n4;
    }

    private static WmiInlineView convertToInline(WmiCompositeView wmiCompositeView) throws WmiNoReadAccessException {
        WmiModel wmiModel = wmiCompositeView.getModel();
        WmiMathDocumentView wmiMathDocumentView = wmiCompositeView.getDocumentView();
        WmiInlineView wmiInlineView = new WmiInlineView(wmiModel, wmiMathDocumentView);
        wmiInlineView.releaseObserver();
        WmiPositionedView wmiPositionedView = (WmiPositionedView)wmiCompositeView.getChild(0);
        WmiPositionedView wmiPositionedView2 = (WmiPositionedView)wmiCompositeView.getChild(1);
        wmiInlineView.appendView(WmiSuperscriptView.createPaddedView(wmiCompositeView, wmiPositionedView));
        wmiInlineView.appendView(WmiSuperscriptView.createPaddedView(wmiCompositeView, wmiPositionedView2));
        wmiInlineView.layoutView();
        return wmiInlineView;
    }

    private static WmiInlineView createPaddedView(WmiCompositeView wmiCompositeView, WmiPositionedView wmiPositionedView) throws WmiNoReadAccessException {
        WmiInlineView wmiInlineView = new WmiInlineView(wmiPositionedView.getModel(), wmiPositionedView.getDocumentView());
        wmiInlineView.releaseObserver();
        wmiInlineView.appendView(wmiPositionedView);
        wmiInlineView.setBaselineAdjustment(((WmiPositionedView)((Object)wmiCompositeView)).getBaseline() - wmiPositionedView.getVerticalOffset() - wmiPositionedView.getBaseline());
        wmiInlineView.layoutView();
        return wmiInlineView;
    }
}

