/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.controller.insert.WmiInsertMathMLCommand;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiDimensionUnit;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPosition;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.util.WmiMathEntityNameMapper;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class WmiMathViewUtil {
    public static final float DEFAULT_FONT_SIZE = 20.0f;
    private static final Font DEFAULT_RESOLVE_FONT = new Font("Times New Roman", 0, 20);
    private static FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), false, false);

    private static int fontSizeAtWrapperLimit(WmiInlineView wmiInlineView, Point point) throws WmiNoReadAccessException {
        WmiAttributeSet wmiAttributeSet;
        WmiPositionedView wmiPositionedView;
        WmiModel wmiModel;
        int n = 0;
        WmiViewPosition wmiViewPosition = WmiViewUtil.findNearestView(wmiInlineView, point);
        if (wmiViewPosition != null && (wmiModel = (wmiPositionedView = wmiViewPosition.getView()).getModel()) instanceof WmiMathModel && (wmiAttributeSet = wmiModel.getAttributes()) instanceof WmiFontAttributeSet) {
            n = ((WmiFontAttributeSet)wmiAttributeSet).getSize();
        }
        return n;
    }

    public static int getMathKerningSize(WmiInlineView wmiInlineView) throws WmiNoReadAccessException {
        int n = 0;
        n = Math.max(n, WmiMathViewUtil.fontSizeAtWrapperLimit(wmiInlineView, new Point(0, 0)));
        n = Math.max(n, WmiMathViewUtil.fontSizeAtWrapperLimit(wmiInlineView, new Point(0, wmiInlineView.getHeight())));
        n = Math.max(n, WmiMathViewUtil.fontSizeAtWrapperLimit(wmiInlineView, new Point(wmiInlineView.getWidth(), wmiInlineView.getHeight())));
        n = Math.max(n, WmiMathViewUtil.fontSizeAtWrapperLimit(wmiInlineView, new Point(wmiInlineView.getWidth(), 0)));
        return (int)((double)n * 0.37);
    }

    public static int getPixelValueForDimension(WmiDimensionUnit wmiDimensionUnit, WmiFontAttributeSet wmiFontAttributeSet, boolean bl) {
        int n = 0;
        float f = wmiDimensionUnit.getUnitsValue();
        String string = wmiDimensionUnit.getUnit();
        WmiDimensionUnit wmiDimensionUnit2 = wmiDimensionUnit.getDefaultUnit();
        if ("px".equals(string) || "pt".equals(string)) {
            n = (int)f;
        } else if ("pc".equals(string)) {
            n = Math.round(f * 12.0f);
        } else if ("in".equals(string)) {
            n = Math.round(f * 72.0f);
        } else if ("cm".equals(string)) {
            n = Math.round(f * 28.346457f);
        } else if ("mm".equals(string)) {
            n = Math.round(f * 28.346457f / 10.0f);
        } else if ("%".equals(string)) {
            int n2 = wmiDimensionUnit2 == null ? 0 : WmiMathViewUtil.getPixelValueForDimension(wmiDimensionUnit2, wmiFontAttributeSet, bl);
            n = Math.round((float)n2 * f / 100.0f);
        } else if ("em".equals(string)) {
            Font font = WmiFontResolver.getFont(wmiFontAttributeSet, 100, bl);
            WmiFontMetrics wmiFontMetrics = WmiFontResolver.getFontMetrics(font);
            int n3 = wmiFontMetrics.getFontProperty(3, bl);
            n = Math.round((float)n3 * f);
        } else if ("ex".equals(string)) {
            Font font = WmiFontResolver.getFont(wmiFontAttributeSet, 100, bl);
            WmiFontMetrics wmiFontMetrics = WmiFontResolver.getFontMetrics(font);
            int n4 = wmiFontMetrics.getFontProperty(1, bl);
            n = Math.round((float)n4 * f);
        } else {
            if (WmiMathOperatorView.getNamedDimension(string) != null) {
                WmiDimensionUnit wmiDimensionUnit3 = WmiMathOperatorView.getNamedDimension(string);
                return WmiMathViewUtil.getPixelValueForDimension(wmiDimensionUnit3, wmiFontAttributeSet, bl);
            }
            int n5 = wmiDimensionUnit2 == null ? 0 : WmiMathViewUtil.getPixelValueForDimension(wmiDimensionUnit2, wmiFontAttributeSet, bl);
            n = Math.round((float)n5 * f);
        }
        return n;
    }

    public static Image renderMathMLEntity(String string, int n, WmiFontAttributeSet wmiFontAttributeSet, boolean bl) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        Object object;
        String string2 = string;
        Font font = DEFAULT_RESOLVE_FONT;
        char c = WmiMathEntityNameMapper.getUnicodeCharacter(string);
        if (c != '\u0000' && bl) {
            object = Character.toString(c);
            font = WmiFontResolver.getFontForCharacter((String)object, DEFAULT_RESOLVE_FONT);
            string2 = WmiFontResolver.mapCharactersForFont((String)object, font, 1);
        }
        object = null;
        if (font != null) {
            font = font.deriveFont((float)wmiFontAttributeSet.getSize());
            FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), false, false);
            Rectangle2D rectangle2D = font.getStringBounds(string2, fontRenderContext);
            LineMetrics lineMetrics = font.getLineMetrics(string2, fontRenderContext);
            int n2 = (int)rectangle2D.getWidth();
            int n3 = (int)rectangle2D.getHeight();
            int n4 = (int)lineMetrics.getDescent();
            object = new BufferedImage(n2 + 2 * n, n3 + 2 * n, 2);
            Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
            graphics2D.setColor(new Color(wmiFontAttributeSet.getForeground()));
            graphics2D.setFont(font);
            ((Graphics)graphics2D).drawString(string2, n, n3 - n4 + n);
            graphics2D.dispose();
        }
        return object;
    }

    public static Image renderMathML(String string, WmiMathDocumentView wmiMathDocumentView, int n, boolean bl) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        return WmiMathViewUtil.renderMathML(string, wmiMathDocumentView, n, null, bl, null);
    }

    public static Image renderMathML(String string, WmiMathDocumentView wmiMathDocumentView, int n, boolean bl, WmiFontAttributeSet wmiFontAttributeSet) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        return WmiMathViewUtil.renderMathML(string, wmiMathDocumentView, n, null, bl, wmiFontAttributeSet);
    }

    public static Image renderTypeMK(Dag dag, WmiMathDocumentView wmiMathDocumentView, int n, boolean bl, WmiFontAttributeSet wmiFontAttributeSet) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        return WmiMathViewUtil.renderTypeMK(dag, wmiMathDocumentView, n, null, bl, wmiFontAttributeSet);
    }

    public static Image renderMathML(String string, WmiMathDocumentView wmiMathDocumentView, int n, int[] nArray, boolean bl, WmiFontAttributeSet wmiFontAttributeSet) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
        WmiMathContext wmiMathContext = wmiFontAttributeSet != null ? new WmiMathContext(wmiFontAttributeSet) : null;
        WmiMathModel wmiMathModel = WmiInsertMathMLCommand.convertMathMLToModel(string, wmiMathDocumentModel, wmiMathContext);
        return WmiMathViewUtil.renderMathModel(wmiMathDocumentView, wmiMathModel, n, nArray, bl);
    }

    public static Image renderTypeMK(Dag dag, WmiMathDocumentView wmiMathDocumentView, int n, int[] nArray, boolean bl, WmiFontAttributeSet wmiFontAttributeSet) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
        WmiMathModel wmiMathModel = WmiMathFactory.createMath(wmiMathDocumentModel, dag, new WmiMathContext(wmiFontAttributeSet));
        return WmiMathViewUtil.renderMathModel(wmiMathDocumentView, wmiMathModel, n, nArray, bl);
    }

    public static Image renderMathModel(WmiMathDocumentView wmiMathDocumentView, WmiMathModel wmiMathModel, int n, int[] nArray, boolean bl) throws WmiNoReadAccessException {
        WmiViewFactory wmiViewFactory = wmiMathDocumentView.getViewFactory();
        WmiView wmiView = wmiViewFactory.createView(wmiMathModel, wmiMathDocumentView);
        BufferedImage bufferedImage = null;
        if (wmiView instanceof WmiPositionedView) {
            WmiPositionedView wmiPositionedView = (WmiPositionedView)wmiView;
            wmiPositionedView.layoutView();
            int n2 = 0;
            int n3 = wmiPositionedView.getWidth() + 2 * n;
            int n4 = wmiPositionedView.getHeight() + 2 * n;
            int n5 = wmiPositionedView.getBaseline();
            if (nArray != null) {
                nArray[0] = n5 + n;
            }
            if (bl) {
                n4 = Math.max(n5, n4 - n5);
                n2 = n4 - n5;
                n4 *= 2;
            } else {
                n2 = n;
            }
            n4 = n4 <= 0 ? 1 : n4;
            n3 = n3 <= 0 ? 1 : n3;
            bufferedImage = new BufferedImage(n3, n4, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            Rectangle rectangle = new Rectangle(0, 0, n3, n4);
            WmiRenderPath wmiRenderPath = new WmiRenderPath(wmiMathDocumentView);
            wmiRenderPath.push(n, n2);
            wmiPositionedView.draw(graphics2D, wmiRenderPath, rectangle);
            graphics2D.dispose();
        }
        return bufferedImage;
    }
}

