/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathStyleModel;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiMathCaret;
import com.maplesoft.mathdoc.view.math.WmiMathInlineView;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.WmiMathTextFragmentView;
import java.awt.Font;
import java.awt.Point;

public class WmiMathTextView
extends WmiTextView {
    public WmiMathTextView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        super(wmiModel, wmiMathDocumentView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPositionMarker(int n) {
        if (WmiModelLock.readLock(this.getModel(), true)) {
            try {
                WmiMathDocumentView wmiMathDocumentView;
                if (n == -1) {
                    n = this.getTraversableCount();
                }
                if ((wmiMathDocumentView = this.getDocumentView()) != null) {
                    int[] nArray;
                    WmiCaret wmiCaret = wmiMathDocumentView.getCaret();
                    boolean bl = false;
                    if (!(wmiCaret instanceof WmiMathCaret)) {
                        wmiCaret = new WmiMathCaret(wmiMathDocumentView);
                        bl = true;
                    }
                    WmiScrollableContainerView wmiScrollableContainerView = WmiViewUtil.findEnclosingContainer(this);
                    int[] nArray2 = super.getCaretBounds(wmiScrollableContainerView, n);
                    if (wmiCaret instanceof WmiMathCaret) {
                        ((WmiMathCaret)wmiCaret).setUprightPosition(nArray2[0], nArray2[2]);
                    }
                    int n2 = (nArray = this.getCaretBounds(n))[2] > nArray2[2] ? nArray[2] : nArray2[2];
                    nArray[2] = n2;
                    wmiCaret.updateCaretBounds(wmiScrollableContainerView, nArray[0], nArray[1], nArray[2], nArray[3]);
                    wmiCaret.updateView(this, n);
                    if (bl) {
                        wmiMathDocumentView.setPositionMarker(wmiCaret);
                    }
                    wmiCaret.show();
                } else {
                    WmiErrorLog.log(new Exception("unable to find document view"));
                }
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            finally {
                WmiModelLock.readUnlock(this.getModel());
            }
        }
    }

    public int[] getCaretBounds(int n) throws WmiNoReadAccessException {
        WmiScrollableContainerView wmiScrollableContainerView = WmiViewUtil.findEnclosingContainer(this);
        Point point = WmiViewUtil.getRelativeOffset(this, wmiScrollableContainerView);
        int[] nArray = super.getCaretBounds(wmiScrollableContainerView, n);
        nArray[0] = point.x;
        nArray[2] = point.x + this.getWidth();
        return nArray;
    }

    public WmiView createViewFragment(int n, int n2) throws WmiNoReadAccessException {
        return new WmiMathTextFragmentView(this.getModel(), this.getDocumentView(), n, n2);
    }

    public int getCorrectedZoomFactor() throws WmiNoReadAccessException {
        return WmiMathTextView.getCorrectedZoomFactor(this);
    }

    public static int getCorrectedZoomFactor(WmiPositionedView wmiPositionedView) throws WmiNoReadAccessException {
        WmiMathDocumentView wmiMathDocumentView = wmiPositionedView.getDocumentView();
        int n = wmiPositionedView.getZoomFactor();
        boolean bl = false;
        WmiModel wmiModel = wmiPositionedView.getModel();
        WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
        while (wmiCompositeModel instanceof WmiMathModel) {
            bl = ((WmiMathModel)((Object)wmiCompositeModel)).useScriptSize(wmiModel);
            if (bl) {
                WmiMathStyleModel wmiMathStyleModel = (WmiMathStyleModel)WmiModelUtil.findAncestorOfTag((WmiModel)wmiCompositeModel, WmiModelTag.MATH_STYLE);
                if (wmiMathStyleModel != null) {
                    WmiMathStyleModel.WmiMathStyleAttributeSet wmiMathStyleAttributeSet = (WmiMathStyleModel.WmiMathStyleAttributeSet)wmiMathStyleModel.getAttributesForRead();
                    n = Math.round((float)n * WmiMathInlineView.calculateScaleFactor(wmiMathStyleAttributeSet, 0.8f, wmiMathDocumentView));
                    break;
                }
                n = Math.round((float)n * 0.8f);
                break;
            }
            wmiModel = wmiCompositeModel;
            wmiCompositeModel = wmiModel.getParent();
        }
        return n;
    }

    public static void setDefaultHeight(WmiPositionedView wmiPositionedView) throws WmiNoReadAccessException {
        WmiAttributeSet wmiAttributeSet;
        WmiModel wmiModel = wmiPositionedView.getModel();
        WmiAttributeSet wmiAttributeSet2 = wmiAttributeSet = wmiModel != null ? wmiModel.getAttributesForRead() : null;
        if (wmiAttributeSet instanceof WmiFontAttributeSet) {
            int n = WmiMathTextView.getCorrectedZoomFactor(wmiPositionedView);
            Font font = WmiFontResolver.getFont((WmiFontAttributeSet)wmiAttributeSet, n, false);
            WmiFontMetrics wmiFontMetrics = WmiFontResolver.getFontMetrics(font);
            wmiPositionedView.setBaseline(wmiFontMetrics.getFontProperty(3));
            wmiPositionedView.setHeight(wmiFontMetrics.getFontProperty(5));
        }
    }

    public int doImplicitLinebreak(WmiParagraphView wmiParagraphView, int n, int n2, int n3) throws WmiNoReadAccessException {
        int n4 = n3 > 0 ? super.doImplicitLinebreak(wmiParagraphView, n, n2, n3) : 0;
        return n4;
    }

    public int doForcedLinebreak(WmiParagraphView wmiParagraphView, int n, int n2) throws WmiNoReadAccessException {
        boolean bl = false;
        WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
        WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
        WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "\\", this.getContext());
        WmiMathOperatorView wmiMathOperatorView = new WmiMathOperatorView(wmiMathTokenModel, wmiMathDocumentView);
        wmiMathOperatorView.layoutView();
        int n3 = n2 - n - wmiMathOperatorView.getWidth();
        Point point = new Point(n3, 0);
        int n4 = this.getOffset(point);
        if (n4 > 0) {
            int n5;
            bl = true;
            WmiTextView[] wmiTextViewArray = WmiMathTextFragmentView.splitMathTextView(this, n4, 0);
            WmiCompositeView wmiCompositeView = this.getParentView();
            int n6 = n5 = wmiCompositeView != null ? wmiCompositeView.indexOf(this) : -1;
            if (n5 >= 0) {
                wmiCompositeView.replaceChild(wmiTextViewArray[0], n5);
                wmiTextViewArray[0].setParentView(wmiCompositeView);
                wmiCompositeView.insertView(wmiMathOperatorView, n5 + 1);
                wmiCompositeView.insertView(wmiTextViewArray[1], n5 + 2);
                wmiCompositeView.markInvalid(1);
                ((WmiPositionedView)((Object)wmiCompositeView)).layoutView();
                wmiParagraphView.split(wmiCompositeView, n5 + 2, 0);
                bl = true;
                this.release();
            }
        }
        return bl ? 2 : 0;
    }

    private WmiMathContext getContext() throws WmiNoReadAccessException {
        WmiAttributeSet wmiAttributeSet;
        WmiMathContext wmiMathContext = null;
        WmiView wmiView = WmiViewUtil.findAncestorOfTag(this, WmiModelTag.MATH);
        if (wmiView != null && wmiView.getModel() instanceof WmiMathWrapperModel && (wmiAttributeSet = wmiView.getModel().getAttributesForRead()) instanceof WmiFontAttributeSet) {
            wmiMathContext = new WmiMathContext((WmiFontAttributeSet)wmiAttributeSet);
        }
        if (wmiMathContext == null) {
            wmiMathContext = new WmiMathContext(null);
        }
        return wmiMathContext;
    }
}

