/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.font.WmiTextLayout;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiDimensionUnit;
import com.maplesoft.mathdoc.model.math.WmiMathAlignGroupModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import com.maplesoft.mathdoc.view.WmiCellView;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiLinebrokenView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiRowView;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiFencedView;
import com.maplesoft.mathdoc.view.math.WmiMathAlignGroupView;
import com.maplesoft.mathdoc.view.math.WmiMathAlignMarkView;
import com.maplesoft.mathdoc.view.math.WmiMathInlineView;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.WmiMathSpaceView;
import com.maplesoft.mathdoc.view.math.WmiMathTableCellView;
import com.maplesoft.mathdoc.view.math.WmiMathTableLabeledRowView;
import com.maplesoft.mathdoc.view.math.WmiMathTableRowView;
import com.maplesoft.mathdoc.view.math.WmiMathTextView;
import com.maplesoft.mathdoc.view.math.WmiMathViewUtil;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class WmiMathTableView
extends WmiLinebrokenView {
    public static final int FRAME_SPACING_HORIZONTAL = 0;
    public static final int FRAME_SPACING_VERTICAL = 1;
    public static final Integer LINE_STYLE_NONE = new Integer(0);
    public static final Integer LINE_STYLE_SOLID = new Integer(1);
    public static final Integer LINE_STYLE_DASHED = new Integer(2);
    public static final Integer ALIGN_STYLE_UNSET = new Integer(-1);
    public static final Integer ALIGN_STYLE_AXIS = new Integer(0);
    public static final Integer ALIGN_STYLE_TOP = new Integer(1);
    public static final Integer ALIGN_STYLE_BOTTOM = new Integer(2);
    public static final Integer ALIGN_STYLE_CENTER = new Integer(3);
    public static final Integer ALIGN_STYLE_LEFT = new Integer(4);
    public static final Integer ALIGN_STYLE_RIGHT = new Integer(5);
    public static final Integer ALIGN_STYLE_DECIMALPOINT = new Integer(6);
    public static final Integer RIGHT_SIDE = new Integer(0);
    public static final Integer LEFT_SIDE = new Integer(1);
    public static final Integer RIGHT_OVERLAP_SIDE = new Integer(2);
    public static final Integer LEFT_OVERLAP_SIDE = new Integer(3);
    private WmiFontAttributeSet fontAttributes;
    private int[] columnMaxWidth;
    private int[] rowMaxHeight;
    private int[][] cellWidths;
    public int[][] cellHeights;
    private int maxColumnCount;
    private int maxRowWidth = 0;
    private int zoomFactor;
    private boolean dontLineBreakCells = false;
    private Integer frameStyle = LINE_STYLE_NONE;
    private ArrayList rowlineStyles = new ArrayList();
    private ArrayList rowSpacing = new ArrayList();
    private ArrayList rowAlignments = new ArrayList();
    private ArrayList columnlineStyles = new ArrayList();
    private ArrayList columnSpacing = new ArrayList();
    private ArrayList columnAlignments = new ArrayList();
    private ArrayList alignGroupAlignments = new ArrayList();
    private int[] frameSpacing = new int[2];
    private Integer alignStyle = ALIGN_STYLE_AXIS;
    private int alignRow = 0;
    private boolean useEqualRows = false;
    private boolean useEqualColumns = false;
    private String tableWidth = "";
    private ArrayList columnWidth = new ArrayList();
    private boolean containsLabeledRow = false;
    private Integer side = RIGHT_SIDE;
    private int minLabelSpacing = 0;
    public boolean cellLinebroken = false;
    private int[] maxAlignGroupCount = null;
    public ArrayList[][] alignGroupWidths;
    public ArrayList[] maxAlignGroupWidths;
    static /* synthetic */ Class class$com$maplesoft$mathdoc$view$WmiTextView;

    public WmiMathTableView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        super(wmiModel, wmiMathDocumentView, wmiMathDocumentView.getBreakWidth());
        WmiMathDocumentView wmiMathDocumentView2 = this.getDocumentView();
        this.zoomFactor = wmiMathDocumentView2 != null ? wmiMathDocumentView2.getZoomFactor() : 100;
        try {
            WmiMathWrapperModel wmiMathWrapperModel = (WmiMathWrapperModel)WmiModelUtil.findAncestorOfTag(wmiModel, WmiModelTag.MATH);
            this.fontAttributes = wmiMathWrapperModel != null ? (WmiFontAttributeSet)wmiMathWrapperModel.getAttributesForRead() : new WmiFontAttributeSet();
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
    }

    public boolean isMatrix() throws WmiNoReadAccessException {
        Object object;
        Object object2;
        boolean bl = false;
        WmiFencedView wmiFencedView = (WmiFencedView)(WmiViewUtil.findAncestorOfTag(this, WmiModelTag.MATH_FENCED) != null ? WmiViewUtil.findAncestorOfTag(this, WmiModelTag.MATH_FENCED) : null);
        if (wmiFencedView != null) {
            object2 = (WmiMathFencedModel)wmiFencedView.getModel();
            object = (WmiMathTokenModel)((WmiMathFencedModel)object2).getModelForLeft();
            WmiMathTokenModel wmiMathTokenModel = (WmiMathTokenModel)((WmiMathFencedModel)object2).getModelForRight();
            if (object.getTokenContents().equals("[") && wmiMathTokenModel.getTokenContents().equals("]")) {
                bl = true;
            }
        }
        if (!bl && (object2 = this.getParentView()) instanceof WmiMathInlineView) {
            object = object2.getParentView();
            Object object3 = object2 = object instanceof WmiMathInlineView ? object : object2;
            if (object2 instanceof WmiMathInlineView && object2.getChildCount() == 3 && object2.getChild(0) instanceof WmiMathOperatorView && ((WmiMathOperatorView)object2.getChild(0)).getText().equals("[") && object2.getChild(2) instanceof WmiMathOperatorView && ((WmiMathOperatorView)object2.getChild(2)).getText().equals("]")) {
                bl = true;
            }
        }
        return bl;
    }

    protected void initializeView(WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException {
        super.initializeView(wmiCompositeModel);
        WmiMathTableModel wmiMathTableModel = (WmiMathTableModel)wmiCompositeModel;
        WmiMathTableModel.WmiMathTableAttributeSet wmiMathTableAttributeSet = (WmiMathTableModel.WmiMathTableAttributeSet)wmiMathTableModel.getAttributesForRead();
        if (wmiMathTableModel.containsLabeledRow() && wmiMathTableAttributeSet.getSide().endsWith("overlap")) {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                WmiMathTableRowView wmiMathTableRowView = (WmiMathTableRowView)this.getChild(i);
                if (!(wmiMathTableRowView instanceof WmiMathTableLabeledRowView)) continue;
                WmiMathTableCellView wmiMathTableCellView = wmiMathTableAttributeSet.getSide().equals("leftoverlap") ? (WmiMathTableCellView)wmiMathTableRowView.getChild(0) : (WmiMathTableCellView)wmiMathTableRowView.getChild(wmiMathTableRowView.getChildCount() - 1);
                WmiMathTableCellView wmiMathTableCellView2 = (WmiMathTableCellView)wmiMathTableCellView.copyView();
                WmiMathTableRowView wmiMathTableRowView2 = new WmiMathTableRowView(wmiMathTableCellView.getModel().getParent(), this.getDocumentView());
                wmiMathTableRowView2.setLabelRow(true);
                WmiMathDocumentModel wmiMathDocumentModel = wmiCompositeModel.getDocument();
                WmiTextModel wmiTextModel = new WmiTextModel(wmiMathDocumentModel);
                WmiMathTableModel.WmiMathTableDataModel wmiMathTableDataModel = new WmiMathTableModel.WmiMathTableDataModel(wmiMathDocumentModel, wmiTextModel);
                WmiMathTableCellView wmiMathTableCellView3 = new WmiMathTableCellView(wmiMathTableDataModel, this.getDocumentView());
                wmiMathTableCellView3.updateView();
                wmiMathTableCellView3.setParentView(wmiMathTableRowView2);
                if (wmiMathTableAttributeSet.getSide().equals("leftoverlap")) {
                    wmiMathTableRowView2.appendView(wmiMathTableCellView3);
                    wmiMathTableRowView2.appendView(wmiMathTableCellView2);
                } else {
                    for (int j = 0; j < wmiMathTableRowView.getChildCount() - 2; ++j) {
                        wmiMathTableRowView2.appendView(wmiMathTableCellView3);
                    }
                    wmiMathTableRowView2.appendView(wmiMathTableCellView2);
                }
                WmiMathTableModel.WmiMathTableLabeledRowModel wmiMathTableLabeledRowModel = (WmiMathTableModel.WmiMathTableLabeledRowModel)wmiMathTableRowView.getModel();
                WmiMathTableModel.WmiMathTableRowModel.WmiMathTableRowAttributeSet wmiMathTableRowAttributeSet = (WmiMathTableModel.WmiMathTableRowModel.WmiMathTableRowAttributeSet)wmiMathTableLabeledRowModel.getAttributesForRead();
                if (wmiMathTableRowAttributeSet.getRowAlign() != null && wmiMathTableRowAttributeSet.getRowAlign().equals("top")) {
                    this.insertView(wmiMathTableRowView2, i);
                } else {
                    this.insertView(wmiMathTableRowView2, i + 1);
                }
                ++n;
                ++i;
            }
        }
    }

    public WmiInlineView createRow(WmiModel wmiModel, int n) {
        return new WmiMathTableRowView(wmiModel, this.getDocumentView());
    }

    public void dontLineBreakCells() {
        this.dontLineBreakCells = true;
    }

    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            this.initializeRowAndColumnBookkeeping();
            WmiMathTableModel wmiMathTableModel = (WmiMathTableModel)this.getModel();
            WmiMathTableModel.WmiMathTableAttributeSet wmiMathTableAttributeSet = (WmiMathTableModel.WmiMathTableAttributeSet)wmiMathTableModel.getAttributesForRead();
            this.getFrameStyle(wmiMathTableAttributeSet);
            this.getRowLineStyle(wmiMathTableAttributeSet);
            this.getRowSpacing(wmiMathTableAttributeSet);
            this.getRowAlignment(wmiMathTableAttributeSet);
            this.getColumnLineStyle(wmiMathTableAttributeSet);
            this.getColumnSpacing(wmiMathTableAttributeSet);
            this.getSide(wmiMathTableAttributeSet);
            this.getColumnAlignment(wmiMathTableAttributeSet);
            this.getFrameSpacing(wmiMathTableAttributeSet);
            this.getAlign(wmiMathTableAttributeSet);
            this.getEqualRows(wmiMathTableAttributeSet);
            this.getEqualColumns(wmiMathTableAttributeSet);
            this.getWidth(wmiMathTableAttributeSet);
            this.getColumnWidth(wmiMathTableAttributeSet);
            this.getMinLabelSpacing(wmiMathTableAttributeSet);
            this.getAlignGroupAlignments(wmiMathTableAttributeSet);
            int n = 0;
            int n2 = this.frameSpacing[1];
            if (!wmiMathTableModel.containsAlignmentElement()) {
                this.calculateMaxColumnWidths();
                this.cellLinebroken = false;
                this.linebreakCells();
                if (this.containsLabeledRow && this.side == LEFT_OVERLAP_SIDE || this.side == RIGHT_OVERLAP_SIDE) {
                    if (this.cellLinebroken) {
                        if (this.side == LEFT_OVERLAP_SIDE) {
                            this.columnWidth.set(0, new Integer(0));
                        } else {
                            this.columnWidth.set(this.columnWidth.size() - 1, new Integer(0));
                        }
                    }
                    this.calculateMaxColumnWidths();
                    this.linebreakCells();
                }
                this.calculateMaxRowHeights();
                this.maxRowWidth = 0;
                for (int i = 0; i < this.getChildCount(); ++i) {
                    WmiMathTableRowView wmiMathTableRowView = (WmiMathTableRowView)this.getChild(i);
                    if (!this.cellLinebroken && wmiMathTableRowView.isLabelRow()) continue;
                    wmiMathTableRowView.layoutView();
                    wmiMathTableRowView.setHorizontalOffset(this.frameSpacing[0]);
                    if (i != 0) {
                        n2 += this.getRowSpacing(i - 1);
                    }
                    wmiMathTableRowView.setVerticalOffset(n2);
                    n2 += wmiMathTableRowView.getHeight();
                    this.maxRowWidth = this.maxRowWidth > wmiMathTableRowView.getWidth() ? this.maxRowWidth : wmiMathTableRowView.getWidth();
                    n = n > wmiMathTableRowView.getHeight() ? n : wmiMathTableRowView.getHeight();
                }
                this.height = n2 + this.frameSpacing[1];
                this.width = this.maxRowWidth + this.frameSpacing[0] * 2;
            } else {
                this.calculateMaxColumnWidths();
                this.calculateAlignGroupWidths();
                this.calculateAlignGroupMaxWidths();
                this.calculateAlignedColumnWidths();
                this.calculateMaxRowHeights();
                this.maxRowWidth = 0;
                for (int i = 0; i < this.getChildCount(); ++i) {
                    WmiMathTableRowView wmiMathTableRowView = (WmiMathTableRowView)this.getChild(i);
                    if (!this.cellLinebroken && wmiMathTableRowView.isLabelRow()) continue;
                    wmiMathTableRowView.layoutView();
                    wmiMathTableRowView.setHorizontalOffset(this.frameSpacing[0]);
                    if (i != 0) {
                        n2 += this.getRowSpacing(i - 1);
                    }
                    wmiMathTableRowView.setVerticalOffset(n2);
                    n2 += wmiMathTableRowView.getHeight();
                    this.maxRowWidth = this.maxRowWidth > wmiMathTableRowView.getWidth() ? this.maxRowWidth : wmiMathTableRowView.getWidth();
                    n = n > wmiMathTableRowView.getHeight() ? n : wmiMathTableRowView.getHeight();
                }
                this.height = n2 + this.frameSpacing[1];
                this.width = this.maxRowWidth + this.frameSpacing[0] * 2;
            }
            this.adjustAlignment();
            if (this.useEqualRows) {
                this.adjustRowHeights(n);
            }
            this.addNavigationLinks();
            this.markValid(1);
            this.checkRepaint();
        }
    }

    public void draw(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle) {
        int n;
        int n2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.frameStyle != LINE_STYLE_NONE) {
            Stroke stroke = graphics2D.getStroke();
            if (this.frameStyle == LINE_STYLE_DASHED) {
                float[] fArray = new float[]{1.5f};
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, fArray, 1.0f));
            }
            n2 = wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset();
            int n3 = wmiRenderPath.getVerticalOffset() + this.getVerticalOffset();
            int n4 = this.width;
            n = this.height;
            if (this.containsLabeledRow) {
                if (this.side == LEFT_SIDE || this.side == LEFT_OVERLAP_SIDE) {
                    n2 += this.columnMaxWidth[0] + this.frameSpacing[0] + this.getColumnSpacing(0) / 2;
                    n4 -= this.columnMaxWidth[0];
                } else {
                    int n5 = this.getMaxNumberOfColumns() - 1;
                    n4 -= this.columnMaxWidth[n5] + this.frameSpacing[1] + this.getColumnSpacing(n5 - 1) / 2;
                }
            }
            graphics2D.drawRect(n2, n3, n4, n - 1);
            graphics2D.setStroke(stroke);
        }
        int n6 = this.getChildCount() - 1;
        if (this.containsLabeledRow && !this.drawOverlappedLabel()) {
            --n6;
        }
        for (n2 = 0; n2 < n6; ++n2) {
            Integer n7;
            if (n2 >= this.rowlineStyles.size()) {
                // empty if block
            }
            Integer n8 = n7 = this.rowlineStyles != null && n2 < this.rowlineStyles.size() ? (Integer)this.rowlineStyles.get(n2) : LINE_STYLE_NONE;
            if (n7 == LINE_STYLE_NONE) continue;
            WmiMathTableRowView wmiMathTableRowView = (WmiMathTableRowView)this.getChild(n2);
            if (!this.drawOverlappedLabel() && wmiMathTableRowView.isLabelRow()) continue;
            n = wmiRenderPath.getVerticalOffset() + this.getVerticalOffset() + wmiMathTableRowView.getVerticalOffset() + wmiMathTableRowView.getHeight() + this.getRowSpacing(n2) / 2;
            Stroke stroke = graphics2D.getStroke();
            if (n7 == LINE_STYLE_DASHED) {
                float[] fArray = new float[]{1.5f};
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, fArray, 1.0f));
            }
            int n9 = wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset() + this.getFrameSpacing(0);
            int n10 = 0;
            int n11 = n2 + 1;
            int n12 = this.getMaxNumberOfColumns();
            for (int i = 0; i < n12; ++i) {
                boolean bl = false;
                boolean bl2 = false;
                int n13 = 0;
                int n14 = 0;
                if (i == 0) {
                    if (this.containsLabeledRow && (this.side == LEFT_SIDE || this.side == LEFT_OVERLAP_SIDE)) {
                        bl = true;
                    }
                    n13 = this.getFrameSpacing(0);
                    n14 = this.getColumnSpacing(i) / 2;
                    if (i == n12 - 1) {
                        n13 += this.getFrameSpacing(0);
                    }
                } else if (i == n12 - 1) {
                    n13 = this.getFrameSpacing(0) * -1;
                    n14 = this.getColumnSpacing(i - 1) / 2;
                    if (this.containsLabeledRow) {
                        if (this.side == RIGHT_SIDE || this.side == RIGHT_OVERLAP_SIDE) {
                            bl2 = true;
                        } else {
                            n13 += this.getFrameSpacing(0);
                            n14 += this.getColumnSpacing(i - 1) / 2;
                        }
                    }
                } else {
                    n13 = 0;
                    n14 = this.getColumnSpacing(i - 1) / 2 + this.getColumnSpacing(i) / 2;
                }
                n10 = this.columnMaxWidth[i] + n14 + n13;
                if ((this.cellHeights[n11][i] != -1 || this.cellHeights[n11][i] == -1 && this.cellWidths[n11][i] == -1) && !bl && !bl2) {
                    graphics2D.drawLine(n9, n, n9 + n10, n);
                }
                n9 += n10;
            }
            graphics2D.setStroke(stroke);
        }
        super.draw(graphics, wmiRenderPath, rectangle);
    }

    public void invalidate(int n) {
        super.invalidate(n);
        int n2 = this.getChildCount();
        for (int i = 0; i < n2; ++i) {
            this.getChild(i).invalidate(n);
        }
    }

    private void getFrameStyle(WmiMathTableModel.WmiMathTableAttributeSet wmiMathTableAttributeSet) {
        String string;
        String string2 = string = wmiMathTableAttributeSet.getFrame() != null ? wmiMathTableAttributeSet.getFrame() : "";
        if (string.equals("solid")) {
            this.frameStyle = LINE_STYLE_SOLID;
        } else if (string.equals("dashed")) {
            this.frameStyle = LINE_STYLE_DASHED;
        }
    }

    private void getAlign(WmiMathTableModel.WmiMathTableAttributeSet wmiMathTableAttributeSet) {
        String string = wmiMathTableAttributeSet.getAlign() != null ? wmiMathTableAttributeSet.getAlign() : "";
        String[] stringArray = string.split(" ");
        this.alignStyle = stringArray[0].equals("top") ? ALIGN_STYLE_TOP : (stringArray[0].equals("bottom") ? ALIGN_STYLE_BOTTOM : (stringArray[0].equals("center") || stringArray[0].equals("baseline") ? ALIGN_STYLE_CENTER : ALIGN_STYLE_AXIS));
        if (stringArray.length > 1) {
            try {
                this.alignRow = Integer.parseInt(stringArray[1]);
                if (this.alignRow < 0) {
                    this.alignRow = this.getChildCount() + this.alignRow + 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void getRowLineStyle(WmiMathTableModel.WmiMathTableAttributeSet wmiMathTableAttributeSet) {
        String string = wmiMathTableAttributeSet.getRowLines() != null ? wmiMathTableAttributeSet.getRowLines() : "";
        String[] stringArray = string.split(" ");
        Integer n = LINE_STYLE_NONE;
        for (int i = 0; i < this.getChildCount() - 1; ++i) {
            if (i < stringArray.length && !stringArray[i].equals("")) {
                if (stringArray[i].equals("solid")) {
                    this.rowlineStyles.add(i, LINE_STYLE_SOLID);
                } else if (stringArray[i].equals("dashed")) {
                    this.rowlineStyles.add(i, LINE_STYLE_DASHED);
                } else {
                    this.rowlineStyles.add(i, LINE_STYLE_NONE);
                }
                n = (Integer)this.rowlineStyles.get(i);
                continue;
            }
            this.rowlineStyles.add(n);
        }
    }

    public void getRowSpacing(WmiMathTableModel.WmiMathTableAttributeSet wmiMathTableAttributeSet) throws WmiNoReadAccessException {
        String string = wmiMathTableAttributeSet.getRowSpacing() != null ? wmiMathTableAttributeSet.getRowSpacing() : "";
        String[] stringArray = string.split(" ");
        int n = Math.round(WmiMathViewUtil.getPixelValueForDimension(WmiDimensionUnit.createDimension("1.0ex", null), this.fontAttributes, this.getDocumentView().isPrintView()) * (this.zoomFactor / 100));
        for (int i = 0; i < this.getChildCount() - 1; ++i) {
            if (i < stringArray.length && !stringArray[i].equals("")) {
                int n2 = Math.round(WmiMathViewUtil.getPixelValueForDimension(WmiDimensionUnit.createDimension(stringArray[i], null), this.fontAttributes, this.getDocumentView().isPrintView()) * (this.zoomFactor / 100));
                this.rowSpacing.add(i, new Integer(n2));
                n = n2;
                continue;
            }
            this.rowSpacing.add(i, new Integer(n));
        }
    }

    public int getRowSpacing(int n) {
        if (n < this.rowSpacing.size()) {
            return (Integer)this.rowSpacing.get(n);
        }
        return 0;
    }

    private void getFrameSpacing(WmiMathTableModel.WmiMathTableAttributeSet wmiMathTableAttributeSet) {
        String string = wmiMathTableAttributeSet.getFrameSpacing() != null ? wmiMathTableAttributeSet.getFrameSpacing() : "";
        String[] stringArray = string.split(" ");
        this.frameSpacing[0] = !stringArray[0].equals("") ? Math.round(WmiMathViewUtil.getPixelValueForDimension(WmiDimensionUnit.createDimension(stringArray[0], null), this.fontAttributes, this.getDocumentView().isPrintView()) * (this.zoomFactor / 100)) : Math.round(WmiMathViewUtil.getPixelValueForDimension(WmiDimensionUnit.createDimension("0.4em", null), this.fontAttributes, this.getDocumentView().isPrintView()) * (this.zoomFactor / 100));
        this.frameSpacing[1] = stringArray.length == 2 && !stringArray[1].equals("") ? Math.round(WmiMathViewUtil.getPixelValueForDimension(WmiDimensionUnit.createDimension(stringArray[1], null), this.fontAttributes, this.getDocumentView().isPrintView()) * (this.zoomFactor / 100)) : Math.round(WmiMathViewUtil.getPixelValueForDimension(WmiDimensionUnit.createDimension("0.5ex", null), this.fontAttributes, this.getDocumentView().isPrintView()) * (this.zoomFactor / 100));
    }

    public int getFrameSpacing(int n) {
        return this.frameSpacing[n];
    }

    private void getEqualRows(WmiMathTableModel.WmiMathTableAttributeSet wmiMathTableAttributeSet) {
        this.useEqualRows = wmiMathTableAttributeSet.getEqualRows();
    }

    private void getEqualColumns(WmiMathTableModel.WmiMathTableAttributeSet wmiMathTableAttributeSet) {
        this.useEqualColumns = wmiMathTableAttributeSet.getEqualColumns();
    }

    private void getRowAlignment(WmiMathTableModel.WmiMathTableAttributeSet wmiMathTableAttributeSet) {
        String string = wmiMathTableAttributeSet.getRowAlign() != null ? wmiMathTableAttributeSet.getRowAlign() : "";
        String[] stringArray = string.split(" ");
        Integer n = ALIGN_STYLE_CENTER;
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (i < stringArray.length && !stringArray[i].equals("")) {
                if (stringArray[i].equals("top")) {
                    this.rowAlignments.add(i, ALIGN_STYLE_TOP);
                } else if (stringArray[i].equals("bottom")) {
                    this.rowAlignments.add(i, ALIGN_STYLE_BOTTOM);
                } else if (stringArray[i].equals("center") || stringArray[i].equals("baseline")) {
                    this.rowAlignments.add(i, ALIGN_STYLE_CENTER);
                } else {
                    this.rowAlignments.add(i, ALIGN_STYLE_AXIS);
                }
                n = (Integer)this.rowAlignments.get(i);
                continue;
            }
            this.rowAlignments.add(n);
        }
    }

    public Integer getRowAlignment(int n) {
        return (Integer)this.rowAlignments.get(n);
    }

    private void getColumnAlignment(WmiMathTableModel.WmiMathTableAttributeSet wmiMathTableAttributeSet) {
        String string = wmiMathTableAttributeSet.getColumnAlign() != null ? wmiMathTableAttributeSet.getColumnAlign() : "";
        String[] stringArray = string.split(" ");
        Integer n = ALIGN_STYLE_CENTER;
        Integer n2 = null;
        int n3 = -1;
        if (this.containsLabeledRow) {
            if (this.side == LEFT_SIDE || this.side == LEFT_OVERLAP_SIDE) {
                n2 = ALIGN_STYLE_LEFT;
                n3 = 0;
            } else {
                n2 = ALIGN_STYLE_RIGHT;
                n3 = this.getMaxNumberOfColumns() - 1;
            }
        }
        for (int i = 0; i < this.getMaxNumberOfColumns(); ++i) {
            if (i == n3) {
                this.columnAlignments.add(n2);
                continue;
            }
            if (i < stringArray.length && !stringArray[i].equals("")) {
                if (stringArray[i].equals("left")) {
                    this.columnAlignments.add(i, ALIGN_STYLE_LEFT);
                } else if (stringArray[i].equals("right")) {
                    this.columnAlignments.add(i, ALIGN_STYLE_RIGHT);
                } else {
                    this.columnAlignments.add(i, ALIGN_STYLE_CENTER);
                }
                n = (Integer)this.columnAlignments.get(i);
                continue;
            }
            this.columnAlignments.add(n);
        }
    }

    private void getAlignGroupAlignments(WmiMathTableModel.WmiMathTableAttributeSet wmiMathTableAttributeSet) {
        String string = wmiMathTableAttributeSet.getGroupAlign() != null ? wmiMathTableAttributeSet.getGroupAlign() : "";
        String[] stringArray = string.split("[\\{\\}]");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].trim().equals("")) continue;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            String[] stringArray2 = stringArray[i].split(" ");
            for (int j = 0; j < stringArray2.length; ++j) {
                if (stringArray2[j].equals("left")) {
                    arrayList.add(ALIGN_STYLE_LEFT);
                    continue;
                }
                if (stringArray2[j].equals("right")) {
                    arrayList.add(ALIGN_STYLE_RIGHT);
                    continue;
                }
                if (stringArray2[j].equals("center")) {
                    arrayList.add(ALIGN_STYLE_CENTER);
                    continue;
                }
                arrayList.add(ALIGN_STYLE_DECIMALPOINT);
            }
            this.alignGroupAlignments.add(arrayList);
        }
    }

    public ArrayList getAlignGroupAlignments(int n) {
        return n < this.alignGroupAlignments.size() ? this.alignGroupAlignments.get(n) : null;
    }

    public Integer getColumnAlignment(int n) {
        return (Integer)this.columnAlignments.get(n);
    }

    public void getColumnSpacing(WmiMathTableModel.WmiMathTableAttributeSet wmiMathTableAttributeSet) throws WmiNoReadAccessException {
        String string = wmiMathTableAttributeSet.getColumnSpacing() != null ? wmiMathTableAttributeSet.getColumnSpacing() : "";
        String[] stringArray = string.split(" ");
        int n = Math.round(WmiMathViewUtil.getPixelValueForDimension(WmiDimensionUnit.createDimension("0.8em", null), this.fontAttributes, this.getDocumentView().isPrintView()) * (this.zoomFactor / 100));
        for (int i = 0; i < this.getMaxNumberOfColumns() - 1; ++i) {
            if (i < stringArray.length && !stringArray[i].equals("")) {
                int n2 = Math.round(WmiMathViewUtil.getPixelValueForDimension(WmiDimensionUnit.createDimension(stringArray[i], null), this.fontAttributes, this.getDocumentView().isPrintView()) * (this.zoomFactor / 100));
                this.columnSpacing.add(i, new Integer(n2));
                n = n2;
                continue;
            }
            this.columnSpacing.add(i, new Integer(n));
        }
    }

    public int getColumnSpacing(int n) {
        if (n < this.columnSpacing.size()) {
            return (Integer)this.columnSpacing.get(n);
        }
        return 0;
    }

    private void getColumnLineStyle(WmiMathTableModel.WmiMathTableAttributeSet wmiMathTableAttributeSet) {
        String string = wmiMathTableAttributeSet.getColumnLines() != null ? wmiMathTableAttributeSet.getColumnLines() : "";
        String[] stringArray = string.split(" ");
        Integer n = LINE_STYLE_NONE;
        for (int i = 0; i < this.getMaxNumberOfColumns(); ++i) {
            if (i < stringArray.length && !stringArray[i].equals("")) {
                if (stringArray[i].equals("solid")) {
                    this.columnlineStyles.add(i, LINE_STYLE_SOLID);
                } else if (stringArray[i].equals("dashed")) {
                    this.columnlineStyles.add(i, LINE_STYLE_DASHED);
                } else {
                    this.columnlineStyles.add(i, LINE_STYLE_NONE);
                }
                n = (Integer)this.columnlineStyles.get(i);
                continue;
            }
            this.columnlineStyles.add(n);
        }
    }

    public Integer getColumnLineStyle(int n) {
        return n >= 0 && n < this.columnlineStyles.size() ? this.columnlineStyles.get(n) : LINE_STYLE_NONE;
    }

    private void getWidth(WmiMathTableModel.WmiMathTableAttributeSet wmiMathTableAttributeSet) {
        this.tableWidth = wmiMathTableAttributeSet.getWidth() != null ? wmiMathTableAttributeSet.getWidth() : "auto";
    }

    private void getColumnWidth(WmiMathTableModel.WmiMathTableAttributeSet wmiMathTableAttributeSet) {
        String string = wmiMathTableAttributeSet.getColumnWidth() != null ? wmiMathTableAttributeSet.getColumnWidth() : "";
        String[] stringArray = string.split(" ");
        String string2 = "auto";
        for (int i = 0; i < this.getMaxNumberOfColumns(); ++i) {
            if (i < stringArray.length && !stringArray[i].equals("")) {
                Object object;
                if (!(stringArray[i].equals("auto") || stringArray[i].equals("fit") || stringArray[i].endsWith("%"))) {
                    int n = Math.round(WmiMathViewUtil.getPixelValueForDimension(WmiDimensionUnit.createDimension(stringArray[i], null), this.fontAttributes, this.getDocumentView().isPrintView()) * (this.zoomFactor / 100));
                    object = new Integer(n);
                } else {
                    object = stringArray[i];
                }
                this.columnWidth.add(i, object);
                string2 = object;
                continue;
            }
            this.columnWidth.add(i, string2);
        }
    }

    private void getSide(WmiMathTableModel.WmiMathTableAttributeSet wmiMathTableAttributeSet) {
        String string;
        String string2 = string = wmiMathTableAttributeSet.getSide() != null ? wmiMathTableAttributeSet.getSide() : "";
        this.side = string.equals("left") ? LEFT_SIDE : (string.equals("rightoverlap") ? RIGHT_OVERLAP_SIDE : (string.equals("leftoverlap") ? LEFT_OVERLAP_SIDE : RIGHT_SIDE));
    }

    public Integer getSide() {
        return this.side;
    }

    public boolean containsLabeledRow() {
        return this.containsLabeledRow;
    }

    public boolean drawOverlappedLabel() {
        return this.containsLabeledRow && (this.side == LEFT_OVERLAP_SIDE || this.side == RIGHT_OVERLAP_SIDE) && this.cellLinebroken;
    }

    private void getMinLabelSpacing(WmiMathTableModel.WmiMathTableAttributeSet wmiMathTableAttributeSet) {
        String string = wmiMathTableAttributeSet.getMinLabelSpacing() != null ? wmiMathTableAttributeSet.getMinLabelSpacing() : "0.8em";
        this.minLabelSpacing = Math.round(WmiMathViewUtil.getPixelValueForDimension(WmiDimensionUnit.createDimension(string, null), this.fontAttributes, this.getDocumentView().isPrintView()) * (this.zoomFactor / 100));
    }

    private void adjustAlignment() throws WmiNoReadAccessException {
        WmiModel wmiModel = this.getModel();
        WmiAttributeSet wmiAttributeSet = wmiModel != null ? wmiModel.getAttributesForRead() : null;
        Font font = null;
        boolean bl = this.getDocumentView().isPrintView();
        font = wmiAttributeSet instanceof WmiFontAttributeSet ? WmiFontResolver.getFont((WmiFontAttributeSet)wmiAttributeSet, this.getZoomFactor(), bl) : WmiFontResolver.getFont(WmiFontAttributeSet.DEFAULT_FONT_ATTRIBUTES, this.getZoomFactor(), bl);
        WmiFontMetrics wmiFontMetrics = WmiFontResolver.getFontMetrics(font);
        if (this.alignStyle == ALIGN_STYLE_AXIS) {
            this.setBaseline(this.height / 2 + wmiFontMetrics.getFontProperty(3, bl) / 2);
        } else if (this.alignStyle == ALIGN_STYLE_TOP) {
            this.setBaseline(this.getVerticalOffsetOfRow(this.alignRow));
        } else if (this.alignStyle == ALIGN_STYLE_BOTTOM) {
            this.setBaseline(this.getVerticalOffsetOfRow(this.alignRow) + this.getHeightOfRow(this.alignRow));
        } else if (this.alignStyle == ALIGN_STYLE_CENTER) {
            this.setBaseline(this.height / 2);
        }
        this.baseline = this.baseline >= 0 ? this.baseline : 0;
    }

    private void adjustRowHeights(int n) {
        WmiMathTableRowView wmiMathTableRowView;
        int n2;
        int n3 = this.frameSpacing[1];
        for (n2 = 0; n2 < this.getChildCount(); ++n2) {
            wmiMathTableRowView = (WmiMathTableRowView)this.getChild(n2);
            if (n2 != 0) {
                n3 += this.getRowSpacing(n2 - 1);
            }
            wmiMathTableRowView.setVerticalOffset(n3);
            wmiMathTableRowView.setHeight(n);
            wmiMathTableRowView.setMaxHeight(n);
            n3 += wmiMathTableRowView.getHeight();
        }
        this.setHeight(n3 + this.frameSpacing[1]);
        for (n2 = 0; n2 < this.getChildCount(); ++n2) {
            wmiMathTableRowView = (WmiMathTableRowView)this.getChild(n2);
            for (int i = 0; i < wmiMathTableRowView.getChildCount(); ++i) {
                WmiMathTableCellView wmiMathTableCellView = (WmiMathTableCellView)wmiMathTableRowView.getChild(i);
                wmiMathTableCellView.adjustVerticalAlignment(this, wmiMathTableRowView);
            }
        }
    }

    private int getVerticalOffsetOfRow(int n) {
        if (n > 0) {
            return ((WmiMathTableRowView)this.getChild(n - 1)).getVerticalOffset();
        }
        return 0;
    }

    private int getHeightOfRow(int n) {
        if (n > 0) {
            return ((WmiMathTableRowView)this.getChild(n - 1)).getHeight();
        }
        return 0;
    }

    public int getMaxNumberOfColumns() {
        return this.maxColumnCount;
    }

    public int getNumberOfRows() {
        return this.getChildCount();
    }

    public void addNavigationLinks() {
        WmiMathTableRowView wmiMathTableRowView;
        int n = this.getChildCount();
        if (n > 0) {
            WmiMathTableRowView wmiMathTableRowView2 = (WmiMathTableRowView)this.getChild(0);
            wmiMathTableRowView2.setNextView(null, 0);
            wmiMathTableRowView2.setNextView(null, 2);
            wmiMathTableRowView = (WmiMathTableRowView)this.getChild(n - 1);
            wmiMathTableRowView.setNextView(null, 1);
            wmiMathTableRowView.setNextView(null, 3);
        }
        for (int i = 0; i < n - 1; ++i) {
            wmiMathTableRowView = (WmiMathTableRowView)this.getChild(i);
            WmiMathTableRowView wmiMathTableRowView3 = (WmiMathTableRowView)this.getChild(i + 1);
            wmiMathTableRowView.setNextView(wmiMathTableRowView3, 1);
            wmiMathTableRowView.setNextView(wmiMathTableRowView3, 3);
            wmiMathTableRowView3.setNextView(wmiMathTableRowView, 0);
            wmiMathTableRowView3.setNextView(wmiMathTableRowView, 2);
        }
    }

    public int getCellWidth(int n, int n2) {
        return this.cellWidths[n][n2];
    }

    public int getCellHeight(int n, int n2) {
        return this.cellHeights[n][n2];
    }

    public void calculateMaxColumnWidths() throws WmiNoReadAccessException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = n6 = this.dontLineBreakCells ? Integer.MAX_VALUE : this.calculateTableWidth();
        if (!this.tableWidth.equals("auto")) {
            this.maxRowWidth = n6 - this.frameSpacing[0] * 2;
        }
        int[] nArray = new int[this.maxColumnCount];
        Arrays.fill(nArray, 0);
        for (n5 = 0; n5 < this.getChildCount(); ++n5) {
            WmiMathTableRowView wmiMathTableRowView = (WmiMathTableRowView)this.getChild(n5);
            n4 = wmiMathTableRowView.getChildCount();
            int n8 = 0;
            int n9 = 0;
            n3 = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                while (nArray[n3] > 0) {
                    this.cellWidths[n5][n3] = n9;
                    ++n3;
                }
                WmiMathTableCellView wmiMathTableCellView = (WmiMathTableCellView)wmiMathTableRowView.getChild(n2);
                wmiMathTableCellView.invalidate(1);
                wmiMathTableCellView.setCellIndex(n5, n3);
                wmiMathTableCellView.layoutView(false);
                n9 = wmiMathTableCellView.getWidth();
                int n10 = wmiMathTableCellView.getHeight();
                int n11 = wmiMathTableCellView.getColumnSpan();
                n8 += n11 > 1 ? n11 - 1 : 0;
                int n12 = wmiMathTableCellView.getRowSpan();
                if (n12 > 1) {
                    nArray[n3] = n12;
                }
                if (this.containsLabeledRow && (n3 == 0 && (this.side == LEFT_SIDE || this.side == LEFT_OVERLAP_SIDE) || n3 == this.getMaxNumberOfColumns() - 1 && (this.side == RIGHT_SIDE || this.side == RIGHT_OVERLAP_SIDE))) {
                    n9 += this.minLabelSpacing;
                }
                if (n11 == 1) {
                    if (n9 > this.columnMaxWidth[n3]) {
                        this.columnMaxWidth[n3] = n9;
                    }
                    this.cellWidths[n5][n3] = n9;
                    this.cellHeights[n5][n3] = n10;
                } else {
                    for (int i = n3; i < n3 + n11; ++i) {
                        this.cellHeights[n5][i] = n10;
                    }
                }
                n3 += n11;
            }
            for (n = 0; n < this.maxColumnCount; ++n) {
                if (nArray[n] <= 0) continue;
                int n13 = n;
                nArray[n13] = nArray[n13] - 1;
            }
        }
        n5 = this.frameSpacing[0] * 2;
        int n14 = 0;
        for (n4 = 0; n4 < this.columnMaxWidth.length; ++n4) {
            n5 += this.columnMaxWidth[n4];
        }
        for (n4 = 0; n4 < this.columnSpacing.size(); ++n4) {
            n5 += this.getColumnSpacing(n4);
            n14 += this.getColumnSpacing(n4);
        }
        if (n6 == 0) {
            n6 = n5;
        }
        n4 = 0;
        n2 = 0;
        for (n3 = 0; n3 < this.columnWidth.size(); ++n3) {
            int n15;
            Object e = this.columnWidth.get(n3);
            if (e instanceof String) {
                String string = e.toString();
                if (string.endsWith("%")) {
                    n = Integer.parseInt(string.substring(0, string.indexOf("%")));
                    this.columnMaxWidth[n3] = Math.round((float)n6 * (float)((double)n * 0.01));
                    n2 += this.columnMaxWidth[n3];
                    continue;
                }
                if (!string.equals("fit") && (n5 <= n6 || !string.equals("auto"))) continue;
                ++n4;
                continue;
            }
            this.columnMaxWidth[n3] = n15 = ((Integer)e).intValue();
            n2 += this.columnMaxWidth[n3];
        }
        if (!(this.isMatrix() || n4 <= 0 && n5 <= n6)) {
            int n16;
            n3 = n6 - this.frameSpacing[0] * 2 - n14 - n2;
            int n17 = n3 / n4;
            for (n16 = 0; n16 < this.columnMaxWidth.length; ++n16) {
                if (n4 <= 1 || this.columnMaxWidth[n16] >= n17) continue;
                n17 = (n3 -= this.columnMaxWidth[n16]) / (n4 - 1);
            }
            for (n16 = 0; n16 < this.columnWidth.size(); ++n16) {
                String string;
                Object e = this.columnWidth.get(n16);
                if (!(e instanceof String) || !(string = e.toString()).equals("fit") && (n5 <= n6 || !string.equals("auto")) || this.getMaximumColumnWidth(n16) <= n17) continue;
                this.columnMaxWidth[n16] = n17;
            }
        }
        if (n6 > n5 && !this.tableWidth.equals("auto")) {
            for (n3 = 0; n3 < this.columnWidth.size(); ++n3) {
                this.columnMaxWidth[n3] = Math.round(n6 / this.columnWidth.size());
            }
        }
        if (this.useEqualColumns) {
            n3 = this.getMaxColumnWidth();
            for (int i = 0; i < this.getChildCount(); ++i) {
                for (int j = 0; j < this.maxColumnCount; ++j) {
                    this.columnMaxWidth[j] = n3;
                }
            }
        }
    }

    public void calculateAlignGroupWidths() throws WmiNoReadAccessException {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            WmiMathTableRowView wmiMathTableRowView = (WmiMathTableRowView)this.getChild(i);
            WmiMathTableModel.WmiMathTableRowModel.WmiMathTableRowAttributeSet wmiMathTableRowAttributeSet = (WmiMathTableModel.WmiMathTableRowModel.WmiMathTableRowAttributeSet)wmiMathTableRowView.getModel().getAttributesForRead();
            wmiMathTableRowView.getAlignGroupAlignments(wmiMathTableRowAttributeSet);
            int n2 = wmiMathTableRowView.getChildCount();
            if (this.maxAlignGroupCount == null) {
                this.maxAlignGroupCount = new int[n2];
            }
            if (this.alignGroupWidths == null) {
                this.alignGroupWidths = new ArrayList[n][n2];
            }
            for (int j = 0; j < n2; ++j) {
                this.alignGroupWidths[i][j] = new ArrayList();
                WmiMathTableCellView wmiMathTableCellView = (WmiMathTableCellView)wmiMathTableRowView.getChild(j);
                WmiMathAlignGroupView wmiMathAlignGroupView = (WmiMathAlignGroupView)WmiViewUtil.findFirstDescendantOfTag(wmiMathTableCellView, WmiModelTag.MATH_ALIGN_GROUP);
                WmiMathAlignGroupView wmiMathAlignGroupView2 = null;
                if (wmiMathAlignGroupView != null) {
                    wmiMathAlignGroupView2 = (WmiMathAlignGroupView)WmiViewUtil.findNextDescendantOfTag(wmiMathTableCellView, wmiMathAlignGroupView, WmiModelTag.MATH_ALIGN_GROUP);
                }
                int n3 = 0;
                while (wmiMathAlignGroupView != null) {
                    Cloneable cloneable;
                    Cloneable cloneable2;
                    WmiMathAlignMarkView wmiMathAlignMarkView = (WmiMathAlignMarkView)WmiViewUtil.findNextDescendantOfTag(wmiMathTableCellView, wmiMathAlignGroupView, WmiModelTag.MATH_ALIGN_MARK);
                    WmiMathAlignMarkView wmiMathAlignMarkView2 = wmiMathAlignMarkView = wmiMathAlignGroupView2 != null && WmiViewUtil.getRelativeOffset(wmiMathAlignMarkView, wmiMathTableCellView).getX() >= WmiViewUtil.getRelativeOffset(wmiMathAlignGroupView2, wmiMathTableCellView).getX() ? null : wmiMathAlignMarkView;
                    if (wmiMathAlignMarkView != null) {
                        Point point = WmiViewUtil.getRelativeOffset(wmiMathAlignMarkView, wmiMathTableCellView);
                        cloneable2 = WmiViewUtil.getRelativeOffset(wmiMathAlignGroupView, wmiMathTableCellView);
                        this.alignGroupWidths[i][j].add(n3 * 2, new Integer(point.x - ((Point)cloneable2).x));
                        if (wmiMathAlignGroupView2 != null) {
                            cloneable = WmiViewUtil.getRelativeOffset(wmiMathAlignGroupView2, wmiMathTableCellView);
                            this.alignGroupWidths[i][j].add(n3 * 2 + 1, new Integer(((Point)cloneable).x - point.x));
                        } else {
                            this.alignGroupWidths[i][j].add(n3 * 2 + 1, new Integer(wmiMathTableCellView.getWidth() - point.x));
                        }
                    } else {
                        Object object;
                        Serializable serializable;
                        Cloneable cloneable3;
                        boolean bl = false;
                        cloneable2 = wmiMathAlignGroupView.getParentView().getParentView();
                        cloneable = (WmiPositionedView)WmiViewUtil.findFirstDescendantOfClass(cloneable2, class$com$maplesoft$mathdoc$view$WmiTextView == null ? WmiMathTableView.class$("com.maplesoft.mathdoc.view.WmiTextView") : class$com$maplesoft$mathdoc$view$WmiTextView);
                        Cloneable cloneable4 = cloneable = WmiViewUtil.getRelativeOffset((WmiPositionedView)cloneable, wmiMathTableCellView).getX() < WmiViewUtil.getRelativeOffset(wmiMathAlignGroupView, wmiMathTableCellView).getX() ? null : cloneable;
                        while (cloneable != null) {
                            if (((WmiAbstractMathTokenModel)cloneable.getModel()).alignmarkIndex >= 0) {
                                int n4;
                                int n5 = ((WmiAbstractMathTokenModel)cloneable.getModel()).alignmarkIndex;
                                cloneable3 = WmiViewUtil.getRelativeOffset((WmiPositionedView)cloneable, wmiMathTableCellView);
                                serializable = WmiViewUtil.getRelativeOffset(wmiMathAlignGroupView, wmiMathTableCellView);
                                object = ((WmiTextView)cloneable).getLayout();
                                int n6 = ((WmiTextLayout)object).getCaretPosition(n5, true);
                                int n7 = ((Point)cloneable3).x - serializable.x + n6;
                                this.alignGroupWidths[i][j].add(n3 * 2, new Integer(n7));
                                if (wmiMathAlignGroupView2 != null) {
                                    Point point = WmiViewUtil.getRelativeOffset(wmiMathAlignGroupView2, wmiMathTableCellView);
                                    n4 = point.x - ((Point)cloneable3).x - n6;
                                } else {
                                    n4 = wmiMathTableCellView.getWidth() - ((Point)cloneable3).x - n6;
                                }
                                this.alignGroupWidths[i][j].add(n3 * 2 + 1, new Integer(n4));
                                wmiMathAlignGroupView.containsEmbeddedAlignMark = true;
                                bl = true;
                                break;
                            }
                            cloneable = (WmiPositionedView)WmiViewUtil.findNextDescendantOfClass(cloneable2, (WmiView)cloneable, class$com$maplesoft$mathdoc$view$WmiTextView == null ? WmiMathTableView.class$("com.maplesoft.mathdoc.view.WmiTextView") : class$com$maplesoft$mathdoc$view$WmiTextView);
                            cloneable = WmiViewUtil.getRelativeOffset((WmiPositionedView)cloneable, wmiMathTableCellView).getX() < WmiViewUtil.getRelativeOffset(wmiMathAlignGroupView, wmiMathTableCellView).getX() ? null : cloneable;
                        }
                        if (!bl) {
                            WmiMathTextView wmiMathTextView;
                            WmiMathAlignGroupModel wmiMathAlignGroupModel = (WmiMathAlignGroupModel)wmiMathAlignGroupView.getModel();
                            cloneable3 = (WmiMathAlignGroupModel.WmiMathAlignGroupAttributeSet)wmiMathAlignGroupModel.getAttributesForRead();
                            serializable = this.getGroupAlign((WmiMathAlignGroupModel.WmiMathAlignGroupAttributeSet)cloneable3, j, n3, wmiMathTableRowView, wmiMathTableCellView);
                            if (serializable == ALIGN_STYLE_LEFT || serializable == ALIGN_STYLE_CENTER || serializable == ALIGN_STYLE_RIGHT) {
                                int n8;
                                Point point = WmiViewUtil.getRelativeOffset(wmiMathAlignGroupView, wmiMathTableCellView);
                                if (wmiMathAlignGroupView2 != null) {
                                    Point point2 = WmiViewUtil.getRelativeOffset(wmiMathAlignGroupView2, wmiMathTableCellView);
                                    n8 = point2.x - point.x;
                                } else {
                                    n8 = wmiMathTableCellView.getWidth() - point.x;
                                }
                                if (serializable == ALIGN_STYLE_LEFT) {
                                    this.alignGroupWidths[i][j].add(n3 * 2, new Integer(0));
                                    this.alignGroupWidths[i][j].add(n3 * 2 + 1, new Integer(n8));
                                } else if (serializable == ALIGN_STYLE_CENTER) {
                                    this.alignGroupWidths[i][j].add(n3 * 2, new Integer(n8 / 2));
                                    this.alignGroupWidths[i][j].add(n3 * 2 + 1, new Integer(n8 / 2));
                                } else if (serializable == ALIGN_STYLE_RIGHT) {
                                    this.alignGroupWidths[i][j].add(n3 * 2, new Integer(n8));
                                    this.alignGroupWidths[i][j].add(n3 * 2 + 1, new Integer(0));
                                }
                            } else if (serializable == ALIGN_STYLE_DECIMALPOINT && (wmiMathTextView = (WmiMathTextView)WmiViewUtil.findNextDescendantOfTag((WmiView)(object = wmiMathAlignGroupView.getParentView().getParentView()), wmiMathAlignGroupView, WmiModelTag.MATH_NUMERIC)) != null) {
                                int n9;
                                Point point = WmiViewUtil.getRelativeOffset(wmiMathTextView, wmiMathTableCellView);
                                Point point3 = WmiViewUtil.getRelativeOffset(wmiMathAlignGroupView, wmiMathTableCellView);
                                int n10 = point.x - point3.x;
                                String string = ((WmiNumericModel)wmiMathTextView.getModel()).getText();
                                WmiTextLayout wmiTextLayout = wmiMathTextView.getLayout();
                                int n11 = string.indexOf(".");
                                int n12 = n11 >= 0 ? wmiTextLayout.getCaretPosition(string.indexOf("."), true) : wmiTextLayout.getWidth();
                                this.alignGroupWidths[i][j].add(n3 * 2, new Integer(n10 + n12));
                                if (wmiMathAlignGroupView2 != null) {
                                    Point point4 = WmiViewUtil.getRelativeOffset(wmiMathAlignGroupView2, wmiMathTableCellView);
                                    n9 = point4.x - point.x - n12;
                                } else {
                                    n9 = wmiMathTableCellView.getWidth() - point.x - n12;
                                }
                                this.alignGroupWidths[i][j].add(n3 * 2 + 1, new Integer(n9));
                            }
                        }
                    }
                    wmiMathAlignGroupView = wmiMathAlignGroupView2;
                    if (wmiMathAlignGroupView2 != null) {
                        wmiMathAlignGroupView2 = (WmiMathAlignGroupView)WmiViewUtil.findNextDescendantOfTag(wmiMathTableCellView, wmiMathAlignGroupView2, WmiModelTag.MATH_ALIGN_GROUP);
                    }
                    ++n3;
                }
                this.maxAlignGroupCount[j] = n3 > this.maxAlignGroupCount[j] ? n3 : this.maxAlignGroupCount[j];
            }
        }
    }

    public void calculateAlignGroupMaxWidths() {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            WmiMathTableRowView wmiMathTableRowView = (WmiMathTableRowView)this.getChild(i);
            int n2 = wmiMathTableRowView.getChildCount();
            if (this.maxAlignGroupWidths == null) {
                this.maxAlignGroupWidths = new ArrayList[n2];
            }
            for (int j = 0; j < n2; ++j) {
                if (this.maxAlignGroupWidths[j] == null) {
                    this.maxAlignGroupWidths[j] = new ArrayList(this.maxAlignGroupCount[j] * 2);
                    for (int k = 0; k < this.maxAlignGroupCount[j] * 2; ++k) {
                        this.maxAlignGroupWidths[j].add(new Integer(0));
                    }
                }
                ArrayList arrayList = this.alignGroupWidths[i][j];
                for (int k = 0; k < arrayList.size(); ++k) {
                    if ((Integer)arrayList.get(k) <= (Integer)this.maxAlignGroupWidths[j].get(k)) continue;
                    this.maxAlignGroupWidths[j].set(k, arrayList.get(k));
                }
            }
        }
    }

    public void calculateAlignedColumnWidths() {
        WmiMathTableRowView wmiMathTableRowView = (WmiMathTableRowView)this.getChild(0);
        int n = wmiMathTableRowView.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.columnMaxWidth[i] = 0;
            for (int j = 0; j < this.maxAlignGroupCount[i] * 2; j += 2) {
                int n2 = i;
                this.columnMaxWidth[n2] = this.columnMaxWidth[n2] + (Integer)this.maxAlignGroupWidths[i].get(j);
                int n3 = i;
                this.columnMaxWidth[n3] = this.columnMaxWidth[n3] + (Integer)this.maxAlignGroupWidths[i].get(j + 1);
            }
        }
    }

    private Integer getGroupAlign(WmiMathAlignGroupModel.WmiMathAlignGroupAttributeSet wmiMathAlignGroupAttributeSet, int n, int n2, WmiMathTableRowView wmiMathTableRowView, WmiMathTableCellView wmiMathTableCellView) {
        Integer n3 = ALIGN_STYLE_LEFT;
        String string = wmiMathAlignGroupAttributeSet.getGroupAlign();
        if (!string.equals("")) {
            n3 = string.equals("left") ? ALIGN_STYLE_LEFT : (string.equals("right") ? ALIGN_STYLE_RIGHT : (string.equals("center") ? ALIGN_STYLE_CENTER : ALIGN_STYLE_DECIMALPOINT));
        } else {
            ArrayList arrayList = wmiMathTableCellView.getAlignmentGroupAlignments();
            if (arrayList != null && n2 < arrayList.size()) {
                n3 = (Integer)arrayList.get(n2);
            } else {
                arrayList = wmiMathTableRowView.getAlignGroupAlignments(n);
                if (arrayList != null) {
                    n3 = (Integer)arrayList.get(n2);
                } else {
                    arrayList = this.getAlignGroupAlignments(n);
                    if (arrayList != null) {
                        n3 = (Integer)arrayList.get(n2);
                    }
                }
            }
        }
        return n3;
    }

    public void linebreakCells() throws WmiNoReadAccessException {
        this.cellLinebroken = false;
        int[] nArray = new int[this.maxColumnCount];
        Arrays.fill(nArray, 0);
        for (int i = 0; i < this.getChildCount(); ++i) {
            WmiMathTableRowView wmiMathTableRowView = (WmiMathTableRowView)this.getChild(i);
            int n = wmiMathTableRowView.getChildCount();
            int n2 = 0;
            for (int j = 0; j < n; ++j) {
                while (nArray[n2] > 0) {
                    ++n2;
                }
                WmiMathTableCellView wmiMathTableCellView = (WmiMathTableCellView)wmiMathTableRowView.getChild(j);
                int n3 = wmiMathTableCellView.getColumnSpan();
                int n4 = wmiMathTableCellView.getRowSpan();
                if (n4 > 1) {
                    nArray[n2] = n4;
                }
                if (n3 > 1) {
                    n2 += n3 - 1;
                }
                if (wmiMathTableCellView.getWidth() > this.columnMaxWidth[n2]) {
                    wmiMathTableCellView.invalidate(1);
                    wmiMathTableCellView.layoutView(!this.isMatrix());
                    this.cellLinebroken = true;
                }
                ++n2;
            }
            for (int j = 0; j < this.maxColumnCount; ++j) {
                if (nArray[j] <= 0) continue;
                int n5 = j;
                nArray[n5] = nArray[n5] - 1;
            }
        }
    }

    private int calculateTableWidth() {
        if (this.tableWidth.equals("auto")) {
            this.breakWidth = this.getBreakWidth();
            return this.breakWidth;
        }
        if (this.tableWidth.endsWith("%")) {
            int n = Integer.parseInt(this.tableWidth.substring(0, this.tableWidth.indexOf("%")));
            return Math.round((float)this.breakWidth * (float)((double)n * 0.01));
        }
        return Math.round(WmiMathViewUtil.getPixelValueForDimension(WmiDimensionUnit.createDimension(this.tableWidth, null), this.fontAttributes, this.getDocumentView().isPrintView()) * (this.zoomFactor / 100));
    }

    public void calculateMaxRowHeights() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.getChildCount(); ++n2) {
            for (n = 0; n < this.maxColumnCount; ++n) {
                this.rowMaxHeight[n2] = this.cellHeights[n2][n] > this.rowMaxHeight[n2] ? this.cellHeights[n2][n] : this.rowMaxHeight[n2];
            }
        }
        if (this.useEqualRows) {
            n2 = this.getMaxRowHeight();
            for (n = 0; n < this.getChildCount(); ++n) {
                this.rowMaxHeight[n] = n2;
            }
        }
    }

    public int getColumnIndex(int n, int n2) {
        int n3 = 0;
        WmiMathTableRowView wmiMathTableRowView = (WmiMathTableRowView)this.getChild(n);
        for (int i = 0; i < n2; ++i) {
            WmiMathTableCellView wmiMathTableCellView = (WmiMathTableCellView)wmiMathTableRowView.getChild(i);
            n3 += wmiMathTableCellView.getColumnSpan();
        }
        while (n3 < this.cellHeights[n].length && this.getCellHeight(n, n3) == 0) {
            ++n3;
        }
        return n3;
    }

    public int getMaxColumnWidth() {
        int n = 0;
        for (int i = 0; i < this.columnMaxWidth.length; ++i) {
            n = this.columnMaxWidth[i] > n ? this.columnMaxWidth[i] : n;
        }
        return n;
    }

    public int getMaxRowHeight() {
        int n = 0;
        for (int i = 0; i < this.rowMaxHeight.length; ++i) {
            n = this.rowMaxHeight[i] > n ? this.rowMaxHeight[i] : n;
        }
        return n;
    }

    public int getMaxRowWidth() {
        return this.maxRowWidth;
    }

    public int getMaximumColumnWidth(int n) {
        if (n < this.columnMaxWidth.length) {
            return this.columnMaxWidth[n];
        }
        return this.columnMaxWidth[this.columnMaxWidth.length - 1];
    }

    public int getMaximumRowHeight(int n) {
        if (n < this.rowMaxHeight.length) {
            return this.rowMaxHeight[n];
        }
        return this.rowMaxHeight[this.rowMaxHeight.length - 1];
    }

    private void initializeRowAndColumnBookkeeping() {
        int n;
        this.checkForLabeledRow();
        this.maxColumnCount = 0;
        for (n = 0; n < this.getChildCount(); ++n) {
            WmiMathTableRowView wmiMathTableRowView = (WmiMathTableRowView)this.getChild(n);
            int n2 = 0;
            for (int i = 0; i < wmiMathTableRowView.getChildCount(); ++i) {
                WmiMathTableCellView wmiMathTableCellView = (WmiMathTableCellView)wmiMathTableRowView.getChild(i);
                n2 += wmiMathTableCellView.getColumnSpan();
            }
            this.maxColumnCount = n2 > this.maxColumnCount ? n2 : this.maxColumnCount;
        }
        this.cellWidths = new int[this.getChildCount()][this.maxColumnCount];
        for (n = 0; n < this.getChildCount(); ++n) {
            Arrays.fill(this.cellWidths[n], 0, this.maxColumnCount, -1);
        }
        this.columnMaxWidth = new int[this.maxColumnCount];
        this.cellHeights = new int[this.getChildCount()][this.maxColumnCount];
        for (n = 0; n < this.getChildCount(); ++n) {
            Arrays.fill(this.cellHeights[n], 0, this.maxColumnCount, -1);
        }
        this.rowMaxHeight = new int[this.getChildCount()];
        this.columnWidth = new ArrayList();
        this.columnSpacing = new ArrayList();
        this.rowSpacing = new ArrayList();
        this.rowlineStyles = new ArrayList();
        this.rowAlignments = new ArrayList();
        this.columnlineStyles = new ArrayList();
        this.columnAlignments = new ArrayList();
    }

    public void checkForLabeledRow() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            WmiView wmiView = this.getChild(i);
            if (!(wmiView instanceof WmiMathTableLabeledRowView)) continue;
            this.containsLabeledRow = true;
        }
    }

    public void resize(int n) throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            this.initializeRowAndColumnBookkeeping();
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            WmiMathTableRowView wmiMathTableRowView = (WmiMathTableRowView)this.getChild(i);
            for (int j = 0; j < wmiMathTableRowView.getChildCount(); ++j) {
                WmiMathTableCellView wmiMathTableCellView = (WmiMathTableCellView)wmiMathTableRowView.getChild(j);
                wmiMathTableCellView.invalidate(1);
            }
        }
        this.width = n;
        this.breakWidth = n;
        this.layoutView();
    }

    public int getBreakWidth() {
        WmiCompositeView wmiCompositeView;
        WmiCellView wmiCellView = null;
        for (wmiCompositeView = this.getParentView(); wmiCompositeView != null; wmiCompositeView = wmiCompositeView.getParentView()) {
            if (!(wmiCompositeView instanceof WmiCellView)) continue;
            wmiCellView = (WmiCellView)((Object)wmiCompositeView);
            break;
        }
        if (wmiCellView != null) {
            this.breakWidth = wmiCellView.getBreakWidth();
            for (wmiCompositeView = this.getParentView(); wmiCompositeView != wmiCellView; wmiCompositeView = wmiCompositeView.getParentView()) {
                if (!(wmiCompositeView instanceof WmiRowView)) continue;
                this.breakWidth -= ((WmiRowView)wmiCompositeView).getLeftIndent();
                this.breakWidth -= ((WmiRowView)wmiCompositeView).getRightIndent();
            }
        } else {
            this.breakWidth = super.getBreakWidth();
        }
        return this.breakWidth;
    }

    public int doImplicitLinebreak(WmiParagraphView wmiParagraphView, int n, int n2, int n3) throws WmiNoReadAccessException {
        int n4 = 0;
        if (n3 >= 1 || this.getWidth() > n2) {
            if (this.isMatrix()) {
                WmiMathContext wmiMathContext = this.getContext();
                WmiInlineView wmiInlineView = this.convertToList(wmiMathContext);
                WmiCompositeView wmiCompositeView = this.getParentView();
                int n5 = wmiCompositeView.indexOf(this);
                wmiCompositeView.replaceChild(wmiInlineView, n5);
                wmiInlineView.setParentView(wmiCompositeView);
                wmiInlineView.applyMathRules(true);
                wmiInlineView.lockOperatorSize(false);
                wmiInlineView.markInvalid(1);
                wmiInlineView.layoutView();
                n4 = 1;
            } else {
                this.resize(n2 - n);
                WmiCompositeView wmiCompositeView = this.getParentView();
                wmiCompositeView.markInvalid(1);
                ((WmiPositionedView)((Object)wmiCompositeView)).layoutView();
                int n6 = wmiCompositeView.indexOf(this);
                if (n6 >= 0) {
                    wmiParagraphView.split(wmiCompositeView, n6 + 1, 0);
                    n4 = 2;
                }
            }
        }
        return n4;
    }

    private WmiInlineView convertToList(WmiMathContext wmiMathContext) throws WmiNoReadAccessException {
        WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
        WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
        WmiInlineView wmiInlineView = new WmiInlineView(this.getModel(), this.getDocumentView());
        wmiInlineView.releaseObserver();
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            WmiView wmiView = this.getChild(i);
            if (n > 1) {
                this.addToken(wmiInlineView, wmiMathContext, wmiMathDocumentModel, wmiMathDocumentView, "[");
            }
            if (wmiView instanceof WmiCompositeView) {
                WmiCompositeView wmiCompositeView = (WmiCompositeView)wmiView;
                int n2 = wmiCompositeView.getChildCount();
                for (int j = 0; j < n2; ++j) {
                    WmiView wmiView2 = wmiCompositeView.getChild(j);
                    if (wmiView2 instanceof WmiMathTableCellView) {
                        this.appendCell(wmiInlineView, (WmiMathTableCellView)wmiView2);
                    } else {
                        wmiInlineView.appendView(wmiView2);
                    }
                    if (j >= n2 - 1) continue;
                    this.addToken(wmiInlineView, wmiMathContext, wmiMathDocumentModel, wmiMathDocumentView, ", ");
                }
            }
            if (n > 1) {
                this.addToken(wmiInlineView, wmiMathContext, wmiMathDocumentModel, wmiMathDocumentView, "]");
            }
            if (i >= n - 1) continue;
            this.addToken(wmiInlineView, wmiMathContext, wmiMathDocumentModel, wmiMathDocumentView, ", ");
            this.addNewline(wmiInlineView, wmiMathDocumentModel, wmiMathDocumentView);
        }
        return wmiInlineView;
    }

    private WmiMathContext getContext() throws WmiNoReadAccessException {
        WmiAttributeSet wmiAttributeSet;
        WmiMathContext wmiMathContext = null;
        WmiView wmiView = WmiViewUtil.findAncestorOfTag(this, WmiModelTag.MATH);
        if (wmiView != null && wmiView.getModel() instanceof WmiMathWrapperModel && (wmiAttributeSet = wmiView.getModel().getAttributesForRead()) instanceof WmiFontAttributeSet) {
            wmiMathContext = new WmiMathContext((WmiFontAttributeSet)wmiAttributeSet);
        }
        if (wmiMathContext == null) {
            wmiMathContext = new WmiMathContext(null);
        }
        return wmiMathContext;
    }

    private void appendCell(WmiInlineView wmiInlineView, WmiMathTableCellView wmiMathTableCellView) {
        int n = wmiMathTableCellView.getChildCount();
        for (int i = 0; i < n; ++i) {
            wmiInlineView.appendView(wmiMathTableCellView.getChild(i));
        }
    }

    private void addToken(WmiInlineView wmiInlineView, WmiMathContext wmiMathContext, WmiMathDocumentModel wmiMathDocumentModel, WmiMathDocumentView wmiMathDocumentView, String string) throws WmiNoReadAccessException {
        WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, string, wmiMathContext);
        WmiMathOperatorView wmiMathOperatorView = new WmiMathOperatorView(wmiMathTokenModel, wmiMathDocumentView);
        wmiMathOperatorView.layoutView();
        wmiInlineView.appendView(wmiMathOperatorView);
    }

    private void addNewline(WmiInlineView wmiInlineView, WmiMathDocumentModel wmiMathDocumentModel, WmiMathDocumentView wmiMathDocumentView) {
        WmiMathSpaceModel wmiMathSpaceModel = new WmiMathSpaceModel(wmiMathDocumentModel);
        try {
            wmiMathSpaceModel.addAttribute("linebreak", "newline");
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        WmiMathSpaceView wmiMathSpaceView = new WmiMathSpaceView(wmiMathSpaceModel, wmiMathDocumentView);
        wmiInlineView.appendView(wmiMathSpaceView);
    }
}

