/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.MathTokenizer;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiMathCaret;
import com.maplesoft.mathdoc.view.math.WmiMathInlineView;
import com.maplesoft.mathdoc.view.math.WmiMathTextView;
import com.maplesoft.mathdoc.view.math.WmiMathViewUtil;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashSet;

public class WmiMathSpaceView
extends WmiGenericView
implements WmiTraversableView {
    private static final HashSet PROC_BREAKS = new HashSet();
    private boolean canNavigate = true;

    public WmiMathSpaceView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        super(wmiModel, wmiMathDocumentView);
    }

    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            super.layoutView();
            WmiMathSpaceModel wmiMathSpaceModel = (WmiMathSpaceModel)this.getModel();
            WmiMathSpaceModel.WmiMathSpaceAttributeSet wmiMathSpaceAttributeSet = (WmiMathSpaceModel.WmiMathSpaceAttributeSet)wmiMathSpaceModel.getAttributes();
            int n = this.getZoomFactor();
            boolean bl = this.getDocumentView().isPrintView();
            this.width = Math.round(WmiMathViewUtil.getPixelValueForDimension(wmiMathSpaceAttributeSet.getWidth(), wmiMathSpaceAttributeSet, bl) * n / 100);
            int n2 = Math.round(WmiMathViewUtil.getPixelValueForDimension(wmiMathSpaceAttributeSet.getHeight(), wmiMathSpaceAttributeSet, bl) * n / 100);
            int n3 = Math.round(WmiMathViewUtil.getPixelValueForDimension(wmiMathSpaceAttributeSet.getDepth(), wmiMathSpaceAttributeSet, bl) * n / 100);
            this.baseline = n2;
            this.height = n2 + n3;
            if (this.height == 0) {
                WmiMathTextView.setDefaultHeight(this);
            }
            if (this.width == 0 && !MathTokenizer.isLinebreakingMSpace(wmiMathSpaceModel)) {
                this.canNavigate = false;
            }
        }
    }

    public boolean isNavagableView() {
        return this.canNavigate;
    }

    public boolean isDeletableSpace() {
        return true;
    }

    public void setPositionMarker(int n) {
        try {
            WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
            if (wmiMathDocumentView != null) {
                WmiScrollableContainerView wmiScrollableContainerView = WmiViewUtil.findEnclosingContainer(this);
                Point point = WmiViewUtil.containerRelativeOffset(this, wmiScrollableContainerView);
                if (n == -1) {
                    n = 1;
                }
                int n2 = n == 0 ? 0 : this.getWidth();
                WmiCaret wmiCaret = wmiMathDocumentView.getCaret();
                boolean bl = false;
                if (!(wmiCaret instanceof WmiMathCaret)) {
                    wmiCaret = new WmiMathCaret(wmiMathDocumentView);
                    bl = true;
                }
                wmiCaret.updateCaretBounds(wmiScrollableContainerView, point.x, point.y, point.x + this.getWidth(), point.y + this.getHeight());
                ((WmiMathCaret)wmiCaret).setUprightPosition(point.x + n2, point.x + n2);
                wmiCaret.updateView(this, n);
                if (bl) {
                    wmiMathDocumentView.setPositionMarker(wmiCaret);
                }
                wmiCaret.show();
            } else {
                WmiErrorLog.log(new Exception("unable to find document view"));
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
    }

    public int getTraversalType() {
        return this.canNavigate ? 2 : 8;
    }

    public int getOffset(Point point) {
        return 0;
    }

    public int getTraversableCount() {
        return 0;
    }

    public boolean isRepeatable() {
        return this.canNavigate;
    }

    public int doExplicitLinebreak(WmiParagraphView wmiParagraphView) throws WmiNoReadAccessException {
        WmiMathSpaceModel.WmiMathSpaceAttributeSet wmiMathSpaceAttributeSet;
        String string;
        WmiAttributeSet wmiAttributeSet;
        int n = 0;
        WmiModel wmiModel = this.getModel();
        WmiAttributeSet wmiAttributeSet2 = wmiAttributeSet = wmiModel != null ? wmiModel.getAttributesForRead() : null;
        if (wmiAttributeSet instanceof WmiMathSpaceModel.WmiMathSpaceAttributeSet && (string = (wmiMathSpaceAttributeSet = (WmiMathSpaceModel.WmiMathSpaceAttributeSet)wmiAttributeSet).getLinebreak()).equals("newline")) {
            WmiCompositeView wmiCompositeView = this.getParentView();
            int n2 = wmiCompositeView.indexOf(this);
            wmiParagraphView.split(wmiCompositeView, n2, 1);
            n = 2;
        }
        return n;
    }

    public int doForcedLinebreak(WmiParagraphView wmiParagraphView, int n, int n2) throws WmiNoReadAccessException {
        WmiCompositeView wmiCompositeView = this.getParentView();
        int n3 = wmiCompositeView.indexOf(this);
        wmiParagraphView.split(wmiCompositeView, n3, 1);
        return 2;
    }

    public int doImplicitLinebreak(WmiParagraphView wmiParagraphView, int n, int n2, int n3) throws WmiNoReadAccessException {
        int n4 = 0;
        if (WmiMathSpaceView.isGoodBreakSpace(this)) {
            n4 = this.doForcedLinebreak(wmiParagraphView, n, n2);
        }
        return n4;
    }

    public boolean hasGoodBreakpoint(int n, int n2, int n3) throws WmiNoReadAccessException {
        return WmiMathSpaceView.isGoodBreakSpace(this);
    }

    public static boolean isGoodBreakSpace(WmiMathSpaceView wmiMathSpaceView) throws WmiNoReadAccessException {
        WmiMathSpaceModel.WmiMathSpaceAttributeSet wmiMathSpaceAttributeSet;
        String string;
        WmiAttributeSet wmiAttributeSet;
        boolean bl = false;
        WmiModel wmiModel = wmiMathSpaceView.getModel();
        WmiAttributeSet wmiAttributeSet2 = wmiAttributeSet = wmiModel != null ? wmiModel.getAttributesForRead() : null;
        if (wmiAttributeSet instanceof WmiMathSpaceModel.WmiMathSpaceAttributeSet && (string = (wmiMathSpaceAttributeSet = (WmiMathSpaceModel.WmiMathSpaceAttributeSet)wmiAttributeSet).getLinebreak()) != null && string.length() > 0 && !string.equals("badbreak") && !string.equals("nobreak")) {
            bl = true;
        }
        return bl;
    }

    public static boolean isCandidateExplicitBreakSpace(WmiMathSpaceView wmiMathSpaceView) throws WmiNoReadAccessException {
        WmiMathSpaceModel.WmiMathSpaceAttributeSet wmiMathSpaceAttributeSet;
        String string;
        WmiAttributeSet wmiAttributeSet;
        boolean bl = false;
        WmiModel wmiModel = wmiMathSpaceView.getModel();
        WmiAttributeSet wmiAttributeSet2 = wmiAttributeSet = wmiModel != null ? wmiModel.getAttributesForRead() : null;
        if (wmiAttributeSet instanceof WmiMathSpaceModel.WmiMathSpaceAttributeSet && PROC_BREAKS.contains(string = (wmiMathSpaceAttributeSet = (WmiMathSpaceModel.WmiMathSpaceAttributeSet)wmiAttributeSet).getLinebreak())) {
            bl = true;
        }
        return bl;
    }

    public static boolean breakAtAllNewlines(WmiParagraphView wmiParagraphView, WmiCompositeView wmiCompositeView, int n) throws WmiNoReadAccessException {
        boolean bl = false;
        ArrayList arrayList = WmiMathSpaceView.breakAtAllNewlines(wmiParagraphView, wmiCompositeView, n, null);
        if (arrayList != null) {
            bl = true;
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                int n3;
                WmiMathSpaceView wmiMathSpaceView = (WmiMathSpaceView)arrayList.get(i);
                wmiCompositeView = wmiMathSpaceView.getParentView();
                int n4 = n3 = wmiCompositeView != null ? wmiCompositeView.indexOf(wmiMathSpaceView) : -1;
                if (n3 < 0) continue;
                WmiView wmiView = wmiParagraphView.split(wmiCompositeView, n3, 1);
                wmiMathSpaceView.adjustIndentation(wmiView);
            }
        }
        return bl;
    }

    public static ArrayList breakAtAllNewlines(WmiParagraphView wmiParagraphView, WmiCompositeView wmiCompositeView, int n, ArrayList arrayList) throws WmiNoReadAccessException {
        int n2 = wmiCompositeView.getChildCount();
        boolean bl = ((WmiPositionedView)((Object)wmiCompositeView)).getWidth() > n;
        for (int i = 0; i < n2; ++i) {
            WmiGenericView wmiGenericView;
            WmiView wmiView = wmiCompositeView.getChild(i);
            if (wmiView instanceof WmiMathSpaceView) {
                wmiGenericView = (WmiMathSpaceView)wmiView;
                if (!WmiMathSpaceView.isCandidateExplicitBreakSpace(wmiGenericView)) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(wmiGenericView);
                continue;
            }
            if (!bl || !(wmiView instanceof WmiMathInlineView)) continue;
            wmiGenericView = (WmiInlineView)wmiView;
            arrayList = WmiMathSpaceView.breakAtAllNewlines(wmiParagraphView, (WmiCompositeView)((Object)wmiGenericView), n, arrayList);
        }
        return arrayList;
    }

    private void adjustIndentation(WmiView wmiView) throws WmiNoReadAccessException {
        if (wmiView instanceof WmiParagraphView.WmiParagraphInlineView) {
            WmiAttributeSet wmiAttributeSet;
            WmiParagraphView.WmiParagraphInlineView wmiParagraphInlineView = (WmiParagraphView.WmiParagraphInlineView)wmiView;
            WmiModel wmiModel = this.getModel();
            WmiAttributeSet wmiAttributeSet2 = wmiAttributeSet = wmiModel != null ? wmiModel.getAttributesForRead() : null;
            if (wmiAttributeSet instanceof WmiMathSpaceModel.WmiMathSpaceAttributeSet) {
                WmiMathSpaceModel.WmiMathSpaceAttributeSet wmiMathSpaceAttributeSet = (WmiMathSpaceModel.WmiMathSpaceAttributeSet)wmiAttributeSet;
                String string = wmiMathSpaceAttributeSet.getLinebreak();
                if (string.equals("increaseindentnewline")) {
                    wmiParagraphInlineView.incrementIndentLevel();
                } else if (string.equals("decreaseindentnewline")) {
                    wmiParagraphInlineView.decrementIndentLevel();
                }
            }
        }
    }

    static {
        PROC_BREAKS.add("increaseindentnewline");
        PROC_BREAKS.add("indentingnewline");
        PROC_BREAKS.add("decreaseindentnewline");
        PROC_BREAKS.add("newline");
        PROC_BREAKS.add("firstprocnewline");
    }
}

