/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.font.WmiTextLayout;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiDimensionUnit;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiFractionView;
import com.maplesoft.mathdoc.view.math.WmiMathInlineView;
import com.maplesoft.mathdoc.view.math.WmiMathSpaceView;
import com.maplesoft.mathdoc.view.math.WmiMathTextView;
import com.maplesoft.mathdoc.view.math.WmiOverView;
import com.maplesoft.mathdoc.view.math.WmiUnderOverView;
import com.maplesoft.mathdoc.view.math.WmiUnderView;
import com.maplesoft.mathdoc.view.math.renderers.WmiAngleBracketRenderer;
import com.maplesoft.mathdoc.view.math.renderers.WmiBaselineProvider;
import com.maplesoft.mathdoc.view.math.renderers.WmiBraceRenderer;
import com.maplesoft.mathdoc.view.math.renderers.WmiHorizontalStretchyAccentRenderer;
import com.maplesoft.mathdoc.view.math.renderers.WmiHorizontalStretchyArrowRenderer;
import com.maplesoft.mathdoc.view.math.renderers.WmiHorizontalStretchyBraceRenderer;
import com.maplesoft.mathdoc.view.math.renderers.WmiIntegralRenderer;
import com.maplesoft.mathdoc.view.math.renderers.WmiLimitRenderer;
import com.maplesoft.mathdoc.view.math.renderers.WmiOperatorRenderer;
import com.maplesoft.mathdoc.view.math.renderers.WmiParenRenderer;
import com.maplesoft.mathdoc.view.math.renderers.WmiSquareBracketRenderer;
import com.maplesoft.mathdoc.view.math.renderers.WmiUnaryMinusRenderer;
import com.maplesoft.mathdoc.view.math.renderers.WmiVerticalOffsetProvider;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.HashSet;

public class WmiMathOperatorView
extends WmiMathTextView {
    private static HashMap specialRendererMap = null;
    private static HashMap specialRendererMapEsstix = null;
    private static HashMap operatorSpaceDimensions = new HashMap();
    private static HashSet stretchyOperatorSet = null;
    private static final String ALT_ABS_BAR = "\u2223";
    private static final String LEFT_BRACKETING_BAR = "\u23a2";
    private static final String RIGHT_BRACKETING_BAR = "\u23a5";
    private static final String DOUBLE_VERTICAL_BAR = "\u2225";
    private static final String DOUBLE_VERTICAL_BAR_ALT = "\u2016";
    private static final String LEFT_CEIL = "\u2308";
    private static final String RIGHT_CEIL = "\u2309";
    private static final String LEFT_FLOOR = "\u230a";
    private static final String RIGHT_FLOOR = "\u230b";
    private static final String LEFT_WHITE_SQUARE = "\u27e6";
    private static final String RIGHT_WHITE_SQUARE = "\u27e7";
    private static final String LEFT_ANGLE_BRACKET = "\u2329";
    private static final String RIGHT_ANGLE_BRACKET = "\u232a";
    private static final String LEFT_DOUBLE_ANGLE_BRACKET = "\u300a";
    private static final String RIGHT_DOUBLE_ANGLE_BRACKET = "\u300b";
    private static final String CONTOUR_INTEGRAL = "\u222e";
    private static final String DOUBLE_CONTOUR_INTEGRAL = "\u222f";
    private static final String TRIPLE_CONTOUR_INTEGRAL = "\u2230";
    private static final String CW_CONTOUR_INTEGRAL = "\u2232";
    private static final String CCW_CONTOUR_INTEGRAL = "\u2233";
    private static final String CIRCULATION_FUNCTION = "\u2a10";
    private static final String CW_INTEGRAL = "\u2231";
    private static final String FINITE_PART_INTEGRAL = "\u2a0d";
    private static final String QUATGERNION_INTEGRAL = "\u2a16";
    private static final String DOUBLE_INTEGRAL = "\u222c";
    private static final String TRIPLE_INTEGRAL = "\u222d";
    private static final String UMINUS_FONT_NAME = "/com/maplesoft/mathdoc/font/resources/ESSTIX8_.TTF";
    private static final String UMINUS = "\u2212";
    private static final float FRACTION_PREPAD_ADJUST = 2.0f;
    private int stretchHeight = 0;
    private int stretchWidth = 0;
    WmiOperatorRenderer renderer = null;
    private int leftPadding = 0;
    private int rightPadding = 0;
    private int underlineHorizontalOffs = 0;
    private int underlineEndHorizontalOffs;
    public static final WmiBaselineProvider LARGE_OP_BASELINE_PROVIDER;
    private WmiBaselineProvider baselineSource = null;
    private WmiVerticalOffsetProvider voffsSource = null;

    public WmiMathOperatorView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        super(wmiModel, wmiMathDocumentView);
    }

    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            WmiMathOperatorModel wmiMathOperatorModel;
            String string;
            if (this.isLargeOp()) {
                this.baselineSource = LARGE_OP_BASELINE_PROVIDER;
            }
            super.layoutView();
            String string2 = this.getText();
            this.initializeRenderer();
            if (this.renderer != null) {
                if (this.renderer.applyRenderer(this, 0)) {
                    this.renderer.layoutView(this, 0);
                } else {
                    this.renderer = null;
                }
            }
            boolean bl = false;
            if (string2.equals(UMINUS) && "&uminus0;".equals(string = (wmiMathOperatorModel = (WmiMathOperatorModel)this.getModel()).getSemanticLabel())) {
                bl = true;
            }
            if (!bl) {
                this.addPadding();
            }
            if (string2.equals("&minus;") && this.getNextView(2) instanceof WmiFractionView) {
                this.leftPadding += Math.round(0.02f * (float)this.getZoomFactor());
            }
        }
    }

    public void resetStretchy() throws WmiNoReadAccessException {
        String string = this.getText();
        if (stretchyOperatorSet.contains(string)) {
            this.resetRenderer();
        }
    }

    public void resetRenderer() throws WmiNoReadAccessException {
        if (this.renderer != null) {
            this.renderer = null;
            this.markInvalid(1);
            this.layoutView();
        }
    }

    public boolean layoutStretchView(int n) throws WmiNoReadAccessException {
        boolean bl = false;
        this.initializeRenderer();
        if (this.renderer != null && this.renderer.isStretchy()) {
            if (this.renderer.applyRenderer(this, n)) {
                bl = true;
                this.renderer.layoutView(this, n);
            } else {
                this.renderer = null;
            }
        }
        return bl;
    }

    protected void initializeRenderer() throws WmiNoReadAccessException {
        String string = this.getText();
        this.renderer = WmiMathOperatorView.getRenderer(string);
    }

    public static WmiOperatorRenderer getRenderer(String string) {
        WmiOperatorRenderer wmiOperatorRenderer = null;
        wmiOperatorRenderer = RuntimePlatform.isMac() || !RuntimePlatform.isEsstix() ? (WmiOperatorRenderer)specialRendererMap.get(string) : (WmiOperatorRenderer)specialRendererMapEsstix.get(string);
        return wmiOperatorRenderer;
    }

    public int getCorrectedZoomFactor() throws WmiNoReadAccessException {
        int n = super.getCorrectedZoomFactor();
        if (this.isLargeOp()) {
            n = Math.round((float)n * 2.0f);
        }
        return n;
    }

    protected boolean isLargeOp() throws WmiNoReadAccessException {
        WmiModel wmiModel = this.getModel();
        WmiAttributeSet wmiAttributeSet = wmiModel.getAttributesForRead();
        boolean bl = false;
        if (wmiAttributeSet instanceof WmiMathOperatorModel.WmiMathOperatorAttributeSet) {
            bl = ((WmiMathOperatorModel.WmiMathOperatorAttributeSet)wmiAttributeSet).isLargeOp() && !stretchyOperatorSet.contains(this.getText());
        }
        return bl;
    }

    public boolean isStretchyOp() throws WmiNoReadAccessException {
        return stretchyOperatorSet.contains(this.getText());
    }

    public boolean enableKernAdjust() {
        return false;
    }

    public int getUnderlineHorizontalOffset() {
        return this.underlineHorizontalOffs;
    }

    public int getUnderlineHorizontalEndOffset() {
        return this.underlineEndHorizontalOffs;
    }

    public void setStretchHeight(int n) throws WmiNoReadAccessException {
        if (this.stretchHeight == 0) {
            this.stretchHeight = n;
        }
    }

    public int getStretchHeight() {
        return this.stretchHeight;
    }

    public void setStretchWidth(int n) throws WmiNoReadAccessException {
        this.stretchWidth = n;
    }

    public int getStretchWidth() {
        return this.stretchWidth;
    }

    public int getHeight() {
        if (this.stretchHeight > 0 && this.stretchHeight > this.height) {
            return this.stretchHeight;
        }
        return super.getHeight();
    }

    public int getWidth() {
        if (this.stretchWidth > 0 && this.stretchWidth > this.width) {
            return this.stretchWidth;
        }
        return super.getWidth();
    }

    public int getLeftPadding() {
        return this.leftPadding;
    }

    public int getRightPadding() {
        return this.rightPadding;
    }

    public void invalidate(int n) {
        super.invalidate(n);
        this.stretchHeight = 0;
        this.stretchWidth = 0;
    }

    public void setBaselineProvider(WmiBaselineProvider wmiBaselineProvider) {
        this.baselineSource = wmiBaselineProvider;
    }

    public int getBaseline() {
        return this.baselineSource != null ? this.baselineSource.calculateBaseline(this) : super.getBaseline();
    }

    public void setVerticalOffsetProvider(WmiVerticalOffsetProvider wmiVerticalOffsetProvider) {
        this.voffsSource = wmiVerticalOffsetProvider;
    }

    public int getVerticalOffset() {
        return this.voffsSource != null ? this.voffsSource.calculateVerticalOffset(this) : super.getVerticalOffset();
    }

    public int getOriginalVerticalOffset() {
        return super.getVerticalOffset();
    }

    protected int getOriginalBaseline() {
        return super.getBaseline();
    }

    public void draw(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle) {
        if (this.renderer != null && !this.renderer.isLayoutOnly()) {
            this.renderer.draw(graphics, wmiRenderPath, rectangle, this);
        } else {
            super.draw(graphics, wmiRenderPath, rectangle);
        }
    }

    public void drawText(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle) {
        super.draw(graphics, wmiRenderPath, rectangle);
    }

    public boolean hasRenderer() {
        return this.getRenderer() != null;
    }

    public WmiOperatorRenderer getRenderer() {
        return this.renderer;
    }

    public int getHorizontalOffset(int n) {
        return this.getCaretPosition(n, true);
    }

    protected int getCaretPosition(int n, boolean bl) {
        int n2 = 0;
        n2 = this.renderer != null ? (n == 0 && bl ? 0 : this.getWidth()) : super.getCaretPosition(n, bl);
        return n2;
    }

    public int[] getCaretBounds(int n) throws WmiNoReadAccessException {
        int[] nArray = null;
        if (this.renderer != null && !this.renderer.isLayoutOnly()) {
            WmiScrollableContainerView wmiScrollableContainerView = WmiViewUtil.findEnclosingContainer(this);
            nArray = new int[4];
            WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
            Point point = WmiViewUtil.getAbsoluteOffset(this);
            if (wmiScrollableContainerView != null && wmiScrollableContainerView != wmiMathDocumentView) {
                Point point2 = WmiViewUtil.getAbsoluteOffset(wmiScrollableContainerView);
                point.x -= point2.x;
                point.y -= point2.y;
            }
            nArray[0] = point.x;
            nArray[1] = point.y;
            nArray[2] = nArray[0] + this.width;
            nArray[3] = nArray[1] + this.height;
        } else {
            nArray = super.getCaretBounds(n);
        }
        return nArray;
    }

    public int getOffset(Point point) {
        int n = 0;
        n = this.renderer != null ? (point.x >= this.getWidth() / 2 ? 1 : 0) : super.getOffset(point);
        return n;
    }

    private void addPadding() throws WmiNoReadAccessException {
        int n;
        Cloneable cloneable;
        try {
            if (this.isOverUnderElement()) {
                return;
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        boolean bl = true;
        boolean bl2 = true;
        if (this.renderer == null) {
            WmiView wmiView = null;
            WmiView wmiView2 = null;
            WmiCompositeView wmiCompositeView = this.getParentView();
            if (wmiCompositeView instanceof WmiInlineView) {
                int n2 = wmiCompositeView.indexOf(this);
                if (n2 > 0) {
                    wmiView = wmiCompositeView.getChild(n2 - 1);
                }
                if (n2 < wmiCompositeView.getChildCount() - 1) {
                    wmiView2 = wmiCompositeView.getChild(n2 + 1);
                }
            } else {
                bl2 = false;
                bl = false;
            }
            if (wmiView instanceof WmiMathOperatorView) {
                bl = false;
            }
            if (wmiView instanceof WmiMathSpaceView && ((WmiMathSpaceView)wmiView).getWidth() > 0) {
                bl = false;
            }
            if (wmiView2 instanceof WmiMathOperatorView) {
                bl2 = false;
            }
            if (wmiView2 instanceof WmiMathSpaceView) {
                WmiMathSpaceView wmiMathSpaceView = (WmiMathSpaceView)wmiView2;
                if (!wmiMathSpaceView.isLayoutValid()) {
                    wmiMathSpaceView.layoutView();
                }
                if (wmiMathSpaceView.getWidth() > 0) {
                    bl2 = false;
                }
            }
        }
        float f = 0.0f;
        float f2 = 0.0f;
        boolean bl3 = false;
        WmiFontAttributeSet wmiFontAttributeSet = this.getFontAttributes();
        if (wmiFontAttributeSet instanceof WmiMathOperatorModel.WmiMathOperatorAttributeSet) {
            cloneable = (WmiMathOperatorModel.WmiMathOperatorAttributeSet)wmiFontAttributeSet;
            f = ((WmiMathOperatorModel.WmiMathOperatorAttributeSet)cloneable).getLSpace();
            f2 = ((WmiMathOperatorModel.WmiMathOperatorAttributeSet)cloneable).getRSpace();
            bl3 = ((WmiMathOperatorModel.WmiMathOperatorAttributeSet)cloneable).hasOperatorStyle(16384);
        }
        boolean bl4 = (cloneable = this.getDocumentView()) != null ? ((WmiMathDocumentView)cloneable).isPrintView() : false;
        WmiTextLayout wmiTextLayout = this.getLayout();
        Font font = wmiTextLayout != null ? wmiTextLayout.getFont() : null;
        WmiFontMetrics wmiFontMetrics = font != null ? WmiFontResolver.getFontMetrics(font) : null;
        int n3 = n = wmiFontMetrics != null && !bl3 ? wmiFontMetrics.getFontProperty(3, bl4) : 1;
        if (f > 0.0f && bl) {
            this.leftPadding = Math.round(f * (float)n);
            this.width += this.leftPadding;
            this.underlineHorizontalOffs = -this.leftPadding;
        } else {
            this.leftPadding = 0;
        }
        if (f2 > 0.0f && bl2) {
            this.rightPadding = Math.round(f2 * (float)n);
            this.width += this.rightPadding;
        } else {
            this.rightPadding = 0;
        }
    }

    private boolean isOverUnderElement() throws WmiNoReadAccessException {
        WmiCompositeView wmiCompositeView = this.getParentView();
        WmiView wmiView = this;
        if (wmiCompositeView instanceof WmiMathInlineView && wmiCompositeView.getChildCount() == 2 && WmiModelUtil.isEmptyIdentifierModel(wmiCompositeView.getChild(0).getModel())) {
            wmiView = wmiCompositeView;
            wmiCompositeView = wmiCompositeView.getParentView();
        }
        if (wmiCompositeView instanceof WmiOverView) {
            return ((WmiOverView)wmiCompositeView).getChild(1) == wmiView;
        }
        if (wmiCompositeView instanceof WmiUnderView) {
            return ((WmiUnderView)wmiCompositeView).getChild(1) == wmiView;
        }
        if (wmiCompositeView instanceof WmiUnderOverView) {
            return ((WmiUnderOverView)wmiCompositeView).getChild(2) == wmiView || ((WmiUnderOverView)wmiCompositeView).getChild(1) == wmiView;
        }
        return false;
    }

    public static WmiDimensionUnit getNamedDimension(String string) {
        return (WmiDimensionUnit)operatorSpaceDimensions.get(string);
    }

    public static void updateOperatorSpaceDimension(String string, String string2) {
        operatorSpaceDimensions.put(string, WmiDimensionUnit.createDimension(string2, null));
    }

    public int computePostKernAdjustment() {
        int n = 0;
        if (this.enableKernAdjust()) {
            n = this.hasRenderer() ? this.renderer.computePostKernAdjustment(this) : super.computePostKernAdjustment();
        }
        return n;
    }

    public int computePreKernAdjustment() {
        int n = 0;
        if (this.enableKernAdjust()) {
            n = this.hasRenderer() ? this.renderer.computePreKernAdjustment(this) : super.computePreKernAdjustment();
        }
        return n;
    }

    public boolean forcePostKernAdjustment() {
        return this.hasRenderer() ? this.renderer.forcePostKernAdjustment(this) : false;
    }

    public boolean forcePreKernAdjustment() {
        return this.hasRenderer() ? this.renderer.forcePreKernAdjustment(this) : false;
    }

    public int computeSpaceAbove() {
        return this.hasRenderer() ? this.renderer.computeSpaceAbove(this) : super.computeSpaceAbove();
    }

    public int computeSpaceBelow() {
        return this.hasRenderer() ? this.renderer.computeSpaceBelow(this) : super.computeSpaceBelow();
    }

    public int doImplicitLinebreak(WmiParagraphView wmiParagraphView, int n, int n2, int n3) throws WmiNoReadAccessException {
        int n4 = 0;
        int n5 = this.getSplitIndex(n, n2, n3);
        if (n5 > 0 || n5 == 0 && !wmiParagraphView.isStartOfLine(this)) {
            WmiCompositeView wmiCompositeView = this.getParentView();
            String string = this.getText();
            int n6 = string != null && string.equals(" ") ? 1 : 0;
            wmiParagraphView.split(wmiCompositeView, n5, n6);
            n4 = 2;
        }
        return n4;
    }

    public int doExplicitLinebreak(WmiParagraphView wmiParagraphView) throws WmiNoReadAccessException {
        return 0;
    }

    public int doForcedLinebreak(WmiParagraphView wmiParagraphView, int n, int n2) throws WmiNoReadAccessException {
        return 0;
    }

    public boolean hasGoodBreakpoint(int n, int n2, int n3) throws WmiNoReadAccessException {
        return this.getSplitIndex(n, n2, n3) >= 0;
    }

    private int getSplitIndex(int n, int n2, int n3) throws WmiNoReadAccessException {
        boolean bl = false;
        int n4 = 0;
        String string = this.getText();
        int n5 = 0;
        if (string != null) {
            boolean bl2;
            if (string.length() > 0) {
                n5 = string.charAt(0);
            }
            boolean bl3 = bl2 = n5 == 59 || n5 == 58 || n5 == 44 || n5 == 33;
            if (!bl2 || n + this.getWidth() < n2) {
                WmiCompositeView wmiCompositeView;
                if (!(string.length() == 0 && n3 < 2 || n5 == 32 && n3 < 1 || (n4 = (wmiCompositeView = this.getParentView()).indexOf(this)) < 0)) {
                    if (bl2) {
                        ++n4;
                    }
                    bl = true;
                }
            } else if (n3 == 2) {
                WmiCompositeView wmiCompositeView = this.getParentView();
                n4 = wmiCompositeView.indexOf(this);
                bl = n4 >= 0;
            }
        }
        return bl ? n4 : -1;
    }

    static {
        specialRendererMap = new HashMap();
        specialRendererMap.put("(", new WmiParenRenderer.WmiLeftParenRenderer());
        specialRendererMap.put(")", new WmiParenRenderer.WmiRightParenRenderer());
        specialRendererMap.put("{", new WmiBraceRenderer.WmiLeftBraceRenderer());
        specialRendererMap.put("}", new WmiBraceRenderer.WmiRightBraceRenderer());
        specialRendererMap.put(UMINUS, new WmiUnaryMinusRenderer());
        specialRendererMap.put("\u222b", new WmiIntegralRenderer());
        specialRendererMap.put(CONTOUR_INTEGRAL, new WmiIntegralRenderer.WmiContourIntegralRenderer());
        specialRendererMap.put(DOUBLE_CONTOUR_INTEGRAL, new WmiIntegralRenderer.WmiDoubleContourIntegralRenderer());
        specialRendererMap.put(TRIPLE_CONTOUR_INTEGRAL, new WmiIntegralRenderer.WmiTripleContourIntegralRenderer());
        specialRendererMap.put(CW_CONTOUR_INTEGRAL, new WmiIntegralRenderer.WmiCWContourIntegralRenderer());
        specialRendererMap.put(CCW_CONTOUR_INTEGRAL, new WmiIntegralRenderer.WmiCCWContourIntegralRenderer());
        specialRendererMap.put(CIRCULATION_FUNCTION, new WmiIntegralRenderer.WmiCirculationFunctionRenderer());
        specialRendererMap.put(CW_INTEGRAL, new WmiIntegralRenderer.WmiCWIntegrationRenderer());
        specialRendererMap.put(FINITE_PART_INTEGRAL, new WmiIntegralRenderer.WmiFinitePartIntegrationRenderer());
        specialRendererMap.put(QUATGERNION_INTEGRAL, new WmiIntegralRenderer.WmiQuaternionIntegrationRenderer());
        specialRendererMap.put(DOUBLE_INTEGRAL, new WmiIntegralRenderer.WmiDoubleIntegralRenderer());
        specialRendererMap.put(TRIPLE_INTEGRAL, new WmiIntegralRenderer.WmiTripleIntegralRenderer());
        specialRendererMap.put(String.valueOf('\u00af'), new WmiHorizontalStretchyAccentRenderer(String.valueOf('\u00af')));
        specialRendererMap.put(String.valueOf('^'), new WmiHorizontalStretchyAccentRenderer(String.valueOf('^')));
        specialRendererMap.put(String.valueOf('~'), new WmiHorizontalStretchyAccentRenderer(String.valueOf('~')));
        specialRendererMap.put(String.valueOf('\u2190'), new WmiHorizontalStretchyArrowRenderer('\u2190'));
        specialRendererMap.put(String.valueOf('\u2192'), new WmiHorizontalStretchyArrowRenderer('\u2192'));
        specialRendererMap.put(String.valueOf('\u2194'), new WmiHorizontalStretchyArrowRenderer('\u2194'));
        specialRendererMap.put(String.valueOf('\u21c0'), new WmiHorizontalStretchyArrowRenderer('\u21c0'));
        specialRendererMap.put(String.valueOf('\u21c1'), new WmiHorizontalStretchyArrowRenderer('\u21c1'));
        specialRendererMap.put(String.valueOf('\u21bc'), new WmiHorizontalStretchyArrowRenderer('\u21bc'));
        specialRendererMap.put(String.valueOf('\u21bd'), new WmiHorizontalStretchyArrowRenderer('\u21bd'));
        specialRendererMap.put(String.valueOf('\u0305'), new WmiHorizontalStretchyArrowRenderer('\u0305'));
        specialRendererMap.put(String.valueOf('\u21cc'), new WmiHorizontalStretchyArrowRenderer('\u21cc'));
        specialRendererMap.put(String.valueOf('\u21cb'), new WmiHorizontalStretchyArrowRenderer('\u21cb'));
        specialRendererMap.put(String.valueOf('\u21d0'), new WmiHorizontalStretchyArrowRenderer('\u21d0'));
        specialRendererMap.put(String.valueOf('\u21d2'), new WmiHorizontalStretchyArrowRenderer('\u21d2'));
        specialRendererMap.put(String.valueOf('\u21da'), new WmiHorizontalStretchyArrowRenderer('\u21da'));
        specialRendererMap.put(String.valueOf('\u21db'), new WmiHorizontalStretchyArrowRenderer('\u21db'));
        specialRendererMap.put(String.valueOf('\u219a'), new WmiHorizontalStretchyArrowRenderer('\u219a'));
        specialRendererMap.put(String.valueOf('\u219b'), new WmiHorizontalStretchyArrowRenderer('\u219b'));
        specialRendererMap.put(String.valueOf('\u21c7'), new WmiHorizontalStretchyArrowRenderer('\u21c7'));
        specialRendererMap.put(String.valueOf('\u21c9'), new WmiHorizontalStretchyArrowRenderer('\u21c9'));
        specialRendererMap.put(String.valueOf('\u21c6'), new WmiHorizontalStretchyArrowRenderer('\u21c6'));
        specialRendererMap.put(String.valueOf('\u21c4'), new WmiHorizontalStretchyArrowRenderer('\u21c4'));
        specialRendererMap.put(String.valueOf('\u21d4'), new WmiHorizontalStretchyArrowRenderer('\u21d4'));
        specialRendererMap.put(String.valueOf('\u21cf'), new WmiHorizontalStretchyArrowRenderer('\u21cf'));
        specialRendererMap.put(String.valueOf('\u21cd'), new WmiHorizontalStretchyArrowRenderer('\u21cd'));
        specialRendererMap.put(String.valueOf('\u21ce'), new WmiHorizontalStretchyArrowRenderer('\u21ce'));
        specialRendererMap.put(String.valueOf('\u21a6'), new WmiHorizontalStretchyArrowRenderer('\u21a6'));
        specialRendererMap.put(String.valueOf('\u2905'), new WmiHorizontalStretchyArrowRenderer('\u2905'));
        specialRendererMap.put(String.valueOf('\u219e'), new WmiHorizontalStretchyArrowRenderer('\u219e'));
        specialRendererMap.put(String.valueOf('\u21a0'), new WmiHorizontalStretchyArrowRenderer('\u21a0'));
        specialRendererMap.put(String.valueOf('\u21a2'), new WmiHorizontalStretchyArrowRenderer('\u21a2'));
        specialRendererMap.put(String.valueOf('\u21a3'), new WmiHorizontalStretchyArrowRenderer('\u21a3'));
        specialRendererMap.put(String.valueOf('\u22c0'), new WmiHorizontalStretchyAccentRenderer('\u22c0'));
        specialRendererMap.put(String.valueOf('\u2227'), new WmiHorizontalStretchyAccentRenderer('\u2227'));
        specialRendererMap.put(String.valueOf('\u02c6'), new WmiHorizontalStretchyAccentRenderer('\u02c6'));
        specialRendererMap.put(String.valueOf('\ufe37'), new WmiHorizontalStretchyBraceRenderer(String.valueOf('\ufe37')));
        specialRendererMap.put(String.valueOf('\ufe38'), new WmiHorizontalStretchyBraceRenderer(String.valueOf('\ufe38')));
        specialRendererMap.put("lim", new WmiLimitRenderer());
        WmiSquareBracketRenderer.WmiSingleVerticalBarRenderer wmiSingleVerticalBarRenderer = new WmiSquareBracketRenderer.WmiSingleVerticalBarRenderer();
        specialRendererMap.put("|", wmiSingleVerticalBarRenderer);
        specialRendererMap.put(ALT_ABS_BAR, wmiSingleVerticalBarRenderer);
        specialRendererMap.put(LEFT_BRACKETING_BAR, wmiSingleVerticalBarRenderer);
        specialRendererMap.put(RIGHT_BRACKETING_BAR, wmiSingleVerticalBarRenderer);
        specialRendererMap.put(DOUBLE_VERTICAL_BAR, new WmiSquareBracketRenderer.WmiDoubleVerticalBarRenderer());
        specialRendererMap.put(DOUBLE_VERTICAL_BAR_ALT, new WmiSquareBracketRenderer.WmiDoubleVerticalBarRenderer());
        specialRendererMap.put(LEFT_CEIL, new WmiSquareBracketRenderer.WmiLeftCeilingRenderer());
        specialRendererMap.put(RIGHT_CEIL, new WmiSquareBracketRenderer.WmiRightCeilingRenderer());
        specialRendererMap.put(LEFT_FLOOR, new WmiSquareBracketRenderer.WmiLeftFloorRenderer());
        specialRendererMap.put(RIGHT_FLOOR, new WmiSquareBracketRenderer.WmiRightFloorRenderer());
        specialRendererMap.put(LEFT_WHITE_SQUARE, new WmiSquareBracketRenderer.WmiDoubleLeftBracketRenderer());
        specialRendererMap.put(RIGHT_WHITE_SQUARE, new WmiSquareBracketRenderer.WmiDoubleRightBracketRenderer());
        specialRendererMap.put("[", new WmiSquareBracketRenderer.WmiLeftSquareBracketRenderer());
        specialRendererMap.put("]", new WmiSquareBracketRenderer.WmiRightSquareBracketRenderer());
        specialRendererMap.put(LEFT_ANGLE_BRACKET, new WmiAngleBracketRenderer('\u2329'));
        specialRendererMap.put(RIGHT_ANGLE_BRACKET, new WmiAngleBracketRenderer('\u232a'));
        specialRendererMap.put(LEFT_DOUBLE_ANGLE_BRACKET, new WmiAngleBracketRenderer('\u300a'));
        specialRendererMap.put(RIGHT_DOUBLE_ANGLE_BRACKET, new WmiAngleBracketRenderer('\u300b'));
        if (!RuntimePlatform.isMac()) {
            RuntimePlatform.setEsstix(true);
            specialRendererMapEsstix = new HashMap();
            specialRendererMapEsstix.put(String.valueOf('\u00af'), new WmiHorizontalStretchyAccentRenderer(String.valueOf('\u00af')));
            specialRendererMapEsstix.put("lim", new WmiLimitRenderer());
            RuntimePlatform.setEsstix(false);
        }
        stretchyOperatorSet = new HashSet();
        stretchyOperatorSet.add("(");
        stretchyOperatorSet.add(")");
        stretchyOperatorSet.add("{");
        stretchyOperatorSet.add("}");
        stretchyOperatorSet.add("[");
        stretchyOperatorSet.add("]");
        stretchyOperatorSet.add("|");
        stretchyOperatorSet.add(ALT_ABS_BAR);
        stretchyOperatorSet.add(DOUBLE_VERTICAL_BAR);
        stretchyOperatorSet.add("\u222b");
        stretchyOperatorSet.add(CONTOUR_INTEGRAL);
        stretchyOperatorSet.add(DOUBLE_CONTOUR_INTEGRAL);
        stretchyOperatorSet.add(TRIPLE_CONTOUR_INTEGRAL);
        stretchyOperatorSet.add(CW_CONTOUR_INTEGRAL);
        stretchyOperatorSet.add(CCW_CONTOUR_INTEGRAL);
        stretchyOperatorSet.add(CIRCULATION_FUNCTION);
        stretchyOperatorSet.add(CW_INTEGRAL);
        stretchyOperatorSet.add(FINITE_PART_INTEGRAL);
        stretchyOperatorSet.add(QUATGERNION_INTEGRAL);
        stretchyOperatorSet.add(DOUBLE_INTEGRAL);
        stretchyOperatorSet.add(TRIPLE_INTEGRAL);
        stretchyOperatorSet.add(LEFT_CEIL);
        stretchyOperatorSet.add(RIGHT_CEIL);
        stretchyOperatorSet.add(LEFT_FLOOR);
        stretchyOperatorSet.add(RIGHT_FLOOR);
        stretchyOperatorSet.add(LEFT_WHITE_SQUARE);
        stretchyOperatorSet.add(RIGHT_WHITE_SQUARE);
        stretchyOperatorSet.add(LEFT_ANGLE_BRACKET);
        stretchyOperatorSet.add(RIGHT_ANGLE_BRACKET);
        stretchyOperatorSet.add(LEFT_DOUBLE_ANGLE_BRACKET);
        stretchyOperatorSet.add(RIGHT_DOUBLE_ANGLE_BRACKET);
        operatorSpaceDimensions.put("veryverythinmathspace", WmiDimensionUnit.createDimension("0.0555556em", null));
        operatorSpaceDimensions.put("verythinmathspace", WmiDimensionUnit.createDimension("0.111111em", null));
        operatorSpaceDimensions.put("thinmathspace", WmiDimensionUnit.createDimension("0.166667em", null));
        operatorSpaceDimensions.put("mediummathspace", WmiDimensionUnit.createDimension("0.222222em", null));
        operatorSpaceDimensions.put("thickmathspace", WmiDimensionUnit.createDimension("0.277778em", null));
        operatorSpaceDimensions.put("verythickmathspace", WmiDimensionUnit.createDimension("0.333333em", null));
        operatorSpaceDimensions.put("veryverythickmathspace", WmiDimensionUnit.createDimension("0.388889em", null));
        LARGE_OP_BASELINE_PROVIDER = new WmiLargeOpBaselineProvider();
    }

    private static class WmiLargeOpBaselineProvider
    implements WmiBaselineProvider {
        private WmiLargeOpBaselineProvider() {
        }

        public int calculateBaseline(WmiMathOperatorView wmiMathOperatorView) {
            int n = wmiMathOperatorView.getOriginalBaseline();
            n = (int)((float)n - (float)wmiMathOperatorView.getHeight() * 0.1f);
            return n;
        }
    }
}

