/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiDimensionUnit;
import com.maplesoft.mathdoc.model.math.WmiMathStyleModel;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.math.WmiMathViewUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class WmiMathInlineView
extends WmiInlineView {
    private Color background = null;

    public WmiMathInlineView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        super(wmiModel, wmiMathDocumentView);
        this.applyMathRules(true);
        this.lockOperatorSize(false);
    }

    public void draw(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle) {
        int n = wmiRenderPath.getHorizontalOffset();
        int n2 = wmiRenderPath.getVerticalOffset();
        int n3 = wmiRenderPath.getLeftSelectionBoundary();
        int n4 = wmiRenderPath.getRightSelectionBoundary();
        if (this.background != null && (n3 < 0 || n3 > this.x + n || n4 < this.x + n + this.width) && n3 != -1 && n4 != -1) {
            graphics.setColor(this.background);
            graphics.fillRect(n + this.x, n2 + this.y, this.width, this.height);
        }
        super.draw(graphics, wmiRenderPath, rectangle);
    }

    public void layoutView() throws WmiNoReadAccessException {
        WmiMathStyleModel.WmiMathStyleAttributeSet wmiMathStyleAttributeSet;
        super.layoutView();
        if (this.getModel() instanceof WmiMathStyleModel && (wmiMathStyleAttributeSet = (WmiMathStyleModel.WmiMathStyleAttributeSet)this.getModel().getAttributesForRead()).isOpaque()) {
            this.background = new Color(wmiMathStyleAttributeSet.getBackground());
        }
    }

    public static float calculateScaleFactor(WmiMathStyleModel.WmiMathStyleAttributeSet wmiMathStyleAttributeSet, float f, WmiMathDocumentView wmiMathDocumentView) {
        String string = wmiMathStyleAttributeSet.getScriptLevel();
        float f2 = wmiMathStyleAttributeSet.getScriptSizeMultiplier();
        WmiDimensionUnit wmiDimensionUnit = wmiMathStyleAttributeSet.getScriptMinSize();
        int n = Math.max(1, Integer.parseInt(string.substring(string.indexOf("+") + 1)));
        float f3 = f;
        if (f2 != 0.71f) {
            f3 = f2;
        }
        float f4 = (float)Math.pow(f3, n);
        int n2 = WmiMathViewUtil.getPixelValueForDimension(wmiDimensionUnit, wmiMathStyleAttributeSet, wmiMathDocumentView.isPrintView());
        if (Math.round(WmiFontResolver.DPI_SCALE_FACTOR * f4 * (float)wmiMathStyleAttributeSet.getSize()) < n2) {
            f4 = (float)n2 / (WmiFontResolver.DPI_SCALE_FACTOR * (float)wmiMathStyleAttributeSet.getSize());
        }
        return f4;
    }
}

