/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTableCellAttributeSet;
import com.maplesoft.mathdoc.model.WmiTableCellModel;
import com.maplesoft.mathdoc.view.WmiCellView;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiResizableContainerView;
import com.maplesoft.mathdoc.view.WmiRowView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTableRowView;
import com.maplesoft.mathdoc.view.WmiTableView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;

public class WmiTableCellView
extends WmiRowView
implements WmiCellView {
    public static final int CELL_BORDER = 5;
    private static final String DEBUG_NAME = "Cell";
    public static final int MINIMUM_CELL_WIDTH = 11;
    private int row = -1;
    private int column = -1;
    private int rowSpan = 1;
    private int columnSpan = 1;
    private int borders = 0;
    private boolean columnSeparator = false;

    public WmiTableCellView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        super(wmiModel, wmiMathDocumentView, DEBUG_NAME);
    }

    public void draw(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle) {
        Shape shape = ((Graphics2D)graphics).getClip();
        int n = wmiRenderPath.getHorizontalOffset() + this.x;
        int n2 = wmiRenderPath.getVerticalOffset() + this.y;
        ((Graphics2D)graphics).clipRect(n, n2, this.width, this.height);
        super.draw(graphics, wmiRenderPath, rectangle);
        ((Graphics2D)graphics).setClip(shape);
        this.drawStub(graphics, wmiRenderPath, rectangle);
    }

    public void drawStub(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle) {
        WmiTableView wmiTableView = (WmiTableView)WmiViewUtil.findAncestorOfTag(this, WmiModelTag.TABLE);
        if (wmiTableView != null) {
            WmiView wmiView;
            int n;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Stroke stroke = graphics2D.getStroke();
            Color color = graphics.getColor();
            graphics2D.setStroke(WmiTableView.BORDER_STROKE);
            WmiSelection wmiSelection = wmiRenderPath.getSelection();
            WmiHighlightPainter wmiHighlightPainter = wmiSelection != null ? wmiSelection.getSelectionHighlighter() : null;
            Color color2 = wmiHighlightPainter != null ? this.getDocumentView().getColor(3) : null;
            int n2 = wmiRenderPath.getHorizontalOffset() + this.x;
            int n3 = wmiRenderPath.getVerticalOffset();
            int n4 = n2 + this.width;
            int n5 = n3 + this.getCellHeight();
            boolean bl = wmiTableView.hasFocus();
            if (this.row > 0) {
                n = 2;
                if ((this.borders & 0x10) != 0 && (wmiView = (WmiTableRowView)this.getParentView()) != null && !((WmiTableRowView)wmiView).drawSeparator()) {
                    n = 0;
                }
                WmiTableView.drawBorder(graphics, this.borders, n, bl, n2, n3, n4, n3, wmiHighlightPainter, color2);
            }
            if ((this.borders & 0x10) != 0) {
                n = 0;
                wmiView = (WmiTableRowView)this.getParentView();
                int n6 = wmiTableView.indexOf(wmiView);
                if (n6 >= 0) {
                    n6 += this.rowSpan;
                }
                if (n6 > 0 && n6 < wmiTableView.getChildCount()) {
                    wmiView = (WmiTableRowView)wmiTableView.getChild(n6);
                    if (wmiView != null && ((WmiTableRowView)wmiView).drawSeparator()) {
                        n = 8;
                    }
                    WmiTableView.drawBorder(graphics, this.borders, n, bl, n2, n5, n4, n5, wmiHighlightPainter, color2);
                }
            }
            if (this.column == 0) {
                n = 1;
                if ((wmiTableView.getBorderStyleIndex() & n) == 0) {
                    n = 0;
                }
                WmiTableView.drawBorder(graphics, this.borders, n, bl, n2, n3, n2, n5, wmiHighlightPainter, color2);
            } else {
                n = 1;
                if ((this.borders & 0x10) != 0 && (wmiView = wmiTableView.getChild(this.column)) != null) {
                    n = this.columnSeparator ? 1 : 0;
                }
                WmiTableView.drawBorder(graphics, this.borders, n, bl, n2, n3, n2, n5, wmiHighlightPainter, color2);
            }
            if (this.column + this.columnSpan == wmiTableView.getColumnCount()) {
                n = 4;
                if ((wmiTableView.getBorderStyleIndex() & n) == 0) {
                    n = 0;
                }
                WmiTableView.drawBorder(graphics, this.borders, n, bl, n4, n3, n4, n5, wmiHighlightPainter, color2);
            }
            graphics.setColor(color);
            graphics2D.setStroke(stroke);
        }
    }

    public void setColumn(int n) throws WmiNoReadAccessException {
        if (n != this.column) {
            this.column = n;
            this.getDocumentView().invalidateAll(this);
        }
    }

    public void setRow(int n) {
        if (n != this.row) {
            this.row = n;
            this.markInvalid(1);
        }
    }

    public void layoutView() throws WmiNoReadAccessException {
        if (this.getChildCount() == 1 && this.getChild(0) != null && this.getChild(0) instanceof WmiResizableContainerView) {
            ((WmiResizableContainerView)this.getChild(0)).setUserResizable(false);
        }
        if (!this.isLayoutValid()) {
            WmiTableCellModel wmiTableCellModel = (WmiTableCellModel)this.getModel();
            if (wmiTableCellModel != null) {
                WmiTableCellAttributeSet wmiTableCellAttributeSet = (WmiTableCellAttributeSet)wmiTableCellModel.getAttributesForRead();
                int n = this.columnSpan;
                if (wmiTableCellAttributeSet != null) {
                    this.rowSpan = wmiTableCellAttributeSet.getRowSpan();
                    this.columnSpan = wmiTableCellAttributeSet.getColumnSpan();
                }
                if (this.rowSpan < 1) {
                    this.rowSpan = 1;
                }
                if (this.columnSpan < 1) {
                    this.columnSpan = 1;
                }
                if (this.columnSpan != n && n != -1) {
                    for (int i = 0; i < this.length; ++i) {
                        WmiView wmiView = this.getChild(i);
                        this.getDocumentView().invalidateAll(wmiView);
                    }
                }
            }
            this.extractBorderStyle();
            this.validateChildren();
            super.layoutView();
            this.width = this.getBreakWidth() + 10;
            this.height += 5;
            this.extractColumnSeparator();
        }
    }

    public void extractBorderStyle() throws WmiNoReadAccessException {
        Object object;
        WmiCompositeModel wmiCompositeModel = WmiModelUtil.findAncestorOfTag(this.getModel(), WmiModelTag.TABLE);
        WmiAttributeSet wmiAttributeSet = wmiCompositeModel.getAttributesForRead();
        Object object2 = object = wmiAttributeSet != null ? wmiAttributeSet.getAttribute("interior") : null;
        if (object != null) {
            String string = object.toString();
            if (string.equals("all")) {
                this.borders = 15;
            } else if (string.equals("none")) {
                WmiTableView wmiTableView = (WmiTableView)WmiViewUtil.findAncestorOfTag(this, WmiModelTag.TABLE);
                this.borders = 0;
                if (this.column == 0 && (wmiTableView.getBorderStyleIndex() & 1) != 0) {
                    this.borders |= 1;
                }
                if (this.column + this.columnSpan == wmiTableView.getColumnCount() && (wmiTableView.getBorderStyleIndex() & 4) != 0) {
                    this.borders |= 4;
                }
            } else if (string.equals("group")) {
                this.borders = 31;
            }
        }
    }

    private void extractColumnSeparator() throws WmiNoReadAccessException {
        this.columnSeparator = false;
        WmiTableView wmiTableView = (WmiTableView)WmiViewUtil.findAncestorOfTag(this, WmiModelTag.TABLE);
        WmiView wmiView = wmiTableView.getChild(this.column);
        if (wmiView != null) {
            Object object;
            WmiModel wmiModel = wmiView.getModel();
            WmiAttributeSet wmiAttributeSet = wmiModel != null ? wmiModel.getAttributesForRead() : null;
            Object object2 = object = wmiAttributeSet != null ? wmiAttributeSet.getAttribute("separator") : null;
            if (object instanceof Boolean) {
                this.columnSeparator = ((Boolean)object).equals(Boolean.TRUE);
            } else if (object != null) {
                this.columnSeparator = object.toString().compareToIgnoreCase("true") == 0;
            }
        }
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getLeftIndent() {
        return 5;
    }

    public int getTopMargin() {
        return 5;
    }

    public int getBreakWidth() {
        int n = 0;
        WmiTableView wmiTableView = (WmiTableView)WmiViewUtil.findAncestorOfTag(this, WmiModelTag.TABLE);
        if (wmiTableView != null) {
            for (int i = 0; i < this.columnSpan; ++i) {
                n += wmiTableView.getColumnWidth(this.column + i);
            }
            n -= 10;
        }
        if (n <= 0) {
            n = 400;
        }
        return n;
    }

    protected int computeColumnIndex() {
        int n;
        int n2 = -1;
        WmiCompositeView wmiCompositeView = this.getParentView();
        if (wmiCompositeView instanceof WmiTableRowView && (n = wmiCompositeView.indexOf(this)) >= 0) {
            n2 = 0;
            for (int i = 0; i < n; ++i) {
                WmiModelTag wmiModelTag;
                WmiView wmiView = wmiCompositeView.getChild(i);
                WmiModel wmiModel = wmiView != null ? wmiView.getModel() : null;
                WmiModelTag wmiModelTag2 = wmiModelTag = wmiModel != null ? wmiModel.getTag() : null;
                if (wmiModelTag != WmiModelTag.TABLE_CELL) continue;
                ++n2;
            }
        }
        return n2;
    }

    public int getCellHeight() {
        int n = 0;
        WmiTableView wmiTableView = (WmiTableView)WmiViewUtil.findAncestorOfTag(this, WmiModelTag.TABLE);
        if (wmiTableView != null) {
            for (int i = 0; i < this.rowSpan; ++i) {
                n += wmiTableView.getRowHeight(this.row + i);
            }
        }
        return n;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.getCellHeight());
    }

    public void updateView() throws WmiNoReadAccessException {
        super.updateView();
    }

    public int getRowIndex() {
        return this.row;
    }

    public int getColumnIndex() {
        return this.column;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public int getColumnSpan() {
        return this.columnSpan;
    }

    public int getWidthConstraint(boolean bl) {
        return this.getBreakWidth();
    }
}

