/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelObserver;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiLinebrokenView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiTextFragmentView;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.math.WmiFencedView;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.util.ArrayList;

public class WmiParagraphView
extends WmiLinebrokenView
implements InputMethodListener {
    private static final String DEBUG_ROW_NAME = "Row";
    private static final int COST_LIMIT = 3;
    public static final int GOOD_BREAK = 0;
    public static final int MID_BREAK = 1;
    public static final int BAD_BREAK = 2;
    private static final float INDENT_SCALE_FACTOR = 0.2f;
    private Insets insets = null;
    private int firstLineIndent = 0;
    private boolean computeBreakWidth = true;
    private int spaceWidth = 0;

    public WmiParagraphView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        super(wmiModel, wmiMathDocumentView);
        this.setParentModel(wmiModel);
    }

    public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
    }

    public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
    }

    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            if (this.requiresUpdateOnLayout()) {
                this.deferredUpdateView();
            }
            int n = this.getZoomFactor();
            this.spaceWidth = (int)((float)n * 0.2f);
            this.setInsets();
            this.firstLineIndent = this.getIntAttribute("firstindent");
            this.breakWidth = this.getLinebreakWidth();
            this.setBreakWidth(this.breakWidth);
            boolean bl = false;
            Object object = this.getAttribute("linebreak");
            if ("newline".equals(object)) {
                bl = true;
            }
            this.linebreak(bl);
            super.layoutView();
            this.adjustVerticalAlignment();
            this.adjustAlignment(this.breakWidth);
            this.baseline = this.computeBaseline();
            if (this.height == 0) {
                WmiFontAttributeSet wmiFontAttributeSet = WmiFontAttributeSet.DEFAULT_FONT_ATTRIBUTES;
                int n2 = this.getZoomFactor();
                boolean bl2 = this.getDocumentView().isPrintView();
                Font font = WmiFontResolver.getFont(wmiFontAttributeSet, n2, bl2);
                WmiFontMetrics wmiFontMetrics = WmiFontResolver.getFontMetrics(font);
                this.baseline = wmiFontMetrics.getFontProperty(3, bl2) + wmiFontMetrics.getFontProperty(0, bl2);
                this.height = this.baseline + wmiFontMetrics.getFontProperty(4, bl2);
            }
        }
    }

    private int computeBaseline() {
        WmiView wmiView;
        int n = 0;
        if (this.getChildCount() > 0 && (wmiView = this.getChild(0)) instanceof WmiPositionedView) {
            n = ((WmiPositionedView)wmiView).getBaseline() + ((WmiPositionedView)wmiView).getVerticalOffset();
        }
        return n;
    }

    private void setInsets() throws WmiNoReadAccessException {
        this.insets = new Insets(this.getSpaceAbove(), this.getLeftMargin(), this.getSpaceBelow(), this.getRightMargin());
    }

    public void updateView() {
        this.invalidate(1);
    }

    public void deferredUpdateView() throws WmiNoReadAccessException {
        int n;
        Object object;
        int n2;
        WmiView[] wmiViewArray = this.extractViews();
        WmiModel[] wmiModelArray = this.extractModels();
        int n3 = wmiModelArray.length;
        WmiView[] wmiViewArray2 = new WmiView[n3];
        int n4 = wmiViewArray != null ? wmiViewArray.length : 0;
        int[] nArray = new int[n4];
        int n5 = 0;
        WmiViewFactory wmiViewFactory = this.getViewFactory();
        for (n2 = 0; n2 < n4; ++n2) {
            nArray[n2] = n2;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            object = wmiModelArray[n2];
            if (object == null) continue;
            for (n = n5; n < n4; ++n) {
                int n6 = nArray[n];
                WmiView wmiView = wmiViewArray[n6];
                if (wmiView == null || wmiView.getModel() != object || !WmiParagraphView.hasUniqueViewObserver((WmiModel)object, this.getDocumentView())) continue;
                wmiViewArray2[n2] = wmiView;
                if (n != n5) {
                    nArray[n] = nArray[n5];
                    nArray[n5] = n6;
                }
                ++n5;
                break;
            }
            if (object.isVisible()) {
                if (wmiViewArray2[n2] != null || wmiViewFactory == null) continue;
                WmiParagraphView.releaseViewObservers((WmiModel)object, this.getDocumentView());
                wmiViewArray2[n2] = wmiViewFactory.createView((WmiModel)object, this);
                continue;
            }
            if (wmiViewArray2[n2] == null) continue;
            wmiViewArray2[n2].release();
            wmiViewArray2[n2] = null;
        }
        for (n = n5; n < n4; ++n) {
            object = wmiViewArray[nArray[n]];
            if (object == null) continue;
            object.release();
        }
        this.length = wmiViewArray2.length;
        this.children = new WmiView[this.length];
        System.arraycopy(wmiViewArray2, 0, this.children, 0, this.length);
    }

    private static void releaseViewObservers(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        for (WmiModelObserver wmiModelObserver = wmiModel.getObserver(); wmiModelObserver != null; wmiModelObserver = wmiModelObserver.getNextObserver()) {
            WmiView wmiView;
            if (!(wmiModelObserver instanceof WmiView) || (wmiView = (WmiView)((Object)wmiModelObserver)).getDocumentView() != wmiMathDocumentView) continue;
            wmiModel.releaseObserver(wmiModelObserver);
        }
    }

    protected WmiModel[] extractModels() throws WmiNoReadAccessException {
        ArrayList arrayList = new ArrayList();
        WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)this.getModel();
        this.extractModels(wmiCompositeModel, arrayList);
        WmiModel[] wmiModelArray = new WmiModel[arrayList.size()];
        arrayList.toArray(wmiModelArray);
        return wmiModelArray;
    }

    protected void extractModels(WmiCompositeModel wmiCompositeModel, ArrayList arrayList) throws WmiNoReadAccessException {
        if (wmiCompositeModel != null) {
            int n = wmiCompositeModel.getChildCount();
            for (int i = 0; i < n; ++i) {
                WmiModel wmiModel = wmiCompositeModel.getChild(i);
                if (!wmiModel.isVisible()) continue;
                arrayList.add(wmiModel);
            }
        }
    }

    protected WmiView[] extractViews() {
        ArrayList arrayList = new ArrayList();
        WmiParagraphView.extractViews(this, arrayList);
        WmiView[] wmiViewArray = new WmiView[arrayList.size()];
        arrayList.toArray(wmiViewArray);
        return wmiViewArray;
    }

    public static void extractViews(WmiCompositeView wmiCompositeView, ArrayList arrayList) {
        WmiMathDocumentView wmiMathDocumentView = wmiCompositeView.getDocumentView();
        int n = wmiCompositeView.getChildCount();
        for (int i = 0; i < n; ++i) {
            WmiView wmiView = wmiCompositeView.getChild(i);
            if (wmiView instanceof WmiParagraphInlineView) {
                WmiParagraphView.extractViews((WmiCompositeView)wmiView, arrayList);
                continue;
            }
            if (!WmiParagraphView.hasUniqueViewObserver(wmiView.getModel(), wmiMathDocumentView) || wmiView instanceof WmiTextView) continue;
            arrayList.add(wmiView);
        }
    }

    private void adjustVerticalAlignment() throws WmiNoReadAccessException {
        int n = this.getChildCount();
        int n2 = this.insets != null ? this.insets.top : 0;
        int n3 = this.computeLineSpacing();
        for (int i = 0; i < n; ++i) {
            WmiInlineView wmiInlineView = (WmiInlineView)this.getChild(i);
            if (n2 > 0) {
                wmiInlineView.setVerticalOffset(wmiInlineView.getVerticalOffset() + n2);
            }
            n2 += n3;
        }
        if ((n2 += this.insets != null ? this.insets.bottom : 0) > 0) {
            this.height += n2;
        }
    }

    private int computeLineSpacing() throws WmiNoReadAccessException {
        int n = 0;
        Object object = this.getAttribute("linespacing");
        float f = 0.0f;
        if (object instanceof Float) {
            f = ((Float)object).floatValue();
        } else if (object != null) {
            f = Float.parseFloat(object.toString());
        }
        if (f > 0.0f) {
            WmiFontAttributeSet wmiFontAttributeSet = WmiFontAttributeSet.DEFAULT_FONT_ATTRIBUTES;
            int n2 = this.getZoomFactor();
            boolean bl = this.getDocumentView().isPrintView();
            Font font = WmiFontResolver.getFont(wmiFontAttributeSet, n2, bl);
            WmiFontMetrics wmiFontMetrics = WmiFontResolver.getFontMetrics(font);
            n = wmiFontMetrics.getFontProperty(3, bl) + wmiFontMetrics.getFontProperty(0, bl) + wmiFontMetrics.getFontProperty(4, bl);
            n = (int)(f * (float)n);
        }
        return n;
    }

    protected void adjustAlignment(int n) throws WmiNoReadAccessException {
        int n2 = this.getLeftIndent();
        int n3 = this.getRightIndent();
        Object object = this.getAttribute("alignment");
        if ("right".equals(object)) {
            this.rightAlign(n, n2, n3);
        } else if ("centred".equals(object)) {
            this.centerAlign(n, n2, n3);
        } else {
            this.leftAlign(n, n2, n3);
        }
    }

    protected void rightAlign(int n, int n2, int n3) {
        WmiInlineView wmiInlineView;
        int n4;
        int n5 = this.getChildCount();
        this.width = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            wmiInlineView = (WmiInlineView)this.getChild(n4);
            int n6 = wmiInlineView.getWidth();
            if (n6 <= this.width) continue;
            this.width = n6;
        }
        if (this.width < n) {
            this.width = n;
        }
        this.width += n2;
        this.width += n3;
        for (n4 = 0; n4 < n5; ++n4) {
            wmiInlineView = (WmiInlineView)this.getChild(n4);
            wmiInlineView.x = this.width - wmiInlineView.width - n3;
        }
    }

    protected void centerAlign(int n, int n2, int n3) {
        WmiInlineView wmiInlineView;
        int n4;
        int n5 = this.getChildCount();
        this.width = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            wmiInlineView = (WmiInlineView)this.getChild(n4);
            int n6 = wmiInlineView.getWidth();
            if (n6 > n) {
                n6 = n6 - wmiInlineView.getPadding(1) <= n ? n : (n6 -= wmiInlineView.getPadding(1));
            }
            if (n6 <= this.width) continue;
            this.width = n6;
        }
        if (this.width < n) {
            this.width = n;
        }
        this.width += n2;
        this.width += n3;
        for (n4 = 0; n4 < n5; ++n4) {
            wmiInlineView = (WmiInlineView)this.getChild(n4);
            wmiInlineView.x = (n - wmiInlineView.getWidth()) / 2 + n2;
            if (wmiInlineView.x >= n2) continue;
            wmiInlineView.x = n2;
        }
    }

    protected void leftAlign(int n, int n2, int n3) {
        int n4 = this.getChildCount();
        this.width = 0;
        for (int i = 0; i < n4; ++i) {
            int n5;
            WmiInlineView wmiInlineView = (WmiInlineView)this.getChild(i);
            wmiInlineView.x = n2;
            if (i == 0) {
                wmiInlineView.x += this.firstLineIndent;
            }
            if ((n5 = wmiInlineView.getWidth()) > n) {
                n5 = n5 - wmiInlineView.getPadding(1) <= n ? n : (n5 -= wmiInlineView.getPadding(1));
            }
            if (n5 <= this.width) continue;
            this.width = n5;
        }
        if (this.width < n) {
            this.width = n;
        }
        this.width += n2;
        this.width += n3;
    }

    protected boolean requiresUpdateOnLayout() {
        return true;
    }

    public int getLeftIndent() {
        return this.insets != null ? this.insets.left : 0;
    }

    public int getRightIndent() {
        return this.insets != null ? this.insets.right : 0;
    }

    public int getFirstLineIndent() {
        return this.firstLineIndent;
    }

    public int getLinebreakWidth() {
        int n = Integer.MAX_VALUE;
        n = this.computeBreakWidth ? this.getWidthConstraint(false) : this.breakWidth;
        return n;
    }

    public void setLinebreakWidth(int n) {
        this.setBreakWidth(n);
        this.breakWidth = n;
        this.computeBreakWidth = false;
    }

    private void linebreak(boolean bl) throws WmiNoReadAccessException {
        int n = this.getChildCount();
        WmiInlineView wmiInlineView = this.createRow(this.getModel(), this.breakWidth);
        for (int i = 0; i < n; ++i) {
            WmiView wmiView = this.getChild(i);
            if (wmiView == null) continue;
            wmiInlineView.appendView(wmiView);
        }
        this.children = new WmiView[1];
        this.children[0] = wmiInlineView;
        wmiInlineView.setParentView(this);
        this.length = 1;
        wmiInlineView.layoutView();
        WmiParagraphView.recursiveResetObservers(this);
        this.doExplicitLinebreaks();
        if (!bl) {
            this.doImplicitLinebreaks();
        }
        WmiParagraphView.recursiveResetObservers(this);
        this.adjustVerticalPadding(this);
        this.pruneEmptyRows();
        WmiParagraphView.recursiveRegisterObservers(this);
        WmiParagraphView.recursiveAdjustInlines(this);
        this.resetNavigationLinks(this);
    }

    private void doExplicitLinebreaks() throws WmiNoReadAccessException {
        int n = 0;
        while (n < this.getChildCount()) {
            WmiPositionedView wmiPositionedView = (WmiPositionedView)this.getChild(n++);
            wmiPositionedView.doExplicitLinebreak(this);
        }
    }

    private void doImplicitLinebreaks() throws WmiNoReadAccessException {
        int n = 0;
        int n2 = this.firstLineIndent;
        while (n < this.getChildCount()) {
            WmiParagraphInlineView wmiParagraphInlineView;
            int n3;
            WmiPositionedView wmiPositionedView = (WmiPositionedView)this.getChild(n);
            if (wmiPositionedView instanceof WmiParagraphInlineView && (n3 = (wmiParagraphInlineView = (WmiParagraphInlineView)wmiPositionedView).getIndentLevel()) > 0) {
                n2 += this.spaceWidth * n3;
            }
            wmiPositionedView.layoutView();
            int n4 = 0;
            int n5 = n3 = wmiPositionedView instanceof WmiParagraphInlineView ? ((WmiParagraphInlineView)wmiPositionedView).getUnadjustedWidth() : this.getWidth();
            if (wmiPositionedView != null && n3 + n2 > this.breakWidth) {
                for (int i = 0; i < 3 && (n4 = wmiPositionedView.doImplicitLinebreak(this, n2, this.breakWidth, i)) == 0; ++i) {
                }
                if (n4 == 0) {
                    n4 = wmiPositionedView.doForcedLinebreak(this, n2, this.breakWidth);
                }
            }
            if (n4 == true) continue;
            ++n;
            n2 = 0;
        }
    }

    public WmiView split(WmiView wmiView, int n, int n2) throws WmiNoReadAccessException {
        WmiPositionedView wmiPositionedView = null;
        while (wmiView != this) {
            Object object;
            WmiView wmiView2;
            int n3;
            wmiPositionedView = null;
            WmiCompositeView wmiCompositeView = wmiView.getParentView();
            int n4 = n3 = wmiCompositeView != null ? wmiCompositeView.indexOf(wmiView) : -1;
            if (wmiView instanceof WmiTextView) {
                wmiView2 = (WmiTextView)wmiView;
                object = WmiTextFragmentView.splitTextView((WmiTextView)wmiView2, n, n2);
                if (object != null && n3 >= 0) {
                    wmiCompositeView.replaceChild(object[0], n3);
                    ((WmiGenericView)wmiView2).release();
                    object[0].setParentView(wmiCompositeView);
                    wmiPositionedView = object[1];
                    wmiCompositeView.markInvalid(1);
                }
            } else if (wmiView instanceof WmiCompositeView) {
                wmiView2 = (WmiCompositeView)wmiView;
                wmiPositionedView = (WmiPositionedView)wmiView2.splitView(n, n2);
                if (n3 >= 0 && wmiPositionedView != null) {
                    object = wmiCompositeView.getChild(n3);
                    wmiCompositeView.replaceChild(wmiPositionedView, n3);
                    wmiPositionedView = (WmiPositionedView)object;
                }
            }
            if (wmiPositionedView != null && n3 >= 0) {
                wmiCompositeView.insertView(wmiPositionedView, n3 + 1);
                wmiCompositeView.markInvalid(1);
            }
            if (wmiCompositeView != this) {
                ((WmiPositionedView)((Object)wmiCompositeView)).layoutView();
            }
            n = n3 + 1;
            wmiView = wmiCompositeView;
            n2 = 0;
        }
        return wmiPositionedView;
    }

    private void pruneEmptyRows() {
        int n = 0;
        while (n < this.getChildCount()) {
            WmiView wmiView = this.getChild(n);
            if (wmiView instanceof WmiInlineView && this.isEmpty((WmiCompositeView)wmiView)) {
                this.removeChild(n);
                continue;
            }
            ++n;
        }
    }

    private boolean isEmpty(WmiCompositeView wmiCompositeView) {
        WmiFencedView wmiFencedView;
        boolean bl = true;
        int n = wmiCompositeView.getChildCount();
        for (int i = 0; i < n; ++i) {
            WmiView wmiView = wmiCompositeView.getChild(i);
            if (wmiView instanceof WmiInlineView) {
                if (this.isEmpty((WmiCompositeView)wmiView)) continue;
                bl = false;
                break;
            }
            if (wmiView == null) continue;
            bl = false;
            break;
        }
        if (bl && wmiCompositeView instanceof WmiFencedView && ((wmiFencedView = (WmiFencedView)wmiCompositeView).getLeftBracket() != null || wmiFencedView.getRightBracket() != null)) {
            bl = false;
        }
        return bl;
    }

    private void adjustVerticalPadding(WmiCompositeView wmiCompositeView) throws WmiNoReadAccessException {
        int n = wmiCompositeView.getChildCount();
        for (int i = 0; i < n; ++i) {
            WmiView wmiView = wmiCompositeView.getChild(i);
            if (wmiView instanceof WmiFencedView || !(wmiView instanceof WmiCompositeView)) continue;
            this.adjustVerticalPadding((WmiCompositeView)wmiView);
        }
        if (!(wmiCompositeView instanceof WmiFencedView) && wmiCompositeView instanceof WmiInlineView) {
            WmiInlineView wmiInlineView = (WmiInlineView)wmiCompositeView;
            wmiInlineView.adjustVerticalLayout();
        }
    }

    private void resetNavigationLinks(WmiCompositeView wmiCompositeView) {
        if (wmiCompositeView instanceof WmiPositionedView) {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                WmiView wmiView = wmiCompositeView.getChild(i);
                if (wmiView instanceof WmiPositionedView) {
                    WmiPositionedView wmiPositionedView = (WmiPositionedView)wmiView;
                    wmiPositionedView.setNextView(null, 1);
                    wmiPositionedView.setNextView(null, 0);
                    wmiPositionedView.setNextView(null, 2);
                    wmiPositionedView.setNextView(null, 3);
                    wmiPositionedView.setNextView(null, -2);
                    wmiPositionedView.setNextView(null, -1);
                    wmiPositionedView.setNextView(null, -4);
                    wmiPositionedView.setNextView(null, -3);
                }
                if (!(wmiView instanceof WmiCompositeView)) continue;
                this.resetNavigationLinks((WmiCompositeView)wmiView);
            }
            ((WmiPositionedView)((Object)wmiCompositeView)).addNavigationLinks();
        }
    }

    private static void recursiveResetObservers(WmiView wmiView) {
        Object object;
        WmiModel wmiModel = wmiView.getModel();
        if (wmiModel != null) {
            object = wmiModel.getObserver();
            while (object != null) {
                WmiModelObserver wmiModelObserver = object.getNextObserver();
                if (object instanceof WmiView && ((WmiView)object).getDocumentView() == wmiView.getDocumentView()) {
                    wmiModel.releaseObserver((WmiModelObserver)object);
                }
                object = wmiModelObserver;
            }
        }
        if (wmiView instanceof WmiCompositeView) {
            object = (WmiCompositeView)wmiView;
            int n = object.getChildCount();
            for (int i = 0; i < n; ++i) {
                WmiView wmiView2 = object.getChild(i);
                if (!(wmiView2 instanceof WmiModelObserver)) continue;
                WmiParagraphView.recursiveResetObservers(wmiView2);
            }
        }
    }

    private static void recursiveRegisterObservers(WmiView wmiView) {
        WmiModel wmiModel = wmiView.getModel();
        if (wmiModel == null || wmiModel.getTag() != WmiModelTag.MATH_PHANTOM) {
            if (wmiModel != null && wmiView instanceof WmiModelObserver) {
                ((WmiModelObserver)((Object)wmiView)).registerObserver();
            }
            if (wmiView instanceof WmiCompositeView) {
                WmiCompositeView wmiCompositeView = (WmiCompositeView)wmiView;
                int n = wmiCompositeView.getChildCount();
                for (int i = 0; i < n; ++i) {
                    WmiView wmiView2 = wmiCompositeView.getChild(i);
                    if (!(wmiView2 instanceof WmiModelObserver)) continue;
                    WmiParagraphView.recursiveRegisterObservers(wmiView2);
                }
            }
        }
    }

    private static void recursiveAdjustInlines(WmiView wmiView) {
        if (wmiView instanceof WmiCompositeView) {
            WmiCompositeView wmiCompositeView = (WmiCompositeView)wmiView;
            int n = wmiCompositeView.getChildCount();
            if (wmiView instanceof WmiInlineView) {
                ((WmiInlineView)wmiView).removeChildShift();
            }
            for (int i = 0; i < n; ++i) {
                WmiView wmiView2 = wmiCompositeView.getChild(i);
                WmiParagraphView.recursiveAdjustInlines(wmiView2);
            }
        }
    }

    public boolean isStartOfLine(WmiView wmiView) {
        boolean bl = true;
        WmiCompositeView wmiCompositeView = wmiView.getParentView();
        while (wmiCompositeView != this) {
            WmiView wmiView2 = ((WmiPositionedView)((Object)wmiCompositeView)).getNextView(-4);
            if (wmiView2 == null) {
                wmiView2 = wmiCompositeView.getChild(0);
            }
            if (wmiView2 != wmiView) {
                bl = false;
                break;
            }
            wmiView = wmiCompositeView;
            wmiCompositeView = wmiView.getParentView();
        }
        return bl;
    }

    public int getSpaceAbove() throws WmiNoReadAccessException {
        return this.getIntAttribute("spaceabove");
    }

    public int getSpaceBelow() throws WmiNoReadAccessException {
        return this.getIntAttribute("spacebelow");
    }

    public int getLeftMargin() throws WmiNoReadAccessException {
        return this.getIntAttribute("leftmargin");
    }

    public int getRightMargin() throws WmiNoReadAccessException {
        return this.getIntAttribute("rightmargin");
    }

    public int getIntAttribute(Object object) throws WmiNoReadAccessException {
        int n = 0;
        Object object2 = this.getAttribute(object);
        if (object2 instanceof Integer) {
            n = (Integer)object2;
        } else if (object2 != null) {
            n = Integer.parseInt(object2.toString());
        }
        return n;
    }

    public Object getAttribute(Object object) throws WmiNoReadAccessException {
        WmiModel wmiModel = this.getModel();
        WmiAttributeSet wmiAttributeSet = wmiModel != null ? wmiModel.getAttributesForRead() : null;
        return wmiAttributeSet != null ? wmiAttributeSet.getAttribute(object) : null;
    }

    public WmiInlineView createRow(WmiModel wmiModel, int n) {
        return new WmiParagraphInlineView(wmiModel, this.getDocumentView());
    }

    public static final class WmiBreakInfo {
        public WmiPositionedView view;
        public String activeText = null;
        public int breakPoint;
        public int nextStart;
        public int width;
        public int nextWidth;
        public int breakWidth;
        public boolean explicitBreaksOnly;
        public boolean forcedBreak;
        public boolean longBreak;

        public WmiBreakInfo(boolean bl) {
            this.update(null, 0, -1, 0, 0, false, false);
            this.breakWidth = 0;
            this.explicitBreaksOnly = bl;
        }

        public void update(WmiPositionedView wmiPositionedView, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
            this.view = wmiPositionedView;
            this.breakPoint = n;
            this.nextStart = n2;
            this.width = n3;
            this.nextWidth = n4;
            this.forcedBreak = bl;
            this.longBreak = bl2;
        }
    }

    public class WmiParagraphInlineView
    extends WmiInlineView {
        boolean mathMode;
        int mathIndentLevel;
        int unadjustedWidth;

        private WmiParagraphInlineView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            super(wmiModel, wmiMathDocumentView);
            this.unadjustedWidth = -1;
            this.mathMode = false;
            this.mathIndentLevel = 0;
        }

        public String getDebugName() {
            return WmiParagraphView.DEBUG_ROW_NAME;
        }

        public void registerObserver() {
        }

        public void setMathMode() {
            this.mathMode = true;
            this.mathIndentLevel = 0;
        }

        public void setTextMode() {
            this.mathMode = false;
            this.mathIndentLevel = 0;
        }

        public void incrementIndentLevel() {
            ++this.mathIndentLevel;
        }

        public void decrementIndentLevel() {
            if (this.mathIndentLevel > 0) {
                --this.mathIndentLevel;
            }
        }

        public WmiView splitView(int n, int n2) {
            WmiView wmiView = super.splitView(n, n2);
            if (this.isMathMode()) {
                int n3;
                boolean bl = false;
                WmiView wmiView2 = this;
                while (wmiView2 instanceof WmiCompositeView && (n3 = ((WmiCompositeView)wmiView2).getChildCount()) > 0) {
                    WmiModel wmiModel;
                    WmiView wmiView3 = ((WmiCompositeView)wmiView2).getChild(0);
                    WmiModel wmiModel2 = wmiModel = wmiView3 != null ? wmiView3.getModel() : null;
                    if (wmiModel.getTag() == WmiModelTag.MATH) {
                        bl = true;
                    }
                    wmiView2 = wmiView3;
                }
                if (bl) {
                    if (this.mathIndentLevel == 0) {
                        this.incrementIndentLevel();
                    }
                } else {
                    this.setTextMode();
                }
            }
            return wmiView;
        }

        public int getIndentLevel() {
            return this.mathMode ? this.mathIndentLevel : 0;
        }

        public boolean isMathMode() {
            return this.mathMode;
        }

        public void layoutView() throws WmiNoReadAccessException {
            if (!this.isLayoutValid()) {
                super.layoutView();
                if (this.mathMode && this.getChildCount() > 0 && this.width < WmiParagraphView.this.breakWidth) {
                    this.unadjustedWidth = this.width;
                    this.width = WmiParagraphView.this.breakWidth;
                }
            }
        }

        public void updateLayout(boolean bl) {
            if (!this.isLayoutValid()) {
                super.updateLayout(bl);
                if (bl && this.mathIndentLevel == 0) {
                    this.mathIndentLevel = 1;
                }
                if (this.mathMode && this.getChildCount() > 0 && this.width < WmiParagraphView.this.breakWidth) {
                    this.unadjustedWidth = this.width;
                    this.width = WmiParagraphView.this.breakWidth;
                }
            }
        }

        protected int getChildShiftAdjustment() {
            return this.mathMode ? WmiParagraphView.this.spaceWidth * this.mathIndentLevel : 0;
        }

        protected int getUnadjustedWidth() {
            return this.unadjustedWidth >= 0 ? this.unadjustedWidth : this.width;
        }
    }
}

