/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiTextLayout;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiMathStyleModel;
import com.maplesoft.mathdoc.view.WmiAdjustableTextBounds;
import com.maplesoft.mathdoc.view.WmiArrayCompositeView;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiResizableContainerView;
import com.maplesoft.mathdoc.view.WmiTextAdjustmentUtils;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiFencedView;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.WmiMathSpaceView;
import com.maplesoft.mathdoc.view.math.WmiMathTextView;
import com.maplesoft.mathdoc.view.math.renderers.WmiIntegralRenderer;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class WmiInlineView
extends WmiArrayCompositeView
implements WmiPositionedView,
WmiAdjustableTextBounds {
    public static final int LEFT_INDENT = 0;
    public static final int RIGHT_INDENT = 1;
    public static final int TOP_INDENT = 2;
    public static final int BOTTOM_INDENT = 3;
    private static final int PAD_DIRECTIONS = 4;
    private int[] insets = null;
    private boolean useMathRules = false;
    private boolean resizeStretchyOps = false;
    private int childShift = 0;
    private int baselineAdjust = 0;
    private boolean containsBreakHints = false;
    private boolean elideOnBreak = false;

    public WmiInlineView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        super(wmiModel, wmiMathDocumentView);
    }

    public void draw(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle) {
        wmiRenderPath.push(this.x - this.childShift, this.y);
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            WmiPositionedView wmiPositionedView = (WmiPositionedView)this.getChild(i);
            if (wmiPositionedView != null) {
                wmiPositionedView.draw(graphics, wmiRenderPath, rectangle);
            }
            wmiRenderPath.next();
        }
        wmiRenderPath.pop();
    }

    public void layoutView() throws WmiNoReadAccessException {
        if (this.useMathRules) {
            this.layoutViewForMath();
        } else {
            this.layoutViewForText();
        }
    }

    public void setBaselineAdjustment(int n) {
        this.baselineAdjust = n;
    }

    public void updateLayout(boolean bl) {
        int n = this.getChildCount();
        this.childShift = 0;
        WmiPositionedView wmiPositionedView = null;
        WmiPositionedView wmiPositionedView2 = null;
        if (n > 0) {
            wmiPositionedView = (WmiPositionedView)this.getChild(0);
            wmiPositionedView2 = (WmiPositionedView)this.getChild(n - 1);
            this.childShift = wmiPositionedView.getHorizontalOffset() - this.getPadding(0);
            this.width = wmiPositionedView2.getHorizontalOffset() + wmiPositionedView2.getWidth() - this.childShift;
        } else {
            this.width = 0;
        }
        if (wmiPositionedView != null) {
            wmiPositionedView.setNextView(null, 2);
            this.setNextView(wmiPositionedView, -4);
        }
        if (wmiPositionedView2 != null) {
            wmiPositionedView2.setNextView(null, 3);
            this.setNextView(wmiPositionedView2, -3);
        }
        this.markValid(1);
    }

    public void removeChildShift() {
        this.childShift -= this.getChildShiftAdjustment();
        if (this.childShift != 0) {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                WmiPositionedView wmiPositionedView = (WmiPositionedView)this.getChild(i);
                wmiPositionedView.setHorizontalOffset(wmiPositionedView.getHorizontalOffset() - this.childShift);
            }
            this.childShift = 0;
        }
    }

    protected int getChildShiftAdjustment() {
        return 0;
    }

    public WmiView splitView(int n, int n2) {
        WmiInlineView wmiInlineView = (WmiInlineView)super.splitView(n, n2);
        this.updateLayout(true);
        wmiInlineView.updateLayout(false);
        return wmiInlineView;
    }

    public void addNavigationLinks() {
        WmiPositionedView wmiPositionedView;
        int n;
        int n2 = this.getChildCount();
        for (n = 0; n < n2 - 1; ++n) {
            wmiPositionedView = (WmiPositionedView)this.getChild(n);
            if (!wmiPositionedView.isNavagableView()) continue;
            int n3 = n + 1;
            WmiPositionedView wmiPositionedView2 = (WmiPositionedView)this.getChild(n3);
            while (wmiPositionedView2 == null || !wmiPositionedView2.isNavagableView()) {
                if (++n3 < n2) {
                    wmiPositionedView2 = (WmiPositionedView)this.getChild(n3);
                    continue;
                }
                wmiPositionedView2 = null;
                break;
            }
            wmiPositionedView.setNextView(wmiPositionedView2, 3);
            if (wmiPositionedView2 == null) continue;
            wmiPositionedView2.setNextView(wmiPositionedView, 2);
        }
        if (n2 > 0) {
            ((WmiPositionedView)this.getChild(0)).setNextView(null, 2);
            ((WmiPositionedView)this.getChild(n2 - 1)).setNextView(null, 3);
        }
        n = 0;
        wmiPositionedView = null;
        WmiPositionedView wmiPositionedView3 = null;
        for (int i = 0; i < n2; ++i) {
            WmiPositionedView wmiPositionedView4 = (WmiPositionedView)this.getChild(i);
            if (!wmiPositionedView4.isNavagableView()) continue;
            if (n == 0) {
                wmiPositionedView = wmiPositionedView4;
                n = 1;
            }
            wmiPositionedView3 = wmiPositionedView4;
        }
        if (wmiPositionedView != null) {
            wmiPositionedView.setNextView(null, 2);
            this.setNextView(wmiPositionedView, -4);
        }
        if (wmiPositionedView3 != null) {
            wmiPositionedView3.setNextView(null, 3);
            this.setNextView(wmiPositionedView3, -3);
        }
    }

    public void setPositionMarker(int n) {
        try {
            if (n == 0) {
                WmiView wmiView = this.getChild(0);
                if (wmiView != null && wmiView instanceof WmiTraversableView) {
                    ((WmiTraversableView)wmiView).setPositionMarker(0);
                } else {
                    WmiTextView wmiTextView = (WmiTextView)WmiViewUtil.findFirstDescendantOfClass(this, WmiTextView.class);
                    if (wmiTextView != null) {
                        wmiTextView.setPositionMarker(0);
                    }
                }
            } else {
                WmiView wmiView = this.getChild(this.getChildCount() - 1);
                if (wmiView != null && wmiView instanceof WmiTraversableView) {
                    ((WmiTraversableView)wmiView).setPositionMarker(-1);
                } else {
                    WmiTextView wmiTextView = (WmiTextView)WmiViewUtil.findLastDescendantOfClass(this, WmiTextView.class);
                    if (wmiTextView != null) {
                        int n2 = wmiTextView.getLength();
                        wmiTextView.setPositionMarker(n2);
                    }
                }
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
    }

    public void setPadding(int n, int n2) {
        if (this.insets == null) {
            this.insets = new int[4];
        }
        if (n2 >= 0 && n2 < 4) {
            this.insets[n2] = n;
        }
    }

    public int getPadding(int n) {
        int n2 = 0;
        if (this.insets != null && n >= 0 && n < 4) {
            n2 = this.insets[n];
        }
        return n2;
    }

    public WmiPositionedView getNearestChildView(Point point) {
        return this.getNearestChildView(point, 2);
    }

    public WmiPositionedView getViewForNavigation(int n, Point point) {
        WmiPositionedView wmiPositionedView = this.getNextView(n);
        if (wmiPositionedView == null) {
            wmiPositionedView = this.getNearestChildView(point);
        }
        if (wmiPositionedView == null || !wmiPositionedView.isNavagableView()) {
            int n2 = n * -1 - 1;
            wmiPositionedView = this.getNextView(n2);
        }
        return wmiPositionedView;
    }

    public void layoutViewForText() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            WmiPositionedView wmiPositionedView;
            int n;
            this.childShift = 0;
            this.width = this.getPadding(0);
            this.height = 0;
            this.baseline = 0;
            int n2 = 0;
            int n3 = 0;
            this.addNavigationLinks();
            int n4 = this.getChildCount();
            for (n = 0; n < n4; ++n) {
                WmiPositionedView wmiPositionedView2 = (WmiPositionedView)this.getChild(n);
                if (wmiPositionedView2 == null) continue;
                wmiPositionedView2.layoutView();
            }
            boolean bl = false;
            for (n = 0; n < n4; ++n) {
                WmiPositionedView wmiPositionedView3;
                wmiPositionedView = (WmiPositionedView)this.getChild(n);
                WmiPositionedView wmiPositionedView4 = wmiPositionedView3 = n < n4 - 1 ? (WmiPositionedView)this.getChild(n + 1) : null;
                if (wmiPositionedView == null) continue;
                if (wmiPositionedView instanceof WmiTextView) {
                    Object object;
                    WmiTextView wmiTextView = (WmiTextView)wmiPositionedView;
                    if (wmiPositionedView3 instanceof WmiTextView) {
                        object = wmiTextView;
                        WmiTextView wmiTextView2 = (WmiTextView)wmiPositionedView3;
                        if (((WmiTextView)object).getAdjustedBaseline() > wmiTextView2.getAdjustedBaseline()) {
                            ((WmiTextView)object).applyKerningAdjustment(bl, true);
                            bl = true;
                        } else {
                            ((WmiTextView)object).applyKerningAdjustment(bl, false);
                            bl = false;
                        }
                    } else {
                        wmiTextView.applyKerningAdjustment(bl, true);
                        bl = true;
                    }
                    object = wmiTextView.getLayout();
                    if (object != null && ((WmiTextLayout)object).containsTabs()) {
                        ((WmiTextLayout)object).setHorizontalOffset(this.width);
                    }
                }
                int n5 = wmiPositionedView.getWidth();
                int n6 = wmiPositionedView.getHeight();
                int n7 = wmiPositionedView.getBaseline();
                if (this.shouldConstrainChildPrintSize(wmiPositionedView)) {
                    float f = ((WmiResizableContainerView)wmiPositionedView).getConstrainedSizeRatio();
                    n5 = (int)((float)n5 * f);
                    n6 = (int)((float)n6 * f);
                    n7 = (int)((float)n7 * f);
                }
                n2 = n6 - n7;
                if (n7 > this.baseline) {
                    this.baseline = n7;
                }
                if (n2 > n3) {
                    n3 = n2;
                }
                wmiPositionedView.setHorizontalOffset(this.width);
                this.width += n5;
            }
            this.baseline += this.baselineAdjust + this.getPadding(2);
            this.height = this.baseline + n3 + this.getPadding(3);
            for (n = 0; n < n4; ++n) {
                wmiPositionedView = (WmiPositionedView)this.getChild(n);
                if (wmiPositionedView == null) continue;
                int n8 = wmiPositionedView.getBaseline();
                if (this.shouldConstrainChildPrintSize(wmiPositionedView)) {
                    float f = ((WmiResizableContainerView)wmiPositionedView).getConstrainedSizeRatio();
                    n8 = (int)((float)n8 * f);
                }
                wmiPositionedView.setVerticalOffset(this.baseline - this.baselineAdjust - n8);
            }
            this.width += this.getPadding(1);
            super.layoutView();
        }
    }

    private boolean shouldConstrainChildPrintSize(WmiPositionedView wmiPositionedView) {
        boolean bl = false;
        if (this.getDocumentView().isPrintView() && wmiPositionedView instanceof WmiResizableContainerView) {
            WmiResizableContainerView wmiResizableContainerView = (WmiResizableContainerView)wmiPositionedView;
            bl = wmiResizableContainerView.shouldConstrainPrintSize();
        }
        return bl;
    }

    public void layoutViewForMath() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            this.childShift = 0;
            if (this.resizeStretchyOps) {
                int n;
                int n2 = this.getChildCount();
                for (n = 0; n < n2; ++n) {
                    WmiView wmiView = this.getChild(n);
                    if (wmiView instanceof WmiMathOperatorView) {
                        ((WmiMathOperatorView)wmiView).resetStretchy();
                        continue;
                    }
                    if (this.containsBreakHints || !(wmiView instanceof WmiMathSpaceView)) continue;
                    this.containsBreakHints = WmiMathSpaceView.isCandidateExplicitBreakSpace((WmiMathSpaceView)wmiView);
                }
                this.validateChildren();
                this.addNavigationLinks();
                this.layoutMathRow();
                boolean bl = false;
                for (n = 0; n < n2; ++n) {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    WmiView wmiView = this.getChild(n);
                    if (wmiView instanceof WmiMathOperatorView) {
                        object4 = (WmiMathOperatorView)wmiView;
                        if (((WmiMathOperatorView)object4).layoutStretchView(this.height)) {
                            bl = true;
                            ((WmiGenericView)object4).setBaseline(this.getBaseline());
                        }
                    } else {
                        object4 = wmiView.getModel();
                        Object object5 = object3 = object4 != null ? object4.getTag() : null;
                        if (object3 == WmiModelTag.MATH_SUB_SUP || object3 == WmiModelTag.MATH_SUBSCRIPT || object3 == WmiModelTag.MATH_SUPERSCRIPT) {
                            int n3;
                            WmiMathOperatorView wmiMathOperatorView;
                            WmiView wmiView2 = ((WmiCompositeView)wmiView).getChild(0);
                            object2 = wmiView2 != null ? wmiView2.getModel() : null;
                            Object object6 = object = object2 != null ? object2.getTag() : null;
                            if (object == WmiModelTag.MATH_STYLE && ((WmiCompositeView)wmiView2).getChildCount() == 1) {
                                wmiView2 = ((WmiCompositeView)wmiView2).getChild(0);
                            }
                            if (wmiView2 instanceof WmiMathOperatorView && (wmiMathOperatorView = (WmiMathOperatorView)wmiView2).layoutStretchView(n3 = wmiMathOperatorView.getHeight())) {
                                bl = true;
                                wmiMathOperatorView.setBaseline(this.getBaseline());
                                if (wmiMathOperatorView.getHeight() != n3) {
                                    ((WmiGenericView)wmiView).markInvalid(1);
                                    if (wmiMathOperatorView.getParentView() != wmiView) {
                                        ((WmiGenericView)((Object)wmiMathOperatorView.getParentView())).markInvalid(1);
                                    }
                                    ((WmiPositionedView)wmiView).layoutView();
                                }
                            }
                        }
                    }
                    if (!(wmiView instanceof WmiInlineView) || !((object4 = WmiViewUtil.findFirstDescendantOfTag(wmiView, WmiModelTag.MATH_OPERATOR)) instanceof WmiMathOperatorView)) continue;
                    object3 = (WmiMathOperatorView)object4;
                    boolean bl2 = true;
                    for (object2 = ((WmiGenericView)object3).getParentView(); object2 != this; object2 = object2.getParentView()) {
                        if (object2 instanceof WmiInlineView && object2.getModel() instanceof WmiMathStyleModel) continue;
                        bl2 = false;
                        break;
                    }
                    if (!bl2) continue;
                    if (((WmiMathOperatorView)object3).layoutStretchView(this.height)) {
                        bl = true;
                        ((WmiGenericView)object3).setBaseline(this.getBaseline());
                    }
                    for (object2 = ((WmiGenericView)object3).getParentView(); object2 != this; object2 = object2.getParentView()) {
                        if (!(object2 instanceof WmiInlineView)) continue;
                        object = (WmiInlineView)object2;
                        ((WmiGenericView)object).setWidth(((WmiMathOperatorView)object3).getWidth());
                        ((WmiGenericView)object).setHeight(((WmiMathOperatorView)object3).getHeight());
                        ((WmiGenericView)object).setBaseline(((WmiMathOperatorView)object3).getBaseline());
                    }
                }
                if (bl) {
                    this.layoutMathRow();
                }
            } else {
                this.layoutMathRow();
            }
            if (this.height == 0) {
                WmiMathTextView.setDefaultHeight(this);
            }
            this.markValid(1);
            this.checkRepaint();
        }
    }

    public void layoutMathRow() throws WmiNoReadAccessException {
        WmiPositionedView wmiPositionedView;
        WmiModelTag wmiModelTag;
        int n;
        this.width = this.getPadding(0);
        this.height = 0;
        this.baseline = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getChildCount();
        for (n = 0; n < n4; ++n) {
            WmiPositionedView wmiPositionedView2 = (WmiPositionedView)this.getChild(n);
            if (wmiPositionedView2 == null) continue;
            wmiPositionedView2.layoutView();
        }
        boolean bl = false;
        boolean bl2 = false;
        int n5 = 0;
        WmiModel wmiModel = this.getModel();
        WmiCompositeModel wmiCompositeModel = wmiModel != null ? wmiModel.getParent() : null;
        WmiModelTag wmiModelTag2 = wmiModelTag = wmiCompositeModel != null ? wmiCompositeModel.getTag() : null;
        if (wmiModelTag == WmiModelTag.MATH_FENCED) {
            bl = true;
        }
        for (n = 0; n < n4; ++n) {
            wmiPositionedView = (WmiPositionedView)this.getChild(n);
            if (wmiPositionedView == null || !wmiPositionedView.isLayoutValid()) continue;
            int n6 = wmiPositionedView.getWidth();
            if (wmiPositionedView instanceof WmiMathOperatorView) {
                if (n6 > 0) {
                    WmiMathOperatorView wmiMathOperatorView = (WmiMathOperatorView)wmiPositionedView;
                    bl = wmiMathOperatorView.forcePreKernAdjustment();
                    bl2 = wmiMathOperatorView.forcePostKernAdjustment();
                    if (bl2 && n5 > 0) {
                        this.width += n5;
                        n5 = 0;
                    }
                }
            } else if (wmiPositionedView instanceof WmiFencedView) {
                bl = true;
                bl2 = true;
                if (n5 > 0) {
                    this.width += n5;
                    n5 = 0;
                }
            } else if (n6 > 0 && bl && wmiPositionedView instanceof WmiAdjustableTextBounds) {
                this.width += ((WmiAdjustableTextBounds)((Object)wmiPositionedView)).computePreKernAdjustment();
                bl2 = false;
                bl = false;
            }
            n2 = wmiPositionedView.getHeight() - wmiPositionedView.getBaseline();
            if (wmiPositionedView.getBaseline() > this.baseline) {
                this.baseline = wmiPositionedView.getBaseline();
            }
            if (n2 > n3) {
                n3 = n2;
            }
            wmiPositionedView.setHorizontalOffset(this.width);
            this.width += n6;
            if (n6 <= 0 || !(wmiPositionedView instanceof WmiAdjustableTextBounds)) continue;
            n5 = ((WmiAdjustableTextBounds)((Object)wmiPositionedView)).computePostKernAdjustment();
        }
        if (wmiModelTag == WmiModelTag.MATH_FENCED) {
            this.width += n5;
        }
        this.baseline += this.baselineAdjust + this.getPadding(2);
        this.height = this.baseline + n3 + this.getPadding(3);
        for (n = 0; n < n4; ++n) {
            wmiPositionedView = (WmiPositionedView)this.getChild(n);
            if (wmiPositionedView == null) continue;
            wmiPositionedView.setVerticalOffset(this.baseline - wmiPositionedView.getBaseline());
        }
        this.width += this.getPadding(1);
    }

    public void applyMathRules(boolean bl) {
        this.useMathRules = bl;
    }

    public void lockOperatorSize(boolean bl) {
        this.resizeStretchyOps = !bl;
    }

    public void invalidate(int n) {
        super.invalidate(n);
        if (this.useMathRules && n == 1 && this.resizeStretchyOps && this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                WmiView wmiView = this.children[i];
                if (!(wmiView instanceof WmiMathOperatorView)) continue;
                wmiView.invalidate(n);
            }
        }
    }

    public int computePreKernAdjustment() {
        int n = 0;
        int n2 = this.getChildCount();
        if (n2 > 0) {
            int n3 = 0;
            WmiPositionedView wmiPositionedView = (WmiPositionedView)this.getChild(0);
            if (wmiPositionedView.getWidth() == 0 && n2 > 1) {
                n3 = 1;
            }
            n = WmiTextAdjustmentUtils.computePreKernAdjustment(this, n3);
        }
        return n;
    }

    public int computePostKernAdjustment() {
        int n = 0;
        int n2 = this.getChildCount();
        if (n2 > 0) {
            int n3 = n2 - 1;
            WmiPositionedView wmiPositionedView = (WmiPositionedView)this.getChild(n3);
            if (wmiPositionedView.getWidth() == 0 && n3 > 0) {
                --n3;
            }
            n = WmiTextAdjustmentUtils.computePostKernAdjustment(this, n3);
        }
        return n;
    }

    public int computeSpaceAbove() {
        int n = this.getChildCount();
        int n2 = this.getHeight();
        for (int i = 0; i < n; ++i) {
            WmiView wmiView = this.getChild(i);
            if (!(wmiView instanceof WmiPositionedView)) continue;
            WmiPositionedView wmiPositionedView = (WmiPositionedView)wmiView;
            int n3 = wmiPositionedView.getVerticalOffset();
            if (wmiView instanceof WmiAdjustableTextBounds) {
                n3 += ((WmiAdjustableTextBounds)((Object)wmiView)).computeSpaceAbove();
            }
            if (n3 >= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public int computeSpaceBelow() {
        int n = this.getChildCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            WmiView wmiView = this.getChild(i);
            if (!(wmiView instanceof WmiPositionedView)) continue;
            WmiPositionedView wmiPositionedView = (WmiPositionedView)wmiView;
            int n3 = wmiPositionedView.getHeight();
            if (this.shouldConstrainChildPrintSize(wmiPositionedView)) {
                float f = ((WmiResizableContainerView)wmiPositionedView).getConstrainedSizeRatio();
                n3 = (int)((float)n3 * f);
            }
            int n4 = wmiPositionedView.getVerticalOffset() + n3;
            if (wmiView instanceof WmiAdjustableTextBounds) {
                n4 -= ((WmiAdjustableTextBounds)((Object)wmiView)).computeSpaceBelow();
            }
            if (n4 <= n2) continue;
            n2 = n4;
        }
        return this.getHeight() - n2;
    }

    public int doExplicitLinebreak(WmiParagraphView wmiParagraphView) throws WmiNoReadAccessException {
        WmiPositionedView wmiPositionedView;
        int n = 0;
        int n2 = this.getChildCount();
        for (int i = 0; i < n2 && (n = (wmiPositionedView = (WmiPositionedView)this.getChild(i)).doExplicitLinebreak(wmiParagraphView)) == 0; ++i) {
        }
        return n;
    }

    public int doForcedLinebreak(WmiParagraphView wmiParagraphView, int n, int n2) throws WmiNoReadAccessException {
        WmiPositionedView wmiPositionedView;
        int n3;
        int n4 = 0;
        int n5 = this.findSpanningView(n, n2);
        if (n5 >= 0 && (n3 = (wmiPositionedView = (WmiPositionedView)this.getChild(n5)).getHorizontalOffset() - this.childShift) >= 0) {
            n4 = wmiPositionedView.doForcedLinebreak(wmiParagraphView, n + n3, n2);
        }
        return n4;
    }

    public int doImplicitLinebreak(WmiParagraphView wmiParagraphView, int n, int n2, int n3) throws WmiNoReadAccessException {
        int n4;
        int n5;
        WmiView wmiView;
        WmiParagraphView.WmiParagraphInlineView wmiParagraphInlineView;
        int n6 = 0;
        WmiModel wmiModel = this.getModel();
        if (wmiModel != null && this.getChildCount() > 0 && wmiModel.getTag() == WmiModelTag.MATH && (wmiParagraphInlineView = (WmiParagraphView.WmiParagraphInlineView)WmiViewUtil.findAncestorOfClass(this, WmiParagraphView.WmiParagraphInlineView.class)) != null && !wmiParagraphInlineView.isMathMode()) {
            wmiView = this.getParentView();
            n5 = wmiView != null ? wmiView.indexOf(this) : -1;
            WmiView wmiView2 = null;
            if (n5 >= 0 && this.getWidth() > n2) {
                wmiParagraphView.split(wmiView, n5 + 1, 0);
            }
            int n7 = n5 = (wmiView = this.getParentView()) != null ? wmiView.indexOf(this) : -1;
            if (n5 >= 0) {
                wmiView2 = wmiParagraphView.split(wmiView, n5, 0);
            }
            if (wmiView2 instanceof WmiParagraphView.WmiParagraphInlineView) {
                ((WmiParagraphView.WmiParagraphInlineView)wmiView2).setMathMode();
            }
            n6 = 2;
        }
        if (n6 == 0 && this.containsBreakHints && WmiMathSpaceView.breakAtAllNewlines(wmiParagraphView, this, n2)) {
            n6 = 1;
        }
        if (n6 == 0 && (n4 = this.findSpanningView(n, n2)) >= 0) {
            wmiView = (WmiPositionedView)this.getChild(n4);
            n5 = wmiView.getHorizontalOffset() - this.childShift;
            n6 = wmiView.doImplicitLinebreak(wmiParagraphView, n + n5, n2, n3);
            while (n6 == 0 && n4 > 0) {
                n6 = this.breakAtDelimiter(wmiParagraphView, n4);
                if (n6 != 0) continue;
                wmiView = (WmiPositionedView)this.getChild(--n4);
                n5 = wmiView.getHorizontalOffset() - this.childShift;
                n6 = wmiView.doImplicitLinebreak(wmiParagraphView, n + n5, n2, n3);
            }
        }
        return n6;
    }

    protected int breakAtDelimiter(WmiParagraphView wmiParagraphView, int n) throws WmiNoReadAccessException {
        return 0;
    }

    public boolean hasGoodBreakpoint(int n, int n2, int n3) throws WmiNoReadAccessException {
        boolean bl = false;
        int n4 = this.findSpanningView(n, n2);
        if (n4 >= 0) {
            WmiPositionedView wmiPositionedView = (WmiPositionedView)this.getChild(n4);
            int n5 = wmiPositionedView.getHorizontalOffset() - this.childShift;
            bl = wmiPositionedView.hasGoodBreakpoint(n + n5, n2, n3);
            while (!bl && n4 > 0) {
                wmiPositionedView = (WmiPositionedView)this.getChild(--n4);
                n5 = wmiPositionedView.getHorizontalOffset();
                bl = wmiPositionedView.hasGoodBreakpoint(n + n5, n2, n3);
            }
        }
        return bl;
    }

    protected int findSpanningView(int n, int n2) {
        int n3 = this.getChildCount();
        int n4 = -1;
        if ((n -= this.childShift) < n2) {
            for (int i = 0; i < n3; ++i) {
                WmiPositionedView wmiPositionedView = (WmiPositionedView)this.getChild(i);
                if (wmiPositionedView.getHorizontalOffset() + n > n2) {
                    n4 = i - 1;
                    break;
                }
                if (wmiPositionedView.getHorizontalOffset() + wmiPositionedView.getWidth() + n > n2) {
                    n4 = i;
                    break;
                }
                if (i != n3 - 1) continue;
                n4 = i;
            }
        }
        return n4;
    }

    public void centerInline(int n) {
        WmiView wmiView;
        int n2 = 0;
        int n3 = this.getChildCount();
        if (n3 > 0 && (wmiView = this.getChild(n3 - 1)) instanceof WmiPositionedView) {
            WmiPositionedView wmiPositionedView = (WmiPositionedView)wmiView;
            n2 = wmiPositionedView.getHorizontalOffset() + wmiPositionedView.getWidth() - this.childShift;
        }
        if (n2 < n) {
            this.childShift -= (n - n2) / 2;
        }
    }

    public void adjustVerticalLayout() throws WmiNoReadAccessException {
        int n;
        WmiPositionedView wmiPositionedView;
        int n2;
        if (this.usesIntegralRenderers()) {
            return;
        }
        this.height = 0;
        this.baseline = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getChildCount();
        for (n2 = 0; n2 < n5; ++n2) {
            wmiPositionedView = (WmiPositionedView)this.getChild(n2);
            n = wmiPositionedView.getHeight();
            int n6 = wmiPositionedView.getBaseline();
            if (this.shouldConstrainChildPrintSize(wmiPositionedView)) {
                float f = ((WmiResizableContainerView)wmiPositionedView).getConstrainedSizeRatio();
                n = (int)((float)n * f);
                n6 = (int)((float)n6 * f);
            }
            n3 = n - n6;
            if (n6 > this.baseline) {
                this.baseline = n6;
            }
            if (n3 <= n4) continue;
            n4 = n3;
        }
        this.baseline += this.baselineAdjust + this.getPadding(2);
        this.height = this.baseline + n4 + this.getPadding(3);
        for (n2 = 0; n2 < n5; ++n2) {
            wmiPositionedView = (WmiPositionedView)this.getChild(n2);
            if (wmiPositionedView == null) continue;
            n = wmiPositionedView.getBaseline();
            if (this.shouldConstrainChildPrintSize(wmiPositionedView)) {
                float f = ((WmiResizableContainerView)wmiPositionedView).getConstrainedSizeRatio();
                n = (int)((float)n * f);
            }
            wmiPositionedView.setVerticalOffset(this.baseline - this.baselineAdjust - n);
        }
    }

    private boolean usesIntegralRenderers() throws WmiNoReadAccessException {
        boolean bl = false;
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            WmiMathOperatorView wmiMathOperatorView;
            WmiModelTag wmiModelTag;
            WmiModelTag wmiModelTag2;
            Object object;
            WmiView wmiView = this.getChild(i);
            if (wmiView instanceof WmiMathOperatorView) {
                object = (WmiMathOperatorView)wmiView;
                if (!(((WmiMathOperatorView)object).getRenderer() instanceof WmiIntegralRenderer)) continue;
                bl = true;
                break;
            }
            object = wmiView.getModel();
            WmiModelTag wmiModelTag3 = wmiModelTag2 = object != null ? object.getTag() : null;
            if (wmiModelTag2 != WmiModelTag.MATH_SUB_SUP && wmiModelTag2 != WmiModelTag.MATH_SUBSCRIPT && wmiModelTag2 != WmiModelTag.MATH_SUPERSCRIPT) continue;
            WmiView wmiView2 = ((WmiCompositeView)wmiView).getChild(0);
            WmiModel wmiModel = wmiView2 != null ? wmiView2.getModel() : null;
            WmiModelTag wmiModelTag4 = wmiModelTag = wmiModel != null ? wmiModel.getTag() : null;
            if (wmiModelTag == WmiModelTag.MATH_STYLE && ((WmiCompositeView)wmiView2).getChildCount() == 1) {
                wmiView2 = ((WmiCompositeView)wmiView2).getChild(0);
            }
            if (!(wmiView2 instanceof WmiMathOperatorView) || !((wmiMathOperatorView = (WmiMathOperatorView)wmiView2).getRenderer() instanceof WmiIntegralRenderer)) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

