/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewPathInterval;
import java.util.HashSet;
import java.util.Iterator;

public class WmiAggregateSelection
implements WmiSelection {
    private WmiMathDocumentView docView = null;
    private HashSet views = new HashSet();
    private HashSet selections = new HashSet();

    public WmiAggregateSelection(WmiMathDocumentView wmiMathDocumentView) {
        this.docView = wmiMathDocumentView;
    }

    public int contains(WmiView wmiView) {
        int n = 0;
        if (this.views.contains(wmiView)) {
            n = 2;
        } else {
            Iterator iterator = this.selections.iterator();
            block4: while (iterator.hasNext()) {
                WmiSelection wmiSelection = (WmiSelection)iterator.next();
                switch (wmiSelection.contains(wmiView)) {
                    case 2: {
                        n = 2;
                        break block4;
                    }
                    case 1: {
                        n = 1;
                    }
                    default: {
                        continue block4;
                    }
                }
            }
        }
        return n;
    }

    public boolean contains(WmiView wmiView, int n) {
        return false;
    }

    public int contains(WmiViewPath wmiViewPath) {
        WmiSelection wmiSelection;
        int n = 0;
        Iterator iterator = this.selections.iterator();
        while (iterator.hasNext()) {
            wmiSelection = (WmiSelection)iterator.next();
            switch (wmiSelection.contains(wmiViewPath)) {
                case 2: {
                    return 2;
                }
                case 1: {
                    n = 1;
                    break;
                }
            }
        }
        if (n == 0) {
            iterator = this.views.iterator();
            wmiSelection = new WmiViewPathInterval(this.docView, wmiViewPath, wmiViewPath);
            while (iterator.hasNext()) {
                WmiView wmiView = (WmiView)iterator.next();
                switch (((WmiViewPathInterval)wmiSelection).contains(wmiView)) {
                    case 1: 
                    case 2: {
                        return 1;
                    }
                }
            }
        }
        return n;
    }

    public boolean hideCaret() {
        return true;
    }

    public WmiViewPath getSelectionStartPath() {
        return null;
    }

    public WmiViewPath getSelectionEndPath() {
        return null;
    }

    public boolean isCompoundSelection() {
        return true;
    }

    protected void deleteView(WmiView wmiView) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModel wmiModel = wmiView.getModel();
        WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
        try {
            wmiCompositeModel.removeChild(wmiModel);
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            wmiModelIndexOutOfBoundsException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSelection() {
        Iterator iterator = this.getViewIterator();
        try {
            WmiModelLock.writeLock(this.docView.getModel(), true);
            while (iterator.hasNext()) {
                WmiView wmiView = (WmiView)iterator.next();
                this.deleteView(wmiView);
            }
            this.docView.resetSelectionOnUpdate();
            this.docView.getModel().update("Delete Selection");
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            wmiNoReadAccessException.printStackTrace();
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            wmiNoWriteAccessException.printStackTrace();
        }
        catch (WmiNoUpdateAccessException wmiNoUpdateAccessException) {
            wmiNoUpdateAccessException.printStackTrace();
        }
        finally {
            WmiModelLock.writeUnlock(this.docView.getModel());
        }
    }

    public void replaceSelection(String string) {
    }

    public void resync() {
    }

    public boolean isReadOnly() throws WmiNoReadAccessException {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void updateSelection(WmiViewPath wmiViewPath) {
    }

    public void add(WmiView wmiView) {
        this.views.add(wmiView);
        this.docView.getContextManager().setContextForDocument(this.docView);
    }

    public void add(WmiSelection wmiSelection) {
        if (wmiSelection instanceof WmiAggregateSelection) {
            this.views.addAll(((WmiAggregateSelection)wmiSelection).views);
            this.selections.addAll(((WmiAggregateSelection)wmiSelection).selections);
        } else {
            this.selections.add(wmiSelection);
        }
    }

    public void remove(WmiView wmiView) {
        this.views.remove(wmiView);
        this.docView.getContextManager().setContextForDocument(this.docView);
    }

    public void clear() {
        this.views.clear();
        this.selections.clear();
    }

    public int getViewCount() {
        return this.views.size();
    }

    public Iterator getViewIterator() {
        return this.views.iterator();
    }

    public Iterator getSelectionIterator() {
        return this.selections.iterator();
    }

    public WmiHighlightPainter getSelectionHighlighter() {
        return null;
    }

    public void repaintDirtyRegions() {
    }

    public boolean getModelInterval(WmiModel[] wmiModelArray, int[] nArray) {
        return false;
    }

    public WmiMathDocumentView getSourceDocument() {
        return this.docView;
    }
}

