/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelPath;
import com.maplesoft.mathdoc.model.WmiModelPathInterval;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiTextCollector;
import com.maplesoft.mathdoc.view.WmiAccessibleView;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import java.awt.Point;
import java.awt.Rectangle;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleText;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;

public class WmiAccessibleTextComposite
implements AccessibleText {
    protected WmiCompositeView view = null;
    protected AccessibleContext context = null;

    public WmiAccessibleTextComposite(WmiCompositeView wmiCompositeView) {
        this.view = wmiCompositeView;
    }

    public int getIndexAtPoint(Point point) {
        int n = 0;
        if (this.view instanceof WmiPositionedView) {
            WmiPositionedView wmiPositionedView = (WmiPositionedView)((Object)this.view);
            WmiPositionedView wmiPositionedView2 = wmiPositionedView.getNearestChildView(point);
            for (int i = 0; i < this.view.getChildCount(); ++i) {
                WmiView wmiView = this.view.getChild(i);
                AccessibleContext accessibleContext = wmiView.getAccessibleContext();
                if (wmiView == wmiPositionedView2) {
                    point.translate(-wmiPositionedView2.getHorizontalOffset(), -wmiPositionedView2.getVerticalOffset());
                    AccessibleText accessibleText = accessibleContext.getAccessibleText();
                    n += accessibleText.getIndexAtPoint(point);
                    break;
                }
                if (!(accessibleContext instanceof WmiAccessibleView)) continue;
                n += ((WmiAccessibleView)((Object)accessibleContext)).getTextLength();
            }
        }
        return n;
    }

    public Rectangle getCharacterBounds(int n) {
        Rectangle rectangle = null;
        int n2 = 0;
        for (int i = 0; i < this.view.getChildCount() && rectangle == null; ++i) {
            WmiView wmiView = this.view.getChild(i);
            AccessibleContext accessibleContext = wmiView.getAccessibleContext();
            if (!(accessibleContext instanceof WmiAccessibleView)) continue;
            int n3 = ((WmiAccessibleView)((Object)accessibleContext)).getTextLength();
            if (n3 > 0 && n3 + n2 >= n3) {
                AccessibleText accessibleText = accessibleContext.getAccessibleText();
                rectangle = accessibleText.getCharacterBounds(n - n2);
                continue;
            }
            n2 += n3;
        }
        return rectangle;
    }

    public int getCharCount() {
        int n = 0;
        if (this.context == null) {
            this.context = this.view.getAccessibleContext();
        }
        if (this.context instanceof WmiAccessibleView) {
            n = ((WmiAccessibleView)((Object)this.context)).getTextLength();
        } else {
            int n2 = this.view.getChildCount();
            for (int i = 0; i < n2; ++i) {
                AccessibleText accessibleText;
                WmiView wmiView = this.view.getChild(i);
                AccessibleContext accessibleContext = wmiView.getAccessibleContext();
                if (accessibleContext == null || (accessibleText = accessibleContext.getAccessibleText()) == null) continue;
                n += accessibleText.getCharCount();
            }
        }
        return n;
    }

    public int getCaretPosition() {
        WmiViewPath wmiViewPath;
        WmiViewPath wmiViewPath2;
        WmiViewPath wmiViewPath3;
        WmiCaret wmiCaret;
        int n = 0;
        WmiMathDocumentView wmiMathDocumentView = this.view.getDocumentView();
        if (wmiMathDocumentView != null && (wmiCaret = wmiMathDocumentView.getCaret()) != null && (wmiViewPath3 = WmiViewPath.commonParent(wmiViewPath2 = new WmiViewPath(this.view), wmiViewPath = wmiCaret.getViewPath())).compareTo(wmiViewPath2) == 0) {
            n = wmiCaret.getOffset();
        }
        return n;
    }

    public String getAtIndex(int n, int n2) {
        String string = null;
        int n3 = this.view.getChildCount();
        int n4 = 0;
        for (int i = 0; i < n3 && string == null; ++i) {
            WmiView wmiView = this.view.getChild(i);
            AccessibleContext accessibleContext = wmiView.getAccessibleContext();
            if (!(accessibleContext instanceof WmiAccessibleView) || accessibleContext instanceof WmiGenericView.WmiAccessibleGenericView && !((WmiGenericView.WmiAccessibleGenericView)accessibleContext).isPhysicalView()) continue;
            int n5 = ((WmiAccessibleView)((Object)accessibleContext)).getTextLength();
            if (n5 > 0 && n5 + n4 >= n2) {
                AccessibleText accessibleText = accessibleContext.getAccessibleText();
                string = accessibleText.getAtIndex(n, n2 - n4);
                continue;
            }
            n4 += n5;
        }
        return string;
    }

    public String getAfterIndex(int n, int n2) {
        return this.getAtIndex(n, n2 + 1);
    }

    public String getBeforeIndex(int n, int n2) {
        return this.getAtIndex(n, n2 - 1);
    }

    public AttributeSet getCharacterAttribute(int n) {
        return new SimpleAttributeSet();
    }

    public int getSelectionStart() {
        return 0;
    }

    public int getSelectionEnd() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSelectedText() {
        String string = null;
        WmiMathDocumentView wmiMathDocumentView = this.view.getDocumentView();
        WmiSelection wmiSelection = wmiMathDocumentView.getSelection();
        if (wmiSelection != null) {
            WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
            WmiViewPath wmiViewPath = wmiSelection.getSelectionStartPath();
            WmiViewPath wmiViewPath2 = wmiSelection.getSelectionEndPath();
            if (wmiViewPath != null && wmiViewPath2 != null) {
                boolean bl = WmiModelLock.readLock(wmiMathDocumentModel, true);
                try {
                    WmiModelPosition wmiModelPosition = wmiViewPath.createModelPosition(wmiMathDocumentView);
                    WmiModelPosition wmiModelPosition2 = wmiViewPath2.createModelPosition(wmiMathDocumentView);
                    WmiModelPathInterval wmiModelPathInterval = new WmiModelPathInterval(new WmiModelPath(wmiModelPosition), new WmiModelPath(wmiModelPosition2));
                    WmiTextCollector wmiTextCollector = new WmiTextCollector(wmiModelPosition, wmiModelPosition2);
                    wmiModelPathInterval.walkInterval(wmiMathDocumentModel, wmiTextCollector);
                    string = wmiTextCollector.getCollectedText();
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiErrorLog.log(wmiNoReadAccessException);
                }
                catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                    WmiErrorLog.log(wmiInvalidModelInitializationException);
                }
                finally {
                    if (bl) {
                        WmiModelLock.readUnlock(wmiMathDocumentModel);
                    }
                }
            }
        }
        return string;
    }
}

