/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.util;

import com.maplesoft.mathdoc.controller.WmiCommandProxy;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.RuntimePlatform;
import com.maplesoft.util.encoder.UTF8Encoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class WmiResourcePackage {
    public static final int SEARCH_REQUIRE_LOCALIZED = 0;
    public static final int SEARCH_PREFER_LOCALIZED = 1;
    public static final int SEARCH_PREFER_COMMON = 3;
    public static final int SEARCH_REQUIRE_COMMON = 4;
    private static final String LOCALIZED_FILE_NAME_SUFFIX = "_Localized";
    private static final String RESOURCE_PACKAGE_KEY = "package";
    private static final String RESOURCE_CLASS_LIST_KEY = "classes";
    private static final String SUFFIX_MAC = ".mac";
    private static final String SUFFIX_WIN = ".win";
    private static final String SUFFIX_UNIX = ".unix";
    private static final String ENCODING_KEY = "__encoding";
    private static boolean DEBUG;
    private static String resourceDir;
    private static String platformSuffix;
    private ResourceBundle commonBundle = null;
    private ResourceBundle localizedBundle = null;
    private boolean isCommonUtf8 = false;
    private boolean isLocalizedUtf8 = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected WmiResourcePackage(String string) {
        if (string != null) {
            try {
                this.commonBundle = ResourceBundle.getBundle(string);
            }
            catch (MissingResourceException missingResourceException) {
                this.commonBundle = null;
            }
            try {
                Locale locale = RuntimeLocale.getDisplayLocale();
                this.localizedBundle = WmiResourcePackage.getLocalizedResourceBundle(string, locale);
            }
            catch (MissingResourceException missingResourceException) {
                this.localizedBundle = null;
            }
            this.isCommonUtf8 = WmiResourcePackage.isUtf8(this.commonBundle);
            this.isLocalizedUtf8 = WmiResourcePackage.isUtf8(this.localizedBundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle getLocalizedResourceBundle(String string, Locale locale) {
        ResourceBundle resourceBundle = null;
        if (resourceDir == null) {
            resourceBundle = ResourceBundle.getBundle(string + LOCALIZED_FILE_NAME_SUFFIX, locale);
        } else {
            locale = RuntimeLocale.normalize(locale);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(resourceDir);
            stringBuffer.append(File.separatorChar);
            stringBuffer.append(string.replace('.', '/'));
            stringBuffer.append(LOCALIZED_FILE_NAME_SUFFIX);
            stringBuffer.append('_');
            stringBuffer.append(locale.toString());
            stringBuffer.append(".properties");
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(stringBuffer.toString());
                resourceBundle = new PropertyResourceBundle(fileInputStream);
            }
            catch (IOException iOException) {
                System.err.println("file not found: " + stringBuffer);
                resourceBundle = ResourceBundle.getBundle(string + LOCALIZED_FILE_NAME_SUFFIX, locale);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return resourceBundle;
    }

    private static boolean isUtf8(ResourceBundle resourceBundle) {
        boolean bl = false;
        if (resourceBundle != null) {
            try {
                String string = resourceBundle.getString(ENCODING_KEY);
                bl = string != null && string.equals("UTF-8");
            }
            catch (MissingResourceException missingResourceException) {
                bl = false;
            }
        }
        return bl;
    }

    public static WmiResourcePackage getResourcePackage(String string) {
        if (DEBUG) {
            return new WmiDebugResourcePackage(string);
        }
        return new WmiResourcePackage(string);
    }

    public static void setPlatformSuffix() {
        platformSuffix = RuntimePlatform.isMac() ? SUFFIX_MAC : (RuntimePlatform.isWindows() ? SUFFIX_WIN : SUFFIX_UNIX);
    }

    public static String getPlatformSuffix() {
        return platformSuffix;
    }

    public static void setResourceDebug(boolean bl) {
    }

    public static boolean isDebugEnabled() {
        return DEBUG;
    }

    public static void setResourceDir(String string) {
    }

    public String getEnglishLocalizedString(String string) {
        return null;
    }

    public String getPackageName() {
        return null;
    }

    public String getStringForKey(String string) {
        return this.getStringForKey(string, 1);
    }

    public String[] getStringsForKeyArray(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = this.getStringForKey(stringArray[i]);
        }
        return stringArray2;
    }

    public String getStringForKey(String string, int n) {
        ResourceBundle resourceBundle = null;
        ResourceBundle resourceBundle2 = null;
        boolean bl = false;
        boolean bl2 = false;
        switch (n) {
            case 0: {
                resourceBundle = this.localizedBundle;
                bl = this.isLocalizedUtf8;
                resourceBundle2 = null;
                break;
            }
            case 1: {
                resourceBundle = this.localizedBundle;
                bl = this.isLocalizedUtf8;
                resourceBundle2 = this.commonBundle;
                bl2 = this.isCommonUtf8;
                break;
            }
            case 3: {
                resourceBundle = this.commonBundle;
                bl = this.isCommonUtf8;
                resourceBundle2 = this.localizedBundle;
                bl2 = this.isLocalizedUtf8;
                break;
            }
            case 4: {
                resourceBundle = this.commonBundle;
                bl = this.isCommonUtf8;
                resourceBundle2 = null;
                break;
            }
            default: {
                resourceBundle = this.localizedBundle;
                bl = this.isLocalizedUtf8;
                resourceBundle2 = this.commonBundle;
                bl2 = this.isCommonUtf8;
            }
        }
        String string2 = null;
        if (resourceBundle != null) {
            string2 = this.doPlatformBundleSearch(resourceBundle, string);
            if (bl) {
                string2 = UTF8Encoder.convertUtf8ToUnicode(string2);
            }
        }
        if (string2 == null && resourceBundle2 != null) {
            string2 = this.doPlatformBundleSearch(resourceBundle2, string);
            if (bl2) {
                string2 = UTF8Encoder.convertUtf8ToUnicode(string2);
            }
        }
        return string2;
    }

    public String getStringForKey(String string, String string2, int n) {
        String string3 = this.getStringForKey(string, n);
        if (string3 != null) {
            string3 = string3.replaceAll("%1", string2);
        }
        return string3;
    }

    public String getStringForKey(String string, String string2) {
        return this.getStringForKey(string, string2, 1);
    }

    public String getStringForKey(String string, String[] stringArray, int n) {
        String string2 = this.getStringForKey(string, n);
        if (string2 != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = "%" + (i + 1);
                string2 = string2.replaceAll(string3, stringArray[i]);
            }
        }
        return string2;
    }

    public String getStringForKey(String string, String[] stringArray) {
        return this.getStringForKey(string, stringArray, 1);
    }

    public int getIntForKey(String string) {
        return this.getIntForKey(string, -1);
    }

    public double getDoubleForKey(String string) {
        return this.getDoubleForKey(string, -1.0);
    }

    public int getIntForKey(String string, int n) {
        int n2 = n;
        String string2 = this.getStringForKey(string);
        if (string2 != null) {
            try {
                n2 = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = n;
            }
        }
        return n2;
    }

    public double getDoubleForKey(String string, double d) {
        double d2 = d;
        String string2 = this.getStringForKey(string);
        if (string2 != null) {
            try {
                d2 = Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                d2 = d;
            }
        }
        return d2;
    }

    public boolean getBooleanForKey(String string) {
        return this.getBooleanForKey(string, false);
    }

    public boolean getBooleanForKey(String string, boolean bl) {
        boolean bl2 = bl;
        String string2 = this.getStringForKey(string);
        if (string2 != null) {
            bl2 = Boolean.valueOf(string2);
        }
        return bl2;
    }

    public boolean instantiateClasses(HashMap hashMap) {
        boolean bl = true;
        String string = this.getStringForKey(RESOURCE_PACKAGE_KEY, 3);
        String string2 = this.getStringForKey(RESOURCE_CLASS_LIST_KEY, 3);
        if (string == null || string2 == null) {
            bl = false;
        }
        if (bl) {
            String[] stringArray = string2.split("  *");
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split(":");
                if (!$assertionsDisabled && stringArray2.length != 1 && stringArray2.length != 2) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && stringArray2[0].length() <= 0) {
                    throw new AssertionError((Object)("this should be <class>:<command name> but isn't: " + stringArray[i] + " index " + i + " from [" + string2 + "]"));
                }
                String string3 = string + "." + stringArray2[0];
                try {
                    Object object;
                    Object object2;
                    if (stringArray2.length == 1) {
                        object2 = Class.forName(string3.trim());
                        object = ((Class)object2).newInstance();
                    } else {
                        if (!$assertionsDisabled && stringArray2[1].length() <= 0) {
                            throw new AssertionError();
                        }
                        object2 = stringArray2[1];
                        object = new WmiCommandProxy((String)object2, string3, this);
                    }
                    if (hashMap == null) continue;
                    hashMap.put(string3, object);
                    continue;
                }
                catch (Exception exception) {
                    bl = false;
                    WmiErrorLog.log(exception);
                }
            }
        }
        return bl;
    }

    public boolean instantiateClasses() {
        return this.instantiateClasses(null);
    }

    public void release() {
        this.commonBundle = null;
        this.localizedBundle = null;
    }

    protected String doPlatformBundleSearch(ResourceBundle resourceBundle, String string) {
        String string2 = null;
        string2 = this.doBundleSearch(resourceBundle, string + platformSuffix);
        if (string2 == null) {
            string2 = this.doBundleSearch(resourceBundle, string);
        }
        return string2;
    }

    protected String doBundleSearch(ResourceBundle resourceBundle, String string) {
        String string2 = null;
        if (resourceBundle != null) {
            try {
                string2 = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                string2 = null;
            }
        }
        return string2;
    }

    static {
        $assertionsDisabled = !WmiResourcePackage.class.desiredAssertionStatus();
        DEBUG = false;
        WmiResourcePackage.setPlatformSuffix();
    }

    private static class WmiDebugResourcePackage
    extends WmiResourcePackage {
        private String name = null;
        private ResourceBundle englishBundle = null;

        protected WmiDebugResourcePackage(String string) {
            super(string);
            this.name = string;
            try {
                this.englishBundle = ResourceBundle.getBundle(string + WmiResourcePackage.LOCALIZED_FILE_NAME_SUFFIX, Locale.ENGLISH);
            }
            catch (MissingResourceException missingResourceException) {
                this.englishBundle = null;
            }
        }

        public String getEnglishLocalizedString(String string) {
            String string2 = null;
            if (this.englishBundle != null) {
                try {
                    string2 = this.englishBundle.getString(string);
                }
                catch (MissingResourceException missingResourceException) {
                    string2 = null;
                }
            }
            return string2;
        }

        public String getPackageName() {
            return this.name;
        }
    }
}

