/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.platform;

import com.maplesoft.mathdoc.components.WmiDropDownButton;
import com.maplesoft.mathdoc.platform.WmiToolBarButtonUIFactory;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ButtonUI;

public class WmiDropDownButtonUIFactory {
    public static ButtonUI createUI() {
        if (RuntimePlatform.isMac()) {
            return new MacDropDownButtonUI();
        }
        return new WindowsUnixDropDownButtonUI();
    }

    static void paintDropDownArrow(Graphics graphics, WmiDropDownButton wmiDropDownButton) {
        Icon icon = wmiDropDownButton.getDropDownIcon();
        if (icon != null) {
            int n = wmiDropDownButton.getWidth() - icon.getIconWidth() - 3;
            int n2 = (wmiDropDownButton.getHeight() - icon.getIconHeight()) / 2 + 2;
            icon.paintIcon(wmiDropDownButton, graphics, n, n2);
        }
    }

    private WmiDropDownButtonUIFactory() {
    }

    public static class MacDropDownButtonUI
    extends WmiToolBarButtonUIFactory.MacToolBarButtonUI {
        public void installUI(JComponent jComponent) {
            super.installUI(jComponent);
            jComponent.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 15));
        }

        public void paint(Graphics graphics, JComponent jComponent) {
            super.paint(graphics, jComponent);
            WmiDropDownButton wmiDropDownButton = (WmiDropDownButton)jComponent;
            WmiDropDownButtonUIFactory.paintDropDownArrow(graphics, wmiDropDownButton);
        }
    }

    public static class WindowsUnixDropDownButtonUI
    extends WmiToolBarButtonUIFactory.WindowsUnixToolBarButtonUI {
        public void installUI(JComponent jComponent) {
            super.installUI(jComponent);
            jComponent.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 15));
        }

        public void paint(Graphics graphics, JComponent jComponent) {
            super.paint(graphics, jComponent);
            WmiDropDownButton wmiDropDownButton = (WmiDropDownButton)jComponent;
            WmiDropDownButtonUIFactory.paintDropDownArrow(graphics, wmiDropDownButton);
        }

        protected void paintBackground(Graphics graphics, AbstractButton abstractButton) {
            super.paintBackground(graphics, abstractButton);
            if (((WmiDropDownButton)abstractButton).isMenuVisible()) {
                graphics.setColor(Color.GRAY);
                int n = abstractButton.getWidth() - 15 + 2;
                graphics.fillRoundRect(n, 0, 15, abstractButton.getHeight(), 2, 2);
                graphics.fillRect(n, 0, 2, abstractButton.getHeight());
            }
        }

        protected void paintBorder(Graphics graphics, AbstractButton abstractButton) {
            super.paintBorder(graphics, abstractButton);
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isSelected() || buttonModel.isRollover() || buttonModel.isPressed()) {
                graphics.setColor(Color.GRAY);
                int n = abstractButton.getWidth() - 15 + 2;
                graphics.drawLine(n, 0, n, abstractButton.getHeight());
                graphics.setColor(abstractButton.getBackground().brighter());
                graphics.drawLine(n + 1, 1, n + 1, abstractButton.getHeight() - 2);
            }
        }
    }
}

