/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiFractionModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiPrecedenceRules;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.WmiSuperscriptModel;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;

public class WmiDiffBuilder
extends WmiAbstractSpecialFunctionBuilder {
    public static final String D_OPERATOR = "&DifferentialD;";
    public static final String DI_OPERATOR = "&PartialD;";
    public static final int FUNC_DAG_INDEX = 0;
    private static final int LAST_ORDER_POSITION = -1;
    private static final WmiMathSemantics DIFF_SEMANTICS = new WmiDiffSemantics();
    public static final boolean INERT = true;
    public static final boolean NONINERT = false;
    private boolean isInert;

    public WmiDiffBuilder() {
        this(false);
    }

    public WmiDiffBuilder(boolean bl) {
        this.isInert = bl;
    }

    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel wmiMathDocumentModel, String string, Dag dag, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        String[] stringArray;
        int[] nArray;
        Dag[] dagArray;
        WmiInlineMathModel wmiInlineMathModel = null;
        int n = this.extractMaxVariables(dag, 1);
        Dag[] dagArray2 = new Dag[n];
        boolean bl = this.extractVariables(dag, 1, dagArray2, dagArray = new Dag[n], nArray = new int[n], stringArray = new String[n]);
        if (bl) {
            wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
            WmiAbstractArrayCompositeModel wmiAbstractArrayCompositeModel = wmiInlineMathModel;
            Dag dag2 = dag.getChild(0);
            WmiMathModel wmiMathModel = this.buildDiffModel(wmiMathDocumentModel, dag2, dagArray2, dagArray, nArray, stringArray, wmiMathContext);
            WmiMathModel wmiMathModel2 = WmiMathFactory.createMath(wmiMathDocumentModel, dag2, wmiMathContext);
            if (WmiPrecedenceRules.areBracketsRequired(dag2, 3, 0)) {
                wmiMathModel2 = WmiMathFactory.addBrackets(wmiMathModel2, wmiMathContext);
            }
            wmiAbstractArrayCompositeModel.appendChild(wmiMathModel);
            wmiAbstractArrayCompositeModel.appendChild(WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "&InvisibleTimes;", wmiMathContext));
            wmiAbstractArrayCompositeModel.appendChild(wmiMathModel2);
            wmiInlineMathModel.setSemantics(DIFF_SEMANTICS);
        }
        return wmiInlineMathModel;
    }

    public boolean shouldBeUsed(Dag dag, WmiMathContext wmiMathContext) {
        boolean bl = super.shouldBeUsed(dag, wmiMathContext);
        bl = bl && dag.getLength() == 2 && dag.getChild(1) != null && dag.getChild(1).getLength() >= 2 && this.extractMaxVariables(dag.getChild(1), 1) > 0;
        return bl;
    }

    private WmiMathModel buildDiffModel(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, Dag[] dagArray, Dag[] dagArray2, int[] nArray, String[] stringArray, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiFractionModel wmiFractionModel = null;
        Dag dag2 = null;
        Dag dag3 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        for (n3 = 0; n3 < dagArray.length && dagArray[n3] != null; ++n3) {
            ++n2;
            if (nArray[n3] > -1) {
                n += nArray[n3];
                if (stringArray[n3] == null) continue;
                if (!bl) {
                    stringBuffer.append("+");
                }
                stringBuffer.append(stringArray[n3]);
                bl = false;
                continue;
            }
            dag3 = dagArray2[n3];
        }
        if (n > 0) {
            dag2 = DagUtil.createIntDag(n);
            if (dag3 != null) {
                dag2 = Dag.createDag(16, new Dag[]{dag2, DagUtil.createIntDag(1), dag3, DagUtil.createIntDag(1)}, null, false);
            }
        } else if (dag3 != null) {
            dag2 = dag3;
        }
        if (stringBuffer.length() == 0) {
            stringBuffer = null;
        }
        boolean bl2 = n2 == 1 ? this.numFunctionVars(dag, dagArray[0]) == 0 : false;
        WmiMathModel wmiMathModel = this.buildTopVarBox(wmiMathDocumentModel, dag2, stringBuffer != null ? stringBuffer.toString() : null, bl2, wmiMathContext);
        WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
        boolean bl3 = true;
        for (n3 = dagArray.length - 1; n3 > -1; --n3) {
            if (dagArray[n3] == null) continue;
            if (!bl3) {
                wmiInlineMathModel.appendChild(WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "&InvisibleTimes;", wmiMathContext));
            }
            bl3 = false;
            wmiInlineMathModel.appendChild(this.buildBottomVarBox(wmiMathDocumentModel, dagArray[n3], dagArray2[n3], nArray[n3], bl2, wmiMathContext));
        }
        wmiFractionModel = new WmiFractionModel(wmiMathDocumentModel, wmiMathModel, wmiInlineMathModel, wmiMathContext);
        return wmiFractionModel;
    }

    private void buildDBoxRun(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, boolean bl, WmiMathContext wmiMathContext, WmiMathModel[] wmiMathModelArray) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        String string;
        WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
        WmiMathModel wmiMathModel = null;
        String string2 = string = bl ? D_OPERATOR : DI_OPERATOR;
        if (dag == null) {
            wmiMathModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, string, wmiMathContext);
            if (this.isInert) {
                this.inertize((WmiMathOperatorModel)wmiMathModel);
            }
        } else {
            wmiMathModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, string, wmiMathContext);
            if (this.isInert) {
                this.inertize((WmiMathOperatorModel)wmiMathModel);
            }
            wmiInlineMathModel.appendChild(wmiMathModel);
            wmiMathModel = WmiMathFactory.createMath(wmiMathDocumentModel, dag, wmiMathContext);
        }
        wmiMathModelArray[0] = wmiInlineMathModel;
        wmiMathModelArray[1] = wmiMathModel;
    }

    private WmiMathModel buildTopVarBox(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, String string, boolean bl, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel[] wmiMathModelArray = new WmiMathModel[2];
        this.buildDBoxRun(wmiMathDocumentModel, null, bl, wmiMathContext, wmiMathModelArray);
        WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)((Object)wmiMathModelArray[0]);
        WmiMathModel wmiMathModel = wmiMathModelArray[1];
        if (dag != null && DagUtil.isInt(dag)) {
            int n = DagUtil.parseInt(dag);
            if (n != 1 || string != null) {
                String string2 = null;
                string2 = string == null ? Integer.toString(n) : (n == 0 ? string : Integer.toString(n) + "+" + string);
                WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathNumericToken(wmiMathDocumentModel, string2, wmiMathContext);
                wmiCompositeModel.appendChild(new WmiSuperscriptModel(wmiMathDocumentModel, wmiMathModel, wmiMathTokenModel, wmiMathContext));
            } else {
                wmiCompositeModel.appendChild(wmiMathModel);
            }
        } else if (dag != null) {
            WmiMathModel wmiMathModel2 = WmiMathFactory.createMath(wmiMathDocumentModel, dag, wmiMathContext);
            wmiCompositeModel.appendChild(new WmiSuperscriptModel(wmiMathDocumentModel, wmiMathModel, wmiMathModel2, wmiMathContext));
        } else {
            wmiCompositeModel.appendChild(wmiMathModel);
        }
        return (WmiMathModel)((Object)wmiCompositeModel);
    }

    private WmiMathModel buildBottomVarBox(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, Dag dag2, int n, boolean bl, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel[] wmiMathModelArray = new WmiMathModel[2];
        this.buildDBoxRun(wmiMathDocumentModel, dag, bl, wmiMathContext, wmiMathModelArray);
        WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)((Object)wmiMathModelArray[0]);
        WmiMathModel wmiMathModel = wmiMathModelArray[1];
        if (dag2 == null && n > 1) {
            dag2 = DagUtil.createIntDag(n);
        }
        if (dag2 != null && !DagUtil.isOne(dag2)) {
            WmiMathModel wmiMathModel2 = WmiMathFactory.createMath(wmiMathDocumentModel, dag2, wmiMathContext);
            wmiCompositeModel.appendChild(new WmiSuperscriptModel(wmiMathDocumentModel, wmiMathModel, wmiMathModel2, wmiMathContext));
        } else {
            wmiCompositeModel.appendChild(wmiMathModel);
        }
        return (WmiMathModel)((Object)wmiCompositeModel);
    }

    private int extractMaxVariables(Dag dag, int n) {
        int n2 = 0;
        if (dag.getLength() > 0 && dag.getType() != 18) {
            int n3 = dag.getLength();
            for (int i = n; i < n3; ++i) {
                n2 += this.extractMaxVariables(dag.getChild(i), 0);
            }
        } else {
            ++n2;
        }
        return n2;
    }

    private boolean extractVariables(Dag dag, int n, Dag[] dagArray, Dag[] dagArray2, int[] nArray, String[] stringArray) {
        int n2;
        boolean bl = true;
        Dag dag2 = null;
        Dag dag3 = null;
        Dag dag4 = null;
        int n3 = 0;
        int n4 = dag.getLength();
        for (n2 = n; n2 < n4 && bl; ++n2) {
            int n5;
            Dag dag5 = dag.getChild(n2);
            int n6 = n5 = dag5 != null ? dag5.getType() : -1;
            if (n5 == 8 || n5 == 10 || n5 == 9) {
                this.findVariableUpdateOrder(dag5, dagArray, nArray);
                continue;
            }
            if (n5 == 30) {
                bl = this.extractVariables(dag5, 0, dagArray, dagArray2, nArray, stringArray);
                continue;
            }
            if (n5 == 18) {
                dag4 = dag5.getChild(0);
                if (!dag4.getData().equals("$")) continue;
                if (dag5.getLength() > 1) {
                    Dag dag6 = dag5.getChild(1);
                    dag2 = dag6.getChild(0);
                    dag3 = dag6.getChild(1);
                    n3 = this.findVariable(dagArray, dag2);
                    if (n3 < 0) {
                        n3 = this.addVariable(dagArray, dag2);
                    }
                } else {
                    n3 = -1;
                }
                if (n3 < 0) continue;
                if (dag3.getType() == 2) {
                    int n7 = Integer.parseInt(dag3.getData());
                    int n8 = n3;
                    nArray[n8] = nArray[n8] + n7;
                } else {
                    nArray[n3] = -1;
                }
                dagArray2[n3] = dag3;
                continue;
            }
            bl = false;
            break;
        }
        if (bl) {
            bl = false;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if (nArray[n2] == 0) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private int findVariable(Dag[] dagArray, Dag dag) {
        int n = -1;
        for (int i = 0; i < dagArray.length; ++i) {
            if (dagArray[i] == dag) {
                n = i;
                break;
            }
            if (dagArray[i] == null) break;
        }
        return n;
    }

    private int addVariable(Dag[] dagArray, Dag dag) {
        int n = -1;
        for (int i = 0; i < dagArray.length; ++i) {
            if (dagArray[i] != null) continue;
            dagArray[i] = dag;
            n = i;
            break;
        }
        return n;
    }

    private void findVariableUpdateOrder(Dag dag, Dag[] dagArray, int[] nArray) {
        String string;
        boolean bl = true;
        if (dag.getType() == 8 && (string = dag.getData()) != null && string.equals("Pi")) {
            bl = false;
        }
        if (bl) {
            for (int i = 0; i < dagArray.length; ++i) {
                if (dagArray[i] == dag) {
                    int n = i;
                    nArray[n] = nArray[n] + 1;
                    break;
                }
                if (dagArray[i] != null) continue;
                dagArray[i] = dag;
                nArray[i] = 1;
                break;
            }
        }
    }

    private int numFunctionVars(Dag dag, Dag dag2) {
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        if (dag == null) {
            n = 0;
        } else {
            String string = dag.getData();
            switch (dag.getType()) {
                case 8: {
                    if (string != null && string.equals("Pi")) break;
                }
                case 10: {
                    n = DagBuilder.lPrint(dag).equals(DagBuilder.lPrint(dag2)) ? 0 : 1;
                    break;
                }
                case 18: 
                case 34: {
                    n2 = 1;
                    bl = true;
                    break;
                }
                case 13: 
                case 14: 
                case 16: 
                case 29: {
                    n2 = 0;
                    bl = true;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            if (bl) {
                int n4 = dag.getLength();
                for (n3 = n2; n3 < n4; ++n3) {
                    n += this.numFunctionVars(dag.getChild(n3), dag2);
                }
            }
        }
        return n;
    }

    public static class WmiDiffSemantics
    implements WmiMathSemantics {
        private static final int OUTER_DIFF_FRAC_INDEX = 0;
        private static final int OUTER_DIFF_ARG_INDEX = 2;
        private static final int FRAC_DENOM_INDEX = 1;
        private static final int DVAR_VAR_INDEX = 1;
        private static final int VAR_SUP_VAR_INDEX = 0;
        private static final int VAR_SUP_ORDER_INDEX = 1;

        public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
            Dag dag = null;
            if (wmiMathModel != null && wmiMathModel.isComposite()) {
                WmiModel wmiModel;
                WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)((Object)wmiMathModel);
                WmiMathModel wmiMathModel2 = (WmiMathModel)wmiCompositeModel.getChild(2);
                WmiModel wmiModel2 = wmiCompositeModel.getChild(0);
                if (wmiModel2 != null && wmiModel2.isComposite() && wmiMathModel2 != null && (wmiModel = ((WmiCompositeModel)wmiModel2).getChild(1)) != null && wmiModel.isComposite()) {
                    WmiCompositeModel wmiCompositeModel2 = (WmiCompositeModel)wmiModel;
                    int n = 1 + wmiCompositeModel2.getChildCount() / 2;
                    Dag[] dagArray = new Dag[n];
                    dagArray[0] = wmiMathModel2.toDag();
                    int n2 = 1;
                    int n3 = dagArray.length - 1;
                    while (n2 < wmiCompositeModel2.getChildCount()) {
                        WmiMathModel wmiMathModel3 = (WmiMathModel)wmiCompositeModel2.getChild(n2);
                        if (wmiMathModel3.isComposite()) {
                            WmiCompositeModel wmiCompositeModel3 = (WmiCompositeModel)((Object)wmiMathModel3);
                            wmiMathModel3 = (WmiMathModel)wmiCompositeModel3.getChild(1);
                        }
                        dagArray[n3] = this.extractVarAndDegree(wmiMathModel3);
                        n2 += 2;
                        --n3;
                    }
                    dag = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.DIFF_FUNC_NAME, dagArray);
                }
            }
            dag = WmiSemanticDagUtil.handleNullDag(dag, wmiMathModel);
            return dag;
        }

        private Dag extractVarAndDegree(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
            Dag dag = null;
            if (wmiMathModel != null) {
                WmiModelTag wmiModelTag = wmiMathModel.getTag();
                if (wmiModelTag == WmiModelTag.MATH_IDENTIFIER) {
                    Dag dag2;
                    dag = dag2 = wmiMathModel.toDag();
                } else if (wmiMathModel.isComposite()) {
                    WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)((Object)wmiMathModel);
                    WmiMathModel wmiMathModel2 = (WmiMathModel)wmiCompositeModel.getChild(0);
                    WmiMathModel wmiMathModel3 = (WmiMathModel)wmiCompositeModel.getChild(1);
                    if (wmiMathModel2 != null && wmiMathModel3 != null) {
                        dag = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.DOLLAR_SIGN_FUNC_NAME, wmiMathModel2.toDag(), wmiMathModel3.toDag());
                    }
                }
            }
            return dag;
        }
    }
}

