/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiOverModel;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;

public class WmiConjugateBuilder
extends WmiAbstractSpecialFunctionBuilder {
    private static final int CONJUGATE_TERM_INDEX = 0;
    public static final String CONJUGATE_OVERBAR_OPERATOR = "\u0305";
    private static final WmiMathSemantics CONJUGATE_SEMANTICS = new WmiConjugateSemantics();

    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel wmiMathDocumentModel, String string, Dag dag, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        Dag dag2 = dag.getChild(0);
        WmiMathModel wmiMathModel = WmiMathFactory.createMath(wmiMathDocumentModel, dag2, wmiMathContext);
        WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, CONJUGATE_OVERBAR_OPERATOR, wmiMathContext);
        WmiOverModel wmiOverModel = new WmiOverModel(wmiMathDocumentModel, wmiMathModel, wmiMathTokenModel, wmiMathContext);
        WmiAttributeSet wmiAttributeSet = wmiOverModel.getAttributesForRead();
        WmiOverModel.WmiOverAttributeSet.ACCENT_KEY.setBooleanValue(wmiAttributeSet, true);
        wmiOverModel.setSemantics(CONJUGATE_SEMANTICS);
        return wmiOverModel;
    }

    public boolean shouldBeUsed(Dag dag, WmiMathContext wmiMathContext) {
        boolean bl = super.shouldBeUsed(dag, wmiMathContext);
        bl = bl && dag.getChild(1) != null && dag.getChild(1).getLength() == 1;
        return bl;
    }

    public static class WmiConjugateSemantics
    implements WmiMathSemantics {
        private static final int CONJUGATE_ARG_INDEX = 0;

        public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
            WmiCompositeModel wmiCompositeModel;
            WmiMathModel wmiMathModel2;
            Dag dag = null;
            if (wmiMathModel.isComposite() && (wmiMathModel2 = (WmiMathModel)(wmiCompositeModel = (WmiCompositeModel)((Object)wmiMathModel)).getChild(0)) != null) {
                dag = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.CONJUGATE_FUNC_NAME, wmiMathModel2.toDag());
            }
            dag = WmiSemanticDagUtil.handleNullDag(dag, wmiMathModel);
            return dag;
        }
    }
}

