/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagRenderContext;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.FunctionDagFactory;
import com.maplesoft.client.dag.HfloatDagFactory;
import com.maplesoft.client.dag.SumDagFactory;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiAbstractModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiAbstractElisionBuilder;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiAssignedSemantics;
import com.maplesoft.mathdoc.model.math.WmiFractionModel;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathActionModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiNumericFormatter;
import com.maplesoft.mathdoc.model.math.WmiRenderContextAwareBuilder;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.WmiSuperscriptModel;
import java.awt.Color;
import java.text.DecimalFormatSymbols;

public class WmiNumericModel
extends WmiAbstractMathTokenModel
implements WmiMathModel {
    public static final WmiInlineRationalSemantics INLINE_RATIONAL_SEMANTICS = new WmiInlineRationalSemantics();
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();
    private WmiMathSemantics semantics = null;
    static /* synthetic */ Class class$com$maplesoft$mathdoc$model$math$WmiNumericModel;

    public WmiNumericModel(WmiMathDocumentModel wmiMathDocumentModel, String string, String string2, WmiMathContext wmiMathContext) {
        super(wmiMathDocumentModel, string, wmiMathContext.createAttributes(2), wmiMathContext);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiNumericModel(WmiMathDocumentModel wmiMathDocumentModel, String string, WmiFontAttributeSet wmiFontAttributeSet) {
        super(wmiMathDocumentModel, string, (WmiAttributeSet)wmiFontAttributeSet);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public void appendText(String string) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException, WmiNoReadAccessException {
        super.appendText(" " + string);
    }

    public Dag toDag() throws WmiNoReadAccessException {
        return this.semantics != null ? this.semantics.toDag(this) : null;
    }

    public WmiModelTag getTag() {
        return WmiModelTag.MATH_NUMERIC;
    }

    protected boolean checkForQuotes() {
        return false;
    }

    public void setSemantics(WmiMathSemantics wmiMathSemantics) {
        this.semantics = wmiMathSemantics;
    }

    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    public boolean useScriptSize(WmiModel wmiModel) throws WmiNoReadAccessException {
        return false;
    }

    public boolean isCrossBoundarySubselectable() {
        return false;
    }

    public boolean isSubselectable() {
        return true;
    }

    protected WmiTextModel createSubModel(int n) throws WmiNoReadAccessException {
        return new WmiNumericModel(this.getDocument(), this.getText().substring(n), this.getText().substring(n), new WmiMathContext((WmiFontAttributeSet)this.getAttributes()));
    }

    public static class WmiInlineRationalSemantics
    implements WmiMathSemantics {
        public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
            WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)((Object)wmiMathModel);
            WmiMathModel wmiMathModel2 = (WmiMathModel)wmiCompositeModel.getChild(0);
            WmiMathModel wmiMathModel3 = (WmiMathModel)wmiCompositeModel.getChild(2);
            Dag[] dagArray = new Dag[]{wmiMathModel2.toDag(), wmiMathModel3.toDag()};
            WmiSemanticDagUtil.fillNullDags(dagArray);
            return Dag.createDag(3, dagArray, null, false);
        }
    }

    public static class WmiHFloatBuilder
    extends WmiFloatBuilder {
        private static final int MAX_HFLOAT_DIGITS = 15;

        public WmiMathModel createModel(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            WmiMathModel wmiMathModel = null;
            double d = HfloatDagFactory.getDoubleValue(dag);
            String string = Double.toString(d);
            if (string.equals("Infinity")) {
                wmiMathModel = this.createHFloatModel(wmiMathDocumentModel, wmiMathContext, "infinity", false);
            } else if (string.equals("-Infinity")) {
                wmiMathModel = this.createHFloatModel(wmiMathDocumentModel, wmiMathContext, "infinity", true);
            } else if (string.equals("NaN")) {
                wmiMathModel = this.createHFloatModel(wmiMathDocumentModel, wmiMathContext, "undefined", false);
            } else {
                int n;
                String string2 = string;
                int n2 = string.indexOf(69);
                int n3 = 0;
                if (n2 >= 0) {
                    n3 = Integer.parseInt(string.substring(n2 + 1));
                    string2 = string.substring(0, n2);
                }
                if ((n = string2.indexOf(46)) >= 0) {
                    n3 -= string2.length() - n - 1;
                    string2 = n != 0 ? string2.substring(0, n) + string2.substring(n + 1) : string2.substring(n + 1);
                }
                int n4 = 2;
                int n5 = 2;
                if (string2.length() > 0 && string2.startsWith("-")) {
                    n4 = 1;
                    string2 = string2.substring(1);
                }
                if (n3 < 0) {
                    n3 = -n3;
                    n5 = 1;
                }
                Dag dag2 = Dag.createDag(n4, null, string2, false);
                Dag dag3 = Dag.createDag(n5, null, Integer.toString(n3), false);
                wmiMathModel = this.createFloatModel(dag2, dag3, dag, wmiMathDocumentModel, wmiMathContext);
                wmiMathModel.setSemantics(this);
            }
            return wmiMathModel;
        }

        private WmiMathModel createHFloatModel(WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, String string, boolean bl) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            Dag[] dagArray;
            WmiMathModel wmiMathModel = null;
            Dag[] dagArray2 = new Dag[]{Dag.createDag(8, null, string, false)};
            if (bl) {
                dagArray = new Dag[]{dagArray2[0], DagConstants.MINUS_ONE};
                dagArray2[0] = Dag.createDag(16, dagArray, null, false);
            }
            dagArray = FunctionDagFactory.createFunctionDag("HFloat", dagArray2);
            wmiMathModel = WmiMathFactory.createMath(wmiMathDocumentModel, (Dag)dagArray, wmiMathContext);
            return wmiMathModel;
        }
    }

    public static class WmiFloatBuilder
    implements WmiRenderContextAwareBuilder,
    WmiMathModelBuilder,
    WmiMathSemantics {
        private static final int ROUNDING_MINUS_LENGTH_COND;
        private static final char ROUNDING_MINUS_STOP_CHAR;
        private static final int MANTISSA_DAG_INDEX = 0;
        private static final int EXPONENT_DAG_INDEX = 1;
        private static final String LINEBREAK_CONTEXT_NAME = "float";
        private static final int INFINITY_INDEX = 1;
        private static final String INFINITY_ID = "infinity";
        private static final int DEFAULT_DISPLAY_PRECISION = -1;
        private static final int SCIENTIFIC_NOTATION_THRESHOLD = 6;
        private static int displayPrecision;
        private static final String EXPLICIT_EXPONENTIATION_OPERATOR = "^";
        private static final String UNDEFINED_NAME = "undefined";
        private static final String ZERO_STRING = "0";
        private static final String POINT_STRING = ".";
        private static final String TEN = "10";
        static final /* synthetic */ boolean $assertionsDisabled;

        public WmiMathModel createModel(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            WmiMathModel wmiMathModel = null;
            if (dag.getLength() == 2) {
                wmiMathModel = this.createFloatModel(dag.getChild(0), dag.getChild(1), dag, wmiMathDocumentModel, wmiMathContext);
                wmiMathModel.setSemantics(new WmiAssignedSemantics(dag));
            }
            return wmiMathModel;
        }

        protected WmiMathModel buildNaNModel(Dag dag, Dag dag2, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            WmiMathModel wmiMathModel = null;
            if (DagUtil.isNameNamed(dag2, UNDEFINED_NAME) || DagUtil.isNameNamed(dag, UNDEFINED_NAME)) {
                if (dag.getData().equals("1") && dag.getType() == 2) {
                    wmiMathModel = WmiMathFactory.createMath(wmiMathDocumentModel, DagConstants.UNDEFINED, wmiMathContext);
                } else {
                    if (dag.getType() == 16) {
                        dag = SumDagFactory.sumDagToIntegerDag(dag);
                    }
                    Dag[] dagArray = new Dag[]{DagConstants.NAME_UNDEFINED};
                    Dag[] dagArray2 = new Dag[2];
                    dagArray2[0] = DagConstants.NAME_FLOAT;
                    Dag[] dagArray3 = new Dag[2];
                    dagArray3[1] = Dag.createDag(29, dagArray, null, false);
                    dagArray3[0] = Dag.createDag(dag.getType(), null, dag.getData(), false);
                    dagArray2[1] = Dag.createDag(29, dagArray3, null, false);
                    Dag dag3 = Dag.createDag(18, dagArray2, null, false);
                    wmiMathModel = WmiMathFactory.createMath(wmiMathDocumentModel, dag3, wmiMathContext);
                }
            }
            return wmiMathModel;
        }

        protected long calculateScientificNotationExponent(int n, long l) {
            long l2 = 0L;
            long l3 = (long)n + l;
            l2 = l < 0L && Math.abs(l3) >= 5L ? l3 : (l < 0L ? 0L : (l3 == 0L ? l3 : l3));
            l2 = Math.abs(l2) < 6L ? 0L : l2;
            return l2;
        }

        protected WmiMathModel createScientificNotationModel(WmiMathDocumentModel wmiMathDocumentModel, String string, StringBuffer stringBuffer, WmiMathContext wmiMathContext, long l) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
            wmiInlineMathModel.addAttributes(wmiMathContext.getStyle());
            WmiAbstractArrayCompositeModel wmiAbstractArrayCompositeModel = wmiInlineMathModel;
            int n = string.length();
            n = displayPrecision >= 0 ? displayPrecision : n;
            stringBuffer = WmiFloatBuilder.buildFloatString(stringBuffer, string, 0, 0, 1, n);
            if (stringBuffer.toString().indexOf(POINT_STRING) == -1) {
                stringBuffer.append(POINT_STRING);
            }
            String string2 = stringBuffer.toString();
            WmiNumericModel wmiNumericModel = new WmiNumericModel(wmiMathDocumentModel, string2, string2, wmiMathContext);
            wmiNumericModel.setSemantics(this);
            String string3 = Long.toString(l - 1L);
            WmiNumericModel wmiNumericModel2 = new WmiNumericModel(wmiMathDocumentModel, TEN, TEN, wmiMathContext);
            WmiNumericModel wmiNumericModel3 = new WmiNumericModel(wmiMathDocumentModel, string3, string3, wmiMathContext);
            wmiAbstractArrayCompositeModel.appendChild(wmiNumericModel);
            if (wmiMathContext.useProcRules()) {
                wmiAbstractArrayCompositeModel.appendChild(WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "&sdot;", wmiMathContext));
                wmiAbstractArrayCompositeModel.appendChild(wmiNumericModel2);
                wmiAbstractArrayCompositeModel.appendChild(WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, EXPLICIT_EXPONENTIATION_OPERATOR, wmiMathContext));
                wmiAbstractArrayCompositeModel.appendChild(wmiNumericModel3);
            } else {
                wmiAbstractArrayCompositeModel.appendChild(WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "&InvisibleTimes;", wmiMathContext));
                WmiSuperscriptModel wmiSuperscriptModel = new WmiSuperscriptModel(wmiMathDocumentModel, wmiNumericModel2, wmiNumericModel3, wmiMathContext);
                wmiAbstractArrayCompositeModel.appendChild(wmiSuperscriptModel);
            }
            return wmiInlineMathModel;
        }

        public WmiMathModel createFloatModel(Dag dag, Dag dag2, Dag dag3, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            WmiMathModel wmiMathModel = null;
            StringBuffer stringBuffer = new StringBuffer();
            wmiMathModel = this.buildFloatInfinityModel(dag, dag2, wmiMathDocumentModel, wmiMathContext);
            if (wmiMathModel == null) {
                wmiMathModel = this.buildNaNModel(dag, dag2, wmiMathDocumentModel, wmiMathContext);
            }
            if (wmiMathModel == null) {
                if (DagUtil.isSum(dag)) {
                    dag = SumDagFactory.sumDagToIntegerDag(dag);
                }
                if (DagUtil.isSum(dag2)) {
                    dag2 = SumDagFactory.sumDagToIntegerDag(dag2);
                }
                boolean bl = DagUtil.isNegInt(dag);
                String string = dag.getData();
                long l = WmiFloatBuilder.calculateExponent(dag2);
                int n = string.length();
                long l2 = this.calculateScientificNotationExponent(n, l);
                if (bl) {
                    stringBuffer.append("&uminus0;");
                }
                if (l2 != 0L) {
                    wmiMathModel = this.createScientificNotationModel(wmiMathDocumentModel, string, stringBuffer, wmiMathContext, l2);
                } else {
                    String string2;
                    if (!$assertionsDisabled && Math.abs(l) >= Integer.MAX_VALUE) {
                        throw new AssertionError();
                    }
                    int n2 = (int)l;
                    int n3 = n + n2;
                    int n4 = n;
                    int n5 = 0;
                    int n6 = 0;
                    if (n2 < 0 && Math.abs(n2) > n) {
                        n5 = 1;
                        n6 = Math.abs(n2) - n;
                    }
                    int n7 = n4 = displayPrecision >= 0 ? displayPrecision + n3 : n4;
                    if (n < n3) {
                        for (int i = 0; i < n3 - n; ++i) {
                            string = string + ZERO_STRING;
                        }
                    }
                    if ((stringBuffer = WmiFloatBuilder.buildFloatString(stringBuffer, string, n5, n6, n3, n4)).toString().indexOf(POINT_STRING) == -1) {
                        if (displayPrecision <= 0) {
                            stringBuffer.append(POINT_STRING);
                        } else {
                            StringBuffer stringBuffer2 = new StringBuffer();
                            stringBuffer2.append(POINT_STRING);
                            for (int i = 1; i <= displayPrecision; ++i) {
                                stringBuffer2.append(ZERO_STRING);
                            }
                            stringBuffer.append(stringBuffer2);
                        }
                    }
                    String string3 = string2 = stringBuffer.toString();
                    wmiMathModel = new WmiNumericModel(wmiMathDocumentModel, string3, string2, wmiMathContext);
                }
            }
            return wmiMathModel;
        }

        public static long calculateExponent(Dag dag) {
            long l = 0L;
            try {
                l = Long.parseLong(dag.getData());
                l = dag.getType() == 1 ? l * -1L : l;
            }
            catch (Exception exception) {
                WmiErrorLog.log(exception);
                l = 0L;
            }
            return l;
        }

        public static StringBuffer buildFloatString(StringBuffer stringBuffer, String string, int n, int n2, int n3, int n4) {
            char c;
            char[] cArray = string.toCharArray();
            int n5 = cArray.length;
            int n6 = 0;
            for (c = '\u0000'; c < n; ++c) {
                stringBuffer.append(ZERO_STRING);
            }
            while (n6 < n3) {
                stringBuffer.append(cArray[n6]);
                ++n6;
            }
            if (n5 != n3) {
                stringBuffer.append(POINT_STRING);
                for (c = '\u0000'; c < n2; ++c) {
                    stringBuffer.append(ZERO_STRING);
                }
                while (n6 < n4) {
                    if (n6 >= n5) {
                        stringBuffer.append(ZERO_STRING);
                    } else if (n6 == n4 - 1 && cArray.length > n4) {
                        c = cArray[n6 + 1];
                        if (c > '4' && c <= '9') {
                            c = cArray[n6];
                            if (c == '9') {
                                stringBuffer.append('0');
                                int n7 = stringBuffer.length() - 2;
                                while (n7 > -1) {
                                    c = stringBuffer.charAt(n7);
                                    if (c == '.') {
                                        if (n7 > 0) {
                                            --n7;
                                            continue;
                                        }
                                        stringBuffer.insert(0, "1");
                                        break;
                                    }
                                    if (c == ROUNDING_MINUS_STOP_CHAR && n7 == ROUNDING_MINUS_LENGTH_COND) {
                                        stringBuffer.insert(n7 + 1, "1");
                                        break;
                                    }
                                    if (c != '9') {
                                        c = (char)(c + '\u0001');
                                        String string2 = Character.toString(c);
                                        stringBuffer.replace(n7, n7 + 1, string2);
                                        break;
                                    }
                                    stringBuffer.setCharAt(n7, '0');
                                    if (n7 == 0) {
                                        stringBuffer.insert(0, "1");
                                    }
                                    --n7;
                                }
                            } else {
                                c = (char)(c + 1);
                                stringBuffer.append(c);
                            }
                        } else {
                            stringBuffer.append(cArray[n6]);
                        }
                    } else {
                        stringBuffer.append(cArray[n6]);
                    }
                    ++n6;
                }
            }
            if (stringBuffer.length() > 0) {
                if (stringBuffer.charAt(0) == '.') {
                    stringBuffer.insert(0, '0');
                }
                if (stringBuffer.indexOf("-.") == 0) {
                    stringBuffer.insert(1, '0');
                }
            }
            return stringBuffer;
        }

        public WmiMathModel buildFloatInfinityModel(Dag dag, Dag dag2, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            WmiMathModel wmiMathModel = null;
            if (this.isFloatInfinity(dag2)) {
                boolean bl = false;
                if (dag.getType() == 16) {
                    bl = DagUtil.isMinusOne(SumDagFactory.sumDagToIntegerDag(dag));
                }
                if (dag2.getType() == 16) {
                    bl = DagUtil.isMinusOne(SumDagFactory.sumDagToIntegerDag(dag2));
                }
                if (!bl) {
                    bl = dag.getType() == 1 || dag2.getType() == 1;
                }
                Dag dag3 = bl ? DagConstants.MINUS_INFINITY : DagConstants.INFINITY;
                wmiMathModel = WmiMathFactory.createMath(wmiMathDocumentModel, dag3, wmiMathContext);
            }
            return wmiMathModel;
        }

        private boolean isFloatInfinity(Dag dag) {
            return dag.getType() == 8 && dag.getData().equals(INFINITY_ID) || dag.getType() == 16 && dag.getChild(1).getData().equals(INFINITY_ID);
        }

        public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
            Dag dag = null;
            if (wmiMathModel instanceof WmiTextModel) {
                int n;
                String string = ((WmiTextModel)((Object)wmiMathModel)).getText();
                for (n = 0; n < string.length() && string.charAt(n) == '0'; ++n) {
                }
                int n2 = string.indexOf(46);
                Dag[] dagArray = new Dag[2];
                int n3 = 2;
                if (string.startsWith("&uminus0;") || string.startsWith("&minus;") || string.startsWith(" \u2212 ") || string.startsWith("\u2212")) {
                    string = string.substring(1);
                    n3 = 1;
                    --n2;
                }
                if (n2 == n) {
                    dagArray[0] = Dag.createDag(n3, null, string.substring(n + 1), false);
                    dagArray[1] = Dag.createDag(1, null, Integer.toString(string.length() - n - 1), false);
                } else if (n2 > 0) {
                    int n4 = string.length() - n2 - 1;
                    if (n2 < string.length() - 1) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(string.substring(n, n2));
                        stringBuffer.append(string.substring(n2 + 1));
                        dagArray[0] = Dag.createDag(n3, null, stringBuffer.toString(), false);
                        dagArray[1] = n4 > 0 ? Dag.createDag(1, null, Integer.toString(n4), false) : Dag.createDag(2, null, Integer.toString(-n4), false);
                    } else {
                        dagArray[0] = Dag.createDag(n3, null, string.substring(n, string.length() - 1), false);
                        dagArray[1] = DagConstants.ZERO;
                    }
                } else {
                    dagArray[0] = Dag.createDag(n3, null, string, false);
                    dagArray[1] = DagConstants.ZERO;
                }
                dag = Dag.createDag(4, dagArray, null, false);
            }
            return dag;
        }

        public void updateContext(DagRenderContext dagRenderContext) {
            displayPrecision = dagRenderContext.getInterfaceProperty("displayprecision", -1);
        }

        static {
            $assertionsDisabled = !(class$com$maplesoft$mathdoc$model$math$WmiNumericModel == null ? (class$com$maplesoft$mathdoc$model$math$WmiNumericModel = WmiNumericModel.class$("com.maplesoft.mathdoc.model.math.WmiNumericModel")) : class$com$maplesoft$mathdoc$model$math$WmiNumericModel).desiredAssertionStatus();
            ROUNDING_MINUS_LENGTH_COND = "&uminus0;".length() - 1;
            ROUNDING_MINUS_STOP_CHAR = "&uminus0;".charAt(ROUNDING_MINUS_LENGTH_COND);
            displayPrecision = -1;
        }
    }

    public static class WmiComplexBuilder
    implements WmiMathModelBuilder,
    WmiMathSemantics {
        public WmiMathModel createModel(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            String string = wmiMathContext.getImaginaryUnit();
            WmiNumericModel wmiNumericModel = new WmiNumericModel(wmiMathDocumentModel, string, string, wmiMathContext);
            wmiNumericModel.setSemantics(this);
            return wmiNumericModel;
        }

        public Dag toDag(WmiMathModel wmiMathModel) {
            Dag[] dagArray = new Dag[]{DagConstants.ONE};
            return Dag.createDag(6, dagArray, null, false);
        }
    }

    public static class WmiRationalBuilder
    implements WmiMathModelBuilder,
    WmiMathSemantics {
        private static final WmiInlineRationalSemantics INLINE_RATIONAL_SEMANTICS = new WmiInlineRationalSemantics();

        public WmiMathModel createModel(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            boolean bl = false;
            Dag dag2 = dag.getChild(0);
            if (DagUtil.isNegative(dag2)) {
                bl = true;
                dag2 = DagUtil.negate(dag2);
            }
            WmiMathModel wmiMathModel = WmiMathFactory.createMath(wmiMathDocumentModel, dag2, wmiMathContext);
            WmiMathModel wmiMathModel2 = WmiMathFactory.createMath(wmiMathDocumentModel, dag.getChild(1), wmiMathContext);
            WmiMathModel wmiMathModel3 = null;
            if (wmiMathContext.useProcRules()) {
                wmiMathModel3 = WmiRationalBuilder.createInlineFraction(wmiMathDocumentModel, wmiMathModel, wmiMathModel2, wmiMathContext);
            } else {
                wmiMathModel3 = new WmiFractionModel(wmiMathDocumentModel, wmiMathModel, wmiMathModel2, wmiMathContext);
                wmiMathModel3.setSemantics(new WmiAssignedSemantics(dag));
            }
            if (bl) {
                WmiModel[] wmiModelArray = new WmiMathModel[2];
                String string = wmiMathContext.useProcRules() ? "\u2212" : "&uminus0;";
                wmiModelArray[0] = new WmiMathOperatorModel(wmiMathDocumentModel, string, string, wmiMathContext);
                wmiModelArray[1] = wmiMathModel3;
                try {
                    wmiMathModel3 = new WmiInlineMathModel(wmiMathDocumentModel, wmiModelArray);
                }
                catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                    WmiErrorLog.log(wmiInvalidModelInitializationException);
                }
            }
            return wmiMathModel3;
        }

        public static WmiMathModel createInlineFraction(WmiMathDocumentModel wmiMathDocumentModel, WmiMathModel wmiMathModel, WmiMathModel wmiMathModel2, WmiMathContext wmiMathContext) throws WmiNoWriteAccessException {
            WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
            WmiModel[] wmiModelArray = new WmiMathModel[]{wmiMathModel, WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "/", wmiMathContext), wmiMathModel2};
            try {
                wmiInlineMathModel.replaceChildren(wmiModelArray, 0, 0);
            }
            catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
            }
            wmiInlineMathModel.setSemantics(INLINE_RATIONAL_SEMANTICS);
            return wmiInlineMathModel;
        }

        public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
            WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)((Object)wmiMathModel);
            WmiMathModel wmiMathModel2 = (WmiMathModel)wmiCompositeModel.getChild(0);
            WmiMathModel wmiMathModel3 = (WmiMathModel)wmiCompositeModel.getChild(1);
            Dag[] dagArray = new Dag[]{wmiMathModel2.toDag(), wmiMathModel3.toDag()};
            return Dag.createDag(3, dagArray, null, false);
        }
    }

    public static class WmiMaskBuilder
    implements WmiMathModelBuilder,
    WmiMathSemantics {
        private static final String EXPLICIT_EXPONENTIATION_OPERATOR = "^";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WmiMathModel createModel(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            WmiAbstractModel wmiAbstractModel;
            Object object;
            WmiInlineMathModel wmiInlineMathModel;
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
            WmiNumericFormatter wmiNumericFormatter = new WmiNumericFormatter(Character.toString(decimalFormatSymbols.getDecimalSeparator()), Character.toString(decimalFormatSymbols.getGroupingSeparator()));
            String string = wmiMathContext.getFormatMask();
            WmiNumericFormatter.WmiFormattedNumeric wmiFormattedNumeric = wmiNumericFormatter.format(dag, string);
            String string2 = new String("10");
            WmiInlineMathModel wmiInlineMathModel2 = wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
            String string3 = wmiFormattedNumeric.getMantissa();
            boolean bl = false;
            boolean bl2 = true;
            if (string3 != null) {
                for (int i = 0; i < string3.length(); ++i) {
                    if (!Character.isDigit(string3.charAt(i))) continue;
                    bl2 = false;
                    break;
                }
            }
            if (string3 == null || bl2) {
                bl = true;
            }
            if (wmiFormattedNumeric.getSign() == -1 && (string3.length() == 0 || string3.charAt(0) != '-')) {
                string3 = "-" + string3;
            }
            WmiNumericModel wmiNumericModel = null;
            WmiMathOperatorModel wmiMathOperatorModel = null;
            if (string3.length() > 0) {
                if (string3.charAt(0) == '-') {
                    wmiMathOperatorModel = new WmiMathOperatorModel(wmiMathDocumentModel, "&uminus0;", "&uminus0;", wmiMathContext);
                    wmiInlineMathModel2.appendChild(wmiMathOperatorModel);
                    string3 = string3.substring(1);
                }
                wmiNumericModel = new WmiNumericModel(wmiMathDocumentModel, string3, string3, wmiMathContext);
                wmiInlineMathModel2.appendChild(wmiNumericModel);
            }
            WmiModel wmiModel = null;
            WmiAbstractModel wmiAbstractModel2 = null;
            WmiAbstractModel wmiAbstractModel3 = null;
            String string4 = wmiFormattedNumeric.getExponent();
            if (string4 != null) {
                char c = string4.charAt(0);
                object = "";
                if (c == '-' || c == '+') {
                    string4 = string4.substring(1);
                    object = Character.toString(c);
                }
                if (!wmiMathContext.isEngineeringNotation() || Long.parseLong(string4) != 0L) {
                    wmiAbstractModel3 = new WmiMathOperatorModel(wmiMathDocumentModel, "&times;", "&times;", wmiMathContext);
                    wmiAbstractModel2 = new WmiNumericModel(wmiMathDocumentModel, string2, string2, wmiMathContext);
                    if (((String)object).length() == 0) {
                        wmiModel = new WmiNumericModel(wmiMathDocumentModel, string4, string4, wmiMathContext);
                    } else {
                        wmiAbstractModel = new WmiNumericModel(wmiMathDocumentModel, string4, string4, wmiMathContext);
                        WmiMathOperatorModel wmiMathOperatorModel2 = new WmiMathOperatorModel(wmiMathDocumentModel, (String)object, (String)object, wmiMathContext);
                        wmiModel = new WmiInlineMathModel(wmiMathDocumentModel);
                        ((WmiInlineMathModel)wmiModel).appendChild(wmiMathOperatorModel2);
                        ((WmiInlineMathModel)wmiModel).appendChild(wmiAbstractModel);
                    }
                    if (wmiMathContext.useProcRules()) {
                        wmiInlineMathModel2.appendChild(WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "&sdot;", wmiMathContext));
                        wmiInlineMathModel2.appendChild(wmiAbstractModel2);
                        wmiInlineMathModel2.appendChild(WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, EXPLICIT_EXPONENTIATION_OPERATOR, wmiMathContext));
                        wmiInlineMathModel2.appendChild(wmiModel);
                    } else {
                        if (!bl) {
                            wmiInlineMathModel2.appendChild(wmiAbstractModel3);
                        }
                        wmiAbstractModel = new WmiSuperscriptModel(wmiMathDocumentModel, wmiAbstractModel2, wmiModel, wmiMathContext);
                        wmiInlineMathModel2.appendChild(wmiAbstractModel);
                    }
                }
            }
            float[] fArray = wmiFormattedNumeric.getRGBColor();
            object = null;
            if (fArray != null) {
                object = new Color(fArray[0], fArray[1], fArray[2]);
            } else if (wmiMathContext.getStyle() != null) {
                object = new Color(wmiMathContext.getStyle().getForeground());
            }
            if (object != null) {
                if (wmiNumericModel != null) {
                    wmiNumericModel.addAttribute("foreground", object);
                }
                if (wmiModel != null) {
                    wmiAbstractModel3.addAttribute("foreground", object);
                    wmiModel.addAttribute("foreground", object);
                    wmiAbstractModel2.addAttribute("foreground", object);
                }
            }
            wmiAbstractModel = new WmiMathActionModel(wmiMathDocumentModel);
            wmiAbstractModel.addAttribute("actiontype", "maplesoft:numeric_formatting");
            wmiAbstractModel.setSemantics(new WmiAssignedSemantics(dag));
            try {
                WmiModelLock.writeLock(wmiAbstractModel, true);
                wmiAbstractModel.addChild(wmiInlineMathModel, 0);
            }
            catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                wmiNoWriteAccessException.printStackTrace();
            }
            catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                wmiModelIndexOutOfBoundsException.printStackTrace();
            }
            finally {
                WmiModelLock.writeUnlock(wmiAbstractModel);
            }
            return wmiAbstractModel;
        }

        public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
            return null;
        }
    }

    public static class WmiIntNegBuilder
    extends WmiIntBuilder {
        public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
            WmiModel wmiModel;
            WmiCompositeModel wmiCompositeModel;
            String string = null;
            int n = 2;
            if (wmiMathModel instanceof WmiTextModel) {
                WmiTextModel wmiTextModel = (WmiTextModel)((Object)wmiMathModel);
                string = wmiTextModel.getText();
                if (string.length() > 0 && (string.startsWith("&uminus0;") || string.startsWith("&minus;") || string.startsWith(" \u2212 ") || string.startsWith("\u2212"))) {
                    string = string.substring(1);
                    n = 1;
                }
            } else if (wmiMathModel instanceof WmiInlineMathModel && (wmiCompositeModel = (WmiCompositeModel)((Object)wmiMathModel)).getChildCount() == 2 && (wmiModel = wmiCompositeModel.getChild(1)) instanceof WmiTextModel) {
                string = ((WmiTextModel)wmiModel).getText();
            }
            return string != null ? Dag.createDag(n, null, string, false) : null;
        }

        public String getPrefix(WmiMathContext wmiMathContext) {
            return wmiMathContext.useProcRules() ? "\u2212" : "&uminus0;";
        }
    }

    public static class WmiIntPosBuilder
    extends WmiIntBuilder {
        public String getPrefix(WmiMathContext wmiMathContext) {
            return "";
        }

        public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
            WmiTextModel wmiTextModel = (WmiTextModel)((Object)wmiMathModel);
            String string = wmiTextModel.getText();
            return Dag.createDag(2, null, string, false);
        }
    }

    public static abstract class WmiIntBuilder
    extends WmiAbstractElisionBuilder
    implements WmiMathSemantics {
        public static final String ELISION_MARKER_TEXT = "digits";
        public static final String SINGLE_ELISION_MARKER_TEXT = "digit";
        private static final String LINEBREAK_CONTEXT_NAME = "integer";

        public WmiMathModel createModel(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoWriteAccessException {
            CharSequence charSequence;
            String string = dag.getData();
            int n = string.length();
            String string2 = string;
            if (this.isElisionRequired(n)) {
                charSequence = new StringBuffer();
                int n2 = n - this.leftSample - this.rightSample;
                ((StringBuffer)charSequence).append(string.substring(0, this.leftSample));
                ((StringBuffer)charSequence).append("[...");
                ((StringBuffer)charSequence).append(n2);
                ((StringBuffer)charSequence).append(" ");
                if (n2 > 1) {
                    ((StringBuffer)charSequence).append(this.getElisionMarkerText());
                } else {
                    ((StringBuffer)charSequence).append(this.getSingleElisionMarkerText());
                }
                ((StringBuffer)charSequence).append("...]");
                ((StringBuffer)charSequence).append(string.substring(n - this.rightSample, n));
                string2 = ((StringBuffer)charSequence).toString();
            }
            charSequence = string2;
            WmiAbstractModel wmiAbstractModel = new WmiNumericModel(wmiMathDocumentModel, (String)charSequence, string2, wmiMathContext);
            wmiAbstractModel.setSemantics(new WmiAssignedSemantics(dag));
            String string3 = this.getPrefix(wmiMathContext);
            if (string3 != null && string3.length() > 0) {
                WmiModel[] wmiModelArray = new WmiMathModel[]{new WmiMathOperatorModel(wmiMathDocumentModel, string3, string3, wmiMathContext), wmiAbstractModel};
                try {
                    wmiAbstractModel = new WmiInlineMathModel(wmiMathDocumentModel, wmiModelArray);
                }
                catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                    WmiErrorLog.log(wmiInvalidModelInitializationException);
                }
            }
            return wmiAbstractModel;
        }

        protected String getElisionThresholdProperty() {
            return "elisiondigitsthreshold";
        }

        protected String getElisionAfterProperty() {
            return "elisiondigitsafter";
        }

        protected String getElisionBeforeProperty() {
            return "elisiondigitsbefore";
        }

        protected int getDefaultElideThreshold() {
            return 10000;
        }

        public String getSingleElisionMarkerText() {
            return SINGLE_ELISION_MARKER_TEXT;
        }

        public String getElisionMarkerText() {
            return ELISION_MARKER_TEXT;
        }

        public abstract String getPrefix(WmiMathContext var1);

        public abstract Dag toDag(WmiMathModel var1) throws WmiNoReadAccessException;
    }
}

