/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeMathModel;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiAbstractModel;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiBooleanAttributeKey;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiDeleteHandler;
import com.maplesoft.mathdoc.model.WmiDeleteManager;
import com.maplesoft.mathdoc.model.WmiDeletePlaceholderModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSource;
import com.maplesoft.mathdoc.model.WmiIntAttributeKey;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiStringAttributeKey;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import java.util.HashMap;

public class WmiMathTableModel
extends WmiAbstractArrayCompositeMathModel
implements WmiMathModel,
WmiFontAttributeSource {
    private WmiMathSemantics semantics;
    protected WmiDeleteHandler deleteHandler = null;
    private boolean containsLabeledRow = false;
    private boolean containsAlignmentElement = false;
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();

    public WmiMathTableModel(WmiMathDocumentModel wmiMathDocumentModel) {
        super(wmiMathDocumentModel);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiMathTableModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray) throws WmiInvalidModelInitializationException {
        super(wmiMathDocumentModel, wmiModelArray);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public void update(String string) throws WmiNoUpdateAccessException {
        super.update(string);
        this.containsLabeledRow = this.findLabeledRow();
        this.containsAlignmentElement = this.findAlignmentElement();
    }

    public WmiModelTag getTag() {
        return WmiModelTag.MATH_TABLE;
    }

    public boolean isVisible() throws WmiNoReadAccessException {
        boolean bl = true;
        WmiMathDocumentModel wmiMathDocumentModel = this.getDocument();
        if (wmiMathDocumentModel != null) {
            bl = !wmiMathDocumentModel.isHidden(this);
        }
        return bl;
    }

    public Dag toDag() throws WmiNoReadAccessException {
        return null;
    }

    public void setSemantics(WmiMathSemantics wmiMathSemantics) {
        this.semantics = wmiMathSemantics;
    }

    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    public void setAttributes(WmiAttributeSet wmiAttributeSet) throws WmiNoWriteAccessException {
        if (wmiAttributeSet instanceof WmiMathTableAttributeSet) {
            super.setAttributes(wmiAttributeSet);
        } else {
            WmiErrorLog.log(new Exception("Invalid attribute set"));
        }
    }

    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiMathTableAttributeSet();
    }

    public boolean isSubselectable() {
        return false;
    }

    public boolean useScriptSize(WmiModel wmiModel) throws WmiNoReadAccessException {
        return false;
    }

    public String getNamedFontStyle() throws WmiNoReadAccessException {
        Object object;
        String string = null;
        WmiAttributeSet wmiAttributeSet = this.getAttributesForRead();
        if (wmiAttributeSet != null && (object = wmiAttributeSet.getAttribute("font_style_name")) != null) {
            string = object.toString();
        }
        return string;
    }

    public void updateFontStyle(String string) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiFontAttributeSet wmiFontAttributeSet = new WmiFontAttributeSet();
        wmiFontAttributeSet.setNamedFontStyle(string, this.getDocument());
        this.addAttributes(wmiFontAttributeSet);
    }

    public boolean isCrossBoundarySubselectable() {
        return false;
    }

    public WmiDeleteHandler getDeleteHandler() {
        if (this.deleteHandler == null) {
            this.deleteHandler = new WmiMathTableDeleteHandler(this);
        }
        return this.deleteHandler;
    }

    private boolean findLabeledRow() {
        boolean bl = false;
        try {
            for (int i = 0; i < this.getChildCount(); ++i) {
                WmiModel wmiModel = this.getChild(i);
                if (!(wmiModel instanceof WmiMathTableLabeledRowModel)) continue;
                bl = true;
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        return bl;
    }

    public boolean containsLabeledRow() {
        return this.containsLabeledRow;
    }

    private boolean findAlignmentElement() {
        WmiModelTag[] wmiModelTagArray = new WmiModelTag[]{WmiModelTag.MATH_ALIGN_GROUP, WmiModelTag.MATH_ALIGN_MARK};
        WmiModel wmiModel = null;
        try {
            wmiModel = WmiModelUtil.findFirstDescendantOfTag((WmiModel)this, wmiModelTagArray);
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        return wmiModel != null;
    }

    public boolean containsAlignmentElement() {
        return this.containsAlignmentElement;
    }

    public class WmiMathTableDeleteHandler
    implements WmiDeleteHandler {
        WmiMathTableModel model;

        WmiMathTableDeleteHandler(WmiMathTableModel wmiMathTableModel2) {
            this.model = wmiMathTableModel2;
        }

        public void processDelete(WmiDeleteManager wmiDeleteManager) throws WmiNoWriteAccessException, WmiNoReadAccessException, WmiModelIndexOutOfBoundsException {
            while (WmiModelUtil.getDeletedChildCount(this.model) > 0) {
                int n = WmiModelUtil.getFirstDeletePlaceHolderPosition(this.model);
                WmiModel wmiModel = ((WmiDeletePlaceholderModel)WmiMathTableModel.this.getChild(n)).getReplacedModel();
                if (wmiModel instanceof WmiMathTableRowModel) {
                    this.model.removeChild(n);
                }
                if (wmiDeleteManager.getModelToReposition() != null) continue;
                if (this.model.getChild(n) != null) {
                    wmiDeleteManager.setModelToReposition(new WmiModelPosition(this.model.getChild(n), 0));
                    continue;
                }
                wmiDeleteManager.setModelToReposition(new WmiModelPosition(this.model.getChild(0), 0));
            }
        }

        public boolean forceDeleteHandling() {
            return false;
        }
    }

    public static class WmiMathTableDataModel
    extends WmiAbstractArrayCompositeMathModel
    implements WmiMathModel {
        private WmiMathSemantics semantics;
        protected WmiDeleteHandler deleteHandler = null;

        public WmiMathTableDataModel(WmiMathDocumentModel wmiMathDocumentModel) {
            super(wmiMathDocumentModel);
        }

        public WmiMathTableDataModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel wmiModel) {
            super(wmiMathDocumentModel);
            try {
                this.appendChild(wmiModel);
            }
            catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                WmiErrorLog.log(wmiNoWriteAccessException);
            }
        }

        public WmiModelTag getTag() {
            return WmiModelTag.MATH_TABLE_CELL;
        }

        protected WmiAttributeSet createCompatibleAttributeSet() {
            return new WmiMathTableDataAttributeSet();
        }

        public boolean isVisible() throws WmiNoReadAccessException {
            boolean bl = true;
            WmiMathDocumentModel wmiMathDocumentModel = this.getDocument();
            if (wmiMathDocumentModel != null) {
                bl = !wmiMathDocumentModel.isHidden(this);
            }
            return bl;
        }

        public Dag toDag() throws WmiNoReadAccessException {
            return this.semantics != null ? this.semantics.toDag(this) : null;
        }

        public void setSemantics(WmiMathSemantics wmiMathSemantics) {
            this.semantics = wmiMathSemantics;
        }

        public WmiMathSemantics getSemantics() {
            return this.semantics;
        }

        public boolean isInEmptyRow() throws WmiNoReadAccessException {
            boolean bl = true;
            WmiCompositeModel wmiCompositeModel = this.getParent();
            int n = wmiCompositeModel.getChildCount();
            for (int i = 0; i < n && bl; ++i) {
                WmiMathTableDataModel wmiMathTableDataModel = (WmiMathTableDataModel)wmiCompositeModel.getChild(i);
                if (wmiMathTableDataModel.getChildCount() <= 0) continue;
                WmiModel wmiModel = wmiMathTableDataModel.getChild(0);
                bl = wmiModel instanceof WmiTextModel && ((WmiTextModel)wmiModel).getLength() == 0 || wmiModel instanceof WmiCompositeModel && ((WmiCompositeModel)wmiModel).getChildCount() == 0;
            }
            return n == 0 || bl;
        }

        public boolean isInEmptyColumn() throws WmiNoReadAccessException {
            boolean bl = true;
            WmiCompositeModel wmiCompositeModel = this.getParent();
            int n = wmiCompositeModel.indexOf(this);
            WmiCompositeModel wmiCompositeModel2 = wmiCompositeModel.getParent();
            int n2 = wmiCompositeModel2.getChildCount();
            for (int i = 0; i < n2 && bl; ++i) {
                WmiMathTableDataModel wmiMathTableDataModel;
                WmiMathTableRowModel wmiMathTableRowModel;
                if (!(wmiCompositeModel2.getChild(i) instanceof WmiMathTableRowModel) || !((wmiMathTableRowModel = (WmiMathTableRowModel)wmiCompositeModel2.getChild(i)).getChild(n) instanceof WmiMathTableDataModel) || (wmiMathTableDataModel = (WmiMathTableDataModel)wmiMathTableRowModel.getChild(n)).getChildCount() <= 0) continue;
                WmiModel wmiModel = wmiMathTableDataModel.getChild(0);
                bl = wmiModel instanceof WmiTextModel && ((WmiTextModel)wmiModel).getLength() == 0 || wmiModel instanceof WmiCompositeModel && ((WmiCompositeModel)wmiModel).getChildCount() == 0;
            }
            return n2 == 0 || bl;
        }

        public WmiDeleteHandler getDeleteHandler() {
            if (this.deleteHandler == null) {
                this.deleteHandler = new WmiMathTableDataDeleteHandler(this);
            }
            return this.deleteHandler;
        }

        public boolean useScriptSize(WmiModel wmiModel) throws WmiNoReadAccessException {
            return false;
        }

        public class WmiMathTableDataDeleteHandler
        implements WmiDeleteHandler {
            WmiMathTableDataModel model;

            WmiMathTableDataDeleteHandler(WmiMathTableDataModel wmiMathTableDataModel2) {
                this.model = wmiMathTableDataModel2;
            }

            public void processDelete(WmiDeleteManager wmiDeleteManager) throws WmiNoWriteAccessException, WmiNoReadAccessException, WmiModelIndexOutOfBoundsException {
                WmiAbstractModel wmiAbstractModel;
                int n;
                WmiAbstractModel wmiAbstractModel2;
                WmiModel wmiModel;
                int n2 = WmiModelUtil.getFirstDeletePlaceHolderPosition(this.model);
                if (n2 > -1) {
                    wmiModel = ((WmiDeletePlaceholderModel)WmiMathTableDataModel.this.getChild(0)).getReplacedModel();
                    WmiFontAttributeSet wmiFontAttributeSet = wmiModel.getAttributes() instanceof WmiFontAttributeSet ? (WmiFontAttributeSet)wmiModel.getAttributes() : new WmiMathAttributeSet();
                    wmiAbstractModel2 = new WmiIdentifierModel(WmiMathTableDataModel.this.getDocument(), "", "", wmiFontAttributeSet, false);
                    WmiMathTableDataModel.this.replaceChild(wmiAbstractModel2, 0);
                    if (wmiDeleteManager.getModelToReposition() == null) {
                        wmiDeleteManager.setModelToReposition(new WmiModelPosition(wmiAbstractModel2, 0));
                    }
                }
                if (this.model.isInEmptyColumn()) {
                    wmiModel = (WmiMathTableRowModel)this.model.getParent();
                    int n3 = ((WmiAbstractArrayCompositeModel)wmiModel).indexOf(this.model);
                    wmiAbstractModel2 = (WmiMathTableModel)((WmiAbstractModel)wmiModel).getParent();
                    if (((WmiAbstractArrayCompositeModel)wmiModel).getChildCount() > 1 && n3 > 0) {
                        for (n = 0; n < ((WmiAbstractArrayCompositeModel)wmiAbstractModel2).getChildCount(); ++n) {
                            wmiAbstractModel = (WmiMathTableRowModel)((WmiAbstractArrayCompositeModel)wmiAbstractModel2).getChild(n);
                            ((WmiAbstractArrayCompositeModel)wmiAbstractModel).removeChild(n3);
                        }
                        if (((WmiAbstractArrayCompositeModel)wmiModel).getChild(n3) != null) {
                            wmiDeleteManager.setModelToReposition(new WmiModelPosition(((WmiAbstractArrayCompositeModel)wmiModel).getChild(n3), 0));
                        } else if (((WmiAbstractArrayCompositeModel)wmiModel).getChild(0) != null) {
                            wmiDeleteManager.setModelToReposition(new WmiModelPosition(((WmiAbstractArrayCompositeModel)wmiModel).getChild(0), 0));
                        }
                    }
                }
                if (this.model.isInEmptyRow()) {
                    wmiModel = (WmiMathTableRowModel)WmiMathTableDataModel.this.getParent();
                    int n4 = ((WmiAbstractArrayCompositeModel)wmiModel).indexOf(this.model);
                    wmiAbstractModel2 = (WmiMathTableModel)((WmiAbstractModel)wmiModel).getParent();
                    n = ((WmiAbstractArrayCompositeModel)wmiAbstractModel2).indexOf(wmiModel);
                    wmiAbstractModel = new WmiDeletePlaceholderModel(wmiModel);
                    ((WmiAbstractArrayCompositeModel)wmiAbstractModel2).replaceChild(wmiAbstractModel, n);
                    wmiDeleteManager.mark((WmiCompositeModel)((Object)wmiAbstractModel2));
                    WmiModel wmiModel2 = wmiModel;
                    if (((WmiAbstractArrayCompositeModel)wmiAbstractModel2).getChild(n + 1) != null) {
                        wmiModel2 = (WmiMathTableRowModel)((WmiAbstractArrayCompositeModel)wmiAbstractModel2).getChild(n + 1);
                    } else if (((WmiAbstractArrayCompositeModel)wmiAbstractModel2).getChild(n - 1) != null) {
                        wmiModel2 = (WmiMathTableRowModel)((WmiAbstractArrayCompositeModel)wmiAbstractModel2).getChild(n - 1);
                    }
                    if (((WmiAbstractArrayCompositeModel)wmiModel2).getChild(n4) != null) {
                        wmiDeleteManager.setModelToReposition(new WmiModelPosition(((WmiAbstractArrayCompositeModel)wmiModel2).getChild(n4), 0));
                    } else if (((WmiAbstractArrayCompositeModel)wmiModel2).getChild(0) != null) {
                        wmiDeleteManager.setModelToReposition(new WmiModelPosition(((WmiAbstractArrayCompositeModel)wmiModel2).getChild(0), 0));
                    }
                }
            }

            public boolean forceDeleteHandling() {
                return false;
            }
        }

        public static class WmiMathTableDataAttributeSet
        extends WmiMathTableAttributeSet {
            private static HashMap keymap = null;
            private static HashMap cache = new HashMap();
            public static final String ROW_SPAN = "rowspan";
            public static final String COLUMN_SPAN = "columnspan";
            public static final String[] ATTRIBUTES = new String[]{"rowalign", "columnalign", "groupalign", "rowspan", "columnspan"};
            public static final WmiAttributeKey[] DATA_KEYS = new WmiAttributeKey[]{new RowAlignKey(), new ColumnAlignKey(), new GroupAlignKey(), new RowSpanKey(), new ColumnSpanKey()};
            public static final WmiAttributeKey[] EXTENDED_KEYS_TABLE_DATA = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiFontAttributeSet.ATTRIBUTE_KEYS, DATA_KEYS);
            protected Integer rowspan = null;
            protected Integer columnspan = null;

            public WmiMathTableDataAttributeSet() {
            }

            public WmiMathTableDataAttributeSet(WmiMathTableDataAttributeSet wmiMathTableDataAttributeSet) {
                this.rowalign = wmiMathTableDataAttributeSet.rowalign;
                this.columnalign = wmiMathTableDataAttributeSet.columnalign;
                this.groupalign = wmiMathTableDataAttributeSet.groupalign;
                this.rowspan = wmiMathTableDataAttributeSet.rowspan;
                this.columnspan = wmiMathTableDataAttributeSet.columnspan;
            }

            public WmiAttributeSet copyAttributes() {
                return new WmiMathTableDataAttributeSet(this);
            }

            public WmiAttributeKey[] getKeys() {
                return EXTENDED_KEYS_TABLE_DATA;
            }

            public HashMap getCache() {
                return cache;
            }

            protected HashMap getKeyMap() {
                return keymap;
            }

            protected void setKeyMap(HashMap hashMap) {
                keymap = hashMap;
            }

            public Integer getRowSpan() {
                return this.rowspan;
            }

            public Integer getColumnSpan() {
                return this.columnspan;
            }

            public static class ColumnSpanKey
            extends WmiIntAttributeKey {
                public ColumnSpanKey() {
                    super(WmiMathTableDataAttributeSet.COLUMN_SPAN, 1);
                }

                public int getIntValue(WmiAttributeSet wmiAttributeSet) {
                    return ((WmiMathTableDataAttributeSet)wmiAttributeSet).columnspan != null ? ((WmiMathTableDataAttributeSet)wmiAttributeSet).columnspan.intValue() : this.getDefaultValue();
                }

                public void setIntValue(WmiAttributeSet wmiAttributeSet, int n) {
                    ((WmiMathTableDataAttributeSet)wmiAttributeSet).columnspan = new Integer(n);
                }
            }

            public static class RowSpanKey
            extends WmiIntAttributeKey {
                public RowSpanKey() {
                    super(WmiMathTableDataAttributeSet.ROW_SPAN, 1);
                }

                public int getIntValue(WmiAttributeSet wmiAttributeSet) {
                    return ((WmiMathTableDataAttributeSet)wmiAttributeSet).rowspan != null ? ((WmiMathTableDataAttributeSet)wmiAttributeSet).rowspan.intValue() : this.getDefaultValue();
                }

                public void setIntValue(WmiAttributeSet wmiAttributeSet, int n) {
                    ((WmiMathTableDataAttributeSet)wmiAttributeSet).rowspan = new Integer(n);
                }
            }

            public static class GroupAlignKey
            extends WmiMathTableAttributeSet.GroupAlignKey {
                public GroupAlignKey() {
                    super("groupalign", "");
                }
            }

            public static class ColumnAlignKey
            extends WmiMathTableAttributeSet.ColumnAlignKey {
                public ColumnAlignKey() {
                    super("columnalign", "");
                }
            }

            public static class RowAlignKey
            extends WmiMathTableAttributeSet.RowAlignKey {
                public RowAlignKey() {
                    super("rowalign", "");
                }
            }
        }
    }

    public static class WmiMathTableLabeledRowModel
    extends WmiMathTableRowModel {
        public WmiMathTableLabeledRowModel(WmiMathDocumentModel wmiMathDocumentModel) {
            super(wmiMathDocumentModel);
        }

        public WmiMathTableLabeledRowModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray) throws WmiInvalidModelInitializationException {
            super(wmiMathDocumentModel, wmiModelArray);
        }

        public WmiMathTableLabeledRowModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel wmiModel) {
            super(wmiMathDocumentModel, wmiModel);
        }

        public WmiModelTag getTag() {
            return WmiModelTag.MATH_TABLE_LABELED_ROW;
        }
    }

    public static class WmiMathTableRowModel
    extends WmiAbstractArrayCompositeMathModel
    implements WmiMathModel {
        private WmiMathSemantics semantics;
        protected WmiDeleteHandler deleteHandler = null;

        public WmiMathTableRowModel(WmiMathDocumentModel wmiMathDocumentModel) {
            super(wmiMathDocumentModel);
        }

        public WmiMathTableRowModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray) throws WmiInvalidModelInitializationException {
            super(wmiMathDocumentModel, wmiModelArray);
        }

        public WmiMathTableRowModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel wmiModel) {
            super(wmiMathDocumentModel);
            try {
                this.appendChild(wmiModel);
            }
            catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                WmiErrorLog.log(wmiNoWriteAccessException);
            }
        }

        public WmiModelTag getTag() {
            return WmiModelTag.MATH_TABLE_ROW;
        }

        public boolean isVisible() throws WmiNoReadAccessException {
            boolean bl = true;
            WmiMathDocumentModel wmiMathDocumentModel = this.getDocument();
            if (wmiMathDocumentModel != null) {
                bl = !wmiMathDocumentModel.isHidden(this);
            }
            return bl;
        }

        public Dag toDag() throws WmiNoReadAccessException {
            return this.semantics != null ? this.semantics.toDag(this) : null;
        }

        public void setSemantics(WmiMathSemantics wmiMathSemantics) {
            this.semantics = wmiMathSemantics;
        }

        public WmiMathSemantics getSemantics() {
            return this.semantics;
        }

        protected WmiAttributeSet createCompatibleAttributeSet() {
            return new WmiMathTableRowAttributeSet();
        }

        public WmiDeleteHandler getDeleteHandler() {
            if (this.deleteHandler == null) {
                this.deleteHandler = new WmiMathTableRowDeleteHandler(this);
            }
            return this.deleteHandler;
        }

        public boolean useScriptSize(WmiModel wmiModel) throws WmiNoReadAccessException {
            return false;
        }

        public class WmiMathTableRowDeleteHandler
        implements WmiDeleteHandler {
            WmiMathTableRowModel model;

            WmiMathTableRowDeleteHandler(WmiMathTableRowModel wmiMathTableRowModel2) {
                this.model = wmiMathTableRowModel2;
            }

            public void processDelete(WmiDeleteManager wmiDeleteManager) throws WmiNoWriteAccessException, WmiNoReadAccessException, WmiModelIndexOutOfBoundsException {
                while (WmiModelUtil.getDeletedChildCount(this.model) > 0) {
                    int n = WmiModelUtil.getFirstDeletePlaceHolderPosition(this.model);
                    WmiModel wmiModel = ((WmiDeletePlaceholderModel)WmiMathTableRowModel.this.getChild(n)).getReplacedModel();
                    WmiMathTableRowModel.this.replaceChild(wmiModel, n);
                    if (!(wmiModel instanceof WmiMathTableDataModel)) continue;
                    WmiMathTableDataModel wmiMathTableDataModel = (WmiMathTableDataModel)wmiModel;
                    WmiModel wmiModel2 = wmiMathTableDataModel.getChild(0);
                    WmiDeletePlaceholderModel wmiDeletePlaceholderModel = new WmiDeletePlaceholderModel(wmiModel2);
                    wmiMathTableDataModel.replaceChild(wmiDeletePlaceholderModel, 0);
                    wmiDeleteManager.mark(wmiMathTableDataModel);
                }
            }

            public boolean forceDeleteHandling() {
                return false;
            }
        }

        public static class WmiMathTableRowAttributeSet
        extends WmiMathTableAttributeSet {
            private static HashMap keymap = null;
            private static HashMap cache = new HashMap();
            public static final String[] ATTRIBUTES = new String[]{"rowalign", "columnalign", "groupalign"};
            public static final WmiAttributeKey[] ROW_KEYS = new WmiAttributeKey[]{new RowAlignKey(), new ColumnAlignKey(), new GroupAlignKey()};
            public static final WmiAttributeKey[] EXTENDED_KEYS_TABLE_ROW = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiFontAttributeSet.ATTRIBUTE_KEYS, ROW_KEYS);

            public WmiMathTableRowAttributeSet() {
            }

            public WmiMathTableRowAttributeSet(WmiMathTableRowAttributeSet wmiMathTableRowAttributeSet) {
                this.rowalign = wmiMathTableRowAttributeSet.rowalign;
                this.columnalign = wmiMathTableRowAttributeSet.columnalign;
                this.groupalign = wmiMathTableRowAttributeSet.groupalign;
            }

            public WmiAttributeSet copyAttributes() {
                return new WmiMathTableRowAttributeSet(this);
            }

            public WmiAttributeKey[] getKeys() {
                return EXTENDED_KEYS_TABLE_ROW;
            }

            public HashMap getCache() {
                return cache;
            }

            protected HashMap getKeyMap() {
                return keymap;
            }

            protected void setKeyMap(HashMap hashMap) {
                keymap = hashMap;
            }

            public static class GroupAlignKey
            extends WmiMathTableAttributeSet.GroupAlignKey {
                public GroupAlignKey() {
                    super("groupalign", "");
                }
            }

            public static class ColumnAlignKey
            extends WmiMathTableAttributeSet.ColumnAlignKey {
                public ColumnAlignKey() {
                    super("columnalign", "");
                }
            }

            public static class RowAlignKey
            extends WmiMathTableAttributeSet.RowAlignKey {
                public RowAlignKey() {
                    super("rowalign", "");
                }
            }
        }
    }

    public static class WmiMathTableAttributeSet
    extends WmiFontAttributeSet {
        public static final String ALIGN = "align";
        public static final String ROW_ALIGN = "rowalign";
        public static final String COLUMN_ALIGN = "columnalign";
        public static final String GROUP_ALIGN = "groupalign";
        public static final String ALIGNMENT_SCOPE = "alignmentscope";
        public static final String COLUMN_WIDTH = "columnwidth";
        public static final String WIDTH = "width";
        public static final String ROW_SPACING = "rowspacing";
        public static final String COLUMN_SPACING = "columnspacing";
        public static final String ROW_LINES = "rowlines";
        public static final String COLUMN_LINES = "columnlines";
        public static final String FRAME = "frame";
        public static final String FRAME_SPACING = "framespacing";
        public static final String EQUAL_ROWS = "equalrows";
        public static final String EQUAL_COLUMNS = "equalcolumns";
        public static final String DISPLAY_STYLE = "displaystyle";
        public static final String SIDE = "side";
        public static final String MIN_LABEL_SPACING = "minlabelspacing";
        private static HashMap keymap = null;
        private static HashMap cache = new HashMap();
        public static final String[] ATTRIBUTES = new String[]{"align", "rowalign", "columnalign", "groupalign", "alignmentscope", "columnwidth", "width", "rowspacing", "columnspacing", "rowlines", "columnlines", "frame", "framespacing", "equalrows", "equalcolumns", "displaystyle", "side", "minlabelspacing"};
        protected String alignVal = null;
        protected String rowalign = null;
        protected String columnalign = null;
        protected String groupalign = null;
        protected String alignmentscope = null;
        protected String columnwidth = null;
        protected String widthVal = null;
        protected String rowspacing = null;
        protected String columnspacing = null;
        protected String rowlines = null;
        protected String columnlines = null;
        protected String frameVal = null;
        protected String framespacing = null;
        protected Boolean equalrows = null;
        protected Boolean equalcolumns = null;
        protected Boolean displaystyle = null;
        protected String sideVal = null;
        protected String minlabelspacing = null;
        public static final WmiAttributeKey[] TABLE_KEYS = new WmiAttributeKey[]{new AlignKey(), new RowAlignKey(), new ColumnAlignKey(), new GroupAlignKey(), new AlignmentScopeKey(), new ColumnWidthKey(), new WidthKey(), new RowSpacingKey(), new ColumnSpacingKey(), new RowLinesKey(), new ColumnLinesKey(), new FrameKey(), new FrameSpacingKey(), new EqualRowsKey(), new EqualColumnsKey(), new DisplayStyleKey(), new SideKey(), new MinLabelSpacingKey()};
        public static final WmiAttributeKey[] EXTENDED_KEYS_TABLE = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiFontAttributeSet.ATTRIBUTE_KEYS, TABLE_KEYS);

        public WmiMathTableAttributeSet() {
        }

        public WmiMathTableAttributeSet(WmiMathTableAttributeSet wmiMathTableAttributeSet) {
            this.alignVal = wmiMathTableAttributeSet.alignVal;
            this.rowalign = wmiMathTableAttributeSet.rowalign;
            this.columnalign = wmiMathTableAttributeSet.columnalign;
            this.groupalign = wmiMathTableAttributeSet.groupalign;
            this.alignmentscope = wmiMathTableAttributeSet.alignmentscope;
            this.columnwidth = wmiMathTableAttributeSet.columnwidth;
            this.widthVal = wmiMathTableAttributeSet.widthVal;
            this.rowspacing = wmiMathTableAttributeSet.rowspacing;
            this.columnspacing = wmiMathTableAttributeSet.columnspacing;
            this.rowlines = wmiMathTableAttributeSet.rowlines;
            this.columnlines = wmiMathTableAttributeSet.columnlines;
            this.frameVal = wmiMathTableAttributeSet.frameVal;
            this.framespacing = wmiMathTableAttributeSet.framespacing;
            this.equalrows = wmiMathTableAttributeSet.equalrows;
            this.equalcolumns = wmiMathTableAttributeSet.equalcolumns;
            this.displaystyle = wmiMathTableAttributeSet.displaystyle;
            this.sideVal = wmiMathTableAttributeSet.sideVal;
            this.minlabelspacing = wmiMathTableAttributeSet.minlabelspacing;
        }

        public WmiAttributeSet copyAttributes() {
            return new WmiMathTableAttributeSet(this);
        }

        public void addAttributes(WmiAttributeSet wmiAttributeSet) {
            super.addAttributes(wmiAttributeSet);
            if (wmiAttributeSet instanceof WmiMathTableAttributeSet) {
                WmiMathTableAttributeSet wmiMathTableAttributeSet = (WmiMathTableAttributeSet)wmiAttributeSet;
                this.alignVal = wmiMathTableAttributeSet.alignVal;
                this.rowalign = wmiMathTableAttributeSet.rowalign;
                this.columnalign = wmiMathTableAttributeSet.columnalign;
                this.groupalign = wmiMathTableAttributeSet.groupalign;
                this.alignmentscope = wmiMathTableAttributeSet.alignmentscope;
                this.columnwidth = wmiMathTableAttributeSet.columnwidth;
                this.widthVal = wmiMathTableAttributeSet.widthVal;
                this.rowspacing = wmiMathTableAttributeSet.rowspacing;
                this.columnspacing = wmiMathTableAttributeSet.columnspacing;
                this.rowlines = wmiMathTableAttributeSet.rowlines;
                this.columnlines = wmiMathTableAttributeSet.columnlines;
                this.frameVal = wmiMathTableAttributeSet.frameVal;
                this.framespacing = wmiMathTableAttributeSet.framespacing;
                this.equalrows = wmiMathTableAttributeSet.equalrows;
                this.equalcolumns = wmiMathTableAttributeSet.equalcolumns;
                this.displaystyle = wmiMathTableAttributeSet.displaystyle;
                this.sideVal = wmiMathTableAttributeSet.sideVal;
                this.minlabelspacing = wmiMathTableAttributeSet.minlabelspacing;
            }
        }

        public WmiAttributeKey[] getKeys() {
            return EXTENDED_KEYS_TABLE;
        }

        public HashMap getCache() {
            return cache;
        }

        protected HashMap getKeyMap() {
            return keymap;
        }

        protected void setKeyMap(HashMap hashMap) {
            keymap = hashMap;
        }

        public String getAlign() {
            return this.alignVal;
        }

        public String getRowAlign() {
            return this.rowalign;
        }

        public String getColumnAlign() {
            return this.columnalign;
        }

        public String getGroupAlign() {
            return this.groupalign;
        }

        public String getAlignmentScope() {
            return this.alignmentscope;
        }

        public String getColumnWidth() {
            return this.columnwidth;
        }

        public String getWidth() {
            return this.widthVal;
        }

        public String getRowSpacing() {
            return this.rowspacing;
        }

        public String getColumnSpacing() {
            return this.columnspacing;
        }

        public String getRowLines() {
            return this.rowlines;
        }

        public String getColumnLines() {
            return this.columnlines;
        }

        public String getFrame() {
            return this.frameVal;
        }

        public String getFrameSpacing() {
            return this.framespacing;
        }

        public boolean getEqualRows() {
            return this.equalrows != null ? this.equalrows : false;
        }

        public boolean getEqualColumns() {
            return this.equalcolumns != null ? this.equalcolumns : false;
        }

        public boolean getDisplayStyle() {
            return this.displaystyle != null ? this.displaystyle : false;
        }

        public String getSide() {
            return this.sideVal != null ? this.sideVal : "";
        }

        public String getMinLabelSpacing() {
            return this.minlabelspacing;
        }

        public static class MinLabelSpacingKey
        extends WmiStringAttributeKey {
            public MinLabelSpacingKey() {
                super(WmiMathTableAttributeSet.MIN_LABEL_SPACING, "0.8em");
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathTableAttributeSet)wmiAttributeSet).minlabelspacing != null ? ((WmiMathTableAttributeSet)wmiAttributeSet).minlabelspacing : this.getDefaultValue();
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                ((WmiMathTableAttributeSet)wmiAttributeSet).minlabelspacing = string;
            }
        }

        public static class SideKey
        extends WmiStringAttributeKey {
            public SideKey() {
                super(WmiMathTableAttributeSet.SIDE, "right");
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathTableAttributeSet)wmiAttributeSet).sideVal != null ? ((WmiMathTableAttributeSet)wmiAttributeSet).sideVal : this.getDefaultValue();
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                ((WmiMathTableAttributeSet)wmiAttributeSet).sideVal = string;
            }
        }

        public static class DisplayStyleKey
        extends WmiBooleanAttributeKey {
            public DisplayStyleKey() {
                super(WmiMathTableAttributeSet.DISPLAY_STYLE, false);
            }

            public boolean getBooleanValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathTableAttributeSet)wmiAttributeSet).displaystyle != null ? ((WmiMathTableAttributeSet)wmiAttributeSet).displaystyle.booleanValue() : this.getDefaultValue();
            }

            public void setBooleanValue(WmiAttributeSet wmiAttributeSet, boolean bl) {
                ((WmiMathTableAttributeSet)wmiAttributeSet).displaystyle = new Boolean(bl);
            }
        }

        public static class EqualColumnsKey
        extends WmiBooleanAttributeKey {
            public EqualColumnsKey() {
                super(WmiMathTableAttributeSet.EQUAL_COLUMNS, false);
            }

            public boolean getBooleanValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathTableAttributeSet)wmiAttributeSet).equalcolumns != null ? ((WmiMathTableAttributeSet)wmiAttributeSet).equalcolumns.booleanValue() : this.getDefaultValue();
            }

            public void setBooleanValue(WmiAttributeSet wmiAttributeSet, boolean bl) {
                ((WmiMathTableAttributeSet)wmiAttributeSet).equalcolumns = new Boolean(bl);
            }
        }

        public static class EqualRowsKey
        extends WmiBooleanAttributeKey {
            public EqualRowsKey() {
                super(WmiMathTableAttributeSet.EQUAL_ROWS, false);
            }

            public boolean getBooleanValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathTableAttributeSet)wmiAttributeSet).equalrows != null ? ((WmiMathTableAttributeSet)wmiAttributeSet).equalrows.booleanValue() : this.getDefaultValue();
            }

            public void setBooleanValue(WmiAttributeSet wmiAttributeSet, boolean bl) {
                ((WmiMathTableAttributeSet)wmiAttributeSet).equalrows = new Boolean(bl);
            }
        }

        public static class FrameSpacingKey
        extends WmiStringAttributeKey {
            public FrameSpacingKey() {
                super(WmiMathTableAttributeSet.FRAME_SPACING, "0.4em 0.5ex");
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathTableAttributeSet)wmiAttributeSet).framespacing != null ? ((WmiMathTableAttributeSet)wmiAttributeSet).framespacing : this.getDefaultValue();
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                ((WmiMathTableAttributeSet)wmiAttributeSet).framespacing = string;
            }
        }

        public static class FrameKey
        extends WmiStringAttributeKey {
            public FrameKey() {
                super(WmiMathTableAttributeSet.FRAME, "none");
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathTableAttributeSet)wmiAttributeSet).frameVal != null ? ((WmiMathTableAttributeSet)wmiAttributeSet).frameVal : this.getDefaultValue();
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                ((WmiMathTableAttributeSet)wmiAttributeSet).frameVal = string;
            }
        }

        public static class ColumnLinesKey
        extends WmiStringAttributeKey {
            public ColumnLinesKey() {
                super(WmiMathTableAttributeSet.COLUMN_LINES, "none");
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathTableAttributeSet)wmiAttributeSet).columnlines != null ? ((WmiMathTableAttributeSet)wmiAttributeSet).columnlines : this.getDefaultValue();
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                ((WmiMathTableAttributeSet)wmiAttributeSet).columnlines = string;
            }
        }

        public static class RowLinesKey
        extends WmiStringAttributeKey {
            public RowLinesKey() {
                super(WmiMathTableAttributeSet.ROW_LINES, "none");
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathTableAttributeSet)wmiAttributeSet).rowlines != null ? ((WmiMathTableAttributeSet)wmiAttributeSet).rowlines : this.getDefaultValue();
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                ((WmiMathTableAttributeSet)wmiAttributeSet).rowlines = string;
            }
        }

        public static class ColumnSpacingKey
        extends WmiStringAttributeKey {
            public ColumnSpacingKey() {
                super(WmiMathTableAttributeSet.COLUMN_SPACING, "0.8em");
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathTableAttributeSet)wmiAttributeSet).columnspacing != null ? ((WmiMathTableAttributeSet)wmiAttributeSet).columnspacing : this.getDefaultValue();
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                ((WmiMathTableAttributeSet)wmiAttributeSet).columnspacing = string;
            }
        }

        public static class RowSpacingKey
        extends WmiStringAttributeKey {
            public RowSpacingKey() {
                super(WmiMathTableAttributeSet.ROW_SPACING, "1.0ex");
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathTableAttributeSet)wmiAttributeSet).rowspacing != null ? ((WmiMathTableAttributeSet)wmiAttributeSet).rowspacing : this.getDefaultValue();
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                ((WmiMathTableAttributeSet)wmiAttributeSet).rowspacing = string;
            }
        }

        public static class WidthKey
        extends WmiStringAttributeKey {
            public WidthKey() {
                super(WmiMathTableAttributeSet.WIDTH, "auto");
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathTableAttributeSet)wmiAttributeSet).widthVal != null ? ((WmiMathTableAttributeSet)wmiAttributeSet).widthVal : this.getDefaultValue();
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                ((WmiMathTableAttributeSet)wmiAttributeSet).widthVal = string;
            }
        }

        public static class ColumnWidthKey
        extends WmiStringAttributeKey {
            public ColumnWidthKey() {
                super(WmiMathTableAttributeSet.COLUMN_WIDTH, "auto");
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathTableAttributeSet)wmiAttributeSet).columnwidth != null ? ((WmiMathTableAttributeSet)wmiAttributeSet).columnwidth : this.getDefaultValue();
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                ((WmiMathTableAttributeSet)wmiAttributeSet).columnwidth = string;
            }
        }

        public static class AlignmentScopeKey
        extends WmiStringAttributeKey {
            public AlignmentScopeKey() {
                super(WmiMathTableAttributeSet.ALIGNMENT_SCOPE, "true");
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathTableAttributeSet)wmiAttributeSet).alignmentscope != null ? ((WmiMathTableAttributeSet)wmiAttributeSet).alignmentscope : this.getDefaultValue();
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                ((WmiMathTableAttributeSet)wmiAttributeSet).alignmentscope = string;
            }
        }

        public static class GroupAlignKey
        extends WmiStringAttributeKey {
            public GroupAlignKey() {
                super(WmiMathTableAttributeSet.GROUP_ALIGN, "{left}");
            }

            public GroupAlignKey(String string, String string2) {
                super(string, string2);
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathTableAttributeSet)wmiAttributeSet).groupalign != null ? ((WmiMathTableAttributeSet)wmiAttributeSet).groupalign : this.getDefaultValue();
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                ((WmiMathTableAttributeSet)wmiAttributeSet).groupalign = string;
            }
        }

        public static class ColumnAlignKey
        extends WmiStringAttributeKey {
            public ColumnAlignKey() {
                super(WmiMathTableAttributeSet.COLUMN_ALIGN, "center");
            }

            public ColumnAlignKey(String string, String string2) {
                super(string, string2);
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathTableAttributeSet)wmiAttributeSet).columnalign != null ? ((WmiMathTableAttributeSet)wmiAttributeSet).columnalign : this.getDefaultValue();
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                ((WmiMathTableAttributeSet)wmiAttributeSet).columnalign = string;
            }
        }

        public static class RowAlignKey
        extends WmiStringAttributeKey {
            public RowAlignKey() {
                super(WmiMathTableAttributeSet.ROW_ALIGN, "baseline");
            }

            public RowAlignKey(String string, String string2) {
                super(string, string2);
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathTableAttributeSet)wmiAttributeSet).rowalign != null ? ((WmiMathTableAttributeSet)wmiAttributeSet).rowalign : this.getDefaultValue();
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                ((WmiMathTableAttributeSet)wmiAttributeSet).rowalign = string;
            }
        }

        public static class AlignKey
        extends WmiStringAttributeKey {
            public AlignKey() {
                super(WmiMathTableAttributeSet.ALIGN, "axis");
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathTableAttributeSet)wmiAttributeSet).alignVal != null ? ((WmiMathTableAttributeSet)wmiAttributeSet).alignVal : this.getDefaultValue();
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                ((WmiMathTableAttributeSet)wmiAttributeSet).alignVal = string;
            }
        }
    }
}

