/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagRenderContext;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractModel;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiAssignmentBuilder;
import com.maplesoft.mathdoc.model.math.WmiCatenateBuilder;
import com.maplesoft.mathdoc.model.math.WmiCollectionBuilder;
import com.maplesoft.mathdoc.model.math.WmiDColonBuilder;
import com.maplesoft.mathdoc.model.math.WmiDefaultMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiForStatementBuilder;
import com.maplesoft.mathdoc.model.math.WmiFunctionBuilder;
import com.maplesoft.mathdoc.model.math.WmiHashTableBuilder;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiIfStatementBuilder;
import com.maplesoft.mathdoc.model.math.WmiKeyWordBuilder;
import com.maplesoft.mathdoc.model.math.WmiLPrintIdentifierBuilder;
import com.maplesoft.mathdoc.model.math.WmiLocalBuilder;
import com.maplesoft.mathdoc.model.math.WmiLogicalBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorDictionary;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathStringModel;
import com.maplesoft.mathdoc.model.math.WmiMathTextModel;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiMemberBuilder;
import com.maplesoft.mathdoc.model.math.WmiNotBuilder;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import com.maplesoft.mathdoc.model.math.WmiOverModel;
import com.maplesoft.mathdoc.model.math.WmiPowerBuilder;
import com.maplesoft.mathdoc.model.math.WmiProcBuilder;
import com.maplesoft.mathdoc.model.math.WmiProductBuilder;
import com.maplesoft.mathdoc.model.math.WmiRangeBuilder;
import com.maplesoft.mathdoc.model.math.WmiRelationalBuilder;
import com.maplesoft.mathdoc.model.math.WmiRenderContextAwareBuilder;
import com.maplesoft.mathdoc.model.math.WmiSeriesBuilder;
import com.maplesoft.mathdoc.model.math.WmiSubexpressionLabelUtil;
import com.maplesoft.mathdoc.model.math.WmiSumBuilder;
import com.maplesoft.mathdoc.model.math.WmiTablerefBuilder;
import com.maplesoft.mathdoc.model.math.WmiTryStatementBuilder;
import com.maplesoft.mathdoc.model.math.WmiUnevalBuilder;
import com.maplesoft.mathdoc.model.math.WmiUseBuilder;
import com.maplesoft.util.WmiMathEntityNameMapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class WmiMathFactory {
    public static final float SUPERSCRIPT_SCALE = 0.8f;
    public static final float LARGE_SYMBOL_SCALE = 2.0f;
    public static final float SUPERSCRIPT_LARGE_SYMBOL_SCALE = 1.6f;
    public static final int DEFAULT_FONT_SIZE = 12;
    public static WmiMathSemantics BRACKET_SEMANTICS;
    private static WmiMathModelBuilder[] builders;
    private static WmiMathModelBuilder defaultBuilder;
    private static ArrayList contextAwareBuilders;
    private static Set numericEntities;
    private static boolean subexpressionLabellingOn;
    private static int labelWidth;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static WmiMathModelBuilder getBuilder(int n) {
        if (builders == null) {
            builders = new WmiMathModelBuilder[60];
            try {
                WmiMathFactory.initializeFactory();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return builders[n];
    }

    public static WmiMathModel createMathModel(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, String string) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathContext wmiMathContext = new WmiMathContext(wmiMathDocumentModel.getFontStyle(string));
        return WmiMathFactory.createMathModel(wmiMathDocumentModel, dag, wmiMathContext);
    }

    public static WmiMathModel createMathModel(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (wmiMathContext.isSubexpressionLabellingActive()) {
            WmiSubexpressionLabelUtil.locateDuplicates(dag, wmiMathContext);
        }
        WmiMathModel wmiMathModel = WmiMathFactory.createMath(wmiMathDocumentModel, dag, wmiMathContext);
        if (wmiMathContext.needsAssumptionSummary()) {
            wmiMathModel = new WmiOverModel(wmiMathDocumentModel, wmiMathContext.reportAssumptions(wmiMathDocumentModel), wmiMathModel, wmiMathContext);
        }
        if (wmiMathContext.needsSubexpressionLabelDetails()) {
            wmiMathModel = new WmiOverModel(wmiMathDocumentModel, wmiMathContext.reportSubexpressions(wmiMathDocumentModel), wmiMathModel, wmiMathContext);
        }
        return wmiMathModel;
    }

    public static WmiMathModel createMath(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel wmiMathModel = null;
        int n = dag.getType();
        if (n == 3) {
            wmiMathContext.setInRational(true);
        }
        if (n > 0 && n < 60) {
            WmiMathModelBuilder wmiMathModelBuilder = WmiMathFactory.getBuilder(n);
            if (wmiMathContext.isApplyNumericFormattingOnBuild() && wmiMathContext.getFormatMask() != null && wmiMathContext.getFormatMask().length() > 0 && n <= 5 && (n <= 2 && wmiMathContext.isApplyInteger() && !wmiMathContext.isInRational() || n == 3 && wmiMathContext.isApplyRational() || n > 3)) {
                wmiMathModelBuilder = new WmiNumericModel.WmiMaskBuilder();
            }
            if (wmiMathModelBuilder != null) {
                wmiMathModel = wmiMathModelBuilder.createModel(dag, wmiMathDocumentModel, wmiMathContext);
            }
        }
        if (wmiMathModel == null) {
            wmiMathModel = defaultBuilder.createModel(dag, wmiMathDocumentModel, wmiMathContext);
        }
        if (n == 3) {
            wmiMathContext.setInRational(false);
        }
        return wmiMathModel;
    }

    public static WmiMathModel createMath(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, String string) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathContext wmiMathContext = new WmiMathContext(wmiMathDocumentModel.getFontStyle(string));
        return WmiMathFactory.createMath(wmiMathDocumentModel, dag, wmiMathContext);
    }

    public static WmiMathTokenModel createMathIdentifierToken(WmiMathDocumentModel wmiMathDocumentModel, String string, WmiMathContext wmiMathContext) {
        return WmiMathFactory.createMathToken(wmiMathDocumentModel, WmiModelTag.MATH_IDENTIFIER, string, wmiMathContext);
    }

    public static WmiMathTokenModel createMathNumericToken(WmiMathDocumentModel wmiMathDocumentModel, String string, WmiMathContext wmiMathContext) {
        return WmiMathFactory.createMathToken(wmiMathDocumentModel, WmiModelTag.MATH_NUMERIC, string, wmiMathContext);
    }

    public static WmiMathTokenModel createMathTextToken(WmiMathDocumentModel wmiMathDocumentModel, String string, WmiMathContext wmiMathContext) {
        return WmiMathFactory.createMathToken(wmiMathDocumentModel, WmiModelTag.MATH_TEXT, string, wmiMathContext);
    }

    public static WmiMathTokenModel createMathOperatorToken(WmiMathDocumentModel wmiMathDocumentModel, String string, WmiMathContext wmiMathContext) {
        return WmiMathFactory.createMathToken(wmiMathDocumentModel, WmiModelTag.MATH_OPERATOR, string, wmiMathContext);
    }

    public static WmiMathTokenModel createMathToken(WmiMathDocumentModel wmiMathDocumentModel, WmiModelTag wmiModelTag, String string, WmiMathContext wmiMathContext) {
        WmiAbstractMathTokenModel wmiAbstractMathTokenModel = null;
        if (wmiModelTag == WmiModelTag.MATH_TEXT) {
            wmiAbstractMathTokenModel = !WmiMathEntityNameMapper.isNonMarkingEntity(string) ? new WmiMathTextModel(wmiMathDocumentModel, string, wmiMathContext) : new WmiMathTextModel(wmiMathDocumentModel, string, wmiMathContext);
        } else if (wmiModelTag == WmiModelTag.MATH_IDENTIFIER || wmiModelTag == WmiModelTag.MATH_OPERATOR || wmiModelTag == WmiModelTag.MATH_NUMERIC) {
            if (wmiModelTag == WmiModelTag.MATH_OPERATOR) {
                wmiAbstractMathTokenModel = new WmiMathOperatorModel(wmiMathDocumentModel, string, string, wmiMathContext);
            } else if (wmiModelTag == WmiModelTag.MATH_IDENTIFIER) {
                wmiAbstractMathTokenModel = new WmiIdentifierModel(wmiMathDocumentModel, string, string, wmiMathContext, false);
            } else if (wmiModelTag == WmiModelTag.MATH_NUMERIC) {
                wmiAbstractMathTokenModel = new WmiNumericModel(wmiMathDocumentModel, string, string, wmiMathContext);
            }
        }
        return wmiAbstractMathTokenModel;
    }

    public static WmiModelTag getTagForEntity(String string) {
        WmiModelTag wmiModelTag = WmiModelTag.MATH_IDENTIFIER;
        if (WmiMathOperatorDictionary.isNameForOperator(string)) {
            wmiModelTag = WmiModelTag.MATH_OPERATOR;
        } else if (numericEntities.contains(string)) {
            wmiModelTag = WmiModelTag.MATH_NUMERIC;
        }
        return wmiModelTag;
    }

    public static boolean isSubexpressionLabellingOn() {
        return subexpressionLabellingOn;
    }

    public static int getLabelWidth() {
        return labelWidth;
    }

    public static WmiMathModel addBrackets(WmiMathModel wmiMathModel, WmiMathContext wmiMathContext) throws WmiNoWriteAccessException {
        return WmiMathFactory.addBrackets(wmiMathModel, "(", ")", wmiMathContext);
    }

    public static WmiMathModel addBrackets(WmiMathModel wmiMathModel, String string, String string2, WmiMathContext wmiMathContext) throws WmiNoWriteAccessException {
        WmiMathFencedModel wmiMathFencedModel = null;
        WmiMathDocumentModel wmiMathDocumentModel = wmiMathModel.getDocument();
        WmiModel[] wmiModelArray = new WmiMathModel[]{wmiMathModel};
        try {
            wmiMathFencedModel = new WmiMathFencedModel(wmiMathDocumentModel, wmiModelArray, wmiMathContext);
            ((WmiAbstractModel)wmiMathFencedModel).addAttribute("open", string);
            ((WmiAbstractModel)wmiMathFencedModel).addAttribute("close", string2);
        }
        catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
            WmiErrorLog.log(wmiInvalidModelInitializationException);
        }
        return wmiMathFencedModel;
    }

    public static void setSuperscriptSize(WmiFontAttributeSet wmiFontAttributeSet) {
        int n = Math.round(0.8f * (float)wmiFontAttributeSet.getSize());
        wmiFontAttributeSet.setSize(n);
    }

    public static void setLargeSymbolSize(WmiFontAttributeSet wmiFontAttributeSet) {
        int n = Math.round(2.0f * (float)wmiFontAttributeSet.getSize());
        wmiFontAttributeSet.setSize(n);
    }

    public static void setSuperscriptLargeSymbolSize(WmiFontAttributeSet wmiFontAttributeSet) {
        int n = Math.round(1.6f * (float)wmiFontAttributeSet.getSize());
        wmiFontAttributeSet.setSize(n);
    }

    public static void updateContext(DagRenderContext dagRenderContext) {
        int n;
        if (builders == null) {
            builders = new WmiMathModelBuilder[60];
            try {
                WmiMathFactory.initializeFactory();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        int n2 = contextAwareBuilders.size();
        for (n = 0; n < n2; ++n) {
            ((WmiRenderContextAwareBuilder)contextAwareBuilders.get(n)).updateContext(dagRenderContext);
        }
        n = 3;
        boolean bl = true;
        n = dagRenderContext.getInterfaceProperty("prettyprint", n);
        boolean bl2 = subexpressionLabellingOn = (bl = dagRenderContext.getInterfaceProperty("labelling", bl)) && (n == 2 || n == 1);
        if (subexpressionLabellingOn) {
            labelWidth = dagRenderContext.getInterfaceProperty("labelwidth", labelWidth);
        }
    }

    private static void addBuilder(int n, WmiMathModelBuilder wmiMathModelBuilder) {
        if (!$assertionsDisabled && builders == null) {
            throw new AssertionError();
        }
        WmiMathFactory.builders[n] = wmiMathModelBuilder;
        if (wmiMathModelBuilder instanceof WmiRenderContextAwareBuilder) {
            contextAwareBuilders.add(wmiMathModelBuilder);
        }
    }

    private static void initializeFactory() {
        WmiMathFactory.addBuilder(1, new WmiNumericModel.WmiIntNegBuilder());
        WmiMathFactory.addBuilder(2, new WmiNumericModel.WmiIntPosBuilder());
        WmiMathFactory.addBuilder(3, new WmiNumericModel.WmiRationalBuilder());
        WmiMathFactory.addBuilder(6, new WmiNumericModel.WmiComplexBuilder());
        WmiMathFactory.addBuilder(4, new WmiNumericModel.WmiFloatBuilder());
        WmiMathFactory.addBuilder(5, new WmiNumericModel.WmiHFloatBuilder());
        WmiMathFactory.addBuilder(8, new WmiIdentifierModel.WmiNameBuilder());
        WmiMathFactory.addBuilder(7, new WmiMathStringModel.WmiStringBuilder());
        WmiMathFactory.addBuilder(19, new WmiUnevalBuilder());
        WmiMathFactory.addBuilder(16, new WmiSumBuilder());
        WmiMathFactory.addBuilder(14, new WmiProductBuilder());
        WmiMathFactory.addBuilder(15, new WmiSeriesBuilder());
        WmiMathFactory.addBuilder(13, new WmiPowerBuilder());
        WmiMathFactory.addBuilder(10, new WmiTablerefBuilder());
        WmiMathFactory.addBuilder(41, new WmiAssignmentBuilder());
        WmiMathFactory.addBuilder(35, new WmiRangeBuilder());
        WmiMathFactory.addBuilder(12, new WmiCatenateBuilder());
        WmiMathFactory.addBuilder(11, new WmiDColonBuilder());
        WmiMathFactory.addBuilder(20, new WmiRelationalBuilder.WmiEquationBuilder());
        WmiMathFactory.addBuilder(21, new WmiRelationalBuilder.WmiInequalityBuilder());
        WmiMathFactory.addBuilder(22, new WmiRelationalBuilder.WmiLessThanEqualsBuilder());
        WmiMathFactory.addBuilder(23, new WmiRelationalBuilder.WmiLessThanBuilder());
        WmiMathFactory.addBuilder(24, new WmiLogicalBuilder.WmiAndBuilder());
        WmiMathFactory.addBuilder(26, new WmiLogicalBuilder.WmiOrBuilder());
        WmiMathFactory.addBuilder(27, new WmiLogicalBuilder.WmiXorBuilder());
        WmiMathFactory.addBuilder(28, new WmiLogicalBuilder.WmiImpliesBuilder());
        WmiMathFactory.addBuilder(25, new WmiNotBuilder());
        WmiMathFactory.addBuilder(29, new WmiCollectionBuilder.WmiExpSequenceModelBuilder());
        WmiMathFactory.addBuilder(30, new WmiCollectionBuilder.WmiListModelBuilder());
        WmiMathFactory.addBuilder(36, new WmiCollectionBuilder.WmiSetModelBuilder());
        WmiMathFactory.addBuilder(55, new WmiHashTableBuilder());
        WmiMathFactory.addBuilder(18, new WmiFunctionBuilder());
        WmiMathFactory.addBuilder(34, new WmiProcBuilder());
        WmiMathFactory.addBuilder(46, new WmiProcBuilder.WmiStatementSequenceBuilder());
        WmiMathFactory.addBuilder(43, new WmiIfStatementBuilder());
        WmiMathFactory.addBuilder(42, new WmiForStatementBuilder());
        WmiMathFactory.addBuilder(49, new WmiTryStatementBuilder());
        WmiMathFactory.addBuilder(53, new WmiUseBuilder());
        WmiMathFactory.addBuilder(45, new WmiKeyWordBuilder("save"));
        WmiMathFactory.addBuilder(44, new WmiKeyWordBuilder("read"));
        WmiMathFactory.addBuilder(47, new WmiKeyWordBuilder("stop"));
        WmiMathFactory.addBuilder(51, new WmiKeyWordBuilder("break"));
        WmiMathFactory.addBuilder(52, new WmiKeyWordBuilder("next"));
        WmiMathFactory.addBuilder(50, new WmiKeyWordBuilder("return"));
        WmiMathFactory.addBuilder(48, new WmiKeyWordBuilder("error"));
        WmiMathFactory.addBuilder(31, new WmiLocalBuilder());
        WmiMathFactory.addBuilder(39, new WmiProcBuilder());
        WmiMathFactory.addBuilder(40, new WmiProcBuilder());
        WmiMathFactory.addBuilder(9, new WmiMemberBuilder());
        WmiMathFactory.addBuilder(38, new WmiLPrintIdentifierBuilder());
        WmiMathFactory.addBuilder(37, new WmiLPrintIdentifierBuilder(2));
        numericEntities.add("ExponentialE");
        numericEntities.add("frac12");
        numericEntities.add("frac14");
        numericEntities.add("frac34");
        numericEntities.add("ImaginaryI");
        numericEntities.add("infin");
        numericEntities.add("half");
    }

    static {
        $assertionsDisabled = !WmiMathFactory.class.desiredAssertionStatus();
        BRACKET_SEMANTICS = new WmiMathSemantics(){
            private static final String LINEBREAK_CONTEXT_NAME = "bracketed";

            public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
                WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)((Object)wmiMathModel);
                WmiMathModel wmiMathModel2 = (WmiMathModel)wmiCompositeModel.getChild(1);
                return wmiMathModel2 != null ? wmiMathModel2.toDag() : null;
            }

            public int getLinebreakCost(WmiMathModel wmiMathModel) {
                return 0;
            }
        };
        builders = null;
        defaultBuilder = new WmiDefaultMathModelBuilder();
        contextAwareBuilders = new ArrayList();
        numericEntities = new HashSet();
        subexpressionLabellingOn = false;
        labelWidth = 20;
    }
}

