/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiColorAttributeKey;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiIntAttributeKey;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiStringAttributeKey;
import com.maplesoft.mathdoc.model.math.WmiDimensionUnit;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import java.util.HashMap;
import java.util.HashSet;

public class WmiMathAttributeSet
extends WmiFontAttributeSet {
    public static final String MATH_VARIANT = "mathvariant";
    public static final String SEMANTICS = "Typesetting:-msemantics";
    public static final String ATOMIC = "atomic";
    public static final String BOLD_ITALIC = "bold-italic";
    public static final String NORMAL = "normal";
    public static final String DOUBLE_STRUCK = "double-struck";
    public static final String BOLD_FRAKTUR = "bold-fraktur";
    public static final String SCRIPT = "script";
    public static final String BOLD_SCRIPT = "bold-script";
    public static final String FRAKTUR = "fraktur";
    public static final String SANS_SERIF = "sans-serif";
    public static final String BOLD_SANS_SERIF = "bold-sans-serif";
    public static final String SANS_SERIF_ITALIC = "sans-serif-italic";
    public static final String SANS_SERIF_BOLD_ITALIC = "sans-serif-bold-italic";
    public static final String MONOSPACE = "monospace";
    public static final String WEIGHT_BOLD = "bold";
    public static final String MATH_COLOR = "mathcolor";
    public static final String MATH_BACKGROUND = "mathbackground";
    public static final String MATH_SIZE = "mathsize";
    public static final String SMALL_SIZE = "small";
    public static final String NORMAL_SIZE = "normal";
    public static final String BIG_SIZE = "big";
    public static final WmiDimensionUnit SMALL_FONT_SIZE;
    public static final WmiDimensionUnit NORMAL_FONT_SIZE;
    public static final WmiDimensionUnit BIG_FONT_SIZE;
    public static final String SEMANTICS_REAL = "real";
    public static final String SEMANTICS_INTEGER = "integer";
    public static final String SEMANTICS_RATIONAL = "rational";
    public static final String SEMANTICS_COMPLEX_POLAR = "complex-polar";
    public static final String SEMANTICS_COMPLEX_CARTESIAN = "complex-cartesian";
    public static final String SEMANTICS_CONSTANT = "constant";
    public static final String SEMANTICS_FUNCTION = "function";
    public static final String SEMANTICS_PREFIX = "prefix";
    public static final String SEMANTICS_INFIX = "infix";
    public static final String SEMANTICS_POSTFIX = "postfix";
    public static final String SEMANTICS_CARTESIAN_PRODUCT = "cartesianproduct";
    public static final String SEMANTICS_LIST = "list";
    public static final String SEMANTICS_LIST_NUMERIC = "list-numeric";
    public static final String SEMANTICS_LIST_LEXICOGRAPHIC = "list-lexicographic";
    public static final String SEMANTICS_SET = "set";
    public static final String SEMANTICS_SET_MULTISET = "multiset";
    public static final String SEMANTICS_SELECTOR = "selector";
    public static final String SEMANTICS_FN = "fn";
    public static final String SEMANTICS_BOUND_VARIABLE = "bound-variable";
    public static final String SEMANTICS_CONDITION = "condition";
    public static final String SEMANTICS_DECLARE = "declare";
    public static final String SEMANTICS_INVERSE = "inverse";
    public static final String SEMANTICS_POWER = "power";
    public static final String SEMANTICS_TRANSPOSE = "transpose";
    public static final String SEMANTICS_EXP = "exp";
    public static final String SEMANTICS_INTERVAL = "interval";
    public static final String SEMANTICS_ABS = "abs";
    public static final String SEMANTICS_CARD = "card";
    public static final String SEMANTICS_FLOOR = "floor";
    public static final String SEMANTICS_QUOTIENT = "quotient";
    public static final String SEMANTICS_CEILING = "ceiling";
    public static final String SEMANTICS_LAMBDA = "lambda";
    public static final String SEMANTICS_INTEGRAL = "integral";
    public static final String SEMANTICS_FORALL = "forall";
    public static final String SEMANTICS_CONJUGATE = "conjugate";
    public static final String SEMANTICS_EXISTS = "exists";
    public static final String SEMANTICS_DIFF = "diff";
    public static final String SEMANTICS_DEGREE = "degree";
    public static final String SEMANTICS_CURL = "curl";
    public static final String SEMANTICS_MEAN = "mean";
    public static final String SEMANTICS_SDEV = "sdev";
    public static final String SEMANTICS_MODE = "mode";
    public static final String SEMANTICS_VARIANCE = "variance";
    public static final String SEMANTICS_MEDIAN = "median";
    public static final String SEMANTICS_MOMENT = "moment";
    public static final String SEMANTICS_MOMENTABOUT = "momentabout";
    public static final String SEMANTICS_PARTIALDIFF = "partialdiff";
    public static final String SEMANTICS_DIVERGENCE = "divergence";
    public static final String SEMANTICS_LIMIT = "limit";
    public static final String SEMANTICS_LOW_LIMIT = "lowlimit";
    public static final String SEMANTICS_UP_LIMIT = "uplimit";
    public static final String SEMANTICS_LAPLACIAN = "laplacian";
    public static final String SEMANTICS_LOG = "log";
    public static final String SEMANTICS_PRODUCT = "product";
    public static final String SEMANTICS_SUM = "sum";
    public static final String SEMANTICS_TENDSTO = "tendsto";
    public static final String SEMANTICS_DETERMINANT = "determinant";
    public static final String SEMANTICS_MATRIX = "matrix";
    public static final String SEMANTICS_MATRIX_ROW = "matrixrow";
    public static final String SEMANTICS_VECTOR = "vector";
    public static final String COLOR = "color";
    public static final String FONT_FAMILY = "fontfamily";
    public static final String FONT_SIZE = "fontsize";
    public static final String FONT_STYLE = "fontstyle";
    public static final String FONT_WEIGHT = "fontweight";
    public static final String DO_NOT_PRUNE = "donotprune";
    public static final String[] MATHML_ATTR_KEYS;
    public static final WmiAttributeKey[] MATH_KEYS;
    public static final WmiAttributeKey[] EXTENDED_KEYS;
    protected static final HashSet HANDLED_ATTR_KEYS;
    public static final String INERT_COLOUR = "inert_colour";
    public static final String INERT_SEMANTICS = "inert";
    private static final HashMap COLOURS;
    private static final int MATHML_ATTR_NAMES_COUNT;
    private static HashMap keyMap;
    private static HashMap cache;
    private String semantics;

    public WmiMathAttributeSet() {
    }

    public WmiMathAttributeSet(WmiFontAttributeSet wmiFontAttributeSet) {
        super(wmiFontAttributeSet);
        if (wmiFontAttributeSet instanceof WmiMathAttributeSet) {
            this.semantics = ((WmiMathAttributeSet)wmiFontAttributeSet).semantics;
        }
    }

    public static String getColour(String string) {
        Object v = COLOURS.get(string.toLowerCase());
        if (v != null) {
            return v.toString();
        }
        return "";
    }

    public static boolean testForAtomic(WmiModel wmiModel) throws WmiNoReadAccessException {
        boolean bl = false;
        if (!(wmiModel instanceof WmiCompositeModel)) {
            bl = true;
        } else if (wmiModel instanceof WmiMathModel) {
            WmiAttributeSet wmiAttributeSet = wmiModel.getAttributes();
            Object object = wmiAttributeSet.getAttribute(SEMANTICS);
            bl = object instanceof String && ((String)object).indexOf(ATOMIC) > -1;
        }
        return bl;
    }

    public void copyMathAttributes(WmiMathAttributeSet wmiMathAttributeSet) {
        this.copyFontAttributes(wmiMathAttributeSet);
        this.semantics = wmiMathAttributeSet.semantics;
    }

    public boolean isCompatibleEditAttributeSet(WmiFontAttributeSet wmiFontAttributeSet) {
        boolean bl = false;
        bl = wmiFontAttributeSet instanceof WmiMathAttributeSet ? this.equals(wmiFontAttributeSet) : super.equals(wmiFontAttributeSet);
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object) && object instanceof WmiMathAttributeSet) {
            WmiMathAttributeSet wmiMathAttributeSet = (WmiMathAttributeSet)object;
            String string = wmiMathAttributeSet.semantics;
            bl = string == null && this.semantics == null || this.semantics != null && this.semantics.equals(string);
        }
        return bl;
    }

    public void addAttributes(WmiAttributeSet wmiAttributeSet) {
        super.addAttributes(wmiAttributeSet);
        if (wmiAttributeSet instanceof WmiMathAttributeSet) {
            this.semantics = ((WmiMathAttributeSet)wmiAttributeSet).semantics;
        }
    }

    protected void setSemantics(String string) {
        this.semantics = string;
    }

    protected String getSemantics() {
        return this.semantics;
    }

    private int dimensionToSize(WmiDimensionUnit wmiDimensionUnit, int n) {
        int n2 = 0;
        String string = wmiDimensionUnit.getUnit();
        float f = wmiDimensionUnit.getUnitsValue();
        if ("px".equals(string) || "pt".equals(string)) {
            n2 = (int)f;
        } else if ("pc".equals(string)) {
            n2 = Math.round(f * 12.0f);
        } else if ("in".equals(string)) {
            n2 = Math.round(f * 72.0f);
        } else if ("cm".equals(string)) {
            n2 = Math.round(f * 28.346457f);
        } else if ("mm".equals(string)) {
            n2 = Math.round(f * 28.346457f / 10.0f);
        } else if ("%".equals(string)) {
            n2 = (int)((double)(NORMAL_FONT_SIZE.getUnitsValue() * f) / 100.0);
        } else if ("em".equals(string)) {
            n2 = (int)(NORMAL_FONT_SIZE.getUnitsValue() * f);
        } else if ("ex".equals(string)) {
            n2 = (int)(NORMAL_FONT_SIZE.getUnitsValue() * f);
        }
        return n2;
    }

    public WmiAttributeSet copyAttributes() {
        return new WmiMathAttributeSet(this);
    }

    private String decodeMathVariant() {
        String string = "normal";
        String string2 = (String)this.getAttribute("family");
        if (string2.equalsIgnoreCase(FRAKTUR) || string2.equalsIgnoreCase("ESSTIXFive") || string2.equalsIgnoreCase("ESSTIXFifteen")) {
            string = this.isBold() ? BOLD_FRAKTUR : FRAKTUR;
        } else if (string2.equalsIgnoreCase(SANS_SERIF)) {
            string = SANS_SERIF;
            if (this.isItalic() && this.isBold()) {
                string = SANS_SERIF_BOLD_ITALIC;
            } else if (this.isItalic()) {
                string = SANS_SERIF_ITALIC;
            } else if (this.isBold()) {
                string = BOLD_SANS_SERIF;
            }
        } else if (string2.equalsIgnoreCase(SCRIPT) || string2.equalsIgnoreCase("ESSTIXThirteen")) {
            string = this.isBold() ? BOLD_SCRIPT : SCRIPT;
        } else if (string2.equalsIgnoreCase(DOUBLE_STRUCK) || string2.equalsIgnoreCase("ESSTIXFourteen")) {
            string = DOUBLE_STRUCK;
        } else if (string2.equalsIgnoreCase(MONOSPACE)) {
            string = MONOSPACE;
        } else if (this.isItalic() && this.isBold()) {
            string = BOLD_ITALIC;
        } else if (this.isItalic()) {
            string = "italic";
        } else if (this.isBold()) {
            string = WEIGHT_BOLD;
        }
        return string.toString();
    }

    protected HashMap getKeyMap() {
        return keyMap;
    }

    public WmiAttributeKey[] getKeys() {
        return EXTENDED_KEYS;
    }

    protected void setKeyMap(HashMap hashMap) {
        keyMap = hashMap;
    }

    public HashMap getCache() {
        return cache;
    }

    public static WmiAttributeKey[] getMathKeys() {
        return EXTENDED_KEYS;
    }

    static {
        MATHML_ATTR_KEYS = new String[]{MATH_COLOR, MATH_BACKGROUND, MATH_SIZE, MATH_VARIANT, COLOR, FONT_FAMILY, FONT_SIZE, FONT_STYLE, FONT_WEIGHT, SEMANTICS};
        MATH_KEYS = new WmiAttributeKey[]{new MathColorKey(), new MathBackgroundKey(), new FontFamilyKey(), new VariantKey(), new MathSizeKey(), new SemanticsKey(), new FontWeightKey()};
        EXTENDED_KEYS = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiFontAttributeSet.ATTRIBUTE_KEYS, MATH_KEYS);
        HANDLED_ATTR_KEYS = new HashSet();
        COLOURS = new HashMap();
        COLOURS.put("black", "0x000000");
        COLOURS.put("silver", "0xC0C0C0");
        COLOURS.put("gray", "0xBEBEBE");
        COLOURS.put("grey", "0xBEBEBE");
        COLOURS.put("white", "0xFFFFFF");
        COLOURS.put("maroon", "0xB03060");
        COLOURS.put("red", "0xFF0000");
        COLOURS.put("purple", "0x800080");
        COLOURS.put("fuchsia", "0xFF00FF");
        COLOURS.put("green", "0x008000");
        COLOURS.put("lime", "0x00FF00");
        COLOURS.put("olive", "0x808000");
        COLOURS.put("yellow", "0xFFFF00");
        COLOURS.put("navy", "0x000080");
        COLOURS.put("blue", "0x0000FF");
        COLOURS.put("teal", "0x008080");
        COLOURS.put("aqua", "0x00FFFF");
        COLOURS.put("ph_purple", "0xC800C8");
        COLOURS.put("ph_green", "0x00A050");
        COLOURS.put(INERT_COLOUR, "#909090");
        COLOURS.put("aliceblue", "0xF0F8FF");
        COLOURS.put("antiquewhite", "0xFAEBD7");
        COLOURS.put("aquamarine", "0x7FFFD4");
        COLOURS.put("azure", "0xF0FFFF");
        COLOURS.put("beige", "0xF5F5DC");
        COLOURS.put("bisque", "0xFFE4C4");
        COLOURS.put("blanchedalmond", "0xFFEBCD");
        COLOURS.put("blueviolet", "0x8A2BE2");
        COLOURS.put("brown", "0xA52A2A");
        COLOURS.put("burlywood", "0xDEB887");
        COLOURS.put("cadetblue", "0x5F9EA0");
        COLOURS.put("chartreuse", "0x7FFF00");
        COLOURS.put("chocolate", "0xD2691E");
        COLOURS.put("coral", "0xFF7F50");
        COLOURS.put("cornflowerblue", "0x6495ED");
        COLOURS.put("cornsilk", "0xFFF8DC");
        COLOURS.put("crimson", "0xDC143C");
        COLOURS.put("cyan", "0x00FFFF");
        COLOURS.put("darkblue", "0x00008B");
        COLOURS.put("darkcyan", "0x008B8B");
        COLOURS.put("darkgoldenrod", "0xB8860B");
        COLOURS.put("darkgray", "0xA9A9A9");
        COLOURS.put("darkgreen", "0x006400");
        COLOURS.put("darkkhaki", "0xBDB76B");
        COLOURS.put("darkmagenta", "0x8B008B");
        COLOURS.put("darkolivegreen", "0x556B2F");
        COLOURS.put("darkorange", "0xFF8C00");
        COLOURS.put("darkorchid", "0x9932CC");
        COLOURS.put("darkred", "0x8B0000");
        COLOURS.put("darksalmon", "0xE9967A");
        COLOURS.put("darkseagreen", "0x8FBC8F");
        COLOURS.put("darkslateblue", "0x483D8B");
        COLOURS.put("darkslategray", "0x2F4F4F");
        COLOURS.put("darkturquoise", "0x00CED1");
        COLOURS.put("darkviolet", "0x9400D3");
        COLOURS.put("deeppink", "0xFF1493");
        COLOURS.put("deepskyblue", "0x00BFFF");
        COLOURS.put("dimgray", "0x696969");
        COLOURS.put("dodgerblue", "0x1E90FF");
        COLOURS.put("firebrick", "0xB22222");
        COLOURS.put("floralwhite", "0xFFFAF0");
        COLOURS.put("forestgreen", "0x228B22");
        COLOURS.put("gainsboro", "0xDCDCDC");
        COLOURS.put("ghostwhite", "0xF8F8FF");
        COLOURS.put("gold", "0xFFD700");
        COLOURS.put("goldenrod", "0xDAA520");
        COLOURS.put("gray", "0xBEBEBE");
        COLOURS.put("greenyellow", "0xADFF2F");
        COLOURS.put("honeydew", "0xF0FFF0");
        COLOURS.put("hotpink", "0xFF69B4");
        COLOURS.put("indianred", "0xCD5C5C");
        COLOURS.put("indigo", "0x4B0082");
        COLOURS.put("ivory", "0xFFFFF0");
        COLOURS.put("khaki", "0xF0E68C");
        COLOURS.put("lavender", "0xE6E6FA");
        COLOURS.put("lavenderblush", "0xFFF0F5");
        COLOURS.put("lawngreen", "0x7CFC00");
        COLOURS.put("lemonchiffon", "0xFFFACD");
        COLOURS.put("lightblue", "0xADD8E6");
        COLOURS.put("lightcoral", "0xF08080");
        COLOURS.put("lightcyan", "0xE0FFFF");
        COLOURS.put("lightgoldenrodyellow", "0xFAFAD2");
        COLOURS.put("lightgray", "0xD3D3D3");
        COLOURS.put("lightgreen", "0x90EE90");
        COLOURS.put("lightpink", "0xFFB6C1");
        COLOURS.put("lightsalmon", "0xFFA07A");
        COLOURS.put("lightseagreen", "0x20B2AA");
        COLOURS.put("lightskyblue", "0x87CEFA");
        COLOURS.put("lightslategray", "0x778899");
        COLOURS.put("lightsteelblue", "0xB0C4DE");
        COLOURS.put("lightyellow", "0xFFFFE0");
        COLOURS.put("limegreen", "0x32CD32");
        COLOURS.put("linen", "0xFAF0E6");
        COLOURS.put("magenta", "0xFF00FF");
        COLOURS.put("mediumaquamarine", "0x66CDAA");
        COLOURS.put("mediumblue", "0x0000CD");
        COLOURS.put("mediumorchid", "0xBA55D3");
        COLOURS.put("mediumpurple", "0x9370DB");
        COLOURS.put("mediumseagreen", "0x3CB371");
        COLOURS.put("mediumslateblue", "0x7B68EE");
        COLOURS.put("mediumspringgreen", "0x00FA9A");
        COLOURS.put("mediumturquoise", "0x48D1CC");
        COLOURS.put("mediumvioletred", "0xC71585");
        COLOURS.put("midnightblue", "0x191970");
        COLOURS.put("mintcream", "0xF5FFFA");
        COLOURS.put("mistyrose", "0xFFE4E1");
        COLOURS.put("moccasin", "0xFFE4B5");
        COLOURS.put("navajowhite", "0xFFDEAD");
        COLOURS.put("oldlace", "0xFDF5E6");
        COLOURS.put("olivedrab", "0x6B8E23");
        COLOURS.put("orange", "0xFFA500");
        COLOURS.put("orangered", "0xFF4500");
        COLOURS.put("orchid", "0xDA70D6");
        COLOURS.put("palegoldenrod", "0xEEE8AA");
        COLOURS.put("palegreen", "0x98FB98");
        COLOURS.put("paleturquoise", "0xAFEEEE");
        COLOURS.put("palevioletred", "0xDB7093");
        COLOURS.put("papayawhip", "0xFFEFD5");
        COLOURS.put("peachpuff", "0xFFDAB9");
        COLOURS.put("peru", "0xCD853F");
        COLOURS.put("pink", "0xFFC0CB");
        COLOURS.put("plum", "0xDDA0DD");
        COLOURS.put("powderblue", "0xB0E0E6");
        COLOURS.put("rosybrown", "0xBC8F8F");
        COLOURS.put("royalblue", "0x4169E1");
        COLOURS.put("saddlebrown", "0x8B4513");
        COLOURS.put("salmon", "0xFA8072");
        COLOURS.put("sandybrown", "0xF4A460");
        COLOURS.put("seagreen", "0x2E8B57");
        COLOURS.put("seashell", "0xFFF5EE");
        COLOURS.put("sienna", "0xA0522D");
        COLOURS.put("skyblue", "0x87CEEB");
        COLOURS.put("slateblue", "0x6A5ACD");
        COLOURS.put("slategray", "0x708090");
        COLOURS.put("snow", "0xFFFAFA");
        COLOURS.put("springgreen", "0x00FF7F");
        COLOURS.put("steelblue", "0x4682B4");
        COLOURS.put("tan", "0xD2B48C");
        COLOURS.put("thistle", "0xD8BFD8");
        COLOURS.put("tomato", "0xFF6347");
        COLOURS.put("turquoise", "0x40E0D0");
        COLOURS.put("violet", "0xEE82EE");
        COLOURS.put("wheat", "0xF5DEB3");
        COLOURS.put("whitesmoke", "0xF5F5F5");
        COLOURS.put("yellowgreen", "0x9ACD32");
        SMALL_FONT_SIZE = WmiDimensionUnit.createDimension("8pt", null);
        NORMAL_FONT_SIZE = WmiDimensionUnit.createDimension("12pt", null);
        BIG_FONT_SIZE = WmiDimensionUnit.createDimension("16pt", null);
        MATHML_ATTR_NAMES_COUNT = MATHML_ATTR_KEYS.length;
        keyMap = null;
        cache = new HashMap();
    }

    public static class MathSizeKey
    extends WmiIntAttributeKey {
        public MathSizeKey() {
            super(WmiMathAttributeSet.MATH_SIZE, 12);
        }

        public int getIntValue(WmiAttributeSet wmiAttributeSet) {
            return ((WmiFontAttributeSet)wmiAttributeSet).getSize();
        }

        public void setIntValue(WmiAttributeSet wmiAttributeSet, int n) {
            ((WmiFontAttributeSet)wmiAttributeSet).setSize(n);
        }

        public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
            int n = 12;
            try {
                n = Integer.parseInt(string.toString());
            }
            catch (NumberFormatException numberFormatException) {
                WmiDimensionUnit wmiDimensionUnit = null;
                wmiDimensionUnit = string.equals(WmiMathAttributeSet.SMALL_SIZE) ? SMALL_FONT_SIZE : (string.equals("normal") ? NORMAL_FONT_SIZE : (string.equals(WmiMathAttributeSet.BIG_SIZE) ? BIG_FONT_SIZE : WmiDimensionUnit.createDimension(string.toString(), NORMAL_FONT_SIZE)));
                int n2 = this.getIntValue(wmiAttributeSet);
                n = ((WmiMathAttributeSet)wmiAttributeSet).dimensionToSize(wmiDimensionUnit, n2);
            }
            this.setIntValue(wmiAttributeSet, n);
        }
    }

    public static class MathBackgroundKey
    extends WmiColorAttributeKey {
        public MathBackgroundKey() {
            super(WmiMathAttributeSet.MATH_BACKGROUND, 0xFFFFFF);
        }

        public String getStringValue(WmiAttributeSet wmiAttributeSet) {
            return ((WmiFontAttributeSet)wmiAttributeSet).getBackgroundColorString();
        }

        public int getIntValue(WmiAttributeSet wmiAttributeSet) {
            return ((WmiFontAttributeSet)wmiAttributeSet).getBackground();
        }

        public void setIntValue(WmiAttributeSet wmiAttributeSet, int n) {
            ((WmiFontAttributeSet)wmiAttributeSet).setBackground(n);
        }
    }

    public static class MathColorKey
    extends WmiColorAttributeKey {
        public MathColorKey() {
            super(WmiMathAttributeSet.MATH_COLOR, 0xFFFFFF);
        }

        public String getStringValue(WmiAttributeSet wmiAttributeSet) {
            return ((WmiFontAttributeSet)wmiAttributeSet).getForegroundColorString();
        }

        public int getIntValue(WmiAttributeSet wmiAttributeSet) {
            return ((WmiFontAttributeSet)wmiAttributeSet).getForeground();
        }

        public void setIntValue(WmiAttributeSet wmiAttributeSet, int n) {
            ((WmiFontAttributeSet)wmiAttributeSet).setForeground(n);
        }
    }

    public static class FontFamilyKey
    extends WmiStringAttributeKey {
        public FontFamilyKey() {
            super(WmiMathAttributeSet.FONT_FAMILY, WmiFontAttributeSet.DEFAULT_FAMILY);
        }

        public String getStringValue(WmiAttributeSet wmiAttributeSet) {
            return ((WmiFontAttributeSet)wmiAttributeSet).getFamily();
        }

        public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
            ((WmiFontAttributeSet)wmiAttributeSet).setFamily(string);
        }
    }

    public static class FontWeightKey
    extends WmiStringAttributeKey {
        public FontWeightKey() {
            super(WmiMathAttributeSet.FONT_WEIGHT, null);
        }

        public String getStringValue(WmiAttributeSet wmiAttributeSet) {
            return ((WmiFontAttributeSet)wmiAttributeSet).isBold() ? WmiMathAttributeSet.WEIGHT_BOLD : null;
        }

        public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
            boolean bl = string != null ? string.toString().compareToIgnoreCase(WmiMathAttributeSet.WEIGHT_BOLD) == 0 : false;
            WmiFontAttributeSet wmiFontAttributeSet = (WmiFontAttributeSet)wmiAttributeSet;
            int n = wmiFontAttributeSet.getExtendedStyle();
            n = bl ? (n |= 1) : (n &= 0xFFFFFFFE);
            wmiFontAttributeSet.setExtendedStyle(n);
        }
    }

    public static class SemanticsKey
    extends WmiStringAttributeKey {
        public SemanticsKey() {
            super(WmiMathAttributeSet.SEMANTICS, null);
        }

        public String getStringValue(WmiAttributeSet wmiAttributeSet) {
            return ((WmiMathAttributeSet)wmiAttributeSet).getSemantics();
        }

        public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
            ((WmiMathAttributeSet)wmiAttributeSet).setSemantics(string);
        }
    }

    public static class VariantKey
    extends WmiStringAttributeKey {
        public VariantKey() {
            super(WmiMathAttributeSet.MATH_VARIANT, null);
        }

        public String getStringValue(WmiAttributeSet wmiAttributeSet) {
            return wmiAttributeSet instanceof WmiMathAttributeSet ? ((WmiMathAttributeSet)wmiAttributeSet).decodeMathVariant() : null;
        }

        public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
            if (wmiAttributeSet instanceof WmiMathAttributeSet) {
                WmiMathAttributeSet wmiMathAttributeSet = (WmiMathAttributeSet)wmiAttributeSet;
                if (!string.equals("normal")) {
                    if (string.equals(WmiMathAttributeSet.WEIGHT_BOLD)) {
                        wmiMathAttributeSet.setStyle(1, true);
                    } else if (string.equals("italic")) {
                        wmiMathAttributeSet.setStyle(2, true);
                    } else if (string.equals(WmiMathAttributeSet.BOLD_ITALIC)) {
                        wmiMathAttributeSet.setStyle(1, true);
                        wmiMathAttributeSet.setStyle(2, true);
                    } else if (string.equals(WmiMathAttributeSet.SANS_SERIF)) {
                        wmiMathAttributeSet.setFamily(WmiMathAttributeSet.SANS_SERIF);
                    } else if (string.equals(WmiMathAttributeSet.BOLD_SANS_SERIF)) {
                        wmiMathAttributeSet.setFamily(WmiMathAttributeSet.SANS_SERIF);
                        wmiMathAttributeSet.setStyle(1, true);
                    } else if (string.equals(WmiMathAttributeSet.SANS_SERIF_ITALIC)) {
                        wmiMathAttributeSet.setFamily(WmiMathAttributeSet.SANS_SERIF);
                        wmiMathAttributeSet.setStyle(2, true);
                    } else if (string.equals(WmiMathAttributeSet.SANS_SERIF_BOLD_ITALIC)) {
                        wmiMathAttributeSet.setFamily(WmiMathAttributeSet.SANS_SERIF);
                        wmiMathAttributeSet.setStyle(1, true);
                        wmiMathAttributeSet.setStyle(2, true);
                    } else if (string.equals(WmiMathAttributeSet.MONOSPACE)) {
                        wmiMathAttributeSet.setFamily("monospaced");
                    } else if (string.equals(WmiMathAttributeSet.SCRIPT)) {
                        wmiMathAttributeSet.setFamily("ESSTIXThirteen");
                    } else if (string.equals(WmiMathAttributeSet.BOLD_SCRIPT)) {
                        wmiMathAttributeSet.setFamily("ESSTIXThirteen");
                        wmiMathAttributeSet.setStyle(1, true);
                    } else if (string.equals(WmiMathAttributeSet.DOUBLE_STRUCK)) {
                        wmiMathAttributeSet.setFamily("ESSTIXFourteen");
                    } else if (string.equals(WmiMathAttributeSet.FRAKTUR)) {
                        wmiMathAttributeSet.setFamily("ESSTIXFive");
                    } else if (string.equals(WmiMathAttributeSet.BOLD_FRAKTUR)) {
                        wmiMathAttributeSet.setFamily("ESSTIXFifteen");
                        wmiMathAttributeSet.setStyle(1, true);
                    }
                }
            }
        }
    }
}

