/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

public class WmiDimensionUnit {
    public static final String EM_UNIT = "em";
    public static final String EX_UNIT = "ex";
    public static final String PIXEL_UNIT = "px";
    public static final String INCH_UNIT = "in";
    public static final String CENTIMETRE_UNIT = "cm";
    public static final String CM_UNIT = "cm";
    public static final String MILLIMETRE_UNIT = "mm";
    public static final String MM_UNIT = "mm";
    public static final String POINT_UNIT = "pt";
    public static final String PICA_UNIT = "pc";
    public static final String PERCENT_UNIT = "%";
    public static final int PICAS_TO_PIXELS = 12;
    public static final int INCHES_TO_PIXELS = 72;
    public static final float CENTIMETRES_TO_PIXELS = 28.346457f;
    public static final int CM_TO_MM = 10;
    public static final int PERCENT = 100;
    protected float unitsValue = 0.0f;
    protected String unit;
    protected WmiDimensionUnit defaultUnit;

    protected WmiDimensionUnit(float f, String string, WmiDimensionUnit wmiDimensionUnit) {
        this.unitsValue = f;
        this.unit = string;
        this.defaultUnit = wmiDimensionUnit;
    }

    public static WmiDimensionUnit createDimension(String string, WmiDimensionUnit wmiDimensionUnit) {
        WmiDimensionUnit wmiDimensionUnit2 = null;
        if (string != null && string.length() > 0) {
            String string2;
            int n = 0;
            int n2 = string.length();
            boolean bl = false;
            for (int i = 0; i < n2; ++i) {
                char c = string.charAt(i);
                if (!Character.isDigit(c) && c != '.' && (i != 0 || c != '-')) continue;
                n = i;
                bl = true;
            }
            String string3 = string.substring(0, n + 1);
            float f = 0.0f;
            try {
                f = Float.parseFloat(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (bl) {
                string2 = string.substring(n + 1).trim();
            } else {
                string2 = string;
                f = 1.0f;
            }
            string2 = string2.toLowerCase();
            wmiDimensionUnit2 = new WmiDimensionUnit(f, string2, wmiDimensionUnit);
        }
        return wmiDimensionUnit2;
    }

    public float getUnitsValue() {
        return this.unitsValue;
    }

    public String getUnit() {
        return this.unit;
    }

    public WmiDimensionUnit getDefaultUnit() {
        return this.defaultUnit;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.unitsValue);
        if (this.unit != null) {
            stringBuffer.append(this.unit);
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof WmiDimensionUnit) {
            WmiDimensionUnit wmiDimensionUnit = (WmiDimensionUnit)object;
            boolean bl2 = bl = this.unitsValue == wmiDimensionUnit.unitsValue;
            if (bl) {
                bl = this.unit != null && wmiDimensionUnit.unit != null ? this.unit.equals(wmiDimensionUnit.unit) : this.unit == wmiDimensionUnit.unit;
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = Float.floatToIntBits(this.unitsValue);
        if (this.unit != null) {
            n ^= this.unit.hashCode();
        }
        return n;
    }
}

