/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiTableBuilder;
import java.util.ArrayList;

public abstract class WmiCollectionBuilder
implements WmiMathModelBuilder,
WmiMathSemantics {
    public static final String COMMA_OPERATOR = ",";
    public static final String LIST_BRACKET_LEFT = "[";
    public static final String LIST_BRACKET_RIGHT = "]";
    public static final String ARGS_BRACKET_LEFT = "(";
    public static final String ARGS_BRACKET_RIGHT = ")";
    public static final String SET_BRACKET_LEFT = "{";
    public static final String SET_BRACKET_RIGHT = "}";

    public WmiMathModel createModel(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        Object object;
        WmiMathModel wmiMathModel = null;
        boolean bl = false;
        if (dag.getType() == 30 && (object = dag.getAttributes()) != null) {
            String string = ((Dag)object).getData();
            if (wmiMathContext != null && string.equals("matrix")) {
                bl = true;
            }
        }
        if (bl && (wmiMathModel = WmiTableBuilder.buildMatrix(wmiMathDocumentModel, dag, wmiMathContext)) == null) {
            bl = false;
        }
        if (!bl) {
            wmiMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
            object = (WmiAbstractArrayCompositeModel)((Object)wmiMathModel);
            int n = dag.getLength();
            int n2 = n - 1;
            if (n > 0) {
                for (int i = 0; i < n2; ++i) {
                    Dag dag2 = dag.getChild(i);
                    WmiMathModel wmiMathModel2 = WmiMathFactory.createMath(wmiMathDocumentModel, dag2, wmiMathContext);
                    ((WmiAbstractArrayCompositeModel)object).appendChild(wmiMathModel2);
                    ((WmiAbstractArrayCompositeModel)object).appendChild(WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, COMMA_OPERATOR, wmiMathContext));
                }
                WmiMathModel wmiMathModel3 = WmiMathFactory.createMath(wmiMathDocumentModel, dag.getChild(n2), wmiMathContext);
                ((WmiAbstractArrayCompositeModel)object).appendChild(wmiMathModel3);
            } else {
                ((WmiAbstractArrayCompositeModel)object).appendChild(WmiMathFactory.createMathIdentifierToken(wmiMathDocumentModel, "", wmiMathContext));
            }
            wmiMathModel.setSemantics(this);
            if (this.hasBrackets()) {
                wmiMathModel = WmiMathFactory.addBrackets(wmiMathModel, this.getLeftBracket(), this.getRightBracket(), wmiMathContext);
                wmiMathModel.setSemantics(this);
            }
        }
        return wmiMathModel;
    }

    public abstract String getLeftBracket();

    public abstract String getRightBracket();

    public abstract int getDagType();

    public boolean hasBrackets() {
        return true;
    }

    private boolean isBracketed(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
        boolean bl = false;
        if (this.hasBrackets()) {
            WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)((Object)wmiMathModel);
            int n = wmiCompositeModel.getChildCount();
            WmiModel wmiModel = wmiCompositeModel.getChild(0);
            WmiModel wmiModel2 = wmiCompositeModel.getChild(n - 1);
            if (wmiModel instanceof WmiMathOperatorModel && wmiModel2 instanceof WmiMathOperatorModel) {
                WmiMathOperatorModel wmiMathOperatorModel = (WmiMathOperatorModel)wmiModel;
                WmiMathOperatorModel wmiMathOperatorModel2 = (WmiMathOperatorModel)wmiModel2;
                String string = wmiMathOperatorModel.getText();
                String string2 = wmiMathOperatorModel2.getText();
                if (string.equals(this.getLeftBracket()) && string2.equals(this.getRightBracket())) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
        Dag[] dagArray;
        WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)((Object)wmiMathModel);
        int n = wmiCompositeModel.getChildCount();
        ArrayList<Dag> arrayList = new ArrayList<Dag>();
        for (int i = this.isBracketed(wmiMathModel) ? 1 : 0; i < n; ++i) {
            dagArray = wmiCompositeModel.getChild(i);
            WmiMathModel wmiMathModel2 = (WmiMathModel)dagArray;
            boolean bl = true;
            if (WmiModelUtil.isEmptyIdentifierModel(wmiMathModel2)) {
                bl = false;
            }
            if (wmiMathModel2 instanceof WmiMathOperatorModel && ((WmiMathOperatorModel)wmiMathModel2).getContents().trim().equals(COMMA_OPERATOR)) {
                bl = false;
            }
            if (!bl) continue;
            arrayList.add(wmiMathModel2.toDag());
        }
        dagArray = arrayList.toArray(new Dag[0]);
        WmiSemanticDagUtil.fillNullDags(dagArray);
        if (dagArray.length == 2 && this.isBracketed(wmiMathModel)) {
            return dagArray[0];
        }
        return Dag.createDag(this.getDagType(), dagArray, null, false);
    }

    public static class WmiSetModelBuilder
    extends WmiCollectionBuilder {
        protected static final String LINEBREAK_CONTEXT_NAME = "set";

        public String getLeftBracket() {
            return WmiCollectionBuilder.SET_BRACKET_LEFT;
        }

        public String getRightBracket() {
            return WmiCollectionBuilder.SET_BRACKET_RIGHT;
        }

        public int getDagType() {
            return 36;
        }
    }

    public static class WmiArgsModelBuilder
    extends WmiListModelBuilder {
        public String getLeftBracket() {
            return WmiCollectionBuilder.ARGS_BRACKET_LEFT;
        }

        public String getRightBracket() {
            return WmiCollectionBuilder.ARGS_BRACKET_RIGHT;
        }
    }

    public static class WmiListModelBuilder
    extends WmiCollectionBuilder {
        protected static final String LINEBREAK_CONTEXT_NAME = "list";

        public String getLeftBracket() {
            return WmiCollectionBuilder.LIST_BRACKET_LEFT;
        }

        public String getRightBracket() {
            return WmiCollectionBuilder.LIST_BRACKET_RIGHT;
        }

        public int getDagType() {
            return 30;
        }
    }

    public static class WmiExpSequenceModelBuilder
    extends WmiCollectionBuilder {
        protected static final String LINEBREAK_CONTEXT_NAME = "expseq";

        public boolean hasBrackets() {
            return false;
        }

        public String getLeftBracket() {
            return null;
        }

        public String getRightBracket() {
            return null;
        }

        public int getDagType() {
            return 29;
        }
    }
}

