/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSource;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiStyleAttributeSet;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.WmiUndoManager;
import com.maplesoft.mathdoc.model.WmiValidForTypeMK;
import com.maplesoft.mathdoc.model.math.MathTokenizer;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathGlyphModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathStringModel;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.util.StringTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class WmiAbstractMathTokenModel
extends WmiTextModel
implements WmiMathTokenModel,
WmiFontAttributeSource,
WmiValidForTypeMK {
    private StringList strings = new StringList();
    public int alignmarkIndex = -1;
    public int alignmarkEdge = 0;
    public long modified = 0L;
    private static final Pattern SPLIT = Pattern.compile("&[^&]*?;");
    private static final Pattern GREEK_BEGIN = Pattern.compile("(.*?)\\d.*");
    public static final int UNSET = 0;
    public static final int MATH_COLOR_FLAG = 1;
    public static final int MATH_BACKGROUND_FLAG = 2;
    public static final int MATH_SIZE_FLAG = 4;
    public static final int MATH_VARIANT_FLAG = 8;
    public static final int FONT_FAMILY_FLAG = 16;
    public static final int FORM_FLAG = 32;
    public static final int FENCE_FLAG = 64;
    public static final int SEPARATOR_FLAG = 128;
    public static final int LSPACE_FLAG = 256;
    public static final int RSPACE_FLAG = 512;
    public static final int STRETCHY_FLAG = 1024;
    public static final int SYMMETRIC_FLAG = 2048;
    public static final int MAXSIZE_FLAG = 4096;
    public static final int MINSIZE_FLAG = 8192;
    public static final int LARGEOP_FLAG = 16384;
    public static final int MOVABLELIMITS_FLAG = 32768;
    public static final int ACCENT_FLAG = 65536;
    public static final int HEIGHT_FLAG = 131072;
    public static final int WIDTH_FLAG = 262144;
    public static final int DEPTH_FLAG = 524288;
    public static final int LINEBREAK_FLAG = 0x100000;
    public static final int LEFT_QUOTE_FLAG = 0x200000;
    public static final int RIGHT_QUOTE_FLAG = 0x400000;
    public static final int ALT_FLAG = 0x800000;
    public static final int INDEX_FLAG = 0x1000000;
    private static String[] ATTRIBUTE_LIST = new String[]{"mathcolor", "mathbackground", "mathsize", "mathvariant", "fontfamily", "form", "fence", "separator", "lspace", "rspace", "stretchy", "symmetric", "maxsize", "minsize", "largeop", "movablelimits", "accent", "height", "width", "depth", "linebreak", "lquote", "rquote", "alt", "index"};
    private ArrayList glyphIndices = new ArrayList();
    private ArrayList glyphs = new ArrayList();

    protected WmiAbstractMathTokenModel(WmiMathDocumentModel wmiMathDocumentModel) {
        this(wmiMathDocumentModel, null);
    }

    protected WmiAbstractMathTokenModel(WmiMathDocumentModel wmiMathDocumentModel, String string) {
        super(wmiMathDocumentModel, null, new WmiMathAttributeSet());
        this.configureStrings(string, new WmiMathContext(new WmiMathAttributeSet()));
    }

    protected WmiAbstractMathTokenModel(WmiMathDocumentModel wmiMathDocumentModel, String string, WmiAttributeSet wmiAttributeSet) {
        super(wmiMathDocumentModel, null, (WmiFontAttributeSet)wmiAttributeSet);
        this.configureStrings(string, new WmiMathContext((WmiFontAttributeSet)wmiAttributeSet));
    }

    protected WmiAbstractMathTokenModel(WmiMathDocumentModel wmiMathDocumentModel, String string, WmiAttributeSet wmiAttributeSet, WmiMathContext wmiMathContext) {
        super(wmiMathDocumentModel, null, (WmiFontAttributeSet)wmiAttributeSet);
        this.configureStrings(string, wmiMathContext);
    }

    protected WmiAbstractMathTokenModel(WmiMathDocumentModel wmiMathDocumentModel, String string, WmiMathContext wmiMathContext) {
        super(wmiMathDocumentModel, string, wmiMathContext.getStyle());
        this.configureStrings(string, wmiMathContext);
    }

    public void setModifiedFlag(int n) {
        this.modified |= (long)n;
    }

    public void setModified(long l) {
        this.modified = l;
    }

    public long getModified() {
        return this.modified;
    }

    public boolean isModified(int n) {
        return (this.modified & (long)n) != 0L;
    }

    public void addGlyph(WmiMathGlyphModel wmiMathGlyphModel) throws WmiNoReadAccessException {
        this.glyphIndices.add(new Integer(this.getContents().length()));
        this.glyphs.add(wmiMathGlyphModel);
    }

    public int getGlyphCount() {
        return this.glyphs.size();
    }

    public ArrayList getGlyphIndices() {
        return this.glyphIndices;
    }

    public WmiMathGlyphModel getGlyph(int n) {
        return (WmiMathGlyphModel)this.glyphs.get(n);
    }

    protected void configureStrings(String string, WmiMathContext wmiMathContext) {
        if (string == null) {
            this.strings = new StringList("", wmiMathContext);
            return;
        }
        if (!wmiMathContext.isSyntaxMappingEnabled() || wmiMathContext.useProcRules() && !WmiAbstractMathTokenModel.isAllowedInProc(string)) {
            this.strings = this.createStringListSplitIfNecessary(string, wmiMathContext);
        } else if (string.indexOf(38) > -1 && string.indexOf(59) > -1) {
            String string2;
            this.strings = this instanceof WmiMathStringModel && string.startsWith("<math") && string.endsWith("</math>") ? new StringList(string, wmiMathContext) : ((string2 = string).equals("&InvisibleTimes;") ? new InvisibleTimesStringList() : (string2.equals("&ApplyFunction;") ? new ApplyFunctionStringList() : this.createStringListSplitIfNecessary(string2, wmiMathContext)));
        } else if (this.enableMapleSyntaxMapping()) {
            Matcher matcher = null;
            if (string.length() > 1 && Character.isLetter(string.charAt(0))) {
                matcher = GREEK_BEGIN.matcher(string);
            }
            if (matcher != null && matcher.matches()) {
                String string3 = matcher.group(1);
                String string4 = WmiIdentifierModel.mapString(string3, wmiMathContext, false);
                if (!string4.equals(string3)) {
                    LinkedList<String> linkedList = new LinkedList<String>();
                    linkedList.add(string4);
                    linkedList.add(string.substring(matcher.end(1)));
                    String[] stringArray = linkedList.toArray(new String[1]);
                    this.strings = new StringList(stringArray, wmiMathContext);
                } else {
                    this.strings = new StringList(string, wmiMathContext);
                }
            } else {
                this.strings = new StringList(string, wmiMathContext, true);
            }
        } else {
            this.strings = new StringList(string, wmiMathContext);
        }
    }

    protected StringList createStringListSplitIfNecessary(String string, WmiMathContext wmiMathContext) {
        if (WmiAbstractMathTokenModel.stringRequiresSplit(string)) {
            String[] stringArray = WmiAbstractMathTokenModel.splitStrings(string);
            return new StringList(stringArray, wmiMathContext);
        }
        return new StringList(string, wmiMathContext);
    }

    protected static boolean stringRequiresSplit(String string) {
        int n = string.indexOf(59);
        return (string.lastIndexOf(38) != 0 || n != string.length() - 1) && string.indexOf(38) >= 0 && n >= 0;
    }

    protected static String[] splitStrings(String string) {
        String[] stringArray = null;
        if (WmiAbstractMathTokenModel.stringRequiresSplit(string)) {
            LinkedList<String> linkedList = new LinkedList<String>();
            Matcher matcher = SPLIT.matcher(string);
            while (matcher.find()) {
                linkedList.add(string.substring(0, matcher.start()));
                linkedList.add(string.substring(matcher.start(), matcher.end()));
                string = string.substring(matcher.end());
                matcher = SPLIT.matcher(string);
            }
            linkedList.add(string);
            stringArray = linkedList.toArray(new String[1]);
        } else {
            stringArray = new String[]{string};
        }
        return stringArray;
    }

    public void setAttributes(WmiAttributeSet wmiAttributeSet) throws WmiNoWriteAccessException {
        this.setAttributes(wmiAttributeSet, false, null);
    }

    public void setAttributes(WmiAttributeSet wmiAttributeSet, boolean bl, HashMap hashMap) throws WmiNoWriteAccessException {
        boolean bl2;
        int n;
        WmiFontAttributeSet wmiFontAttributeSet;
        int n2;
        if (wmiAttributeSet instanceof WmiFontAttributeSet && (n2 = (wmiFontAttributeSet = (WmiFontAttributeSet)wmiAttributeSet).getForeground() & 0xFFFFFF) == (n = wmiFontAttributeSet.getBackground() & 0xFFFFFF) && (bl2 = wmiFontAttributeSet.isOpaque())) {
            try {
                wmiFontAttributeSet = (WmiFontAttributeSet)this.getAttributes();
                wmiFontAttributeSet.setStyle(32, false);
                wmiAttributeSet = wmiFontAttributeSet;
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
        }
        if (!bl) {
            super.setAttributes(wmiAttributeSet);
        } else {
            for (int i = 0; i < ATTRIBUTE_LIST.length; ++i) {
                n2 = 1 << i;
                String string = ATTRIBUTE_LIST[i];
                if (this.isModified(n2)) {
                    wmiAttributeSet.addAttribute(string, this.attributes.getAttribute(string));
                    continue;
                }
                if (!(wmiAttributeSet instanceof WmiAbstractArrayAttributeSet) || ((WmiAbstractArrayAttributeSet)wmiAttributeSet).locateKey(string) == null || hashMap == null || hashMap.get(string) == null) continue;
                wmiAttributeSet.addAttribute(string, hashMap.get(string));
            }
            super.setAttributes(wmiAttributeSet);
        }
    }

    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiMathAttributeSet();
    }

    protected boolean enableMapleSyntaxMapping() {
        return true;
    }

    protected boolean checkForQuotes() {
        return true;
    }

    public boolean isComposite() {
        return false;
    }

    public static boolean isAllowedInProc(String string) {
        return string != null && string.startsWith("&") && string.endsWith(";");
    }

    public String getTokenContents() throws WmiNoReadAccessException {
        return this.getText();
    }

    public String getSemanticLabel() {
        return this.strings.toSemanticString();
    }

    public void doReplaceText(String string, int n, int n2) throws WmiModelIndexOutOfBoundsException, WmiNoWriteAccessException {
        this.verifyWriteLock();
        this.createPendingModel();
        if (this.pending instanceof WmiAbstractMathTokenModel) {
            WmiAbstractMathTokenModel wmiAbstractMathTokenModel = (WmiAbstractMathTokenModel)this.pending;
            if (wmiAbstractMathTokenModel.strings == this.strings || wmiAbstractMathTokenModel.strings == null) {
                String string2 = this.strings.toSemanticString();
                boolean bl = !string2.equals(this.strings.toString());
                wmiAbstractMathTokenModel.strings = new StringList(string2, bl, bl);
            }
            wmiAbstractMathTokenModel.strings.replaceText(string, n, n2);
        }
    }

    protected String getContents() throws WmiNoReadAccessException {
        String string = null;
        this.verifyReadLock();
        string = this.usePending() && this.pending instanceof WmiAbstractMathTokenModel ? ((WmiAbstractMathTokenModel)this.pending).strings.toString() : this.strings.toString();
        return string;
    }

    public void update(String string) throws WmiNoUpdateAccessException {
        this.verifyUpdateLock();
        WmiTokenModelEdit wmiTokenModelEdit = null;
        if (string != null) {
            wmiTokenModelEdit = this.createMathTextEdit();
            wmiTokenModelEdit.setPreupdateProperties(this.parent, this.attributes, this.strings);
        }
        if (this.pending != null) {
            this.updateValuesFromPending();
        }
        if (wmiTokenModelEdit != null) {
            wmiTokenModelEdit.setPostupdateProperties(this.parent, this.attributes, this.strings);
            WmiUndoManager wmiUndoManager = this.getDocument().getUndoManager();
            wmiUndoManager.addEdit(wmiTokenModelEdit);
        }
        this.pending = null;
    }

    protected WmiTokenModelEdit createMathTextEdit() {
        return new WmiTokenModelEdit(this);
    }

    protected void updateValuesFromPending() throws WmiNoUpdateAccessException {
        super.updateValuesFromPending();
        this.strings = ((WmiAbstractMathTokenModel)this.pending).strings;
    }

    public WmiMathSemantics getSemantics() {
        return null;
    }

    public void setSemantics(WmiMathSemantics wmiMathSemantics) {
    }

    public Dag toDag() throws WmiNoReadAccessException {
        return null;
    }

    public boolean forceSave(Object object, Object object2) {
        return false;
    }

    public Dag getTypeMk() {
        return null;
    }

    public boolean suppliesOwnTypeMK() {
        return false;
    }

    public String getNamedFontStyle() throws WmiNoReadAccessException {
        Object object;
        String string = null;
        WmiAttributeSet wmiAttributeSet = this.getAttributesForRead();
        if (wmiAttributeSet != null && (object = wmiAttributeSet.getAttribute("font_style_name")) != null) {
            string = object.toString();
        }
        return string;
    }

    public void updateFontStyle(String string) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiFontAttributeSet wmiFontAttributeSet = new WmiFontAttributeSet();
        wmiFontAttributeSet.setNamedFontStyle(string, this.getDocument());
        WmiAttributeSet wmiAttributeSet = this.getAttributesForRead();
        if (wmiAttributeSet instanceof WmiFontAttributeSet) {
            int n = 3;
            int n2 = ((WmiFontAttributeSet)wmiAttributeSet).getExtendedStyle() & n;
            int n3 = wmiFontAttributeSet.getExtendedStyle();
            n3 &= ~n;
            wmiFontAttributeSet.setExtendedStyle(n3 |= n2);
        }
        this.addAttributes(wmiFontAttributeSet);
    }

    public void replaceText(String string, int n, int n2) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiAttributeSet wmiAttributeSet = this.getAttributes();
            if (wmiAttributeSet instanceof WmiFontAttributeSet) {
                WmiFontAttributeSet wmiFontAttributeSet = (WmiFontAttributeSet)wmiAttributeSet;
                int n3 = wmiFontAttributeSet.getExtendedStyle();
                int n4 = WmiAbstractMathTokenModel.getPrototype(this, n3);
                int n5 = n4 ^ n3;
                this.doReplaceText(string, n, n2);
                int n6 = WmiAbstractMathTokenModel.getPrototype(this, n3);
                if (n6 != n4) {
                    if (n5 != 0) {
                        n6 &= ~n5;
                        n6 |= n3 & n5;
                    }
                    wmiFontAttributeSet.setExtendedStyle(n6);
                }
                this.setAttributes(wmiFontAttributeSet);
            } else {
                this.doReplaceText(string, n, n2);
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
    }

    public static int getPrototype(WmiModel wmiModel, int n) throws WmiNoReadAccessException {
        WmiModelTag wmiModelTag = wmiModel.getTag();
        int n2 = n;
        if (wmiModelTag == WmiModelTag.MATH_IDENTIFIER) {
            String string = ((WmiTextModel)wmiModel).getAllText();
            int n3 = WmiIdentifierModel.getAppropriateAttributeCode(string, MathTokenizer.isMathSymbol(string));
            if (n3 == 0) {
                n2 = n & 0xFFFFFFDA;
                n2 |= 2;
            } else {
                n2 = n & 0xFFFFFFD8;
            }
        } else if (wmiModelTag == WmiModelTag.MATH_OPERATOR) {
            String string = ((WmiTextModel)wmiModel).getAllText();
            int n4 = WmiMathOperatorModel.getType(string);
            switch (n4) {
                case 3: 
                case 5: {
                    n2 = n & 0xFFFFFFD8;
                    break;
                }
                case 4: {
                    n2 = n | 1;
                    n2 &= 0xFFFFFFD9;
                }
            }
        } else if (wmiModelTag == WmiModelTag.MATH_NUMERIC || wmiModelTag == WmiModelTag.MATH_STRING || wmiModelTag == WmiModelTag.MATH_TEXT) {
            n2 = n & 0xFFFFFFD8;
        } else if (!(wmiModel instanceof WmiCompositeModel)) {
            WmiStyleAttributeSet wmiStyleAttributeSet;
            WmiMathDocumentModel wmiMathDocumentModel = wmiModel.getDocument();
            WmiAttributeSet wmiAttributeSet = wmiModel.getAttributesForRead();
            Object object = wmiAttributeSet.getAttribute(WmiFontAttributeSet.STYLE_KEY);
            if (object != null && (wmiStyleAttributeSet = wmiMathDocumentModel.getStyle(0, object.toString())) instanceof WmiFontAttributeSet) {
                n2 = ((WmiFontAttributeSet)wmiStyleAttributeSet).getExtendedStyle();
            }
        }
        return n2;
    }

    protected class InvisibleTimesStringList
    extends StringList {
        protected InvisibleTimesStringList() {
        }

        public String toSemanticString() {
            return "&InvisibleTimes;";
        }

        public String toString() {
            return " ";
        }
    }

    protected class ApplyFunctionStringList
    extends StringList {
        protected ApplyFunctionStringList() {
        }

        public String toSemanticString() {
            return "&ApplyFunction;";
        }

        public String toString() {
            return "";
        }
    }

    protected class StringList
    implements Cloneable {
        private StringListEntry root;
        private String cachedDisplayString;

        public StringList() {
        }

        public StringList(String string) {
            this.root = this.createEntry(string, false);
        }

        public StringList(String string, boolean bl) {
            this.root = this.createEntry(string, bl);
        }

        public StringList(String string, boolean bl, boolean bl2) {
            this.root = this.createEntry(string, bl, bl2);
        }

        public StringList(String string, WmiMathContext wmiMathContext) {
            this.root = this.createEntry(string, wmiMathContext, false);
        }

        public StringList(String[] stringArray, WmiMathContext wmiMathContext) {
            this.root = this.createEntry(stringArray, wmiMathContext);
        }

        public StringList(String string, WmiMathContext wmiMathContext, boolean bl) {
            this.root = this.createEntry(string, wmiMathContext, bl);
        }

        public StringList(String string, WmiMathContext wmiMathContext, boolean bl, boolean bl2) {
            this.root = this.createEntry(string, wmiMathContext, bl, bl2);
        }

        public StringListEntry createEntry(String string, boolean bl) {
            return this.createEntry(string, new WmiMathContext((WmiFontAttributeSet)WmiAbstractMathTokenModel.this.attributes), bl, true);
        }

        public StringListEntry createEntry(String string, boolean bl, boolean bl2) {
            return this.createEntry(string, new WmiMathContext((WmiFontAttributeSet)WmiAbstractMathTokenModel.this.attributes), bl, bl2);
        }

        public StringListEntry createEntry(String string, WmiMathContext wmiMathContext, boolean bl) {
            return this.createEntry(string, wmiMathContext, bl, true);
        }

        public boolean requiresQuotes(String string) {
            int n;
            boolean bl = false;
            if (" $".equals(string)) {
                return bl;
            }
            int n2 = string.length();
            if (n2 > 0) {
                for (n = 0; n < n2; ++n) {
                    if (!StringTools.isWordDelimiter(string.charAt(n))) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                bl = false;
                for (n = 0; n < n2; ++n) {
                    if (string.charAt(n) <= ' ') continue;
                    bl = true;
                    break;
                }
            }
            if (string.length() > 0 && string.charAt(0) == '`' && string.charAt(string.length() - 1) == '`') {
                bl = false;
            }
            return bl;
        }

        public StringListEntry createEntry(String string, WmiMathContext wmiMathContext, boolean bl, boolean bl2) {
            StringListEntry stringListEntry = null;
            String string2 = string;
            if (wmiMathContext.useProcRules() && !WmiAbstractMathTokenModel.isAllowedInProc(string2)) {
                string2 = string;
            } else if (string != null) {
                if (bl && string.indexOf("&") > -1 && string.indexOf(";") > -1) {
                    String[] stringArray = WmiAbstractMathTokenModel.splitStrings(string);
                    return this.createEntry(stringArray, wmiMathContext);
                }
                if (bl2 && string.startsWith("&") && string.endsWith(";")) {
                    string2 = WmiIdentifierModel.mapString(string.substring(1, string.length() - 1), wmiMathContext, true);
                } else if (!wmiMathContext.isMaple11OrLater() || wmiMathContext.getTypesettingCount() == 0) {
                    String string3 = string2 = WmiAbstractMathTokenModel.this.enableMapleSyntaxMapping() && bl ? WmiIdentifierModel.mapString(string, wmiMathContext, false) : string;
                    if (WmiAbstractMathTokenModel.this.enableMapleSyntaxMapping() && bl) {
                        string = string2;
                    }
                }
            }
            if (string2 != string) {
                stringListEntry = new EntityStringListEntry(string, wmiMathContext);
            } else {
                if (wmiMathContext.useProcRules() && WmiAbstractMathTokenModel.this.checkForQuotes() && this.requiresQuotes(string)) {
                    string = '`' + string + '`';
                }
                stringListEntry = new TextStringListEntry(string);
            }
            return stringListEntry;
        }

        public StringListEntry createEntry(String[] stringArray) {
            return this.createEntry(stringArray, new WmiMathContext((WmiFontAttributeSet)WmiAbstractMathTokenModel.this.attributes));
        }

        public StringListEntry createEntry(String[] stringArray, WmiMathContext wmiMathContext) {
            StringListEntry stringListEntry = null;
            StringListEntry stringListEntry2 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                StringListEntry stringListEntry3 = this.createEntry(stringArray[i], wmiMathContext, false);
                if (stringListEntry2 != null) {
                    stringListEntry2.setNext(stringListEntry3);
                }
                stringListEntry3.setPrevious(stringListEntry2);
                stringListEntry2 = stringListEntry3;
                if (i != 0) continue;
                stringListEntry = stringListEntry2;
            }
            return stringListEntry;
        }

        public void replaceText(String string, int n, int n2) {
            if (string != null && this.cachedDisplayString != null && n2 == this.cachedDisplayString.length() && n == 0 && string.equals(this.cachedDisplayString)) {
                return;
            }
            StringListEntry stringListEntry = null;
            StringListEntry[] stringListEntryArray = new StringListEntry[1];
            int n3 = this.locateOffset(stringListEntryArray, n, n2);
            stringListEntry = stringListEntryArray[0];
            if (this.root == null && stringListEntry == null && n3 == 0) {
                this.root = stringListEntry = new TextStringListEntry("");
            } else if (stringListEntry == null && n3 == 0) {
                stringListEntry = this.root;
            }
            if (n2 > 0) {
                this.deleteSpan(stringListEntry, n3, n2);
            }
            if (string != null) {
                this.insertText(stringListEntry, string, n3);
            }
            if (this.root == null && stringListEntry != null && stringListEntry.toString().length() > 0) {
                this.root = stringListEntry;
                stringListEntry.setPrevious(null);
            }
            this.cachedDisplayString = null;
        }

        private int locateOffset(StringListEntry[] stringListEntryArray, int n, int n2) {
            StringListEntry stringListEntry;
            int n3 = 0;
            int n4 = n;
            for (stringListEntry = this.root; stringListEntry != null; stringListEntry = stringListEntry.getNext()) {
                if ((n3 += stringListEntry.getLength()) < n + n2) continue;
                n4 -= n3;
                n4 += stringListEntry.getLength();
                break;
            }
            stringListEntryArray[0] = stringListEntry;
            return n4;
        }

        private void deleteSpan(StringListEntry stringListEntry, int n, int n2) {
            StringListEntry stringListEntry2 = stringListEntry;
            if (n2 > 0) {
                int n3 = n2;
                while (stringListEntry2 != null && n3 > 0) {
                    n3 -= stringListEntry2.deleteSpan(n, n3);
                    n = 0;
                    if (stringListEntry2.getLength() == 0) {
                        StringListEntry stringListEntry3 = stringListEntry2.getNext();
                        StringListEntry stringListEntry4 = stringListEntry2.getPrevious();
                        if (stringListEntry3 != null) {
                            stringListEntry3.setPrevious(stringListEntry4);
                        }
                        if (stringListEntry4 != null) {
                            stringListEntry4.setNext(stringListEntry3);
                        } else {
                            this.root = stringListEntry3;
                        }
                        stringListEntry2.setPrevious(null);
                        stringListEntry2.setNext(null);
                        stringListEntry2 = stringListEntry3;
                        continue;
                    }
                    stringListEntry2 = stringListEntry2.getNext();
                }
            }
        }

        private void insertText(StringListEntry stringListEntry, String string, int n) {
            StringListEntry stringListEntry2 = this.createEntry(string, false);
            if (stringListEntry2.isEntity()) {
                if (n == 0) {
                    this.insertHookUp(stringListEntry, stringListEntry2, n);
                } else if (n == stringListEntry.getLength()) {
                    this.insertHookUp(stringListEntry, stringListEntry2, n);
                } else {
                    this.splitAndInsert(stringListEntry, stringListEntry2, n);
                }
            } else if (stringListEntry != null) {
                if (stringListEntry.isEntity()) {
                    this.insertHookUp(stringListEntry, stringListEntry2, stringListEntry.getLength());
                } else {
                    stringListEntry.join(stringListEntry2, n);
                }
            } else {
                WmiErrorLog.log(new Exception("encountered a null target node"));
            }
        }

        private void insertHookUp(StringListEntry stringListEntry, StringListEntry stringListEntry2, int n) {
            if (n == 0) {
                StringListEntry stringListEntry3 = stringListEntry.getPrevious();
                if (stringListEntry3 != null) {
                    stringListEntry3.setNext(stringListEntry2);
                } else {
                    this.root = stringListEntry2;
                    if (stringListEntry.getNext() == null && stringListEntry.getLength() == 0) {
                        stringListEntry = null;
                    }
                }
                if (stringListEntry != null) {
                    stringListEntry.setPrevious(stringListEntry2);
                }
                stringListEntry2.setNext(stringListEntry);
            } else if (n == stringListEntry.getLength()) {
                StringListEntry stringListEntry4 = stringListEntry.getNext();
                stringListEntry.setNext(stringListEntry2);
                stringListEntry2.setPrevious(stringListEntry);
                if (stringListEntry4 != null) {
                    stringListEntry4.setPrevious(stringListEntry2);
                }
                stringListEntry2.setNext(stringListEntry4);
            }
        }

        private void splitAndInsert(StringListEntry stringListEntry, StringListEntry stringListEntry2, int n) {
            stringListEntry = stringListEntry.split(n);
            StringListEntry stringListEntry3 = stringListEntry.getNext();
            stringListEntry.setNext(stringListEntry2);
            stringListEntry2.setPrevious(stringListEntry);
            stringListEntry3.setPrevious(stringListEntry2);
            stringListEntry2.setNext(stringListEntry3);
        }

        public String toString() {
            if (this.cachedDisplayString == null) {
                StringListEntry stringListEntry = this.root;
                if (stringListEntry == null) {
                    this.cachedDisplayString = "";
                } else if (stringListEntry.getNext() == null) {
                    this.cachedDisplayString = stringListEntry.toString();
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    while (stringListEntry != null) {
                        stringBuffer.append(stringListEntry.toString());
                        stringListEntry = stringListEntry.getNext();
                    }
                    this.cachedDisplayString = stringBuffer.toString();
                }
            }
            return this.cachedDisplayString;
        }

        public String toSemanticString() {
            String string;
            StringListEntry stringListEntry = this.root;
            if (stringListEntry == null) {
                string = "";
            } else if (stringListEntry.getNext() == null) {
                string = stringListEntry.toSemanticString();
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                while (stringListEntry != null) {
                    stringBuffer.append(stringListEntry.toSemanticString());
                    stringListEntry = stringListEntry.getNext();
                }
                string = stringBuffer.toString();
            }
            return string;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof String) {
                bl = ((String)object).equals(this.toString());
            } else if (object instanceof StringList) {
                StringList stringList = (StringList)object;
                bl = this.toString().equals(stringList.toString());
            }
            return bl;
        }

        private class TextStringListEntry
        extends StringListEntry
        implements Cloneable {
            private String text;

            public TextStringListEntry(String string) {
                this.text = string;
            }

            public boolean isEntity() {
                return false;
            }

            public String toString() {
                return this.text;
            }

            public String toSemanticString() {
                return this.text;
            }

            public int getLength() {
                return this.text.length();
            }

            public void appendText(String string) {
                this.text = this.text != null ? this.text + string : string;
            }

            public int deleteSpan(int n, int n2) {
                int n3 = 0;
                if (n + n2 < this.text.length()) {
                    if (n == 0) {
                        this.text = this.text.substring(n2);
                        n3 = n2;
                    } else if (n == this.text.length() - 1) {
                        this.text = this.text.substring(0, n);
                        n3 = n2;
                    } else if (n < 0) {
                        this.text = this.text.substring(n2 + n);
                        n3 = n2 + n;
                    } else {
                        this.text = this.text.substring(0, n) + this.text.substring(n + n2);
                        n3 = n2;
                    }
                } else {
                    n3 = this.text.length() - n;
                    n3 = n3 == 0 ? 1 : n3;
                    this.text = this.text.substring(0, n);
                }
                return n3;
            }

            public StringListEntry split(int n) {
                String string = this.text.substring(0, n);
                String string2 = this.text.substring(n);
                TextStringListEntry textStringListEntry = new TextStringListEntry(string);
                TextStringListEntry textStringListEntry2 = new TextStringListEntry(string2);
                StringListEntry stringListEntry = this.getPrevious();
                StringListEntry stringListEntry2 = this.getNext();
                if (stringListEntry != null) {
                    stringListEntry.setNext(textStringListEntry);
                } else {
                    StringList.this.root = textStringListEntry;
                }
                textStringListEntry.setPrevious(stringListEntry);
                textStringListEntry.setNext(textStringListEntry2);
                textStringListEntry2.setPrevious(textStringListEntry);
                textStringListEntry2.setNext(stringListEntry2);
                if (stringListEntry2 != null) {
                    stringListEntry2.setPrevious(textStringListEntry2);
                }
                return textStringListEntry;
            }

            public void join(StringListEntry stringListEntry, int n) {
                StringBuffer stringBuffer = new StringBuffer(this.text.substring(0, n));
                stringBuffer.append(stringListEntry.toString());
                stringBuffer.append(this.text.substring(n));
                this.text = stringBuffer.toString();
            }
        }

        private class EntityStringListEntry
        extends StringListEntry
        implements Cloneable {
            private String displayEntity;
            private String semanticEntity;

            public EntityStringListEntry(String string, WmiMathContext wmiMathContext) {
                this.semanticEntity = string;
                this.configure(wmiMathContext);
            }

            private void configure(WmiMathContext wmiMathContext) {
                if (this.semanticEntity != null) {
                    if (this.semanticEntity.startsWith("&") && this.semanticEntity.endsWith(";")) {
                        this.displayEntity = WmiIdentifierModel.mapString(this.semanticEntity.substring(1, this.semanticEntity.length() - 1), wmiMathContext, true);
                    } else {
                        String string;
                        String string2 = string = WmiAbstractMathTokenModel.this.enableMapleSyntaxMapping() ? WmiIdentifierModel.mapString(this.semanticEntity, wmiMathContext, false) : this.semanticEntity;
                        if (!string.equals(this.semanticEntity)) {
                            this.displayEntity = string;
                        }
                    }
                }
            }

            public boolean isEntity() {
                return true;
            }

            public String toString() {
                return this.displayEntity == null ? "" : this.displayEntity;
            }

            public String toSemanticString() {
                return this.semanticEntity;
            }

            public int getLength() {
                return this.displayEntity == null ? 0 : this.displayEntity.length();
            }

            public void appendText(String string) {
            }

            public int deleteSpan(int n, int n2) {
                int n3 = this.displayEntity == null ? 0 : this.displayEntity.length();
                this.displayEntity = null;
                this.semanticEntity = null;
                return n3;
            }

            public StringListEntry split(int n) {
                return null;
            }

            public void join(StringListEntry stringListEntry, int n) {
            }
        }

        private abstract class StringListEntry
        implements Cloneable {
            private StringListEntry previous;
            private StringListEntry next;

            private StringListEntry() {
            }

            public void setPrevious(StringListEntry stringListEntry) {
                this.previous = stringListEntry;
            }

            public void setNext(StringListEntry stringListEntry) {
                this.next = stringListEntry;
            }

            public StringListEntry getNext() {
                return this.next;
            }

            public StringListEntry getPrevious() {
                return this.previous;
            }

            public abstract int getLength();

            public abstract boolean isEntity();

            public abstract String toSemanticString();

            public abstract void appendText(String var1);

            public abstract int deleteSpan(int var1, int var2);

            public abstract StringListEntry split(int var1);

            public abstract void join(StringListEntry var1, int var2);
        }
    }

    protected static class WmiTokenModelEdit
    extends WmiTextModel.WmiTextModelEdit {
        protected StringList editStrings;
        protected StringList oldStrings;

        protected WmiTokenModelEdit(WmiAbstractMathTokenModel wmiAbstractMathTokenModel) {
            super(wmiAbstractMathTokenModel);
        }

        public void undo() throws WmiNoUpdateAccessException {
            ((WmiAbstractMathTokenModel)this.model).strings = this.oldStrings;
            super.undo();
        }

        public void redo() throws WmiNoUpdateAccessException {
            ((WmiAbstractMathTokenModel)this.model).strings = this.editStrings;
            super.redo();
        }

        protected void setPreupdateProperties(WmiCompositeModel wmiCompositeModel, WmiAttributeSet wmiAttributeSet, StringList stringList) {
            super.setPreupdateProperties(wmiCompositeModel, wmiAttributeSet, null);
            this.oldStrings = stringList;
        }

        protected void setPostupdateProperties(WmiCompositeModel wmiCompositeModel, WmiAttributeSet wmiAttributeSet, StringList stringList) {
            super.setPostupdateProperties(wmiCompositeModel, wmiAttributeSet, null);
            this.editStrings = stringList;
        }
    }
}

