/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.controller.insert.MathInsertUtil;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSource;
import com.maplesoft.mathdoc.model.WmiLocallyHideableModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextContainingModel;
import com.maplesoft.mathdoc.model.WmiUndoManager;
import com.maplesoft.mathdoc.model.WmiUndoableEdit;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import java.util.ArrayList;

public class WmiTextModel
extends WmiAbstractModel
implements WmiModel,
WmiFontAttributeSource,
WmiLocallyHideableModel,
WmiTextContainingModel {
    private String contents;

    public WmiTextModel(WmiMathDocumentModel wmiMathDocumentModel) {
        this(wmiMathDocumentModel, "");
    }

    public WmiTextModel(WmiMathDocumentModel wmiMathDocumentModel, String string) {
        this(wmiMathDocumentModel, string, WmiFontAttributeSet.DEFAULT_FONT_ATTRIBUTES);
    }

    public WmiTextModel(WmiMathDocumentModel wmiMathDocumentModel, String string, WmiFontAttributeSet wmiFontAttributeSet) {
        super(wmiMathDocumentModel);
        this.contents = string;
        this.attributes = wmiFontAttributeSet != null ? wmiFontAttributeSet.pack() : WmiFontAttributeSet.DEFAULT_FONT_ATTRIBUTES;
        this.pending = this;
    }

    public WmiModelTag getTag() {
        return WmiModelTag.TEXT;
    }

    public boolean isVisible() throws WmiNoReadAccessException {
        boolean bl = true;
        WmiMathDocumentModel wmiMathDocumentModel = this.getDocument();
        if (wmiMathDocumentModel != null) {
            bl = !wmiMathDocumentModel.isHidden(this);
        }
        return bl;
    }

    public void setAttributes(WmiAttributeSet wmiAttributeSet) throws WmiNoWriteAccessException {
        if (wmiAttributeSet instanceof WmiFontAttributeSet) {
            super.setAttributes(wmiAttributeSet);
        } else {
            WmiErrorLog.log(new Exception("Invalid attribute set"));
        }
    }

    public void update(String string) throws WmiNoUpdateAccessException {
        this.verifyUpdateLock();
        WmiTextModelEdit wmiTextModelEdit = null;
        if (string != null) {
            wmiTextModelEdit = new WmiTextModelEdit(this);
            wmiTextModelEdit.setPreupdateProperties(this.parent, this.attributes, this.contents);
        }
        if (this.pending != null) {
            this.updateValuesFromPending();
        }
        if (wmiTextModelEdit != null) {
            wmiTextModelEdit.setPostupdateProperties(this.parent, this.attributes, this.contents);
            WmiUndoManager wmiUndoManager = this.getDocument().getUndoManager();
            wmiUndoManager.addEdit(wmiTextModelEdit);
        }
        this.pending = null;
    }

    protected void updateValuesFromPending() throws WmiNoUpdateAccessException {
        this.verifyUpdateLock();
        this.contents = ((WmiTextModel)this.pending).contents;
        if (this.attributes != this.pending.attributes) {
            this.attributes = this.pending.attributes instanceof WmiFontAttributeSet ? ((WmiFontAttributeSet)this.pending.attributes).pack() : this.pending.attributes;
        }
        this.parent = this.pending.parent;
    }

    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiFontAttributeSet();
    }

    protected WmiTextModel createSubModel(int n) throws WmiNoReadAccessException {
        return new WmiTextModel(this.getDocument(), this.getText().substring(n), (WmiFontAttributeSet)this.getAttributes());
    }

    public int getLength() throws WmiNoReadAccessException {
        String string = this.getContents();
        return string != null ? string.length() : 0;
    }

    public String getText() throws WmiNoReadAccessException {
        return this.getContents();
    }

    public String getSubstring(int n, int n2) throws WmiNoReadAccessException, WmiModelIndexOutOfBoundsException {
        String string = null;
        String string2 = this.getContents();
        if (string2 != null) {
            if (n < 0) {
                throw new WmiModelIndexOutOfBoundsException(this, n);
            }
            if (n + n2 > string2.length()) {
                throw new WmiModelIndexOutOfBoundsException(this, n + n2);
            }
            string = string2.substring(n, n + n2);
        }
        return string;
    }

    public char getChar(int n) throws WmiNoReadAccessException, WmiModelIndexOutOfBoundsException {
        String string = this.getContents();
        if (string == null || n < 0 || n > string.length()) {
            throw new WmiModelIndexOutOfBoundsException(this, n);
        }
        return string.charAt(n);
    }

    public void appendText(String string) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException, WmiNoReadAccessException {
        this.replaceText(string, this.getLength(), 0);
    }

    public void insertText(String string, int n) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        this.replaceText(string, n, 0);
    }

    public void deleteText(int n, int n2) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        this.replaceText(null, n, n2);
    }

    public void replaceText(String string, int n, int n2) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        this.verifyWriteLock();
        this.createPendingModel();
        if (this.pending instanceof WmiTextModel) {
            WmiTextModel wmiTextModel = (WmiTextModel)this.pending;
            String string2 = wmiTextModel.contents;
            if (string2 == null) {
                string2 = new String();
            }
            int n3 = string2.length();
            if (n < 0 || n > n3) {
                throw new WmiModelIndexOutOfBoundsException(this, n);
            }
            if (n2 < 0) {
                throw new WmiModelIndexOutOfBoundsException(this, n2);
            }
            wmiTextModel.contents = string != null ? (n == n3 - n2 ? string2.substring(0, n3 - n2) + string : (n == 0 ? string + string2.substring(n2) : string2.substring(0, n) + string + string2.substring(n + n2))) : string2.substring(0, n) + string2.substring(n + n2);
        }
    }

    public WmiTextModel splitModel(int n) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoWriteAccessException {
        return this.splitModel(n, null);
    }

    public WmiTextModel createSubModel(int n, int n2) throws WmiNoReadAccessException {
        WmiTextModel wmiTextModel = this.createSubModel(n);
        try {
            wmiTextModel.deleteText(n2 - n, this.getLength() - n2);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        return wmiTextModel;
    }

    public WmiTextModel splitModel(int n, ArrayList arrayList) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoWriteAccessException {
        if (((WmiFontAttributeSet)this.getAttributes()).hasStyle(128)) {
            return this;
        }
        WmiTextModel wmiTextModel = this;
        if (n < 0 || n > this.getLength()) {
            throw new WmiModelIndexOutOfBoundsException(this, n);
        }
        if (n > 0 && n < this.getLength()) {
            WmiCompositeModel wmiCompositeModel;
            wmiTextModel = this.createSubModel(n);
            this.deleteText(n, this.getLength() - n);
            if (WmiModelUtil.findAncestorOfClass(this, WmiMathWrapperModel.class) != null) {
                MathInsertUtil.ensureParentMathRow(new WmiModelPosition(this, n));
            }
            if ((wmiCompositeModel = this.getParent()) != null) {
                int n2 = wmiCompositeModel.indexOf(this);
                wmiCompositeModel.addChild(wmiTextModel, n2 + 1);
                WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(this.getDocument());
                wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "donotprune");
                wmiCompositeModel.addChild(wmiInlineMathModel, n2 + 1);
                if (arrayList != null) {
                    arrayList.add(new WmiModelPosition(wmiCompositeModel.getChild(n2), -1));
                    arrayList.add(new WmiModelPosition(wmiCompositeModel.getChild(n2 + 2), 0));
                }
                wmiCompositeModel.removeChild(wmiInlineMathModel);
                wmiTextModel.setParent(wmiCompositeModel);
            }
        }
        return wmiTextModel;
    }

    public void setStyleName(String string) throws WmiNoWriteAccessException {
        this.addAttribute("font_style_name", string);
    }

    protected String getContents() throws WmiNoReadAccessException {
        String string = this.contents;
        this.verifyReadLock();
        if (this.usePending() && this.pending instanceof WmiTextModel) {
            string = ((WmiTextModel)this.pending).contents;
        }
        return string;
    }

    public String getNamedFontStyle() throws WmiNoReadAccessException {
        Object object;
        String string = null;
        WmiAttributeSet wmiAttributeSet = this.getAttributesForRead();
        if (wmiAttributeSet != null && (object = wmiAttributeSet.getAttribute("font_style_name")) != null) {
            string = object.toString();
        }
        return string;
    }

    public void updateFontStyle(String string) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiFontAttributeSet wmiFontAttributeSet = new WmiFontAttributeSet();
        wmiFontAttributeSet.setNamedFontStyle(string, this.getDocument());
        this.addAttributes(wmiFontAttributeSet);
    }

    public boolean isGlobalVisible() throws WmiNoReadAccessException {
        boolean bl = true;
        WmiMathDocumentModel wmiMathDocumentModel = this.getDocument();
        if (wmiMathDocumentModel != null) {
            bl = !wmiMathDocumentModel.isHidden(this, false);
        }
        return bl;
    }

    public void getAllText(StringBuffer stringBuffer) throws WmiNoReadAccessException {
        stringBuffer.append(this.getContents());
    }

    public String getAllText() throws WmiNoReadAccessException {
        return this.getContents();
    }

    public WmiModelPosition getModelPosition(int n, boolean bl) throws WmiNoReadAccessException {
        return new WmiModelPosition(this, n);
    }

    public static class WmiTextModelEdit
    implements WmiUndoableEdit {
        protected WmiTextModel model;
        private WmiCompositeModel oldParent = null;
        private WmiCompositeModel newParent = null;
        private WmiAttributeSet oldAttributes = null;
        private WmiAttributeSet newAttributes = null;
        private String oldContents = null;
        private String newContents = null;

        protected WmiTextModelEdit(WmiTextModel wmiTextModel) {
            this.model = wmiTextModel;
        }

        protected void setPreupdateProperties(WmiCompositeModel wmiCompositeModel, WmiAttributeSet wmiAttributeSet, String string) {
            this.oldParent = wmiCompositeModel;
            this.oldAttributes = wmiAttributeSet;
            this.oldContents = string;
        }

        protected void setPostupdateProperties(WmiCompositeModel wmiCompositeModel, WmiAttributeSet wmiAttributeSet, String string) {
            this.newParent = wmiCompositeModel;
            this.newAttributes = wmiAttributeSet;
            this.newContents = string;
        }

        public void undo() throws WmiNoUpdateAccessException {
            this.model.verifyUpdateLock();
            this.model.parent = this.oldParent;
            this.model.attributes = this.oldAttributes;
            this.model.contents = this.oldContents;
            try {
                this.model.getDocument().notifyModelListeners(this.model, 0);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
        }

        public void redo() throws WmiNoUpdateAccessException {
            this.model.verifyUpdateLock();
            this.model.parent = this.newParent;
            this.model.attributes = this.newAttributes;
            this.model.contents = this.newContents;
            try {
                this.model.getDocument().notifyModelListeners(this.model, 0);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
        }
    }
}

