/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiLayoutAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextContainingModel;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import java.util.ArrayList;

public class WmiParagraphModel
extends WmiAbstractArrayCompositeModel
implements WmiTextContainingModel {
    public WmiParagraphModel(WmiMathDocumentModel wmiMathDocumentModel) {
        super(wmiMathDocumentModel);
    }

    public WmiParagraphModel(WmiMathDocumentModel wmiMathDocumentModel, WmiModel[] wmiModelArray) throws WmiInvalidModelInitializationException {
        super(wmiMathDocumentModel, wmiModelArray);
    }

    public WmiParagraphModel createEmptyParagraph() throws WmiNoWriteAccessException, WmiNoReadAccessException {
        WmiParagraphModel wmiParagraphModel = new WmiParagraphModel(this.getDocument());
        WmiAttributeSet wmiAttributeSet = this.getAttributesForRead();
        wmiParagraphModel.setAttributes(wmiAttributeSet.copyAttributes());
        return wmiParagraphModel;
    }

    public void getAllText(StringBuffer stringBuffer) throws WmiNoReadAccessException {
        if (stringBuffer != null) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                WmiModel wmiModel = this.getChild(i);
                if (!(wmiModel instanceof WmiTextContainingModel)) continue;
                ((WmiTextContainingModel)((Object)wmiModel)).getAllText(stringBuffer);
            }
        }
    }

    public ArrayList extractText() throws WmiNoReadAccessException {
        ArrayList arrayList = new ArrayList();
        WmiParagraphModel.extractText(arrayList, this);
        return arrayList;
    }

    private static void extractText(ArrayList arrayList, WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException {
        for (int i = 0; i < wmiCompositeModel.getChildCount(); ++i) {
            WmiModel wmiModel = wmiCompositeModel.getChild(i);
            if (wmiModel instanceof WmiTextModel) {
                arrayList.add(wmiModel);
                continue;
            }
            if (!(wmiModel instanceof WmiCompositeModel) || wmiModel instanceof WmiMathWrapperModel) continue;
            WmiParagraphModel.extractText(arrayList, (WmiCompositeModel)wmiModel);
        }
    }

    public boolean isEmpty() throws WmiNoReadAccessException {
        return this.isEmpty(null);
    }

    public boolean isEmpty(WmiModel wmiModel) throws WmiNoReadAccessException {
        boolean bl = false;
        int n = this.getChildCount();
        if (n == 0) {
            bl = true;
        } else {
            bl = true;
            for (int i = 0; i < n && bl; ++i) {
                WmiModel wmiModel2 = this.getChild(i);
                if (wmiModel2 == wmiModel) continue;
                bl = wmiModel2 instanceof WmiTextModel ? ((WmiTextModel)wmiModel2).getLength() == 0 : (wmiModel2 instanceof WmiMathWrapperModel ? ((WmiMathWrapperModel)wmiModel2).isEmptyMath() : false);
            }
        }
        return bl;
    }

    public void updateLayoutStyle(String string) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiAttributeSet wmiAttributeSet = this.getAttributes();
        if (wmiAttributeSet instanceof WmiLayoutAttributeSet) {
            ((WmiLayoutAttributeSet)wmiAttributeSet).setNamedLayoutStyle(string, this.getDocument());
            this.addAttributes(wmiAttributeSet);
        }
    }

    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiLayoutAttributeSet();
    }

    public WmiModelTag getTag() {
        return WmiModelTag.PARAGRAPH;
    }

    public boolean isVisible() throws WmiNoReadAccessException {
        return true;
    }

    public void update(String string) throws WmiNoUpdateAccessException {
        this.verifyUpdateLock();
        try {
            this.guaranteeInsertPoints();
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
        super.update(string);
    }

    protected void guaranteeInsertPoints() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        for (int i = 0; i < this.getChildCount(); ++i) {
            WmiModel wmiModel = this.getChild(i);
            if (this.isTextOrMath(wmiModel)) continue;
            if (i > 0) {
                if (this.isTextOrMath(this.getChild(i - 1))) continue;
                this.addChild(this.createFillModel(), i);
                continue;
            }
            this.addChild(this.createFillModel(), 0);
        }
        if (this.getChildCount() > 0 && !this.isTextOrMath(this.getChild(this.getChildCount() - 1)) || this.getChildCount() == 0) {
            this.appendChild(this.createFillModel());
        }
    }

    protected boolean isTextOrMath(WmiModel wmiModel) {
        boolean bl = wmiModel instanceof WmiTextModel || wmiModel instanceof WmiMathWrapperModel;
        return bl;
    }

    protected WmiModel createFillModel() throws WmiNoReadAccessException {
        WmiFontAttributeSet wmiFontAttributeSet = new WmiFontAttributeSet();
        wmiFontAttributeSet.addAttributes(this.getAttributes());
        return new WmiTextModel(this.getDocument(), "", wmiFontAttributeSet);
    }

    public String getAllText() throws WmiNoReadAccessException {
        StringBuffer stringBuffer = new StringBuffer();
        this.getAllText(stringBuffer);
        return stringBuffer.toString();
    }

    public int getLength() throws WmiNoReadAccessException {
        int n = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            WmiModel wmiModel = this.getChild(i);
            if (!(wmiModel instanceof WmiTextContainingModel)) continue;
            n += ((WmiTextContainingModel)((Object)wmiModel)).getLength();
        }
        return n;
    }

    public WmiModelPosition getModelPosition(int n, boolean bl) throws WmiNoReadAccessException {
        int n2 = this.getChildCount();
        int n3 = 0;
        WmiModelPosition wmiModelPosition = null;
        for (int i = 0; i < n2; ++i) {
            WmiTextContainingModel wmiTextContainingModel;
            int n4;
            WmiModel wmiModel = this.getChild(i);
            if (!(wmiModel instanceof WmiTextContainingModel) || (n4 = (wmiTextContainingModel = (WmiTextContainingModel)((Object)wmiModel)).getLength()) <= 0) continue;
            if (!bl && n3 == n) {
                wmiModelPosition = wmiTextContainingModel.getModelPosition(0, bl);
                break;
            }
            if (bl && n3 + n4 == n) {
                wmiModelPosition = wmiTextContainingModel.getModelPosition(n4, bl);
                break;
            }
            if (n - n3 < n4) {
                wmiModelPosition = wmiTextContainingModel.getModelPosition(n - n3, bl);
                break;
            }
            n3 += n4;
        }
        return wmiModelPosition;
    }
}

