/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPath;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiTextModel;

public class WmiModelPathInterval {
    private WmiModelPath lowerBound;
    private WmiModelPath upperBound;

    public WmiModelPathInterval(WmiModelPath wmiModelPath, WmiModelPath wmiModelPath2) {
        if (wmiModelPath2.greaterThan(wmiModelPath)) {
            this.lowerBound = (WmiModelPath)wmiModelPath.clone();
            this.upperBound = (WmiModelPath)wmiModelPath2.clone();
        } else {
            this.lowerBound = (WmiModelPath)wmiModelPath2.clone();
            this.upperBound = (WmiModelPath)wmiModelPath.clone();
        }
    }

    private int getBeginOffset(WmiModelPath wmiModelPath, WmiTextModel wmiTextModel) {
        int n = 0;
        int n2 = wmiModelPath.depth();
        int n3 = this.lowerBound.depth();
        boolean bl = true;
        for (int i = 0; i < n2; ++i) {
            if (i < n3 && wmiModelPath.peek(i) == this.lowerBound.peek(i)) continue;
            bl = false;
            break;
        }
        if (bl && n3 > n2) {
            n = this.lowerBound.peek(n2);
        }
        return n;
    }

    private int getEndOffset(WmiModelPath wmiModelPath, WmiTextModel wmiTextModel) throws WmiNoReadAccessException {
        int n = wmiTextModel.getLength();
        int n2 = wmiModelPath.depth();
        int n3 = this.upperBound.depth();
        boolean bl = true;
        for (int i = 0; i < n2; ++i) {
            if (i < n3 && wmiModelPath.peek(i) == this.upperBound.peek(i)) continue;
            bl = false;
            break;
        }
        if (bl && n3 > n2) {
            n = this.upperBound.peek(n2);
        }
        return n;
    }

    private boolean inInterval(WmiModelPath wmiModelPath) {
        boolean bl = false;
        int n = wmiModelPath.depth();
        int n2 = this.lowerBound.depth();
        int n3 = this.upperBound.depth();
        boolean bl2 = true;
        boolean bl3 = true;
        for (int i = 0; i < n; ++i) {
            int n4;
            bl = true;
            int n5 = wmiModelPath.peek(i);
            if (bl2) {
                if (i < n2) {
                    n4 = this.lowerBound.peek(i);
                    if (n5 < 0) {
                        bl = false;
                        break;
                    }
                    if (n5 < n4) {
                        bl = false;
                        break;
                    }
                    if (n5 == n4) {
                        bl = true;
                    } else {
                        bl2 = false;
                    }
                } else {
                    bl = true;
                }
            }
            if (!bl3) continue;
            if (i < n3) {
                n4 = this.upperBound.peek(i);
                if (n5 < 0 && i == n - 1) {
                    bl = true;
                    continue;
                }
                if (n4 < 0) {
                    bl = true;
                    bl3 = false;
                    continue;
                }
                if (n5 > n4) {
                    bl = false;
                    break;
                }
                if (n5 == n4) {
                    bl = true;
                    continue;
                }
                bl3 = false;
                continue;
            }
            bl = true;
        }
        return bl;
    }

    protected int walkIntervalChildren(WmiModelPath wmiModelPath, WmiModel wmiModel, WmiMathDocumentModel wmiMathDocumentModel, WmiModelPathWalker wmiModelPathWalker) throws WmiNoReadAccessException {
        int n = 0;
        if (wmiModel instanceof WmiCompositeModel) {
            WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)wmiModel;
            int n2 = wmiCompositeModel.getChildCount();
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                wmiModelPath.push(i);
                if (this.inInterval(wmiModelPath)) {
                    int n5 = this.walkIntervalChildren(wmiModelPath, wmiCompositeModel.getChild(i), wmiMathDocumentModel, wmiModelPathWalker);
                    if (n5 == 2) {
                        ++n4;
                    } else if (n5 == 1) {
                        ++n3;
                    }
                }
                wmiModelPath.pop();
            }
            if (n4 == n2) {
                n = 2;
            } else if (n4 > 0 || n3 > 0) {
                n = 1;
            }
        } else if (wmiModel instanceof WmiTextModel) {
            WmiTextModel wmiTextModel = (WmiTextModel)wmiModel;
            n = 2;
            int n6 = this.getBeginOffset(wmiModelPath, wmiTextModel);
            if (n6 > 0) {
                n = 1;
            } else {
                int n7 = this.getEndOffset(wmiModelPath, wmiTextModel);
                if (n7 >= 0 && n7 < wmiTextModel.getLength()) {
                    n = 1;
                }
            }
        } else {
            n = 2;
        }
        if (n != 0) {
            wmiModelPathWalker.visitModel(wmiModel, n == 2);
        }
        return n;
    }

    public WmiModelPath getLowerBound() {
        return this.lowerBound;
    }

    public WmiModelPath getUpperBound() {
        return this.upperBound;
    }

    public void walkInterval(WmiMathDocumentModel wmiMathDocumentModel, WmiModelPathWalker wmiModelPathWalker) throws WmiNoReadAccessException {
        WmiModelPath wmiModelPath = WmiModelPath.commonParent(this.lowerBound, this.upperBound);
        WmiModelPosition wmiModelPosition = wmiModelPath.getModelPosition(wmiMathDocumentModel);
        if (wmiModelPathWalker != null && wmiModelPosition != null) {
            this.walkIntervalChildren(wmiModelPath, wmiModelPosition.getModel(), wmiMathDocumentModel, wmiModelPathWalker);
        }
    }

    public static interface WmiModelPathWalker {
        public void visitModel(WmiModel var1, boolean var2);
    }
}

