/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiCorruptedModelLockException;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiLockTimeoutException;
import com.maplesoft.mathdoc.exception.WmiMissingModelLockException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;

public final class WmiModelLock {
    private static final int LOCK_WAIT_TIMEOUT = 10000000;
    public static final int NO_LOCK = -1;
    public static final int READ_LOCK = 0;
    public static final int WRITE_LOCK = 1;
    public static final int UPDATE_LOCK = 2;
    private static Object monitor = new Object();
    private static boolean noWait = false;
    WmiMathDocumentModel document = null;
    int readLockCount = 0;
    int writeLockCount = 0;
    int updateLockCount = 0;
    Thread owner = null;
    boolean enabled = true;

    public WmiModelLock(WmiMathDocumentModel wmiMathDocumentModel) {
        this.document = wmiMathDocumentModel;
    }

    public void disable() {
        this.enabled = false;
    }

    public static boolean readLock(WmiModel wmiModel, boolean bl) {
        return WmiModelLock.acquireLock(wmiModel, 0, bl);
    }

    public static void readUnlock(WmiModel wmiModel) {
        WmiModelLock.releaseLock(wmiModel, 0);
    }

    public static boolean writeLock(WmiModel wmiModel, boolean bl) {
        return WmiModelLock.acquireLock(wmiModel, 1, bl);
    }

    public static void writeUnlock(WmiModel wmiModel) {
        WmiModelLock.releaseLock(wmiModel, 1);
    }

    public static boolean updateLock(WmiModel wmiModel, boolean bl) {
        return WmiModelLock.acquireLock(wmiModel, 2, bl);
    }

    public static void updateUnlock(WmiModel wmiModel) {
        WmiModelLock.releaseLock(wmiModel, 2);
    }

    public static boolean hasLock(WmiModel wmiModel, int n) {
        return WmiModelLock.getLock(wmiModel, n) != null;
    }

    public static boolean ownsWriteLock(WmiModel wmiModel) {
        boolean bl = false;
        WmiModelLock wmiModelLock = WmiModelLock.getLock(wmiModel, 1);
        if (wmiModelLock != null && wmiModelLock.writeLockCount > 0) {
            bl = wmiModelLock.owner == Thread.currentThread();
        }
        return bl;
    }

    public static boolean ownsUpdateLock(WmiModel wmiModel) {
        boolean bl = false;
        WmiModelLock wmiModelLock = WmiModelLock.getLock(wmiModel);
        if (wmiModelLock != null && wmiModelLock.updateLockCount > 0) {
            bl = wmiModelLock.owner == Thread.currentThread();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WmiModelLock getLock(WmiModel wmiModel) {
        WmiModelLock wmiModelLock = null;
        WmiMathDocumentModel wmiMathDocumentModel = wmiModel.getDocument();
        Object object = monitor;
        synchronized (object) {
            wmiModelLock = wmiMathDocumentModel.getLock();
        }
        return wmiModelLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WmiModelLock getLock(WmiModel wmiModel, int n) {
        WmiModelLock wmiModelLock = null;
        WmiMathDocumentModel wmiMathDocumentModel = wmiModel.getDocument();
        Object object = monitor;
        synchronized (object) {
            wmiModelLock = wmiMathDocumentModel.getLock();
            switch (n) {
                case 0: {
                    if (wmiModelLock.readLockCount != 0) break;
                    wmiModelLock = null;
                    break;
                }
                case 1: {
                    if (wmiModelLock.writeLockCount != 0) break;
                    wmiModelLock = null;
                    break;
                }
                case 2: {
                    if (wmiModelLock.updateLockCount != 0) break;
                    wmiModelLock = null;
                }
            }
        }
        return wmiModelLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean canLock(WmiModel wmiModel, int n) {
        boolean bl = true;
        if (wmiModel == null) {
            return false;
        }
        Object object = monitor;
        synchronized (object) {
            WmiModelLock wmiModelLock = null;
            WmiMathDocumentModel wmiMathDocumentModel = wmiModel.getDocument();
            wmiModelLock = wmiMathDocumentModel.getLock();
            if (wmiModelLock.updateLockCount > 0) {
                bl = wmiModelLock.owner == Thread.currentThread();
            } else if (wmiModelLock.writeLockCount > 0) {
                boolean bl2 = bl = n == 0 || wmiModelLock.owner == Thread.currentThread();
                if (bl && n == 2) {
                    bl = wmiModelLock.readLockCount == 0;
                }
            } else {
                bl = n != 2;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean acquireLock(WmiModel wmiModel, int n, boolean bl) {
        boolean bl2 = false;
        if (wmiModel != null) {
            Object object = monitor;
            synchronized (object) {
                WmiMathDocumentModel wmiMathDocumentModel = wmiModel.getDocument();
                WmiModelLock wmiModelLock = wmiMathDocumentModel.getLock();
                if (wmiModelLock != null && wmiModelLock.enabled) {
                    if (WmiModelLock.canLock(wmiModel, n)) {
                        WmiModelLock.incrementLockCount(wmiModelLock, n);
                        bl2 = true;
                    } else if (bl) {
                        boolean bl3 = true;
                        long l = System.currentTimeMillis();
                        while (!WmiModelLock.canLock(wmiModel, n)) {
                            try {
                                long l2 = System.currentTimeMillis();
                                monitor.wait(10000000L);
                            }
                            catch (InterruptedException interruptedException) {
                                WmiErrorLog.log(interruptedException);
                                bl3 = false;
                                monitor.notifyAll();
                                break;
                            }
                            catch (WmiLockTimeoutException wmiLockTimeoutException) {
                                WmiErrorLog.log(wmiLockTimeoutException);
                                bl3 = false;
                                monitor.notifyAll();
                                break;
                            }
                            if (wmiModelLock.enabled) continue;
                            bl3 = false;
                            monitor.notifyAll();
                            break;
                        }
                        if (bl3) {
                            WmiModelLock.incrementLockCount(wmiModelLock, n);
                            bl2 = true;
                        }
                    }
                }
            }
        }
        return bl2;
    }

    private static void incrementLockCount(WmiModelLock wmiModelLock, int n) {
        if (wmiModelLock != null) {
            switch (n) {
                case 0: {
                    ++wmiModelLock.readLockCount;
                    break;
                }
                case 1: {
                    ++wmiModelLock.writeLockCount;
                    wmiModelLock.owner = Thread.currentThread();
                    break;
                }
                case 2: {
                    ++wmiModelLock.updateLockCount;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseLock(WmiModel wmiModel, int n) {
        if (wmiModel == null) {
            WmiErrorLog.log(new IllegalArgumentException("null model!"));
            return;
        }
        WmiModelLock wmiModelLock = null;
        WmiMathDocumentModel wmiMathDocumentModel = wmiModel.getDocument();
        Object object = monitor;
        synchronized (object) {
            try {
                wmiModelLock = wmiMathDocumentModel.getLock();
                if (wmiModelLock == null) {
                    throw new WmiMissingModelLockException(wmiModel);
                }
                switch (n) {
                    case 0: {
                        if (wmiModelLock.readLockCount > 0) {
                            --wmiModelLock.readLockCount;
                            break;
                        }
                        throw new WmiCorruptedModelLockException(wmiModel);
                    }
                    case 1: {
                        if (wmiModelLock.writeLockCount == 1) {
                            wmiModelLock.writeLockCount = 0;
                            wmiModelLock.owner = null;
                            break;
                        }
                        if (wmiModelLock.writeLockCount > 0) {
                            --wmiModelLock.writeLockCount;
                            break;
                        }
                        throw new WmiCorruptedModelLockException(wmiModel);
                    }
                    case 2: {
                        if (wmiModelLock.updateLockCount > 0) {
                            --wmiModelLock.updateLockCount;
                            break;
                        }
                        throw new WmiCorruptedModelLockException(wmiModel);
                    }
                }
            }
            catch (WmiMissingModelLockException wmiMissingModelLockException) {
                WmiErrorLog.log(new Exception("Missing model lock"));
            }
            catch (WmiCorruptedModelLockException wmiCorruptedModelLockException) {
                WmiErrorLog.log(new Exception("Corrupted model lock"));
            }
            monitor.notifyAll();
        }
    }
}

