/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public abstract class WmiMetadataContainer
implements Comparable {
    public static final String INVALID_ID = "<invalid>";
    public static final String DEFAULT_NAME = "<default>";
    public static final String ID_TAG = "id";
    public static final String CATEGORY_TAG = "category";
    public static final String NAME_TAG = "name";
    public static final String VALUE_TAG = "value";
    public static final int MERGE_CANCEL_ACTION = 0;
    public static final int MERGE_NO_ATTRIBUTE_CHANGE = 1;
    public static final int MERGE_ADD_MISSING = 2;
    public static final int MERGE_REPLACE_WITH_DEFAULTS = 3;
    public static final int MERGE_OVERWITE_ALL = 4;
    private String id = null;
    private String name = null;
    private HashMap valueMap = null;

    public static String getMetadataSafeString(String string) {
        String string2 = string;
        if (string2 != null) {
            if (string2.length() == 0) {
                string2 = DEFAULT_NAME;
            }
        } else {
            string2 = DEFAULT_NAME;
        }
        return string2;
    }

    public WmiMetadataContainer(String string, String string2) {
        this.valueMap = new HashMap();
        this.id = string;
        this.name = string2;
    }

    protected WmiMetadataContainer(WmiMetadataContainer wmiMetadataContainer, boolean bl) {
        this.id = bl ? wmiMetadataContainer.id : INVALID_ID;
        this.name = new String(wmiMetadataContainer.name);
        this.valueMap = WmiMetadataContainer.attributeMapDeepCopy(wmiMetadataContainer.valueMap);
    }

    public String toString() {
        return this.getName();
    }

    public int compareTo(Object object) {
        return this.toString().compareTo(object.toString());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean addAttribute(String string, String string2) {
        boolean bl = false;
        if (!this.valueMap.containsKey(string)) {
            if (string2 != null) {
                this.valueMap.put(string, string2);
            } else {
                this.valueMap.put(string, DEFAULT_NAME);
            }
            bl = true;
        }
        return bl;
    }

    public String getAttribute(String string) {
        return (String)this.valueMap.get(string);
    }

    public boolean removeAttribute(String string) {
        boolean bl = false;
        if (this.valueMap.containsKey(string)) {
            this.valueMap.remove(string);
            bl = true;
        }
        return bl;
    }

    public void removeAllAttributes() {
        this.valueMap.clear();
    }

    public boolean renameAttribute(String string, String string2) {
        boolean bl = false;
        if (this.valueMap.containsKey(string)) {
            Object v = this.valueMap.get(string);
            this.valueMap.remove(string);
            this.valueMap.put(string2, v);
            bl = true;
        }
        return bl;
    }

    public boolean changeAttribute(String string, String string2, boolean bl) {
        boolean bl2 = false;
        if (!this.valueMap.containsKey(string)) {
            if (bl) {
                bl2 = this.addAttribute(string, string2);
            }
        } else {
            this.valueMap.put(string, string2);
            bl2 = true;
        }
        return bl2;
    }

    public void mergeAttributesFromSource(WmiMetadataContainer wmiMetadataContainer, int n) {
        switch (n) {
            case 2: {
                this.mergeAttributesFromSource(wmiMetadataContainer, false);
                break;
            }
            case 3: {
                this.mergeAttributesFromSource(wmiMetadataContainer, true);
                break;
            }
            case 4: {
                this.replaceAttributesFromSource(wmiMetadataContainer);
                break;
            }
        }
    }

    protected void replaceAttributesFromSource(WmiMetadataContainer wmiMetadataContainer) {
        this.valueMap = WmiMetadataContainer.attributeMapDeepCopy(wmiMetadataContainer.valueMap);
    }

    protected void mergeAttributesFromSource(WmiMetadataContainer wmiMetadataContainer, boolean bl) {
        Iterator iterator = wmiMetadataContainer.valueMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object v;
            String string;
            Object k = iterator.next();
            String string2 = k != null ? k.toString() : null;
            if (string2 == null || (string = (v = wmiMetadataContainer.valueMap.get(string2)) != null ? v.toString() : null) == null) continue;
            boolean bl2 = this.valueMap.containsKey(string2);
            if (bl2 && bl) {
                this.changeAttribute(string2, string);
                continue;
            }
            if (bl2) continue;
            this.addAttribute(string2, string);
        }
    }

    public boolean changeAttribute(String string, String string2) {
        return this.changeAttribute(string, string2, false);
    }

    public Set getAttributeKeySet() {
        return this.valueMap.keySet();
    }

    public int getAttributeCount() {
        return this.valueMap.size();
    }

    protected static HashMap attributeMapDeepCopy(HashMap hashMap) {
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)hashMap.get(string);
            hashMap2.put(string, string2);
        }
        return hashMap2;
    }
}

