/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractMappedAttributeSet;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiStyleAttributeSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.NoSuchElementException;

public class WmiLayoutAttributeSet
extends WmiAbstractMappedAttributeSet
implements WmiStyleAttributeSet {
    public static final String ALIGNMENT = "alignment";
    public static final String ALIGNMENT_LEFT = "left";
    public static final String ALIGNMENT_RIGHT = "right";
    public static final String ALIGNMENT_CENTRED = "centred";
    public static final String ALIGNMENT_JUSTIFY = "justify";
    public static final String LIST = "bullet";
    public static final String BULLETSUFFIX = "bulletsuffix";
    public static final String INITIAL_LIST_VALUE = "initial";
    public static final int INITIAL_LIST_MAX_VALUE = 254;
    public static final String LIST_NONE = "none";
    public static final String LIST_DOT = "dot";
    public static final String LIST_DASH = "dash";
    public static final String LIST_INDENT = "indent";
    public static final String LIST_NUMERIC = "numeric";
    public static final String LIST_ALPHABETIC = "alphabetic";
    public static final String LIST_UPPER_ALPHABETIC = "ALPHABETIC";
    public static final String LIST_ROMAN = "roman";
    public static final String LIST_UPPER_ROMAN = "ROMAN";
    public static final String FIRST_INDENT = "firstindent";
    public static final String LEFT_MARGIN = "leftmargin";
    public static final String RIGHT_MARGIN = "rightmargin";
    public static final String LINESPACING = "linespacing";
    public static final String SPACE_ABOVE = "spaceabove";
    public static final String SPACE_BELOW = "spacebelow";
    public static final String LINEBREAK = "linebreak";
    public static final String LINEBREAK_SPACE = "space";
    public static final String LINEBREAK_ANY = "any";
    public static final String LINEBREAK_NEWLINE = "newline";
    public static final String PAGEBREAK_BEFORE = "pagebreak-before";
    public static final String STYLE_NAME = "layout_style_name";
    public static final String SET_PROPERTY = "true";
    public static final String UNSET_PROPERTY = "false";
    public static final String BULLET_DOT_TEXT = "\u2022 ";
    public static final String BULLET_DASH_TEXT = "\u2013 ";
    public static final String BULLET_INDENT_TEXT = "  ";
    public static final String[] NUMBERED_LISTS = new String[]{"numeric", "alphabetic", "ALPHABETIC", "roman", "ROMAN"};
    private static final int JUSTIFY_STYLE = 3;
    private static final int LIST_STYLE = 60;
    private static final int LINEBREAK_STYLE = 192;
    private static final int LIST_INITIAL_VALUE_STYLE = 261120;
    private static final int LIST_INITIAL_VALUE_STYLE_FIRST_VALUE = 1024;
    private static final String[] ATTRIBUTE_KEY_SET = new String[]{"alignment", "bullet", "firstindent", "leftmargin", "rightmargin", "linespacing", "spaceabove", "spacebelow", "linebreak", "pagebreak-before", "initial", "bulletsuffix"};
    private static final String[] NAMED_ATTRIBUTE_KEY_SET = new String[]{"alignment", "bullet", "firstindent", "leftmargin", "rightmargin", "linespacing", "spaceabove", "spacebelow", "linebreak", "pagebreak-before", "layout_style_name", "initial", "bulletsuffix"};
    private static final String[] ALIGNMENT_SET = new String[]{"left", "right", "centred", "justify"};
    private static final String[] LIST_SET = new String[]{"none", "dot", "dash", "indent", "numeric", "alphabetic", "ALPHABETIC", "roman", "ROMAN"};
    private static final String[] LINEBREAK_SET = new String[]{"space", "any", "newline"};
    private static HashMap attributeMapper = null;
    private String styleName = null;
    private int leftMargin = 0;
    private int rightMargin = 0;
    private int topMargin = 0;
    private int bottomMargin = 0;
    private int firstIndent = 0;
    private float linespacing = 0.0f;
    private boolean pagebreakBefore = false;
    private int extendedStyle = 0;
    private String bulletSuffix = "";

    public WmiLayoutAttributeSet() {
        this(null);
    }

    public WmiLayoutAttributeSet(String string) {
        this.styleName = string;
    }

    public static void initAttributeMapper() {
        attributeMapper = new HashMap();
        attributeMapper.put(ALIGNMENT, new WmiLayoutBitAttributeMapper(ALIGNMENT_SET, 3));
        attributeMapper.put(LIST, new WmiLayoutBitAttributeMapper(LIST_SET, 60));
        attributeMapper.put(FIRST_INDENT, new WmiFirstIndentMapper());
        attributeMapper.put(LINESPACING, new WmiLinespacingMapper());
        attributeMapper.put(LEFT_MARGIN, new WmiLeftMarginMapper());
        attributeMapper.put(RIGHT_MARGIN, new WmiRightMarginMapper());
        attributeMapper.put(SPACE_ABOVE, new WmiTopMarginMapper());
        attributeMapper.put(SPACE_BELOW, new WmiBottomMarginMapper());
        attributeMapper.put(LINEBREAK, new WmiLayoutBitAttributeMapper(LINEBREAK_SET, 192));
        attributeMapper.put(PAGEBREAK_BEFORE, new WmiPagebreakMapper());
        attributeMapper.put(INITIAL_LIST_VALUE, new WmiInitialListValueMapper(261120, 1024));
        attributeMapper.put(BULLETSUFFIX, new WmiBulletSuffixMapper());
    }

    public String getBulletText(int n) {
        Object object;
        String string = null;
        HashMap hashMap = this.getAttributeMapperMap();
        WmiAbstractMappedAttributeSet.WmiAttributeMapper wmiAttributeMapper = (WmiAbstractMappedAttributeSet.WmiAttributeMapper)hashMap.get(LIST);
        WmiBulletSuffixMapper wmiBulletSuffixMapper = (WmiBulletSuffixMapper)attributeMapper.get(BULLETSUFFIX);
        String string2 = (String)wmiBulletSuffixMapper.getAttribute(this);
        if (wmiAttributeMapper != null && (object = wmiAttributeMapper.getAttribute(this)) != null) {
            if (object.equals(LIST_DOT)) {
                string = BULLET_DOT_TEXT;
            } else if (object.equals(LIST_DASH)) {
                string = BULLET_DASH_TEXT;
            } else if (object.equals(LIST_INDENT)) {
                string = BULLET_INDENT_TEXT;
            } else if (object.equals(LIST_NUMERIC)) {
                string = Integer.toString(n) + string2 + " ";
            } else if (object.equals(LIST_ALPHABETIC)) {
                string = WmiLayoutAttributeSet.getLetters(n) + string2 + " ";
            } else if (object.equals(LIST_UPPER_ALPHABETIC)) {
                string = WmiLayoutAttributeSet.getLetters(n).toUpperCase() + string2 + " ";
            } else if (object.equals(LIST_ROMAN)) {
                string = WmiLayoutAttributeSet.getRoman(n) + string2 + " ";
            } else if (object.equals(LIST_UPPER_ROMAN)) {
                string = WmiLayoutAttributeSet.getRoman(n).toUpperCase() + string2 + " ";
            }
        }
        return string;
    }

    private static String getLetters(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n > 0) {
            int n2 = n % 26;
            if (n2 == 0) {
                n2 = 26;
            }
            stringBuffer.insert(0, (char)(97 + n2 - 1));
            n -= n2;
            n /= 26;
        }
        return stringBuffer.toString();
    }

    private static String getRoman(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n >= 1000) {
            stringBuffer.append('m');
            n -= 1000;
        }
        if (n >= 900) {
            stringBuffer.append("cm");
            n -= 900;
        }
        if (n >= 500) {
            stringBuffer.append('d');
            n -= 500;
        }
        if (n >= 400) {
            stringBuffer.append("cd");
            n -= 400;
        }
        while (n >= 100) {
            stringBuffer.append('c');
            n -= 100;
        }
        if (n >= 90) {
            stringBuffer.append("xc");
            n -= 90;
        }
        if (n >= 50) {
            stringBuffer.append("l");
            n -= 50;
        }
        if (n >= 40) {
            stringBuffer.append("xl");
            n -= 40;
        }
        while (n >= 10) {
            stringBuffer.append('x');
            n -= 10;
        }
        if (n == 9) {
            stringBuffer.append("ix");
            n -= 9;
        }
        if (n >= 5) {
            stringBuffer.append('v');
            n -= 5;
        }
        if (n >= 4) {
            stringBuffer.append("iv");
            n -= 4;
        }
        while (n >= 1) {
            stringBuffer.append('i');
            --n;
        }
        return stringBuffer.toString();
    }

    public int getInitialListValue() {
        Object object;
        int n = 0;
        WmiAbstractMappedAttributeSet.WmiAttributeMapper wmiAttributeMapper = (WmiAbstractMappedAttributeSet.WmiAttributeMapper)attributeMapper.get(INITIAL_LIST_VALUE);
        if (wmiAttributeMapper != null && (object = wmiAttributeMapper.getAttribute(this)) instanceof Integer) {
            n = (Integer)object;
        }
        return n;
    }

    public Object getListType() {
        Object object = null;
        WmiAbstractMappedAttributeSet.WmiAttributeMapper wmiAttributeMapper = (WmiAbstractMappedAttributeSet.WmiAttributeMapper)attributeMapper.get(LIST);
        if (wmiAttributeMapper != null) {
            object = wmiAttributeMapper.getAttribute(this);
        }
        return object;
    }

    public int getIndent() {
        return this.firstIndent;
    }

    public String getStyleName() {
        return this.styleName;
    }

    public void setIndent(int n) {
        this.firstIndent = n;
    }

    public void setMargins(int n, int n2, int n3, int n4) {
        this.leftMargin = n;
        this.rightMargin = n2;
        this.topMargin = n3;
        this.bottomMargin = n4;
    }

    public void setNamedLayoutStyle(String string, WmiMathDocumentModel wmiMathDocumentModel) throws WmiNoReadAccessException {
        WmiLayoutAttributeSet wmiLayoutAttributeSet;
        this.setLayoutStyleName(string);
        if (string != null && wmiMathDocumentModel != null && (wmiLayoutAttributeSet = wmiMathDocumentModel.getLayoutStyle(string)) != null) {
            this.addAttributes(wmiLayoutAttributeSet);
        }
    }

    public void setLayoutStyleName(String string) {
        this.styleName = string;
    }

    protected synchronized HashMap getAttributeMapperMap() {
        if (attributeMapper == null) {
            WmiLayoutAttributeSet.initAttributeMapper();
        }
        return attributeMapper;
    }

    public void addAttribute(Object object, Object object2) {
        if (object.equals(STYLE_NAME)) {
            this.setLayoutStyleName(object2 != null ? object2.toString() : null);
        } else {
            super.addAttribute(object, object2);
        }
    }

    public WmiAttributeSet copyAttributes() {
        WmiLayoutAttributeSet wmiLayoutAttributeSet = new WmiLayoutAttributeSet(this.getStyleName());
        wmiLayoutAttributeSet.setIndent(this.getIndent());
        wmiLayoutAttributeSet.setMargins(this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
        wmiLayoutAttributeSet.extendedStyle = this.extendedStyle;
        wmiLayoutAttributeSet.linespacing = this.linespacing;
        wmiLayoutAttributeSet.pagebreakBefore = this.pagebreakBefore;
        wmiLayoutAttributeSet.bulletSuffix = this.bulletSuffix;
        return wmiLayoutAttributeSet;
    }

    public Object getAttribute(Object object) {
        Object object2 = null;
        object2 = object.equals(STYLE_NAME) ? this.styleName : super.getAttribute(object);
        return object2;
    }

    public int getAttributeCount() {
        return this.styleName == null ? ATTRIBUTE_KEY_SET.length : NAMED_ATTRIBUTE_KEY_SET.length;
    }

    public Enumeration getAttributeNames() {
        return new WmiLayoutAttributeEnumeration(this.styleName == null ? ATTRIBUTE_KEY_SET : NAMED_ATTRIBUTE_KEY_SET);
    }

    public boolean isNumberedList() {
        Object object;
        boolean bl = false;
        WmiAbstractMappedAttributeSet.WmiAttributeMapper wmiAttributeMapper = (WmiAbstractMappedAttributeSet.WmiAttributeMapper)attributeMapper.get(LIST);
        if (wmiAttributeMapper != null && (object = wmiAttributeMapper.getAttribute(this)) != null) {
            for (int i = 0; i < NUMBERED_LISTS.length && !bl; ++i) {
                bl = object.equals(NUMBERED_LISTS[i]);
            }
        }
        return bl;
    }

    static /* synthetic */ String[] access$900() {
        return ATTRIBUTE_KEY_SET;
    }

    public static class WmiLayoutAttributeEnumeration
    implements Enumeration {
        private int index = 0;
        private String[] keys = WmiLayoutAttributeSet.access$900();

        public WmiLayoutAttributeEnumeration(String[] stringArray) {
            this.keys = stringArray;
        }

        public boolean hasMoreElements() {
            return this.keys != null && this.index < this.keys.length;
        }

        public Object nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            return this.keys[this.index++];
        }
    }

    protected static class WmiInitialListValueMapper
    extends WmiAbstractMappedAttributeSet.WmiIntAttributeMapper {
        int mask;
        int first;

        public WmiInitialListValueMapper(int n, int n2) {
            this.mask = n;
            this.first = n2;
        }

        public void store(WmiAttributeSet wmiAttributeSet, int n) {
            if (n > 254) {
                n = 254;
            } else if (n < 0) {
                n = 255;
            }
            int n2 = ((WmiLayoutAttributeSet)wmiAttributeSet).extendedStyle;
            ((WmiLayoutAttributeSet)wmiAttributeSet).extendedStyle = n2 - (n2 & this.mask) | n * this.first;
        }

        public int fetch(WmiAttributeSet wmiAttributeSet) {
            int n = (((WmiLayoutAttributeSet)wmiAttributeSet).extendedStyle & this.mask) / this.first;
            if (n > 254) {
                n = -1;
            }
            return n;
        }
    }

    protected static class WmiPagebreakMapper
    extends WmiAbstractMappedAttributeSet.WmiStringBoolAttributeMapper {
        protected WmiPagebreakMapper() {
        }

        public void store(WmiAttributeSet wmiAttributeSet, String string) {
            ((WmiLayoutAttributeSet)wmiAttributeSet).pagebreakBefore = Boolean.valueOf(string);
        }

        public String fetch(WmiAttributeSet wmiAttributeSet) {
            return String.valueOf(((WmiLayoutAttributeSet)wmiAttributeSet).pagebreakBefore);
        }
    }

    protected static class WmiBottomMarginMapper
    extends WmiAbstractMappedAttributeSet.WmiIntAttributeMapper {
        protected WmiBottomMarginMapper() {
        }

        public void store(WmiAttributeSet wmiAttributeSet, int n) {
            ((WmiLayoutAttributeSet)wmiAttributeSet).bottomMargin = n;
        }

        public int fetch(WmiAttributeSet wmiAttributeSet) {
            return ((WmiLayoutAttributeSet)wmiAttributeSet).bottomMargin;
        }
    }

    protected static class WmiTopMarginMapper
    extends WmiAbstractMappedAttributeSet.WmiIntAttributeMapper {
        protected WmiTopMarginMapper() {
        }

        public void store(WmiAttributeSet wmiAttributeSet, int n) {
            ((WmiLayoutAttributeSet)wmiAttributeSet).topMargin = n;
        }

        public int fetch(WmiAttributeSet wmiAttributeSet) {
            return ((WmiLayoutAttributeSet)wmiAttributeSet).topMargin;
        }
    }

    protected static class WmiBulletSuffixMapper
    extends WmiAbstractMappedAttributeSet.WmiStringAttributeMapper {
        protected WmiBulletSuffixMapper() {
        }

        public void store(WmiAttributeSet wmiAttributeSet, String string) {
            ((WmiLayoutAttributeSet)wmiAttributeSet).bulletSuffix = string;
        }

        public String fetch(WmiAttributeSet wmiAttributeSet) {
            return ((WmiLayoutAttributeSet)wmiAttributeSet).bulletSuffix;
        }
    }

    protected static class WmiRightMarginMapper
    extends WmiAbstractMappedAttributeSet.WmiIntAttributeMapper {
        protected WmiRightMarginMapper() {
        }

        public void store(WmiAttributeSet wmiAttributeSet, int n) {
            ((WmiLayoutAttributeSet)wmiAttributeSet).rightMargin = n;
        }

        public int fetch(WmiAttributeSet wmiAttributeSet) {
            return ((WmiLayoutAttributeSet)wmiAttributeSet).rightMargin;
        }
    }

    protected static class WmiLeftMarginMapper
    extends WmiAbstractMappedAttributeSet.WmiIntAttributeMapper {
        protected WmiLeftMarginMapper() {
        }

        public void store(WmiAttributeSet wmiAttributeSet, int n) {
            ((WmiLayoutAttributeSet)wmiAttributeSet).leftMargin = n;
        }

        public int fetch(WmiAttributeSet wmiAttributeSet) {
            return ((WmiLayoutAttributeSet)wmiAttributeSet).leftMargin;
        }
    }

    protected static class WmiLinespacingMapper
    implements WmiAbstractMappedAttributeSet.WmiAttributeMapper {
        protected WmiLinespacingMapper() {
        }

        public void addAttribute(WmiAttributeSet wmiAttributeSet, Object object) {
            float f = 0.0f;
            if (object instanceof Float) {
                f = ((Float)object).floatValue();
            } else if (object != null) {
                try {
                    f = Float.parseFloat(object.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    WmiErrorLog.log(numberFormatException);
                }
            }
            ((WmiLayoutAttributeSet)wmiAttributeSet).linespacing = f;
        }

        public Object getAttribute(WmiAttributeSet wmiAttributeSet) {
            float f = ((WmiLayoutAttributeSet)wmiAttributeSet).linespacing;
            return new Float(f);
        }
    }

    protected static class WmiFirstIndentMapper
    extends WmiAbstractMappedAttributeSet.WmiIntAttributeMapper {
        protected WmiFirstIndentMapper() {
        }

        public void store(WmiAttributeSet wmiAttributeSet, int n) {
            ((WmiLayoutAttributeSet)wmiAttributeSet).firstIndent = n;
        }

        public int fetch(WmiAttributeSet wmiAttributeSet) {
            return ((WmiLayoutAttributeSet)wmiAttributeSet).firstIndent;
        }
    }

    protected static class WmiLayoutBitAttributeMapper
    implements WmiAbstractMappedAttributeSet.WmiAttributeMapper {
        private Object[] values;
        private int groupBits;
        private int[] setBit;

        protected WmiLayoutBitAttributeMapper(Object[] objectArray, int n) {
            this.values = objectArray;
            this.groupBits = n;
            int n2 = n;
            int n3 = 0;
            while ((n2 & 1) == 0) {
                n2 >>= 1;
                ++n3;
            }
            this.setBit = new int[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                this.setBit[i] = i << n3;
            }
        }

        public void addAttribute(WmiAttributeSet wmiAttributeSet, Object object) {
            WmiLayoutAttributeSet wmiLayoutAttributeSet = (WmiLayoutAttributeSet)wmiAttributeSet;
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.values[i].equals(object)) continue;
                wmiLayoutAttributeSet.extendedStyle &= ~this.groupBits;
                wmiLayoutAttributeSet.extendedStyle |= this.setBit[i];
                break;
            }
        }

        public Object getAttribute(WmiAttributeSet wmiAttributeSet) {
            Object object = null;
            int n = ((WmiLayoutAttributeSet)wmiAttributeSet).extendedStyle & this.groupBits;
            for (int i = 0; i < this.setBit.length; ++i) {
                if (n != this.setBit[i]) continue;
                object = this.values[i];
                break;
            }
            return object;
        }
    }
}

