/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiBooleanAttributeKey;
import com.maplesoft.mathdoc.model.WmiColorAttributeKey;
import com.maplesoft.mathdoc.model.WmiIntAttributeKey;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiStringAttributeKey;
import com.maplesoft.mathdoc.model.WmiStyleAttributeSet;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Color;
import java.util.HashMap;
import java.util.Locale;

public class WmiFontAttributeSet
extends WmiAbstractArrayAttributeSet
implements WmiStyleAttributeSet {
    public static final String ENCODING_SHIFT_JIS = "shift_JIS";
    public static final String ENCODING_ISO8859_1 = "ISO8859-1";
    public static final String ENCODING_UTF8 = "UTF-8";
    public static final String BOLD = "bold";
    public static final String ITALIC = "italic";
    public static final String UNDERLINE = "underline";
    public static final String SUPERSCRIPT = "superscript";
    public static final String SUBSCRIPT = "subscript";
    public static final String OPAQUE = "opaque";
    public static final String FOREGROUND = "foreground";
    public static final String BACKGROUND = "background";
    public static final String FAMILY = "family";
    public static final String SIZE = "size";
    public static final String EXECUTABLE = "executable";
    public static final String READ_ONLY = "readonly";
    public static final String COMPOSED = "composed";
    public static final String CONVERTED = "converted";
    public static final String IM_SELECTED = "imselected";
    public static final String PLACEHOLDER = "placeholder";
    public static final String SELECTION_PLACEHOLDER = "selection-placeholder";
    public static final String STYLE_NAME = "font_style_name";
    public static final String SET_PROPERTY = "true";
    public static final String RESET_PROPERTY = "false";
    public static final int PLAIN_STYLE = 0;
    public static final int BOLD_STYLE = 1;
    public static final int ITALIC_STYLE = 2;
    public static final int UNDERLINE_STYLE = 4;
    public static final int SUBSCRIPT_STYLE = 8;
    public static final int SUPERSCRIPT_STYLE = 16;
    public static final int OPAQUE_STYLE = 32;
    public static final int EXECUTABLE_STYLE = 64;
    public static final int READ_ONLY_STYLE = 128;
    public static final int COMPOSED_STYLE = 256;
    public static final int CONVERTED_STYLE = 512;
    public static final int IM_SELECTED_STYLE = 1024;
    public static final int PLACEHOLDER_STYLE = 2048;
    public static final int SELECTION_PLACEHOLDER_STYLE = 4096;
    protected static final String[] ATTRIBUTE_KEY_SET = new String[]{"family", "size", "bold", "italic", "underline", "subscript", "superscript", "opaque", "foreground", "background", "executable", "readonly", "composed", "converted", "imselected", "placeholder", "selection-placeholder", "font_style_name"};
    public static final String DEFAULT_FAMILY = WmiFontAttributeSet.getDefaultStyleFontFamily();
    public static final int DEFAULT_SIZE = 12;
    public static final int DEFAULT_STYLE = 0;
    public static final int DEFAULT_FOREGROUND = 0;
    public static final int DEFAULT_BACKGROUND = 0xFFFFFF;
    public static final WmiAttributeKey BOLD_KEY = new FontStyleBitKey("bold", 1);
    public static final WmiAttributeKey ITALIC_KEY = new FontStyleBitKey("italic", 2);
    public static final WmiAttributeKey UNDERLINE_KEY = new FontStyleBitKey("underline", 4);
    public static final WmiAttributeKey SUBSCRIPT_KEY = new FontStyleBitKey("subscript", 8);
    public static final WmiAttributeKey SUPERSCRIPT_KEY = new FontStyleBitKey("superscript", 16);
    public static final WmiAttributeKey OPAQUE_KEY = new FontStyleBitKey("opaque", 32);
    public static final WmiAttributeKey EXECUTABLE_KEY = new FontStyleBitKey("executable", 64);
    public static final WmiAttributeKey READ_ONLY_KEY = new FontStyleBitKey("readonly", 128);
    public static final WmiAttributeKey COMPOSED_KEY = new FontStyleBitKey("composed", 256);
    public static final WmiAttributeKey CONVERTED_KEY = new FontStyleBitKey("converted", 512);
    public static final WmiAttributeKey IM_SELECTED_KEY = new FontStyleBitKey("imselected", 1024);
    public static final WmiAttributeKey PLACEHOLDER_KEY = new FontStyleBitKey("placeholder", 2048);
    public static final WmiAttributeKey SELECTION_PLACEHOLDER_KEY = new FontStyleBitKey("selection-placeholder", 4096);
    public static final WmiAttributeKey FOREGROUND_KEY = new FontForegroundKey();
    public static final WmiAttributeKey BACKGROUND_KEY = new FontBackgroundKey();
    public static final WmiAttributeKey STYLE_KEY = new FontStyleKey();
    public static final WmiAttributeKey FAMILY_KEY = new FontFamilyKey();
    public static final WmiAttributeKey SIZE_KEY = new FontSizeKey();
    public static final WmiAttributeKey[] ATTRIBUTE_KEYS = new WmiAttributeKey[]{FAMILY_KEY, SIZE_KEY, BOLD_KEY, ITALIC_KEY, UNDERLINE_KEY, SUBSCRIPT_KEY, SUPERSCRIPT_KEY, FOREGROUND_KEY, BACKGROUND_KEY, OPAQUE_KEY, EXECUTABLE_KEY, READ_ONLY_KEY, COMPOSED_KEY, CONVERTED_KEY, IM_SELECTED_KEY, PLACEHOLDER_KEY, SELECTION_PLACEHOLDER_KEY, STYLE_KEY};
    public static final WmiFontAttributeSet DEFAULT_FONT_ATTRIBUTES = new WmiFontAttributeSet();
    private static HashMap keymap = null;
    private static HashMap cache = new HashMap();
    private String fontStyleName = null;
    private String family = DEFAULT_FAMILY;
    private int size = 12;
    private int foreground = 0;
    private int background = 0xFFFFFF;
    private int extendedStyle = 0;
    private String foregroundString = null;
    private String backgroundString = null;

    private static String getDefaultStyleFontFamily() {
        String string = "Times New Roman";
        Locale locale = RuntimeLocale.getEncodingLocale();
        if (RuntimeLocale.areLocalesEqual(locale, Locale.JAPANESE)) {
            string = WmiFontAttributeSet.getDefaultJapaneseSansSerifFont();
        }
        return string;
    }

    private static String getDefaultJapaneseSansSerifFont() {
        String string = null;
        string = RuntimePlatform.isMac() ? (RuntimePlatform.getMacOSVersion() <= 3 ? "Osaka" : "Hiragino Kaku Gothic Pro") : "MS Gothic";
        return string;
    }

    public WmiFontAttributeSet() {
    }

    public WmiFontAttributeSet(String string) {
        this.fontStyleName = string;
    }

    public WmiFontAttributeSet(WmiFontAttributeSet wmiFontAttributeSet) {
        this.copyFontAttributes(wmiFontAttributeSet);
    }

    public void copyFontAttributes(WmiFontAttributeSet wmiFontAttributeSet) {
        this.fontStyleName = wmiFontAttributeSet.getFontStyleName();
        this.family = wmiFontAttributeSet.getFamily();
        this.size = wmiFontAttributeSet.getSize();
        this.foreground = wmiFontAttributeSet.getForeground();
        this.foregroundString = null;
        this.background = wmiFontAttributeSet.getBackground();
        this.backgroundString = null;
        this.extendedStyle = wmiFontAttributeSet.getExtendedStyle();
    }

    public void addAttributes(WmiAttributeSet wmiAttributeSet) {
        if (wmiAttributeSet instanceof WmiFontAttributeSet) {
            this.copyFontAttributes((WmiFontAttributeSet)wmiAttributeSet);
        } else {
            super.addAttributes(wmiAttributeSet);
        }
    }

    public int getExtendedStyle() {
        return this.extendedStyle;
    }

    public String getFontStyleName() {
        return this.fontStyleName;
    }

    public String getStyleName() {
        return this.fontStyleName;
    }

    public void setFontStyleName(String string) {
        this.fontStyleName = string;
    }

    public boolean hasStyle(int n) {
        return (this.extendedStyle & n) != 0;
    }

    public void setStyle(int n, boolean bl) {
        if (bl && (n == 8 || n == 16)) {
            this.extendedStyle &= 0xFFFFFFE7;
        }
        this.extendedStyle = bl ? (this.extendedStyle |= n) : (this.extendedStyle &= ~n);
    }

    public boolean isBold() {
        return this.hasStyle(1);
    }

    public boolean isExecutable() {
        return this.hasStyle(64);
    }

    public boolean isItalic() {
        return this.hasStyle(2);
    }

    public boolean isOpaque() {
        return this.hasStyle(32);
    }

    public boolean isReadOnly() {
        return this.hasStyle(128);
    }

    public boolean isSubscript() {
        return this.hasStyle(8);
    }

    public boolean isSuperscript() {
        return this.hasStyle(16);
    }

    public boolean isUnderlined() {
        return this.hasStyle(4);
    }

    public boolean isComposed() {
        return this.hasStyle(256);
    }

    public boolean isConverted() {
        return this.hasStyle(512);
    }

    public boolean isInputMethodSelected() {
        return this.hasStyle(1024);
    }

    public boolean isInputMethodText() {
        return this.hasStyle(1792);
    }

    public void setColor(int n, int n2, boolean bl) {
        this.setForeground(n);
        this.setBackground(n2);
        this.setStyle(32, bl);
    }

    public void setExtendedStyle(int n) {
        this.extendedStyle = n;
    }

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String string) {
        this.family = string;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public void setFont(String string, int n) {
        this.family = string;
        this.size = n;
    }

    public void setNamedFontStyle(String string, WmiMathDocumentModel wmiMathDocumentModel) throws WmiNoReadAccessException {
        WmiFontAttributeSet wmiFontAttributeSet;
        this.setFontStyleName(string);
        if (string != null && wmiMathDocumentModel != null && (wmiFontAttributeSet = wmiMathDocumentModel.getFontStyle(string)) != null) {
            this.addAttributes(wmiFontAttributeSet);
        }
    }

    public int getBackground() {
        return this.background;
    }

    public String getBackgroundColorString() {
        if (this.backgroundString == null) {
            this.backgroundString = WmiColorAttributeKey.createRGBStringFromColorIndex(this.background);
        }
        return this.backgroundString;
    }

    public void setBackground(int n) {
        this.background = n;
        this.backgroundString = null;
    }

    public int getForeground() {
        return this.foreground;
    }

    public String getForegroundColorString() {
        if (this.foregroundString == null) {
            this.foregroundString = WmiColorAttributeKey.createRGBStringFromColorIndex(this.foreground);
        }
        return this.foregroundString;
    }

    public void setForeground(int n) {
        this.foreground = n;
        this.foregroundString = null;
    }

    public void debugPrint() {
    }

    public boolean isCompatibleEditAttributeSet(WmiFontAttributeSet wmiFontAttributeSet) {
        return this.equals(wmiFontAttributeSet);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof WmiFontAttributeSet) {
            WmiFontAttributeSet wmiFontAttributeSet = (WmiFontAttributeSet)object;
            if (this.size == wmiFontAttributeSet.size && this.foreground == wmiFontAttributeSet.foreground && this.background == wmiFontAttributeSet.background && this.extendedStyle == wmiFontAttributeSet.extendedStyle) {
                bl = true;
                if (this.fontStyleName != null) {
                    bl = this.fontStyleName.equals(wmiFontAttributeSet.fontStyleName);
                } else {
                    boolean bl2 = bl = wmiFontAttributeSet.fontStyleName == null;
                }
                if (bl && this.family != null) {
                    bl = this.family.equals(wmiFontAttributeSet.family);
                }
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = this.extendedStyle * 29;
        if (this.fontStyleName != null) {
            n ^= this.fontStyleName.hashCode();
        }
        if (this.family != null) {
            n ^= this.family.hashCode();
        }
        n ^= this.background * 3;
        n ^= this.foreground * 5;
        return n ^= this.size * 17;
    }

    protected HashMap getKeyMap() {
        return keymap;
    }

    public WmiAttributeKey[] getKeys() {
        return ATTRIBUTE_KEYS;
    }

    protected void setKeyMap(HashMap hashMap) {
        keymap = hashMap;
    }

    public HashMap getCache() {
        return cache;
    }

    public String exportAsMStyleTag() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<mstyle ");
        stringBuffer.append("fontfamily = '" + this.family + "' ");
        stringBuffer.append("mathsize = '" + this.size + "' ");
        stringBuffer.append("mathcolor = '#" + WmiColorAttributeKey.createRGBHexStringFromColor(new Color(this.foreground)) + "' ");
        stringBuffer.append("mathbackground = '#" + WmiColorAttributeKey.createRGBHexStringFromColor(new Color(this.background)) + "' ");
        String string = "";
        if (this.isBold()) {
            string = this.isItalic() ? "bold-italic" : BOLD;
        } else if (this.isItalic()) {
            string = ITALIC;
        }
        if (!string.equals("")) {
            stringBuffer.append("mathvariant = '" + string + "'");
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public static class FontSizeKey
    extends WmiIntAttributeKey {
        public FontSizeKey() {
            super(WmiFontAttributeSet.SIZE, 12);
        }

        public int getIntValue(WmiAttributeSet wmiAttributeSet) {
            return ((WmiFontAttributeSet)wmiAttributeSet).getSize();
        }

        public void setIntValue(WmiAttributeSet wmiAttributeSet, int n) {
            ((WmiFontAttributeSet)wmiAttributeSet).setSize(n);
        }
    }

    public static class FontFamilyKey
    extends WmiStringAttributeKey {
        protected FontFamilyKey() {
            super(WmiFontAttributeSet.FAMILY, DEFAULT_FAMILY);
        }

        public String getStringValue(WmiAttributeSet wmiAttributeSet) {
            return ((WmiFontAttributeSet)wmiAttributeSet).getFamily();
        }

        public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
            ((WmiFontAttributeSet)wmiAttributeSet).setFamily(string);
        }
    }

    public static class FontStyleKey
    extends WmiStringAttributeKey {
        protected FontStyleKey() {
            super(WmiFontAttributeSet.STYLE_NAME, null);
        }

        public String getStringValue(WmiAttributeSet wmiAttributeSet) {
            return ((WmiFontAttributeSet)wmiAttributeSet).getFontStyleName();
        }

        public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
            ((WmiFontAttributeSet)wmiAttributeSet).setFontStyleName(string);
        }
    }

    public static class FontBackgroundKey
    extends WmiColorAttributeKey {
        protected FontBackgroundKey() {
            super(WmiFontAttributeSet.BACKGROUND, 0xFFFFFF);
        }

        public String getStringValue(WmiAttributeSet wmiAttributeSet) {
            return ((WmiFontAttributeSet)wmiAttributeSet).getBackgroundColorString();
        }

        public int getIntValue(WmiAttributeSet wmiAttributeSet) {
            return ((WmiFontAttributeSet)wmiAttributeSet).getBackground();
        }

        public void setIntValue(WmiAttributeSet wmiAttributeSet, int n) {
            ((WmiFontAttributeSet)wmiAttributeSet).setBackground(n);
        }
    }

    public static class FontForegroundKey
    extends WmiColorAttributeKey {
        protected FontForegroundKey() {
            super(WmiFontAttributeSet.FOREGROUND, 0);
        }

        public String getStringValue(WmiAttributeSet wmiAttributeSet) {
            return ((WmiFontAttributeSet)wmiAttributeSet).getForegroundColorString();
        }

        public int getIntValue(WmiAttributeSet wmiAttributeSet) {
            return ((WmiFontAttributeSet)wmiAttributeSet).getForeground();
        }

        public void setIntValue(WmiAttributeSet wmiAttributeSet, int n) {
            ((WmiFontAttributeSet)wmiAttributeSet).setForeground(n);
        }
    }

    public static class FontStyleBitKey
    extends WmiBooleanAttributeKey {
        private int styleBit;

        public FontStyleBitKey(String string, int n) {
            super(string, false);
            this.styleBit = n;
        }

        public boolean getBooleanValue(WmiAttributeSet wmiAttributeSet) {
            return ((WmiFontAttributeSet)wmiAttributeSet).hasStyle(this.styleBit);
        }

        public void setBooleanValue(WmiAttributeSet wmiAttributeSet, boolean bl) {
            ((WmiFontAttributeSet)wmiAttributeSet).setStyle(this.styleBit, bl);
        }
    }
}

