/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.graphics.AbstractInheritedAttributeKey;
import com.maplesoft.mathdoc.model.graphics.InheritedAttributeSet;

public class WmiFloatAttributeKey
extends AbstractInheritedAttributeKey
implements WmiAttributeKey {
    private String name;
    private float defaultValue;

    protected WmiFloatAttributeKey(String string, float f) {
        this.name = string;
        this.defaultValue = f;
    }

    public WmiFloatAttributeKey(String string, float f, int n) {
        super(n);
        this.name = string;
        this.defaultValue = f;
    }

    public String toString() {
        return this.getAttributeName();
    }

    public float getDefaultValue() {
        return this.defaultValue;
    }

    public boolean getBooleanValue(WmiAttributeSet wmiAttributeSet) {
        return false;
    }

    public int getIntValue(WmiAttributeSet wmiAttributeSet) {
        return (int)this.getFloatValue(wmiAttributeSet);
    }

    public float getFloatValue(WmiAttributeSet wmiAttributeSet) {
        return 0.0f;
    }

    public String getStringValue(WmiAttributeSet wmiAttributeSet) {
        return String.valueOf(this.getFloatValue(wmiAttributeSet));
    }

    public Object getValue(WmiAttributeSet wmiAttributeSet) {
        return new Float(this.getFloatValue(wmiAttributeSet));
    }

    public void setBooleanValue(WmiAttributeSet wmiAttributeSet, boolean bl) {
    }

    public void setIntValue(WmiAttributeSet wmiAttributeSet, int n) {
        this.setFloatValue(wmiAttributeSet, n);
    }

    public void setFloatValue(WmiAttributeSet wmiAttributeSet, float f) {
    }

    public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
        try {
            this.setFloatValue(wmiAttributeSet, Float.parseFloat(string));
        }
        catch (NumberFormatException numberFormatException) {
            WmiErrorLog.log(numberFormatException);
        }
    }

    public void setValue(WmiAttributeSet wmiAttributeSet, Object object) {
        this.setStringValue(wmiAttributeSet, String.valueOf(object));
    }

    public String getAttributeName() {
        return this.name;
    }

    public int getAttributeType() {
        return 2;
    }

    public boolean isInherited(InheritedAttributeSet inheritedAttributeSet) {
        return inheritedAttributeSet != null && inheritedAttributeSet.isInherited((Object)this);
    }

    public void setInheritance(InheritedAttributeSet inheritedAttributeSet, boolean bl) {
        if (inheritedAttributeSet != null) {
            inheritedAttributeSet.setInherited((Object)this, bl);
        }
    }
}

