/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiDeleteHandler;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import java.util.Stack;

public class WmiDeleteManager {
    private Stack deletionStack = new Stack();
    private WmiModelPosition modelToReposition = null;

    public void mark(WmiCompositeModel wmiCompositeModel) {
        if (!this.deletionStack.contains(wmiCompositeModel)) {
            this.deletionStack.push(wmiCompositeModel);
        }
    }

    public void unMark(WmiCompositeModel wmiCompositeModel) {
        this.deletionStack.removeElement(wmiCompositeModel);
    }

    public void clear() {
        this.deletionStack.clear();
    }

    public void update() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        while (!this.deletionStack.isEmpty()) {
            WmiCompositeModel wmiCompositeModel;
            WmiDeleteHandler wmiDeleteHandler;
            Object e = this.deletionStack.pop();
            if (!(e instanceof WmiCompositeModel) || (wmiDeleteHandler = (wmiCompositeModel = (WmiCompositeModel)e).getDeleteHandler()) == null) continue;
            wmiDeleteHandler.processDelete(this);
        }
    }

    public WmiModelPosition getModelToReposition() {
        return this.modelToReposition;
    }

    public void setModelToReposition(WmiModelPosition wmiModelPosition) {
        this.modelToReposition = wmiModelPosition;
    }
}

